/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.utils.EntityParser;
import org.refactoringminer.utils.RefactoringRelationship;
import org.refactoringminer.utils.RefactoringSet;

public class RefFinderResultReader {
    private static Map<String, Function<List<String>, RefactoringRelationship>> mappers = RefFinderResultReader.initMappings();

    public static RefactoringSet read(String project, String revision, String folderPath) {
        try {
            RefactoringSet result = new RefactoringSet(project, revision);
            for (RefactoringRelationship r : RefFinderResultReader.readFolder(folderPath)) {
                result.add(r);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<RefactoringRelationship> readFolder(String path) throws Exception {
        ArrayList<RefactoringRelationship> result = new ArrayList<RefactoringRelationship>();
        File folder = new File(path);
        for (File f : folder.listFiles()) {
            if (!f.isFile()) continue;
            RefFinderResultReader.readXml(f.getPath(), result);
        }
        return result;
    }

    public static void readXml(String path, List<RefactoringRelationship> result) throws Exception {
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = br.readLine()) != null) {
                RefactoringRelationship r;
                if (line.trim().isEmpty() || (r = RefFinderResultReader.parse(line)) == null) continue;
                result.add(r);
            }
        }
    }

    private static RefactoringRelationship parse(String line) {
        int openPar = line.indexOf(40);
        String type = line.substring(0, openPar);
        String args = line.substring(openPar + 2, line.length() - 2);
        Function<List<String>, RefactoringRelationship> mapper = mappers.get(type);
        if (mapper != null) {
            List<String> argList = Arrays.asList(args.split("\",\""));
            return mapper.apply(argList);
        }
        return null;
    }

    private static Map<String, Function<List<String>, RefactoringRelationship>> initMappings() {
        HashMap<String, Function<List<String>, RefactoringRelationship>> mappers = new HashMap<String, Function<List<String>, RefactoringRelationship>>();
        mappers.put("extract_superclass", args -> RefFinderResultReader.parse(args, RefactoringType.EXTRACT_SUPERCLASS, RefFinderResultReader.type(1), RefFinderResultReader.type(2)));
        mappers.put("extract_interface", args -> RefFinderResultReader.parse(args, RefactoringType.EXTRACT_INTERFACE, RefFinderResultReader.type(2), RefFinderResultReader.type(1)));
        mappers.put("rename_method", args -> RefFinderResultReader.parse(args, RefactoringType.RENAME_METHOD, RefFinderResultReader.member(1), RefFinderResultReader.member(2)));
        mappers.put("move_method", args -> RefFinderResultReader.parse(args, RefactoringType.MOVE_OPERATION, RefFinderResultReader.member(2, 1), RefFinderResultReader.member(3, 1)));
        mappers.put("push_down_method", args -> RefFinderResultReader.parse(args, RefactoringType.PUSH_DOWN_OPERATION, RefFinderResultReader.member(2, 1), RefFinderResultReader.member(3, 1)));
        mappers.put("pull_up_method", args -> RefFinderResultReader.parse(args, RefactoringType.PULL_UP_OPERATION, RefFinderResultReader.member(2, 1), RefFinderResultReader.member(3, 1)));
        mappers.put("extract_method", args -> RefFinderResultReader.parse(args, RefactoringType.EXTRACT_OPERATION, RefFinderResultReader.member(1), RefFinderResultReader.member(2)));
        mappers.put("inline_method", args -> RefFinderResultReader.parse(args, RefactoringType.INLINE_OPERATION, RefFinderResultReader.member(2), RefFinderResultReader.member(1)));
        mappers.put("move_field", args -> RefFinderResultReader.parse(args, RefactoringType.MOVE_ATTRIBUTE, RefFinderResultReader.member(2, 1), RefFinderResultReader.member(3, 1)));
        mappers.put("push_down_field", args -> RefFinderResultReader.parse(args, RefactoringType.PUSH_DOWN_ATTRIBUTE, RefFinderResultReader.member(2, 1), RefFinderResultReader.member(3, 1)));
        mappers.put("pull_up_field", args -> RefFinderResultReader.parse(args, RefactoringType.PULL_UP_ATTRIBUTE, RefFinderResultReader.member(2, 1), RefFinderResultReader.member(3, 1)));
        return mappers;
    }

    private static RefactoringRelationship parse(List<String> args, RefactoringType type, EntityParser parserBefore, EntityParser parserAfter) {
        return new RefactoringRelationship(type, parserBefore.parse(args), parserAfter.parse(args));
    }

    private static EntityParser type(final int i) {
        return new EntityParser(){

            @Override
            String parse(List<String> args) {
                return RefFinderResultReader.normalize(args.get(i - 1));
            }
        };
    }

    private static EntityParser member(final int i, final int j) {
        return new EntityParser(){

            @Override
            String parse(List<String> args) {
                return RefFinderResultReader.normalize(args.get(i - 1)) + "#" + RefFinderResultReader.normalize(args.get(j - 1));
            }
        };
    }

    private static EntityParser member(final int i) {
        return new EntityParser(){

            @Override
            String parse(List<String> args) {
                return RefFinderResultReader.normalize(args.get(i - 1));
            }
        };
    }

    private static String normalize(String entity) {
        return entity.replace("%.", ".").replace('#', '.');
    }
}

