/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.utils;

import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.ExtractSuperclassRefactoring;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.MoveAttributeRefactoring;
import gr.uom.java.xmi.diff.MoveClassRefactoring;
import gr.uom.java.xmi.diff.MoveOperationRefactoring;
import gr.uom.java.xmi.diff.RenameClassRefactoring;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import java.util.List;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringHandler;
import org.refactoringminer.utils.RefactoringRelationship;
import org.refactoringminer.utils.RefactoringSet;

public class RefactoringCollector
extends RefactoringHandler {
    private final RefactoringSet rs;
    private Exception ex = null;

    public RefactoringCollector(String cloneUrl, String commitId) {
        this.rs = new RefactoringSet(cloneUrl, commitId);
    }

    @Override
    public void handle(String commitId, List<Refactoring> refactorings) {
        for (Refactoring r : refactorings) {
            Refactoring ref;
            if (r instanceof MoveClassRefactoring) {
                ref = (MoveClassRefactoring)r;
                this.rs.add(new RefactoringRelationship(r.getRefactoringType(), ((MoveClassRefactoring)ref).getOriginalClassName(), ((MoveClassRefactoring)ref).getMovedClassName()));
                continue;
            }
            if (r instanceof RenameClassRefactoring) {
                ref = (RenameClassRefactoring)r;
                this.rs.add(new RefactoringRelationship(r.getRefactoringType(), ((RenameClassRefactoring)ref).getOriginalClassName(), ((RenameClassRefactoring)ref).getRenamedClassName()));
                continue;
            }
            if (r instanceof ExtractSuperclassRefactoring) {
                ref = (ExtractSuperclassRefactoring)r;
                for (String subclass : ((ExtractSuperclassRefactoring)ref).getSubclassSetBefore()) {
                    this.rs.add(new RefactoringRelationship(r.getRefactoringType(), subclass, ((ExtractSuperclassRefactoring)ref).getExtractedClass().getName()));
                }
                continue;
            }
            if (r instanceof MoveOperationRefactoring) {
                ref = (MoveOperationRefactoring)r;
                this.rs.add(new RefactoringRelationship(r.getRefactoringType(), ((MoveOperationRefactoring)ref).getOriginalOperation().getKey(), ((MoveOperationRefactoring)ref).getMovedOperation().getKey()));
                continue;
            }
            if (r instanceof RenameOperationRefactoring) {
                ref = (RenameOperationRefactoring)r;
                this.rs.add(new RefactoringRelationship(r.getRefactoringType(), ((RenameOperationRefactoring)ref).getOriginalOperation().getKey(), ((RenameOperationRefactoring)ref).getRenamedOperation().getKey()));
                continue;
            }
            if (r instanceof ExtractOperationRefactoring) {
                ref = (ExtractOperationRefactoring)r;
                continue;
            }
            if (r instanceof InlineOperationRefactoring) {
                ref = (InlineOperationRefactoring)r;
                continue;
            }
            if (r instanceof MoveAttributeRefactoring) {
                ref = (MoveAttributeRefactoring)r;
                String attrName = ((MoveAttributeRefactoring)ref).getMovedAttribute().getName();
                this.rs.add(new RefactoringRelationship(r.getRefactoringType(), ((MoveAttributeRefactoring)ref).getSourceClassName() + "#" + attrName, ((MoveAttributeRefactoring)ref).getTargetClassName() + "#" + attrName));
                continue;
            }
            throw new RuntimeException("refactoring not supported");
        }
    }

    @Override
    public void handleException(String commitId, Exception e) {
        this.ex = e;
    }

    public RefactoringSet assertAndGetResult() {
        if (this.ex == null) {
            return this.rs;
        }
        throw new RuntimeException(this.ex);
    }
}

