/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.utils;

import java.util.HashMap;
import java.util.Map;
import org.refactoringminer.api.RefactoringType;
import org.refactoringminer.utils.RefactoringRelationship;

public class RefactoringCrawlerRefactoring {
    private static final Map<String, RefactoringType> TYPE_MAP = new HashMap<String, RefactoringType>();
    private String type;
    private String newElement;
    private String oldElement;

    public RefactoringCrawlerRefactoring(String type, String newElement, String oldElement) {
        this.type = type.trim();
        this.newElement = newElement.trim();
        this.oldElement = oldElement.trim();
    }

    public String getType() {
        return this.type;
    }

    public String getNewElement() {
        return this.newElement;
    }

    public String getOldElement() {
        return this.oldElement;
    }

    public String toString() {
        return this.type + "\t" + this.oldElement + "\t" + this.newElement;
    }

    RefactoringRelationship toRefactoringRelationship() {
        RefactoringType refType = TYPE_MAP.get(this.type);
        if (refType == null) {
            throw new RuntimeException("unkown refactoring type " + this.type);
        }
        return new RefactoringRelationship(refType, this.oldElement, this.newElement);
    }

    static {
        TYPE_MAP.put("RenamedClasses", RefactoringType.RENAME_CLASS);
        TYPE_MAP.put("RenamedMethods", RefactoringType.RENAME_METHOD);
        TYPE_MAP.put("PulledUpMethods", RefactoringType.PULL_UP_OPERATION);
        TYPE_MAP.put("PushedDownMethods", RefactoringType.PUSH_DOWN_OPERATION);
        TYPE_MAP.put("MovedMethods", RefactoringType.MOVE_OPERATION);
        TYPE_MAP.put("RenamedPackages", RefactoringType.RENAME_PACKAGE);
    }
}

