/*
 * Decompiled with CFR 0.152.
 */
package org.refactoringminer.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.refactoringminer.utils.RefactoringCrawlerRefactoring;
import org.refactoringminer.utils.RefactoringSet;

public class RefactoringCrawlerResultReader {
    public static RefactoringSet read(String project, String revision, String folderPath) {
        try {
            RefactoringSet result = new RefactoringSet(project, revision);
            for (RefactoringCrawlerRefactoring r : RefactoringCrawlerResultReader.readFolder(folderPath)) {
                result.add(r.toRefactoringRelationship());
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<RefactoringCrawlerRefactoring> readFolder(String path) throws Exception {
        ArrayList<RefactoringCrawlerRefactoring> result = new ArrayList<RefactoringCrawlerRefactoring>();
        File folder = new File(path);
        for (File f : folder.listFiles()) {
            if (!f.isFile()) continue;
            RefactoringCrawlerResultReader.readXml(f.getPath(), result);
        }
        return result;
    }

    public static void readXml(String path, List<RefactoringCrawlerRefactoring> result) throws Exception {
        String content = RefactoringCrawlerResultReader.readFile(path, StandardCharsets.UTF_8);
        Pattern p = Pattern.compile("<refactoring name=\"([^\"]+)\">\\s*<parameter name= \"new element\">([^/]+)</parameter>\\s*<parameter name= \"old element\">([^/]+)</parameter>");
        Matcher m = p.matcher(content);
        while (m.find()) {
            result.add(new RefactoringCrawlerRefactoring(m.group(1), m.group(2), m.group(3)));
        }
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

