/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.annotation.source.CsvFileSourceAnnotation;
import gr.uom.java.xmi.annotation.source.CsvSourceAnnotation;
import gr.uom.java.xmi.annotation.source.EmptySourceAnnotation;
import gr.uom.java.xmi.annotation.source.EnumSourceAnnotation;
import gr.uom.java.xmi.annotation.source.NullAndEmptySourceAnnotation;
import gr.uom.java.xmi.annotation.source.NullSourceAnnotation;
import gr.uom.java.xmi.annotation.source.ValueSourceAnnotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.TriFunction;

public abstract class SourceAnnotation {
    protected static final Map<String, TriFunction<UMLAnnotation, UMLOperation, UMLModel, SourceAnnotation>> implementations = Map.of("CsvSource", CsvSourceAnnotation::new, "CsvFileSource", CsvFileSourceAnnotation::new, "ValueSource", ValueSourceAnnotation::new, "EnumSource", EnumSourceAnnotation::new, "NullAndEmptySource", NullAndEmptySourceAnnotation::new, "EmptySource", EmptySourceAnnotation::new, "NullSource", NullSourceAnnotation::new);
    protected List<List<String>> testParameters;
    protected UMLAnnotation annotation;

    protected SourceAnnotation(UMLAnnotation annotation, String typeName) {
        assert (annotation.getTypeName().equals(typeName)) : "Annotation is not a " + typeName + " annotation";
        this.annotation = annotation;
        this.testParameters = new ArrayList<List<String>>();
    }

    public static SourceAnnotation create(UMLAnnotation annotation, UMLOperation operation, UMLModel model) {
        if (implementations.containsKey(annotation.getTypeName())) {
            return (SourceAnnotation)implementations.get(annotation.getTypeName()).apply((Object)annotation, (Object)operation, (Object)model);
        }
        throw new IllegalArgumentException("Annotation type " + annotation.getTypeName() + " is not supported");
    }

    protected static String sanitizeLiteral(String literal) {
        literal = literal.startsWith("\"") ? literal.substring(1) : literal;
        literal = literal.endsWith("\"") ? literal.substring(0, literal.length() - 1) : literal;
        literal = literal.endsWith(".class") ? literal.substring(0, literal.length() - 6) : literal;
        return literal;
    }

    public abstract List<List<String>> getTestParameters();
}

