/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLJavadoc;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.VariableDeclarationProvider;
import gr.uom.java.xmi.Visibility;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.StringDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class UMLAttribute
implements Comparable<UMLAttribute>,
Serializable,
VariableDeclarationProvider,
VariableDeclarationContainer {
    private LocationInfo locationInfo;
    private String name;
    private UMLType type;
    private Visibility visibility;
    private String className;
    private boolean isFinal;
    private boolean isStatic;
    private boolean isTransient;
    private boolean isVolatile;
    private Optional<UMLAnonymousClass> anonymousClassContainer;
    private VariableDeclaration variableDeclaration;
    private List<UMLAnonymousClass> anonymousClassList;
    private UMLJavadoc javadoc;
    private List<UMLComment> comments;
    private Map<String, Set<VariableDeclaration>> variableDeclarationMap;

    public UMLAttribute(String name, UMLType type, LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
        this.name = name;
        this.type = type;
        this.anonymousClassList = new ArrayList<UMLAnonymousClass>();
        this.comments = new ArrayList<UMLComment>();
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public String getElementType() {
        return "attribute";
    }

    public UMLType getType() {
        return this.type;
    }

    public void setType(UMLType type) {
        this.type = type;
    }

    @Override
    public boolean isDeclaredInAnonymousClass() {
        return this.anonymousClassContainer != null && this.anonymousClassContainer.isPresent();
    }

    @Override
    public boolean isGetter() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public AbstractCall isDelegate() {
        return null;
    }

    @Override
    public Optional<UMLAnonymousClass> getAnonymousClassContainer() {
        return this.anonymousClassContainer;
    }

    public void setAnonymousClassContainer(UMLAnonymousClass anonymousClass) {
        this.anonymousClassContainer = Optional.of(anonymousClass);
    }

    public void addAnonymousClass(UMLAnonymousClass anonymous) {
        this.anonymousClassList.add(anonymous);
    }

    @Override
    public List<UMLAnonymousClass> getAnonymousClassList() {
        return this.anonymousClassList;
    }

    @Override
    public UMLAnonymousClass findAnonymousClass(AnonymousClassDeclarationObject anonymousClassDeclaration) {
        for (UMLAnonymousClass anonymousClass : this.getAnonymousClassList()) {
            if (!anonymousClass.getLocationInfo().equals(anonymousClassDeclaration.getLocationInfo())) continue;
            return anonymousClass;
        }
        return null;
    }

    @Override
    public List<VariableDeclaration> getParameterDeclarationList() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            for (LambdaExpressionObject lambda : initializer.getLambdas()) {
                if (!this.match(initializer, lambda)) continue;
                return lambda.getParameters();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<UMLType> getParameterTypeList() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            for (LambdaExpressionObject lambda : initializer.getLambdas()) {
                if (!this.match(initializer, lambda)) continue;
                return lambda.getParameterTypeList();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getParameterNameList() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            for (LambdaExpressionObject lambda : initializer.getLambdas()) {
                if (!this.match(initializer, lambda)) continue;
                return lambda.getParameterNameList();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<UMLParameter> getParametersWithoutReturnType() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            for (LambdaExpressionObject lambda : initializer.getLambdas()) {
                if (!this.match(initializer, lambda)) continue;
                return lambda.getUmlParameters();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getNumberOfNonVarargsParameters() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            for (LambdaExpressionObject lambda : initializer.getLambdas()) {
                if (!this.match(initializer, lambda)) continue;
                return lambda.getNumberOfNonVarargsParameters();
            }
        }
        return 0;
    }

    @Override
    public boolean hasVarargsParameter() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            for (LambdaExpressionObject lambda : initializer.getLambdas()) {
                if (!this.match(initializer, lambda)) continue;
                return lambda.hasVarargsParameter();
            }
        }
        return false;
    }

    @Override
    public OperationBody getBody() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            for (LambdaExpressionObject lambda : initializer.getLambdas()) {
                if (!this.match(initializer, lambda)) continue;
                return lambda.getBody();
            }
        }
        return null;
    }

    private boolean match(AbstractExpression initializer, LambdaExpressionObject lambda) {
        return lambda.getLocationInfo().getStartLine() == initializer.getLocationInfo().getStartLine() && lambda.getLocationInfo().getEndLine() == initializer.getLocationInfo().getEndLine();
    }

    @Override
    public List<LambdaExpressionObject> getAllLambdas() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            return initializer.getLambdas();
        }
        return Collections.emptyList();
    }

    @Override
    public List<AbstractCall> getAllOperationInvocations() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            return new ArrayList<AbstractCall>(initializer.getMethodInvocations());
        }
        return Collections.emptyList();
    }

    @Override
    public List<AbstractCall> getAllCreations() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            return new ArrayList<AbstractCall>(initializer.getCreations());
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllVariables() {
        AbstractExpression initializer = this.variableDeclaration.getInitializer();
        if (initializer != null) {
            ArrayList<String> variables = new ArrayList<String>();
            for (LeafExpression variable : initializer.getVariables()) {
                variables.add(variable.getString());
            }
            return variables;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Set<VariableDeclaration>> variableDeclarationMap() {
        if (this.variableDeclarationMap == null) {
            this.variableDeclarationMap = new LinkedHashMap<String, Set<VariableDeclaration>>();
            for (VariableDeclaration declaration : this.getAllVariableDeclarations()) {
                if (this.variableDeclarationMap.containsKey(declaration.getVariableName())) {
                    this.variableDeclarationMap.get(declaration.getVariableName()).add(declaration);
                    continue;
                }
                LinkedHashSet<VariableDeclaration> variableDeclarations = new LinkedHashSet<VariableDeclaration>();
                variableDeclarations.add(declaration);
                this.variableDeclarationMap.put(declaration.getVariableName(), variableDeclarations);
            }
        }
        return this.variableDeclarationMap;
    }

    @Override
    public boolean hasTestAnnotation() {
        return false;
    }

    @Override
    public boolean hasParameterizedTestAnnotation() {
        return false;
    }

    @Override
    public boolean hasSetUpAnnotation() {
        return false;
    }

    @Override
    public boolean hasTearDownAnnotation() {
        return false;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public String getNonQualifiedClassName() {
        return this.className.contains(".") ? this.className.substring(this.className.lastIndexOf(".") + 1, this.className.length()) : this.className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VariableDeclaration getVariableDeclaration() {
        return this.variableDeclaration;
    }

    public void setVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.variableDeclaration = variableDeclaration;
    }

    public UMLJavadoc getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(UMLJavadoc javadoc) {
        this.javadoc = javadoc;
    }

    @Override
    public List<UMLComment> getComments() {
        return this.comments;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.variableDeclaration.getAnnotations();
    }

    public boolean identicalIncludingAnnotation(UMLAttribute attribute) {
        boolean equal;
        AbstractExpression thisInitializer = this.getVariableDeclaration().getInitializer();
        AbstractExpression otherInitializer = attribute.getVariableDeclaration().getInitializer();
        boolean bl = equal = this.name.equals(attribute.name) && this.type.equals(attribute.type) && this.type.equalsQualified(attribute.type) && this.visibility.equals((Object)attribute.visibility) && this.getAnnotations().equals(attribute.getAnnotations());
        if (thisInitializer != null && otherInitializer != null) {
            return equal && thisInitializer.getExpression().equals(otherInitializer.getExpression());
        }
        if (thisInitializer == null && otherInitializer == null) {
            return equal;
        }
        return false;
    }

    public boolean renamedWithIdenticalTypeAndInitializer(UMLAttribute attribute) {
        AbstractExpression thisInitializer = this.getVariableDeclaration().getInitializer();
        AbstractExpression otherInitializer = attribute.getVariableDeclaration().getInitializer();
        if (thisInitializer != null && otherInitializer != null && !this.name.equals(attribute.name)) {
            return thisInitializer.getExpression().equals(otherInitializer.getExpression()) && this.type.equals(attribute.type) && this.type.equalsQualified(attribute.type);
        }
        return false;
    }

    public boolean equalsIgnoringChangedType(UMLAttribute attribute) {
        if (this.name.equals(attribute.name) && this.type.equals(attribute.type) && this.type.equalsQualified(attribute.type)) {
            return true;
        }
        if (!this.type.equals(attribute.type)) {
            return this.name.equals(attribute.name);
        }
        return false;
    }

    public boolean equalsIgnoringChangedVisibility(UMLAttribute attribute) {
        return this.name.equals(attribute.name) && this.type.equals(attribute.type);
    }

    @Override
    public CodeRange codeRange() {
        LocationInfo info = this.getLocationInfo();
        return info.codeRange();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UMLAttribute) {
            UMLAttribute umlAttribute = (UMLAttribute)o;
            return this.name.equals(umlAttribute.name) && this.visibility.equals((Object)umlAttribute.visibility) && this.type.equals(umlAttribute.type);
        }
        return false;
    }

    public boolean equalsQualified(UMLAttribute umlAttribute) {
        return this.name.equals(umlAttribute.name) && this.visibility.equals((Object)umlAttribute.visibility) && this.type.equalsQualified(umlAttribute.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.visibility);
        sb.append(" ");
        sb.append(this.name);
        sb.append(" : ");
        sb.append(this.type);
        return sb.toString();
    }

    @Override
    public String toQualifiedString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.visibility);
        sb.append(" ");
        sb.append(this.name);
        sb.append(" : ");
        sb.append(this.type.toQualifiedString());
        return sb.toString();
    }

    @Override
    public int compareTo(UMLAttribute attribute) {
        return this.toString().compareTo(attribute.toString());
    }

    public double normalizedNameDistance(UMLAttribute attribute) {
        String s1 = this.getName().toLowerCase();
        String s2 = attribute.getName().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }
}

