/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLImport;
import gr.uom.java.xmi.UMLJavadoc;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.UMLTypeParameter;
import gr.uom.java.xmi.Visibility;
import gr.uom.java.xmi.diff.StringDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class UMLClass
extends UMLAbstractClass
implements Comparable<UMLClass>,
Serializable,
LocationInfoProvider {
    private String qualifiedName;
    private String sourceFile;
    private String sourceFolder;
    private Visibility visibility;
    private boolean isFinal;
    private boolean isStatic;
    private boolean isAbstract;
    private boolean isInterface;
    private boolean isEnum;
    private boolean isAnnotation;
    private boolean topLevel;
    private List<UMLTypeParameter> typeParameters;
    private UMLJavadoc javadoc;
    private UMLJavadoc packageDeclarationJavadoc;
    private List<UMLComment> packageDeclarationComments;

    public UMLClass(String packageName, String name, LocationInfo locationInfo, boolean topLevel, List<UMLImport> importedTypes) {
        super(packageName, name, locationInfo, importedTypes);
        this.qualifiedName = packageName.equals("") ? name : packageName + "." + name;
        this.sourceFile = this.getSourceFile();
        this.sourceFolder = "";
        if (packageName.equals("")) {
            int index = this.sourceFile.indexOf(name);
            if (index != -1) {
                this.sourceFolder = this.sourceFile.substring(0, index);
            }
        } else if (topLevel) {
            int index = this.sourceFile.indexOf(packageName.replace('.', '/'));
            if (index != -1) {
                this.sourceFolder = this.sourceFile.substring(0, index);
            }
        } else {
            int index = -1;
            if (packageName.contains(".")) {
                String realPackageName = packageName.substring(0, packageName.lastIndexOf(46));
                index = this.sourceFile.indexOf(realPackageName.replace('.', '/'));
            } else {
                index = this.sourceFile.indexOf(packageName);
            }
            if (index != -1) {
                this.sourceFolder = this.sourceFile.substring(0, index);
            }
        }
        this.isAbstract = false;
        this.isInterface = false;
        this.topLevel = topLevel;
        this.typeParameters = new ArrayList<UMLTypeParameter>();
        this.packageDeclarationComments = new ArrayList<UMLComment>();
    }

    @Override
    public String getTypeDeclarationKind() {
        if (this.isInterface) {
            return "interface";
        }
        if (this.isEnum) {
            return "enum";
        }
        if (this.isAnnotation) {
            return "annotation";
        }
        return "class";
    }

    public List<UMLTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public List<String> getTypeParameterNames() {
        ArrayList<String> typeParameterNames = new ArrayList<String>();
        for (UMLTypeParameter typeParameter : this.typeParameters) {
            typeParameterNames.add(typeParameter.getName());
        }
        return typeParameterNames;
    }

    public void addTypeParameter(UMLTypeParameter typeParameter) {
        this.typeParameters.add(typeParameter);
    }

    @Override
    public String getName() {
        return this.qualifiedName;
    }

    @Override
    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public void setAnnotation(boolean isAnnotation) {
        this.isAnnotation = isAnnotation;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public UMLJavadoc getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(UMLJavadoc javadoc) {
        this.javadoc = javadoc;
    }

    public UMLJavadoc getPackageDeclarationJavadoc() {
        return this.packageDeclarationJavadoc;
    }

    public void setPackageDeclarationJavadoc(UMLJavadoc packageJavadoc) {
        this.packageDeclarationJavadoc = packageJavadoc;
    }

    public List<UMLComment> getPackageDeclarationComments() {
        return this.packageDeclarationComments;
    }

    public UMLOperation matchOperation(UMLOperation otherOperation) {
        ListIterator operationIt = this.operations.listIterator();
        while (operationIt.hasNext()) {
            UMLOperation operation = (UMLOperation)operationIt.next();
            if (!operation.getName().equals(otherOperation.getName()) || operation.getParameters().size() != otherOperation.getParameters().size()) continue;
            boolean match = true;
            int i = 0;
            for (UMLParameter parameter : operation.getParameters()) {
                UMLParameter otherParameter = otherOperation.getParameters().get(i);
                String thisParameterType = parameter.getType().getClassType();
                String otherParameterType = otherParameter.getType().getClassType();
                int thisArrayDimension = parameter.getType().getArrayDimension();
                int otherArrayDimension = otherParameter.getType().getArrayDimension();
                String thisParameterTypeComparedString = null;
                thisParameterTypeComparedString = thisParameterType.contains(".") ? thisParameterType.substring(thisParameterType.lastIndexOf(".") + 1) : thisParameterType;
                String otherParameterTypeComparedString = null;
                otherParameterTypeComparedString = otherParameterType.contains(".") ? otherParameterType.substring(otherParameterType.lastIndexOf(".") + 1) : otherParameterType;
                if (!thisParameterTypeComparedString.equals(otherParameterTypeComparedString) || thisArrayDimension != otherArrayDimension) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (!match) continue;
            return operation;
        }
        return null;
    }

    public boolean hasSameNameAndKind(UMLClass umlClass) {
        if (!this.name.equals(umlClass.name)) {
            return false;
        }
        return this.hasSameKind(umlClass);
    }

    public boolean hasSameKind(UMLClass umlClass) {
        if (this.isInterface != umlClass.isInterface) {
            return false;
        }
        return this.equalTypeParameters(umlClass);
    }

    private boolean equalTypeParameters(UMLClass umlClass) {
        return this.typeParameters.equals(umlClass.typeParameters) || this.getTypeParameterNames().equals(umlClass.getTypeParameterNames()) || this.renamedParameterizedType(umlClass);
    }

    private boolean renamedParameterizedType(UMLClass umlClass) {
        block0: for (UMLOperation operation1 : this.operations) {
            List<UMLParameter> parameterized1 = operation1.getParameterizedTypesInSignature();
            if (parameterized1.isEmpty()) continue;
            for (UMLOperation operation2 : umlClass.operations) {
                if (!operation1.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation2)) continue;
                List<UMLParameter> parameterized2 = operation2.getParameterizedTypesInSignature();
                if (parameterized1.size() != parameterized2.size()) continue block0;
                int renamed = 0;
                for (int i = 0; i < parameterized1.size(); ++i) {
                    UMLType type1 = parameterized1.get(i).getType();
                    UMLType type2 = parameterized2.get(i).getType();
                    if (!type1.getTypeArguments().toString().equals(this.typeParameters.toString()) || !type2.getTypeArguments().toString().equals(umlClass.typeParameters.toString())) continue;
                    ++renamed;
                }
                if (renamed != parameterized1.size()) continue block0;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UMLClass) {
            UMLClass umlClass = (UMLClass)o;
            return this.packageName.equals(umlClass.packageName) && this.name.equals(umlClass.name) && this.sourceFile.equals(umlClass.sourceFile);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sourceFile == null ? 0 : this.sourceFile.hashCode());
        return result;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(UMLClass umlClass) {
        return this.toString().compareTo(umlClass.toString());
    }

    public double normalizedNameDistance(UMLClass c) {
        String s1 = this.name.toLowerCase();
        String s2 = c.name.toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    public double normalizedPackageNameDistance(UMLClass c) {
        String s1 = this.packageName.toLowerCase();
        String s2 = c.packageName.toLowerCase();
        if (s1.length() == 0 && s2.length() == 0) {
            return 0.0;
        }
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    public double normalizedSourceFolderDistance(UMLClass c) {
        String s1 = this.sourceFolder.toLowerCase();
        String s2 = c.sourceFolder.toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    @Override
    public boolean isSingleAbstractMethodInterface() {
        return this.isInterface && this.operations.size() == 1;
    }

    @Override
    public boolean isSingleMethodClass() {
        if (!this.isInterface && !this.isEnum) {
            int counter = 0;
            for (UMLOperation operation : this.operations) {
                if (operation.isConstructor()) continue;
                ++counter;
            }
            return counter == 1;
        }
        return false;
    }
}

