/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.UMLClass;

public interface UMLClassMatcher {
    public MatchResult match(UMLClass var1, UMLClass var2);

    public static class ExtremelyRelaxedRename
    implements UMLClassMatcher {
        @Override
        public MatchResult match(UMLClass removedClass, UMLClass addedClass) {
            MatchResult matchResult = removedClass.hasAttributesAndOperationsWithCommonNames(addedClass);
            if (removedClass.hasSameKind(addedClass) && matchResult.isMatch()) {
                matchResult.setMatch(true);
                return matchResult;
            }
            matchResult.setMatch(false);
            return matchResult;
        }
    }

    public static class RelaxedRename
    implements UMLClassMatcher {
        @Override
        public MatchResult match(UMLClass removedClass, UMLClass addedClass) {
            MatchResult matchResult = removedClass.hasCommonAttributesAndOperations(addedClass);
            if (removedClass.hasSameKind(addedClass) && matchResult.isMatch()) {
                matchResult.setMatch(true);
                return matchResult;
            }
            matchResult.setMatch(false);
            return matchResult;
        }
    }

    public static class Rename
    implements UMLClassMatcher {
        @Override
        public MatchResult match(UMLClass removedClass, UMLClass addedClass) {
            MatchResult matchResult = removedClass.hasSameAttributesAndOperations(addedClass);
            if (removedClass.hasSameKind(addedClass) && matchResult.isMatch()) {
                matchResult.setMatch(true);
                return matchResult;
            }
            matchResult.setMatch(false);
            return matchResult;
        }
    }

    public static class ExtremelyRelaxedMove
    implements UMLClassMatcher {
        @Override
        public MatchResult match(UMLClass removedClass, UMLClass addedClass) {
            MatchResult matchResult = removedClass.hasAttributesAndOperationsWithCommonNames(addedClass);
            if (removedClass.hasSameNameAndKind(addedClass) && matchResult.isMatch()) {
                matchResult.setMatch(true);
                return matchResult;
            }
            matchResult.setMatch(false);
            return matchResult;
        }
    }

    public static class RelaxedMove
    implements UMLClassMatcher {
        @Override
        public MatchResult match(UMLClass removedClass, UMLClass addedClass) {
            MatchResult matchResult = removedClass.hasCommonAttributesAndOperations(addedClass);
            if (removedClass.hasSameNameAndKind(addedClass) && matchResult.isMatch()) {
                matchResult.setMatch(true);
                return matchResult;
            }
            matchResult.setMatch(false);
            return matchResult;
        }
    }

    public static class Move
    implements UMLClassMatcher {
        @Override
        public MatchResult match(UMLClass removedClass, UMLClass addedClass) {
            MatchResult matchResult = removedClass.hasSameAttributesAndOperations(addedClass);
            if (removedClass.hasSameNameAndKind(addedClass) && matchResult.isMatch()) {
                matchResult.setMatch(true);
                return matchResult;
            }
            matchResult.setMatch(false);
            return matchResult;
        }
    }

    public static class MatchResult {
        private int matchedOperations;
        private int matchedAttributes;
        private int totalOperations;
        private int totalAttributes;
        private boolean match;

        public MatchResult(int matchedOperations, int matchedAttributes, int totalOperations, int totalAttributes, boolean match) {
            this.matchedOperations = matchedOperations;
            this.matchedAttributes = matchedAttributes;
            this.totalOperations = totalOperations;
            this.totalAttributes = totalAttributes;
            this.match = match;
        }

        public int getMatchedOperations() {
            return this.matchedOperations;
        }

        public int getMatchedAttributes() {
            return this.matchedAttributes;
        }

        public int getTotalOperations() {
            return this.totalOperations;
        }

        public int getTotalAttributes() {
            return this.totalAttributes;
        }

        public boolean isMatch() {
            return this.match;
        }

        private void setMatch(boolean match) {
            this.match = match;
        }
    }
}

