/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.diff.CodeRange;
import java.io.Serializable;
import java.util.Objects;

public class UMLImport
implements Serializable,
LocationInfoProvider {
    private String name;
    private boolean isOnDemand;
    private boolean isStatic;
    private LocationInfo locationInfo;

    public UMLImport(String name, boolean isOnDemand, boolean isStatic, LocationInfo locationInfo) {
        this.name = name;
        this.isOnDemand = isOnDemand;
        this.isStatic = isStatic;
        this.locationInfo = locationInfo;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOnDemand() {
        return this.isOnDemand;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isOnDemand, this.isStatic);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLImport other = (UMLImport)obj;
        return Objects.equals(this.name, other.name) && this.isOnDemand == other.isOnDemand && this.isStatic == other.isStatic;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("import ");
        if (this.isStatic) {
            sb.append("static ");
        }
        sb.append(this.name);
        if (this.isOnDemand) {
            sb.append(".*");
        }
        return sb.toString();
    }
}

