/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLJavadoc;
import gr.uom.java.xmi.UMLModifier;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.UMLTypeParameter;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.Visibility;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.StringDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.refactoringminer.util.AstUtils;

public class UMLOperation
implements Comparable<UMLOperation>,
Serializable,
VariableDeclarationContainer {
    private LocationInfo locationInfo;
    private String name;
    private Visibility visibility;
    private boolean isAbstract;
    private List<UMLParameter> parameters;
    private String className;
    private boolean isConstructor;
    private boolean isFinal;
    private boolean isStatic;
    private boolean isNative;
    private boolean isSynchronized;
    private boolean isDefault;
    private Optional<UMLAnonymousClass> anonymousClassContainer;
    private OperationBody operationBody;
    private List<UMLAnonymousClass> anonymousClassList;
    private List<UMLTypeParameter> typeParameters;
    private List<UMLType> thrownExceptionTypes;
    private UMLJavadoc javadoc;
    private List<UMLAnnotation> annotations;
    private List<UMLModifier> modifiers;
    private List<UMLComment> comments;
    private Map<String, Set<VariableDeclaration>> variableDeclarationMap;

    public UMLOperation(String name, LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
        this.name = name;
        this.parameters = new ArrayList<UMLParameter>();
        this.anonymousClassList = new ArrayList<UMLAnonymousClass>();
        this.typeParameters = new ArrayList<UMLTypeParameter>();
        this.thrownExceptionTypes = new ArrayList<UMLType>();
        this.annotations = new ArrayList<UMLAnnotation>();
        this.modifiers = new ArrayList<UMLModifier>();
        this.comments = new ArrayList<UMLComment>();
    }

    public List<UMLTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void addTypeParameter(UMLTypeParameter typeParameter) {
        this.typeParameters.add(typeParameter);
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(UMLAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public List<UMLModifier> getModifiers() {
        return this.modifiers;
    }

    public void addModifier(UMLModifier modifier) {
        this.modifiers.add(modifier);
    }

    public List<UMLType> getThrownExceptionTypes() {
        return this.thrownExceptionTypes;
    }

    public void addThrownExceptionType(UMLType exceptionType) {
        this.thrownExceptionTypes.add(exceptionType);
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getElementType() {
        return "method";
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean isNative) {
        this.isNative = isNative;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public boolean isDeclaredInAnonymousClass() {
        return this.anonymousClassContainer != null && this.anonymousClassContainer.isPresent();
    }

    @Override
    public Optional<UMLAnonymousClass> getAnonymousClassContainer() {
        return this.anonymousClassContainer;
    }

    public void setAnonymousClassContainer(UMLAnonymousClass anonymousClass) {
        this.anonymousClassContainer = Optional.of(anonymousClass);
    }

    @Override
    public OperationBody getBody() {
        return this.operationBody;
    }

    public boolean hasOverrideAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!annotation.getTypeName().equals("Override")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTestAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!annotation.getTypeName().equals("Test")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasParameterizedTestAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!UMLOperation.isParameterizedTestAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSetUpAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!annotation.getTypeName().equals("Before") && !annotation.getTypeName().equals("BeforeClass") && !annotation.getTypeName().equals("BeforeEach") && !annotation.getTypeName().equals("BeforeAll")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTearDownAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!annotation.getTypeName().equals("After") && !annotation.getTypeName().equals("AfterClass") && !annotation.getTypeName().equals("AfterEach") && !annotation.getTypeName().equals("AfterAll")) continue;
            return true;
        }
        return false;
    }

    public boolean hasDataProviderAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!annotation.getTypeName().equals("DataProvider")) continue;
            return true;
        }
        return false;
    }

    public UMLJavadoc getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(UMLJavadoc javadoc) {
        this.javadoc = javadoc;
    }

    @Override
    public List<UMLComment> getComments() {
        return this.comments;
    }

    @Override
    public List<AbstractCall> getAllOperationInvocations() {
        if (this.operationBody != null) {
            return this.operationBody.getAllOperationInvocations();
        }
        return Collections.emptyList();
    }

    @Override
    public List<AbstractCall> getAllCreations() {
        if (this.operationBody != null) {
            return this.operationBody.getAllCreations();
        }
        return Collections.emptyList();
    }

    public boolean containsAssertion() {
        if (this.operationBody != null) {
            return this.operationBody.containsAssertion();
        }
        return false;
    }

    @Override
    public List<LambdaExpressionObject> getAllLambdas() {
        if (this.operationBody != null) {
            return this.operationBody.getAllLambdas();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllVariables() {
        if (this.operationBody != null) {
            return this.operationBody.getAllVariables();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Set<VariableDeclaration>> variableDeclarationMap() {
        if (this.variableDeclarationMap == null) {
            this.variableDeclarationMap = new LinkedHashMap<String, Set<VariableDeclaration>>();
            for (VariableDeclaration declaration : this.getAllVariableDeclarations()) {
                if (this.variableDeclarationMap.containsKey(declaration.getVariableName())) {
                    this.variableDeclarationMap.get(declaration.getVariableName()).add(declaration);
                    continue;
                }
                LinkedHashSet<VariableDeclaration> variableDeclarations = new LinkedHashSet<VariableDeclaration>();
                variableDeclarations.add(declaration);
                this.variableDeclarationMap.put(declaration.getVariableName(), variableDeclarations);
            }
        }
        return this.variableDeclarationMap;
    }

    public int statementCount() {
        if (this.operationBody != null) {
            return this.operationBody.statementCount();
        }
        return 0;
    }

    public void setBody(OperationBody body) {
        this.operationBody = body;
    }

    public String getNonQualifiedClassName() {
        return this.className.contains(".") ? this.className.substring(this.className.lastIndexOf(".") + 1, this.className.length()) : this.className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void addParameter(UMLParameter parameter) {
        this.parameters.add(parameter);
    }

    public List<UMLParameter> getParameters() {
        return this.parameters;
    }

    public void addAnonymousClass(UMLAnonymousClass anonymous) {
        this.anonymousClassList.add(anonymous);
    }

    @Override
    public List<UMLAnonymousClass> getAnonymousClassList() {
        return this.anonymousClassList;
    }

    @Override
    public UMLAnonymousClass findAnonymousClass(AnonymousClassDeclarationObject anonymousClassDeclaration) {
        for (UMLAnonymousClass anonymousClass : this.getAnonymousClassList()) {
            if (!anonymousClass.getLocationInfo().equals(anonymousClassDeclaration.getLocationInfo())) continue;
            return anonymousClass;
        }
        return null;
    }

    public UMLParameter getReturnParameter() {
        for (UMLParameter parameter : this.parameters) {
            if (!parameter.getKind().equals("return")) continue;
            return parameter;
        }
        return null;
    }

    public boolean equalReturnParameter(UMLOperation operation) {
        UMLParameter thisReturnParameter = this.getReturnParameter();
        UMLParameter otherReturnParameter = operation.getReturnParameter();
        if (thisReturnParameter != null && otherReturnParameter != null) {
            return thisReturnParameter.equals(otherReturnParameter);
        }
        return thisReturnParameter == null && otherReturnParameter == null;
    }

    public boolean equalQualifiedReturnParameter(UMLOperation operation) {
        UMLParameter thisReturnParameter = this.getReturnParameter();
        UMLParameter otherReturnParameter = operation.getReturnParameter();
        if (thisReturnParameter != null && otherReturnParameter != null) {
            return thisReturnParameter.equalsQualified(otherReturnParameter);
        }
        return thisReturnParameter == null && otherReturnParameter == null;
    }

    public boolean equalSignatureForAbstractMethods(UMLOperation operation) {
        return this.getBody() == null && operation.getBody() == null && this.name.equals(operation.name) && this.equalTypeParameters(operation) && this.equalReturnParameter(operation) && this.getParameterTypeList().equals(operation.getParameterTypeList());
    }

    public boolean equalSignature(UMLOperation operation) {
        boolean equalParameterTypes = this.getParameterTypeList().equals(operation.getParameterTypeList());
        boolean compatibleParameterTypes = false;
        if (!equalParameterTypes) {
            List<UMLType> thisParameterTypeList = this.getParameterTypeList();
            List<UMLType> otherParameterTypeList = operation.getParameterTypeList();
            if (thisParameterTypeList.size() == otherParameterTypeList.size()) {
                int compatibleTypes = 0;
                int equalTypes = 0;
                for (int i = 0; i < thisParameterTypeList.size(); ++i) {
                    UMLType thisParameterType = thisParameterTypeList.get(i);
                    UMLType otherParameterType = otherParameterTypeList.get(i);
                    if ((thisParameterType.getClassType().endsWith("." + otherParameterType.getClassType()) || otherParameterType.getClassType().endsWith("." + thisParameterType.getClassType())) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension()) {
                        ++compatibleTypes;
                        continue;
                    }
                    if (!thisParameterType.equals(otherParameterType)) continue;
                    ++equalTypes;
                }
                if (equalTypes + compatibleTypes == thisParameterTypeList.size()) {
                    compatibleParameterTypes = true;
                }
            }
        }
        return this.name.equals(operation.name) && this.equalTypeParameters(operation) && (equalParameterTypes || compatibleParameterTypes) && this.equalReturnParameter(operation);
    }

    public boolean equalSignatureIgnoringOperationName(UMLOperation operation) {
        return this.visibility.equals((Object)operation.visibility) && this.isAbstract == operation.isAbstract && this.isFinal == operation.isFinal && this.isStatic == operation.isStatic && this.parameters.equals(operation.parameters) && this.equalTypeParameters(operation);
    }

    public boolean equalSignatureIgnoringChangedTypes(UMLOperation operation) {
        if (!(this.isConstructor && operation.isConstructor || this.equivalentName(operation))) {
            return false;
        }
        if (this.isAbstract != operation.isAbstract) {
            return false;
        }
        if (this.parameters.size() != operation.parameters.size()) {
            return false;
        }
        if (!this.equalTypeParameters(operation)) {
            return false;
        }
        int i = 0;
        for (UMLParameter thisParameter : this.parameters) {
            UMLParameter otherParameter;
            if (!thisParameter.equals(otherParameter = operation.parameters.get(i)) && !thisParameter.equalsExcludingType(otherParameter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalSignatureWithIdenticalNameIgnoringChangedTypes(UMLOperation operation) {
        if (!(this.isConstructor && operation.isConstructor || this.name.equals(operation.name))) {
            return false;
        }
        if (this.isAbstract != operation.isAbstract) {
            return false;
        }
        if (this.parameters.size() != operation.parameters.size()) {
            return false;
        }
        if (!this.equalTypeParameters(operation)) {
            return false;
        }
        int i = 0;
        for (UMLParameter thisParameter : this.parameters) {
            UMLParameter otherParameter;
            if (!thisParameter.equals(otherParameter = operation.parameters.get(i)) && !thisParameter.equalsExcludingType(otherParameter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalSignatureWithIdenticalNameIgnoringChangedTypesToFromObject(UMLOperation operation) {
        if (!(this.isConstructor && operation.isConstructor || this.name.equals(operation.name))) {
            return false;
        }
        if (this.isAbstract != operation.isAbstract) {
            return false;
        }
        if (this.parameters.size() != operation.parameters.size()) {
            return false;
        }
        if (!this.equalTypeParameters(operation)) {
            return false;
        }
        int i = 0;
        for (UMLParameter thisParameter : this.parameters) {
            UMLParameter otherParameter;
            if (!thisParameter.equals(otherParameter = operation.parameters.get(i)) && !thisParameter.equalsExcludingType(otherParameter)) {
                return false;
            }
            if (thisParameter.getName().equals(otherParameter.getName()) && !thisParameter.getType().equals(otherParameter.getType()) && !thisParameter.getType().getClassType().equals("Object") && !otherParameter.getType().getClassType().equals("Object")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equivalentName(UMLOperation operation) {
        return this.name.equals(operation.name) || UMLOperation.equivalentNames(this, operation) || UMLOperation.equivalentNames(operation, this);
    }

    private static boolean equivalentNames(UMLOperation operation1, UMLOperation operation2) {
        boolean equalReturn;
        boolean bl = equalReturn = operation1.equalReturnParameter(operation2) && operation1.getParametersWithoutReturnType().size() > 0 && operation2.getParametersWithoutReturnType().size() > 0;
        if (operation1.name.startsWith(operation2.name) && !operation2.name.equals("get") && !operation2.name.equals("set") && !operation2.name.equals("print")) {
            String suffix1 = operation1.name.substring(operation2.name.length(), operation1.name.length());
            String className2 = operation2.className.contains(".") ? operation2.className.substring(operation2.className.lastIndexOf(".") + 1, operation2.className.length()) : operation2.className;
            return operation2.name.length() > operation1.name.length() - operation2.name.length() || equalReturn || className2.contains(suffix1);
        }
        return false;
    }

    @Override
    public List<UMLParameter> getParametersWithoutReturnType() {
        ArrayList<UMLParameter> params = new ArrayList<UMLParameter>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            params.add(parameter);
        }
        return params;
    }

    public List<UMLParameter> getParameterizedTypesInSignature() {
        ArrayList<UMLParameter> params = new ArrayList<UMLParameter>();
        for (UMLParameter parameter : this.parameters) {
            if (!parameter.getType().isParameterized()) continue;
            params.add(parameter);
        }
        return params;
    }

    @Override
    public List<UMLType> getParameterTypeList() {
        ArrayList<UMLType> parameterTypeList = new ArrayList<UMLType>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            parameterTypeList.add(parameter.getType());
        }
        return parameterTypeList;
    }

    @Override
    public List<String> getParameterNameList() {
        ArrayList<String> parameterNameList = new ArrayList<String>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            parameterNameList.add(parameter.getName());
        }
        return parameterNameList;
    }

    @Override
    public List<VariableDeclaration> getParameterDeclarationList() {
        ArrayList<VariableDeclaration> parameterDeclarationList = new ArrayList<VariableDeclaration>();
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return")) continue;
            parameterDeclarationList.add(parameter.getVariableDeclaration());
        }
        return parameterDeclarationList;
    }

    @Override
    public int getNumberOfNonVarargsParameters() {
        int counter = 0;
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return") || parameter.isVarargs()) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public boolean hasVarargsParameter() {
        for (UMLParameter parameter : this.parameters) {
            if (parameter.getKind().equals("return") || !parameter.isVarargs()) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractCall isDelegate() {
        List<AbstractStatement> statements;
        if (this.getBody() != null && (statements = this.getBody().getCompositeStatement().getStatements()).size() == 1 && statements.get(0) instanceof StatementObject) {
            StatementObject statement = (StatementObject)statements.get(0);
            for (AbstractCall operationInvocation : statement.getMethodInvocations()) {
                if (!operationInvocation.matchesOperation(this, this, null, null) && (!operationInvocation.getName().equals(this.getName()) || operationInvocation.getExpression() != null && !operationInvocation.getExpression().endsWith("this"))) continue;
                return operationInvocation;
            }
        }
        return null;
    }

    @Override
    public boolean isGetter() {
        if (this.getBody() != null) {
            StatementObject statement;
            List<AbstractStatement> statements = this.getBody().getCompositeStatement().getStatements();
            List<UMLParameter> parameters = this.getParametersWithoutReturnType();
            if (statements.size() == 1 && statements.get(0) instanceof StatementObject && (statement = (StatementObject)statements.get(0)).getString().startsWith("return ")) {
                boolean parameterUsed = false;
                block0: for (UMLParameter parameter : parameters) {
                    for (LeafExpression variableExpression : statement.getVariables()) {
                        if (!variableExpression.getString().equals(parameter.getName())) continue;
                        parameterUsed = true;
                        continue block0;
                    }
                }
                for (LeafExpression variableExpression : statement.getVariables()) {
                    String variable = variableExpression.getString();
                    if (statement.getString().equals("return " + variable + ";\n") && (parameters.size() == 0 || !parameterUsed)) {
                        return true;
                    }
                    if (statement.getString().equals("return " + variable + ".keySet();\n") && (parameters.size() == 0 || !parameterUsed)) {
                        return true;
                    }
                    if (!statement.getString().equals("return " + variable + ".values();\n") || parameters.size() != 0 && parameterUsed) continue;
                    return true;
                }
                UMLParameter returnParameter = this.getReturnParameter();
                if ((this.name.startsWith("is") || this.name.startsWith("has")) && (parameters.size() == 0 || !parameterUsed) && returnParameter != null && returnParameter.getType().getClassType().equals("boolean")) {
                    return true;
                }
                if (statement.getString().equals("return null;\n")) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSetter() {
        List<AbstractStatement> statements;
        List<String> parameterNames = this.getParameterNameList();
        if (this.getBody() != null && parameterNames.size() == 1 && (statements = this.getBody().getCompositeStatement().getStatements()).size() == 1 && statements.get(0) instanceof StatementObject) {
            StatementObject statement = (StatementObject)statements.get(0);
            for (LeafExpression variableExpression : statement.getVariables()) {
                String variable = variableExpression.getString();
                if (!statement.getString().equals(variable + "=" + parameterNames.get(0) + ";\n")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMultiSetter() {
        List<String> parameterNames = this.getParameterNameList();
        int matchCount = 0;
        if (this.getBody() != null) {
            List<AbstractStatement> statements = this.getBody().getCompositeStatement().getStatements();
            for (AbstractStatement statement : statements) {
                if (!(statement instanceof StatementObject)) continue;
                block1: for (LeafExpression variableExpression : statement.getVariables()) {
                    String variable = variableExpression.getString();
                    if (!statement.getString().startsWith(variable + "=")) continue;
                    for (String parameterName : parameterNames) {
                        if (!statement.getString().equals(variable + "=" + parameterName + ";\n")) continue;
                        ++matchCount;
                        continue block1;
                    }
                }
            }
        }
        return matchCount > 0;
    }

    public boolean equalsIgnoringAbstraction(UMLOperation operation) {
        return this.className.equals(operation.className) && this.name.equals(operation.name) && this.equalReturnParameter(operation) && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
    }

    public boolean equalsIgnoringVisibility(UMLOperation operation) {
        boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
        boolean otherEmptyBody = operation.getBody() == null || operation.hasEmptyBody();
        return this.className.equals(operation.className) && this.name.equals(operation.name) && this.isAbstract == operation.isAbstract && thisEmptyBody == otherEmptyBody && this.equalReturnParameter(operation) && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
    }

    public boolean equalsIgnoringNameCase(UMLOperation operation) {
        boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
        boolean otherEmptyBody = operation.getBody() == null || operation.hasEmptyBody();
        return this.className.equals(operation.className) && this.name.equalsIgnoreCase(operation.name) && this.visibility.equals((Object)operation.visibility) && this.isAbstract == operation.isAbstract && thisEmptyBody == otherEmptyBody && this.equalReturnParameter(operation) && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UMLOperation) {
            UMLOperation operation = (UMLOperation)o;
            boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
            boolean otherEmptyBody = operation.getBody() == null || operation.hasEmptyBody();
            return this.className.equals(operation.className) && this.name.equals(operation.name) && this.visibility.equals((Object)operation.visibility) && this.isAbstract == operation.isAbstract && thisEmptyBody == otherEmptyBody && this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
        }
        return false;
    }

    public boolean equalsIgoringTypeParameters(UMLOperation operation) {
        boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
        boolean otherEmptyBody = operation.getBody() == null || operation.hasEmptyBody();
        return this.className.equals(operation.className) && this.name.equals(operation.name) && this.visibility.equals((Object)operation.visibility) && this.isAbstract == operation.isAbstract && thisEmptyBody == otherEmptyBody && this.getParameterTypeList().equals(operation.getParameterTypeList());
    }

    public boolean equalsQualified(UMLOperation operation) {
        if (this.className.equals(operation.className) && this.name.equals(operation.name) && this.visibility.equals((Object)operation.visibility) && this.isAbstract == operation.isAbstract && this.equalTypeParameters(operation)) {
            UMLParameter thisReturnParameter = this.getReturnParameter();
            UMLParameter otherReturnParameter = operation.getReturnParameter();
            if (thisReturnParameter != null && otherReturnParameter != null && !thisReturnParameter.getType().equalsQualified(otherReturnParameter.getType())) {
                return false;
            }
            List<UMLType> thisParameterTypeList = this.getParameterTypeList();
            List<UMLType> otherParameterTypeList = operation.getParameterTypeList();
            if (thisParameterTypeList.size() != otherParameterTypeList.size()) {
                return false;
            }
            for (int i = 0; i < thisParameterTypeList.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypeList.get(i);
                if (thisParameterType.equalsQualified(otherParameterType = otherParameterTypeList.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        boolean thisEmptyBody = this.getBody() == null || this.hasEmptyBody();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.isAbstract ? 1231 : 1237);
        result = 31 * result + (thisEmptyBody ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.getParameterTypeList() == null ? 0 : this.getParameterTypeList().hashCode());
        result = 31 * result + (this.visibility == null ? 0 : this.visibility.hashCode());
        result = 31 * result + (this.typeParameters == null ? 0 : this.typeParameters.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.visibility);
        sb.append(" ");
        if (this.isAbstract) {
            sb.append("abstract");
            sb.append(" ");
        }
        sb.append(this.name);
        UMLParameter returnParameter = this.getReturnParameter();
        ArrayList<UMLParameter> parameters = new ArrayList<UMLParameter>(this.parameters);
        parameters.remove(returnParameter);
        sb.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            UMLParameter parameter = (UMLParameter)parameters.get(i);
            if (!parameter.getKind().equals("in")) continue;
            sb.append(parameter);
            if (i >= parameters.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (returnParameter != null) {
            sb.append(" : ");
            sb.append(returnParameter.toString());
        }
        return sb.toString();
    }

    @Override
    public String toQualifiedString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.visibility);
        sb.append(" ");
        if (this.isAbstract) {
            sb.append("abstract");
            sb.append(" ");
        }
        sb.append(this.name);
        UMLParameter returnParameter = this.getReturnParameter();
        ArrayList<UMLParameter> parameters = new ArrayList<UMLParameter>(this.parameters);
        parameters.remove(returnParameter);
        sb.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            UMLParameter parameter = (UMLParameter)parameters.get(i);
            if (!parameter.getKind().equals("in")) continue;
            sb.append(parameter.toQualifiedString());
            if (i >= parameters.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (returnParameter != null) {
            sb.append(" : ");
            sb.append(returnParameter.toQualifiedString());
        }
        return sb.toString();
    }

    public String getKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className);
        sb.append('#');
        sb.append(this.name);
        UMLParameter returnParameter = this.getReturnParameter();
        ArrayList<UMLParameter> parameters = new ArrayList<UMLParameter>(this.parameters);
        parameters.remove(returnParameter);
        sb.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            UMLParameter parameter = (UMLParameter)parameters.get(i);
            if (!parameter.getKind().equals("in")) continue;
            sb.append(AstUtils.stripTypeParamsFromTypeName(parameter.getType().toString()));
            if (i >= parameters.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(UMLOperation operation) {
        return this.toString().compareTo(operation.toString());
    }

    public double normalizedNameDistance(UMLOperation operation) {
        String s1 = this.getName().toLowerCase();
        String s2 = operation.getName().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    public boolean testMethodCheck(UMLOperation operation) {
        if (this.hasTestAnnotation() && !operation.hasTestAnnotation() && !operation.containsAssertion()) {
            return false;
        }
        return this.hasTestAnnotation() || this.containsAssertion() || !operation.hasTestAnnotation();
    }

    public boolean equalParameters(UMLOperation operation) {
        return this.equalReturnParameter(operation) && this.getParameters().equals(operation.getParameters());
    }

    public boolean equalParameterTypes(UMLOperation operation) {
        return this.getParameterTypeList().equals(operation.getParameterTypeList()) && this.equalTypeParameters(operation);
    }

    private boolean typeParameterToTypeArgumentMatch(UMLOperation operation, Map<UMLTypeParameter, UMLType> typeParameterToTypeArgumentMap) {
        for (UMLTypeParameter key : typeParameterToTypeArgumentMap.keySet()) {
            UMLType value = typeParameterToTypeArgumentMap.get(key);
            UMLParameter thisReturnParameter = this.getReturnParameter();
            UMLParameter otherReturnParameter = operation.getReturnParameter();
            if (thisReturnParameter == null || otherReturnParameter == null) continue;
            UMLType thisReturnType = thisReturnParameter.getType();
            UMLType otherReturnType = otherReturnParameter.getType();
            if (thisReturnType.toString().equals(value.toString()) && (otherReturnType.toString().equals(key.toString()) || otherReturnType.toString().equals(key.getName()))) {
                return true;
            }
            if (!otherReturnType.toString().equals(value.toString()) || !thisReturnType.toString().equals(key.toString()) && !thisReturnType.toString().equals(key.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean equalTypeParameters(UMLOperation operation) {
        return this.typeParameters.equals(operation.typeParameters);
    }

    private boolean equalParameterNames(UMLOperation operation) {
        return this.getParameterNameList().equals(operation.getParameterNameList());
    }

    private boolean overloadedParameterTypes(UMLOperation operation) {
        return this.getParameterTypeList().containsAll(operation.getParameterTypeList()) || operation.getParameterTypeList().containsAll(this.getParameterTypeList());
    }

    public boolean replacedParameterTypes(UMLOperation operation) {
        List<UMLType> thisParameterTypes = this.getParameterTypeList();
        List<UMLType> otherParameterTypes = operation.getParameterTypeList();
        if (thisParameterTypes.size() == otherParameterTypes.size() && thisParameterTypes.size() > 0) {
            int commonParameterTypes = 0;
            int differentParameterTypes = 0;
            for (int i = 0; i < thisParameterTypes.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypes.get(i);
                if (thisParameterType.equals(otherParameterType = otherParameterTypes.get(i)) || thisParameterType.getClassType().equals(otherParameterType.getClassType()) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension() || thisParameterType.equalsWithSubType(otherParameterType)) {
                    ++commonParameterTypes;
                    continue;
                }
                ++differentParameterTypes;
            }
            return commonParameterTypes >= differentParameterTypes && commonParameterTypes > 0;
        }
        if (thisParameterTypes.size() > otherParameterTypes.size() && thisParameterTypes.size() > 0) {
            int commonParameterTypes = 0;
            int differentParameterTypes = 0;
            for (int i = 0; i < otherParameterTypes.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypes.get(i);
                if (thisParameterType.equals(otherParameterType = otherParameterTypes.get(i)) || thisParameterType.getClassType().equals(otherParameterType.getClassType()) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension() || thisParameterType.equalsWithSubType(otherParameterType)) {
                    ++commonParameterTypes;
                    continue;
                }
                ++differentParameterTypes;
            }
            return commonParameterTypes >= differentParameterTypes && commonParameterTypes > 0;
        }
        if (otherParameterTypes.size() > thisParameterTypes.size() && thisParameterTypes.size() > 0) {
            int commonParameterTypes = 0;
            int differentParameterTypes = 0;
            for (int i = 0; i < thisParameterTypes.size(); ++i) {
                UMLType otherParameterType;
                UMLType thisParameterType = thisParameterTypes.get(i);
                if (thisParameterType.equals(otherParameterType = otherParameterTypes.get(i)) || thisParameterType.getClassType().equals(otherParameterType.getClassType()) && thisParameterType.getArrayDimension() == otherParameterType.getArrayDimension() || thisParameterType.equalsWithSubType(otherParameterType)) {
                    ++commonParameterTypes;
                    continue;
                }
                ++differentParameterTypes;
            }
            return commonParameterTypes >= differentParameterTypes && commonParameterTypes > 0;
        }
        return false;
    }

    public List<UMLOperation> getOperationsInsideAnonymousClass(List<UMLAnonymousClass> allAddedAnonymousClasses) {
        ArrayList<UMLOperation> operationsInsideAnonymousClass = new ArrayList<UMLOperation>();
        if (this.operationBody != null) {
            List<AnonymousClassDeclarationObject> anonymousClassDeclarations = this.operationBody.getAllAnonymousClassDeclarations();
            for (AnonymousClassDeclarationObject anonymousClassDeclaration : anonymousClassDeclarations) {
                for (UMLAnonymousClass anonymousClass : allAddedAnonymousClasses) {
                    if (!anonymousClass.getLocationInfo().equals(anonymousClassDeclaration.getLocationInfo())) continue;
                    operationsInsideAnonymousClass.addAll(anonymousClass.getOperations());
                }
            }
        }
        return operationsInsideAnonymousClass;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public boolean overridesObject() {
        return this.isEquals() || this.isHashCode() || this.isToString() || this.isClone() || this.isCompareTo();
    }

    private boolean isEquals() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("equals") && this.getReturnParameter().getType().getClassType().equals("boolean") && parameterTypeList.size() == 1 && parameterTypeList.get(0).getClassType().equals("Object");
    }

    private boolean isHashCode() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("hashCode") && this.getReturnParameter().getType().getClassType().equals("int") && parameterTypeList.size() == 0;
    }

    private boolean isToString() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("toString") && this.getReturnParameter().getType().getClassType().equals("String") && parameterTypeList.size() == 0;
    }

    private boolean isClone() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("clone") && this.getReturnParameter().getType().getClassType().equals("Object") && parameterTypeList.size() == 0;
    }

    private boolean isCompareTo() {
        List<UMLType> parameterTypeList = this.getParameterTypeList();
        return this.getName().equals("compareTo") && this.getReturnParameter().getType().getClassType().equals("int") && parameterTypeList.size() == 1;
    }

    public boolean compatibleSignature(UMLOperation removedOperation) {
        return this.equalReturnParameter(removedOperation) && (this.equalParameterTypes(removedOperation) || this.overloadedParameterTypes(removedOperation) || this.equalParameterNames(removedOperation)) || this.replacedParameterTypes(removedOperation);
    }

    public boolean compatibleSignature(UMLOperation removedOperation, Map<UMLTypeParameter, UMLType> typeParameterToTypeArgumentMap) {
        return (this.equalReturnParameter(removedOperation) || this.typeParameterToTypeArgumentMatch(removedOperation, typeParameterToTypeArgumentMap)) && (this.equalParameterTypes(removedOperation) || this.overloadedParameterTypes(removedOperation) || this.equalParameterNames(removedOperation)) || this.replacedParameterTypes(removedOperation);
    }

    public boolean hasTwoParametersWithTheSameType() {
        List<UMLType> parameterTypes = this.getParameterTypeList();
        return parameterTypes.size() == 2 && parameterTypes.get(0).equals(parameterTypes.get(1));
    }

    public List<String> getSignatureIdentifiers() {
        ArrayList<String> signature = new ArrayList<String>();
        signature.add(this.name);
        signature.addAll(this.getParameterNameList());
        return signature;
    }

    public static boolean isParameterizedTestAnnotation(UMLAnnotation a) {
        return UMLOperation.isJUnit5ParameterizedTest(a) || UMLOperation.isTestNGParameterizedAnnotation(a);
    }

    private static boolean isJUnit5ParameterizedTest(UMLAnnotation a) {
        return a.getTypeName().equals("ParameterizedTest");
    }

    public static boolean isTestNGParameterizedAnnotation(UMLAnnotation a) {
        return a.getTypeName().equals("Test") && a.isNormalAnnotation() && a.getMemberValuePairs().containsKey("dataProvider");
    }
}

