/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.List;

public class UMLTypeParameter
implements LocationInfoProvider {
    private String name;
    private List<UMLType> typeBounds;
    private List<UMLAnnotation> annotations;
    private LocationInfo locationInfo;

    public UMLTypeParameter(String name, LocationInfo locationInfo) {
        this.name = name;
        this.locationInfo = locationInfo;
        this.typeBounds = new ArrayList<UMLType>();
        this.annotations = new ArrayList<UMLAnnotation>();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public List<UMLType> getTypeBounds() {
        return this.typeBounds;
    }

    public void addTypeBound(UMLType type) {
        this.typeBounds.add(type);
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(UMLAnnotation annotation) {
        this.annotations.add(annotation);
    }

    protected String typeBoundsToString() {
        StringBuilder sb = new StringBuilder();
        if (!this.typeBounds.isEmpty()) {
            sb.append(" extends ");
            for (int i = 0; i < this.typeBounds.size(); ++i) {
                sb.append(this.typeBounds.get(i).toQualifiedString());
                if (i >= this.typeBounds.size() - 1) continue;
                sb.append(" & ");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(this.typeBoundsToString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.typeBounds == null ? 0 : this.typeBounds.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLTypeParameter other = (UMLTypeParameter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.typeBounds == null ? other.typeBounds != null : !this.typeBounds.equals(other.typeBounds));
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }
}

