/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface VariableDeclarationContainer
extends LocationInfoProvider {
    default public List<VariableDeclaration> getAllVariableDeclarations() {
        OperationBody operationBody = this.getBody();
        if (operationBody != null) {
            ArrayList<VariableDeclaration> allVariableDeclarations = new ArrayList<VariableDeclaration>();
            allVariableDeclarations.addAll(this.getParameterDeclarationList());
            allVariableDeclarations.addAll(operationBody.getAllVariableDeclarations());
            return allVariableDeclarations;
        }
        return this.getParameterDeclarationList();
    }

    default public List<VariableDeclaration> getVariableDeclarationsInScope(LocationInfo location) {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
        for (VariableDeclaration parameterDeclaration : this.getParameterDeclarationList()) {
            if (!parameterDeclaration.getScope().subsumes(location)) continue;
            variableDeclarations.add(parameterDeclaration);
        }
        OperationBody operationBody = this.getBody();
        if (operationBody != null) {
            variableDeclarations.addAll(operationBody.getVariableDeclarationsInScope(location));
        }
        return variableDeclarations;
    }

    default public VariableDeclaration getVariableDeclaration(String variableName) {
        VariableDeclaration variableDeclatation;
        OperationBody operationBody = this.getBody();
        if (operationBody != null && (variableDeclatation = operationBody.getVariableDeclaration(variableName)) != null) {
            return variableDeclatation;
        }
        for (VariableDeclaration parameterDeclaration : this.getParameterDeclarationList()) {
            if (!parameterDeclaration.getVariableName().equals(variableName)) continue;
            return parameterDeclaration;
        }
        return null;
    }

    public List<VariableDeclaration> getParameterDeclarationList();

    public List<UMLType> getParameterTypeList();

    public List<String> getParameterNameList();

    public List<UMLParameter> getParametersWithoutReturnType();

    default public boolean equalReturnParameter(VariableDeclarationContainer operation) {
        if (this instanceof UMLOperation && operation instanceof UMLOperation) {
            return ((UMLOperation)this).equalReturnParameter((UMLOperation)operation);
        }
        return false;
    }

    public int getNumberOfNonVarargsParameters();

    public boolean hasVarargsParameter();

    public OperationBody getBody();

    public List<UMLAnonymousClass> getAnonymousClassList();

    public List<LambdaExpressionObject> getAllLambdas();

    public List<AbstractCall> getAllOperationInvocations();

    public List<AbstractCall> getAllCreations();

    public List<String> getAllVariables();

    public List<UMLComment> getComments();

    public String getName();

    public String getElementType();

    public String getClassName();

    public String toQualifiedString();

    public Map<String, Set<VariableDeclaration>> variableDeclarationMap();

    public UMLAnonymousClass findAnonymousClass(AnonymousClassDeclarationObject var1);

    public boolean hasTestAnnotation();

    public boolean hasParameterizedTestAnnotation();

    public boolean hasSetUpAnnotation();

    public boolean hasTearDownAnnotation();

    public boolean isDeclaredInAnonymousClass();

    public Optional<UMLAnonymousClass> getAnonymousClassContainer();

    public boolean isGetter();

    public boolean isConstructor();

    public AbstractCall isDelegate();

    default public boolean hasEmptyBody() {
        OperationBody operationBody = this.getBody();
        if (operationBody != null) {
            return operationBody.getCompositeStatement().getStatements().size() == 0;
        }
        return false;
    }

    default public boolean emptyBodiesWithIdenticalComments(VariableDeclarationContainer other) {
        if (this.hasEmptyBody() && other.hasEmptyBody()) {
            List<UMLComment> comments1 = this.getComments();
            List<UMLComment> comments2 = other.getComments();
            if (comments1.size() == comments2.size() && comments1.size() > 0) {
                int identicalComments = 0;
                for (int i = 0; i < comments1.size(); ++i) {
                    if (!comments1.get(i).getText().equals(comments2.get(i).getText())) continue;
                    ++identicalComments;
                }
                return identicalComments == comments1.size();
            }
        }
        return false;
    }

    default public AbstractCall delegatesTo(VariableDeclarationContainer operation, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        List<AbstractStatement> statements;
        if (this.getBody() != null && (statements = this.getBody().getCompositeStatement().getStatements()).size() == 1 && statements.get(0) instanceof StatementObject) {
            StatementObject statement = (StatementObject)statements.get(0);
            for (AbstractCall operationInvocation : statement.getMethodInvocations()) {
                if (!operationInvocation.matchesOperation(operation, this, classDiff, modelDiff)) continue;
                return operationInvocation;
            }
        }
        return null;
    }

    default public int getBodyHashCode() {
        OperationBody operationBody = this.getBody();
        if (operationBody != null) {
            return operationBody.getBodyHashCode();
        }
        return 0;
    }

    default public List<String> stringRepresentation() {
        OperationBody operationBody = this.getBody();
        if (operationBody != null) {
            return operationBody.stringRepresentation();
        }
        return Collections.emptyList();
    }

    default public List<UMLType> commonParameterTypes(VariableDeclarationContainer operation) {
        ArrayList<UMLType> commonParameterTypes = new ArrayList<UMLType>();
        List<UMLType> thisParameterTypeList = this.getParameterTypeList();
        List<UMLType> otherParameterTypeList = operation.getParameterTypeList();
        int min = Math.min(thisParameterTypeList.size(), otherParameterTypeList.size());
        for (int i = 0; i < min; ++i) {
            UMLType otherParameterType;
            UMLType thisParameterType = thisParameterTypeList.get(i);
            if (!thisParameterType.equals(otherParameterType = otherParameterTypeList.get(i))) continue;
            commonParameterTypes.add(thisParameterType);
        }
        return commonParameterTypes;
    }

    default public CompositeStatementObject loopWithVariables(String currentElementName, String collectionName) {
        OperationBody operationBody = this.getBody();
        if (operationBody != null) {
            return operationBody.loopWithVariables(currentElementName, collectionName);
        }
        return null;
    }

    default public Map<String, Set<String>> aliasedVariables() {
        OperationBody operationBody = this.getBody();
        if (operationBody != null) {
            Map<String, Set<VariableDeclaration>> variableDeclarationMap = this.variableDeclarationMap();
            Map<String, Set<String>> map = operationBody.aliasedVariables();
            LinkedHashMap toBeAdded = new LinkedHashMap();
            LinkedHashSet<String> keysToBeRemoved = new LinkedHashSet<String>();
            for (String key : map.keySet()) {
                if (!variableDeclarationMap.containsKey(key)) {
                    keysToBeRemoved.add(key);
                    continue;
                }
                boolean foundInLocalVariables = false;
                for (String value : map.get(key)) {
                    UMLType variableType;
                    if (variableDeclarationMap.containsKey(value)) {
                        foundInLocalVariables = true;
                        break;
                    }
                    String[] tokens = value.split("\\s");
                    if (tokens.length < 2) continue;
                    String lastToken = tokens[tokens.length - 1];
                    String beforeLastToken = tokens[tokens.length - 2];
                    if (!variableDeclarationMap.containsKey(lastToken) || (variableType = variableDeclarationMap.get(lastToken).iterator().next().getType()) == null || !variableType.toString().equals(beforeLastToken)) continue;
                    LinkedHashSet<String> values = new LinkedHashSet<String>();
                    values.add(lastToken);
                    toBeAdded.put(key, values);
                    break;
                }
                if (foundInLocalVariables) continue;
                keysToBeRemoved.add(key);
            }
            for (String key : keysToBeRemoved) {
                map.remove(key);
            }
            map.putAll(toBeAdded);
            return map;
        }
        return new LinkedHashMap<String, Set<String>>();
    }

    default public Map<String, Set<String>> aliasedAttributes() {
        OperationBody operationBody = this.getBody();
        if (operationBody != null && this.isConstructor()) {
            List<String> parameterNames = this.getParameterNameList();
            Map<String, Set<String>> map = operationBody.aliasedAttributes();
            LinkedHashSet<String> keysToBeRemoved = new LinkedHashSet<String>();
            for (String key : map.keySet()) {
                if (parameterNames.contains(key)) continue;
                keysToBeRemoved.add(key);
            }
            for (String key : keysToBeRemoved) {
                map.remove(key);
            }
            return map;
        }
        return new LinkedHashMap<String, Set<String>>();
    }
}

