/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.annotation.source;

import gr.uom.java.xmi.SourceAnnotation;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.annotation.NormalAnnotation;
import gr.uom.java.xmi.annotation.SingleMemberAnnotation;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.util.CsvUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CsvFileSourceAnnotation
extends SourceAnnotation
implements NormalAnnotation,
SingleMemberAnnotation {
    public static final String ANNOTATION_TYPENAME = "CsvFileSource";

    public CsvFileSourceAnnotation(UMLAnnotation annotation, UMLOperation operation, UMLModel model) {
        super(annotation, ANNOTATION_TYPENAME);
        this.testParameters = CsvUtils.extractParametersFromCsvFile(this.getValue());
    }

    @Override
    public List<List<String>> getTestParameters() {
        return this.testParameters;
    }

    @Override
    public List<String> getValue() {
        Stream st = Stream.empty();
        if (this.annotation.isSingleMemberAnnotation()) {
            try {
                for (LeafExpression expression : this.annotation.getValue().getStringLiterals()) {
                    Stream nextFileContent = CsvUtils.readLinesOfCsvFile(expression.getString()).stream();
                    st = Stream.concat(st, nextFileContent);
                }
                return st.collect(Collectors.toList());
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }
        if (this.annotation.isNormalAnnotation()) {
            Map<String, AbstractExpression> parameters = this.annotation.getMemberValuePairs();
            if (parameters.containsKey("files")) {
                try {
                    for (LeafExpression expression : parameters.get("files").getStringLiterals()) {
                        String literal = expression.getString();
                        literal = literal.startsWith("\"") ? literal.substring(1) : literal;
                        literal = literal.endsWith("\"") ? literal.substring(0, literal.length() - 1) : literal;
                        Stream nextFileContent = CsvUtils.readLinesOfCsvFile(literal.strip()).stream();
                        st = Stream.concat(st, nextFileContent);
                    }
                    return st.collect(Collectors.toList());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
            if (parameters.containsKey("resources")) {
                try {
                    for (LeafExpression expression : parameters.get("resources").getStringLiterals()) {
                        Object filePath = expression.getString();
                        String resPath = "/src/test/resources";
                        filePath = ((String)filePath).startsWith("/") ? "/src/test/resources" + (String)filePath : "/src/test/resources/" + (String)filePath;
                        Stream nextFileContent = CsvUtils.readLinesOfCsvFile((String)filePath).stream();
                        st = Stream.concat(st, nextFileContent);
                    }
                    return st.collect(Collectors.toList());
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
            throw new IllegalArgumentException("@CsvFileSource normal annotation should have a value or resources parameter");
        }
        throw new IllegalArgumentException("@CsvFileSource should be a normal or single member annotation");
    }
}

