/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.annotation.source;

import gr.uom.java.xmi.SourceAnnotation;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.annotation.NormalAnnotation;
import gr.uom.java.xmi.annotation.SingleMemberAnnotation;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.util.CsvUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CsvSourceAnnotation
extends SourceAnnotation
implements NormalAnnotation,
SingleMemberAnnotation {
    public static final String ANNOTATION_TYPENAME = "CsvSource";

    public CsvSourceAnnotation(UMLAnnotation annotation, UMLOperation operation, UMLModel model) {
        super(annotation, ANNOTATION_TYPENAME);
        for (String csvParams : this.getValue()) {
            List<String> parameters = CsvUtils.extractParametersFromCsv(csvParams);
            this.testParameters.add(parameters);
        }
    }

    @Override
    public List<List<String>> getTestParameters() {
        return this.testParameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> getValue() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.annotation.isSingleMemberAnnotation()) {
            for (LeafExpression literal : this.annotation.getValue().getStringLiterals()) {
                result.add(literal.getString());
            }
            return result;
        }
        if (!this.annotation.isNormalAnnotation()) return null;
        Map<String, AbstractExpression> parameters = this.annotation.getMemberValuePairs();
        if (parameters.containsKey("value")) {
            for (LeafExpression literal : parameters.get("value").getStringLiterals()) {
                result.add(literal.getString());
            }
            return null;
        } else {
            if (!parameters.containsKey("textBlock")) throw new IllegalArgumentException("@CsvSource normal annotation should have a value or textBlock parameter");
            List<LeafExpression> textBlock = parameters.get("textBlock").getStringLiterals();
            if (textBlock.size() == 1) {
                for (String line : textBlock.get(0).getString().split("[\\r\\n]+")) {
                    result.add(line);
                }
                return null;
            } else {
                if (textBlock.size() <= 1) throw new IllegalArgumentException("@CsvSource text block should not be empty");
                for (LeafExpression literal : textBlock) {
                    result.add(literal.getString());
                }
            }
        }
        return null;
    }
}

