/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.annotation.source;

import gr.uom.java.xmi.SourceAnnotation;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.annotation.MarkerAnnotation;
import gr.uom.java.xmi.annotation.NormalAnnotation;
import gr.uom.java.xmi.annotation.SingleMemberAnnotation;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.LeafExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EnumSourceAnnotation
extends SourceAnnotation
implements SingleMemberAnnotation,
MarkerAnnotation,
NormalAnnotation {
    public static final String ANNOTATION_TYPENAME = "EnumSource";
    private List<List<String>> testParameters = new ArrayList<List<String>>();

    public EnumSourceAnnotation(UMLAnnotation annotation, UMLOperation operation, UMLModel model) {
        super(annotation, ANNOTATION_TYPENAME);
        String enumClassLiteral = annotation.isMarkerAnnotation() ? EnumSourceAnnotation.sanitizeLiteral(EnumSourceAnnotation.getFirstParameterType(operation)) : EnumSourceAnnotation.sanitizeLiteral(this.getValue().get(0));
        UMLClass enumClassDeclaration = EnumSourceAnnotation.findEnumDeclaration(model, enumClassLiteral);
        if (annotation.isNormalAnnotation() && annotation.getMemberValuePairs().containsKey("names")) {
            if (annotation.getMemberValuePairs().containsKey("mode")) {
                String mode = annotation.getMemberValuePairs().get("mode").getString();
                if (mode.equals("EXCLUDE") || mode.equals("Mode.EXCLUDE") || mode.equals("EnumSource.Mode.EXCLUDE")) {
                    for (UMLEnumConstant constant : enumClassDeclaration.getEnumConstants()) {
                        if (EnumSourceAnnotation.isExcluded(annotation, constant)) continue;
                        this.testParameters.add(Collections.singletonList(EnumSourceAnnotation.sanitizeLiteral(constant.getName())));
                    }
                } else {
                    this.testParameters.addAll(EnumSourceAnnotation.extractIncludedNames(annotation));
                }
            } else {
                this.testParameters.addAll(EnumSourceAnnotation.extractIncludedNames(annotation));
            }
        } else {
            for (UMLEnumConstant constant : enumClassDeclaration.getEnumConstants()) {
                this.testParameters.add(Collections.singletonList(EnumSourceAnnotation.sanitizeLiteral(constant.getName())));
            }
        }
    }

    private static boolean isExcluded(UMLAnnotation annotation, UMLEnumConstant constant) {
        return annotation.getMemberValuePairs().get("names").getStringLiterals().contains(constant.getName());
    }

    private static List<List<String>> extractIncludedNames(UMLAnnotation annotation) {
        ArrayList<List<String>> includedValues = new ArrayList<List<String>>();
        for (LeafExpression expression : annotation.getMemberValuePairs().get("names").getStringLiterals()) {
            includedValues.add(Collections.singletonList(EnumSourceAnnotation.sanitizeLiteral(expression.getString())));
        }
        return includedValues;
    }

    private static UMLClass findEnumDeclaration(UMLModel model, String enumClassLiteral) {
        UMLClass enumClassDeclaration = null;
        for (UMLClass aClass : model.getClassList()) {
            if (!aClass.getName().contains(enumClassLiteral)) continue;
            enumClassDeclaration = aClass;
        }
        return enumClassDeclaration;
    }

    private static String getFirstParameterType(UMLOperation operation) {
        return operation.getParametersWithoutReturnType().get(0).getType().getClassType();
    }

    @Override
    public List<String> getValue() {
        assert (!this.annotation.isMarkerAnnotation()) : "getValue() is not supported by marker EnumSource annotation";
        AbstractExpression value = this.annotation.isSingleMemberAnnotation() ? this.annotation.getValue() : this.annotation.getMemberValuePairs().get("value");
        List<LeafExpression> typeLiterals = value.getTypeLiterals();
        assert (typeLiterals.size() == 1);
        return Collections.singletonList(typeLiterals.get(0).getString());
    }

    @Override
    public List<List<String>> getTestParameters() {
        return this.testParameters;
    }
}

