/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.annotation.source;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.SourceAnnotation;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.annotation.MarkerAnnotation;
import gr.uom.java.xmi.annotation.SingleMemberAnnotation;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodSourceAnnotation
extends SourceAnnotation
implements SingleMemberAnnotation,
MarkerAnnotation {
    private static final String ANNOTATION_TYPENAME = "MethodSource";
    private final UMLOperation annotatedOperation;

    public MethodSourceAnnotation(UMLAnnotation annotation, UMLOperation operation, UMLModel model) {
        super(annotation, ANNOTATION_TYPENAME);
        this.annotatedOperation = operation;
        List<String> values = this.getValue();
        assert (values.size() == 1);
        String methodSourceName = values.get(0);
        String pkg = operation.getClassName().substring(0, operation.getClassName().lastIndexOf("."));
        String name = operation.getNonQualifiedClassName();
        LocationInfo locationInfo = operation.getLocationInfo();
        UMLClass declaringClass = model.getClass(new UMLClass(pkg, name, locationInfo, true, Collections.emptyList()));
        List sameNameMethods = declaringClass.getOperations().stream().filter(op -> op.getName().equals(methodSourceName)).collect(Collectors.toList());
        int maxIterations = sameNameMethods.size();
        block0: while (sameNameMethods.size() > 1 && maxIterations-- > 0) {
            Iterator iterator = sameNameMethods.iterator();
            while (iterator.hasNext()) {
                UMLOperation method = (UMLOperation)iterator.next();
                if (method.getAnnotations().containsAll(operation.getAnnotations())) {
                    iterator.remove();
                    continue block0;
                }
                if (!method.equalSignature(operation)) continue;
                iterator.remove();
                continue block0;
            }
        }
        UMLOperation sourceMethod = (UMLOperation)sameNameMethods.get(0);
        Optional<VariableDeclaration> returnedVarCandidates = sourceMethod.getBody().getAllVariableDeclarations().stream().filter(v -> sourceMethod.getReturnParameter().getType().equals(v.getType())).findAny();
        if (returnedVarCandidates.isPresent()) {
            Set<AbstractCodeFragment> stmtsUsingVar = returnedVarCandidates.get().getStatementsInScopeUsingVariable();
            String strLiterals = stmtsUsingVar.stream().flatMap(stmt -> stmt.getStringLiterals().stream()).map(str -> str.getString()).collect(Collectors.joining(System.getProperty("line.separator")));
        } else {
            Optional<StatementObject> stmtCandidate = sourceMethod.getBody().getCompositeStatement().getStatements().stream().filter(s -> s instanceof StatementObject).map(s -> (StatementObject)s).filter(s -> s.isLastStatement()).findAny();
            if (stmtCandidate.isPresent()) {
                String string = stmtCandidate.get().getStringLiterals().stream().map(str -> str.getString()).collect(Collectors.joining(System.getProperty("line.separator")));
            }
        }
    }

    @Override
    public List<String> getValue() {
        return Collections.singletonList(this.annotation.isMarkerAnnotation() ? this.annotatedOperation.getName() : this.annotation.getValue().getTypeLiterals().get(0).getString());
    }

    @Override
    public List<List<String>> getTestParameters() {
        return null;
    }
}

