/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.annotation.source;

import gr.uom.java.xmi.SourceAnnotation;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.annotation.NormalAnnotation;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.LeafExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValueSourceAnnotation
extends SourceAnnotation
implements NormalAnnotation {
    public static final String ANNOTATION_TYPENAME = "ValueSource";
    private final Map<String, AbstractExpression> memberValuePairs;
    private final List<List<String>> testParameters;
    private Set<String> numberKeys = Set.of("bytes", "doubles", "floats", "ints", "longs", "shorts");
    private Set<String> stringKeys = Set.of("strings", "chars");

    private List<LeafExpression> extractLiterals(AbstractExpression annotationParameterValue, String memberKey) {
        if (this.numberKeys.contains(memberKey)) {
            return annotationParameterValue.getNumberLiterals();
        }
        if (this.stringKeys.contains(memberKey)) {
            return annotationParameterValue.getStringLiterals();
        }
        if (memberKey.equals("booleans")) {
            return annotationParameterValue.getBooleanLiterals();
        }
        if (memberKey.equals("classes")) {
            return annotationParameterValue.getTypeLiterals();
        }
        return Collections.emptyList();
    }

    public ValueSourceAnnotation(UMLAnnotation annotation, UMLOperation operation, UMLModel model) {
        super(annotation, ANNOTATION_TYPENAME);
        this.memberValuePairs = annotation.getMemberValuePairs();
        Set<String> providedKeys = this.memberValuePairs.keySet();
        this.testParameters = new ArrayList<List<String>>();
        for (String key : providedKeys) {
            AbstractExpression annotationParameterValue = this.memberValuePairs.get(key);
            for (LeafExpression literal : this.extractLiterals(annotationParameterValue, key)) {
                this.testParameters.add(Collections.singletonList(ValueSourceAnnotation.sanitizeLiteral(literal.getString())));
            }
        }
    }

    @Override
    public List<List<String>> getTestParameters() {
        return this.testParameters;
    }
}

