/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LeafType;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.MethodReference;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.StringBasedHeuristics;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.MergeVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.VariableReplacementWithMethodInvocation;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public abstract class AbstractCall
extends LeafExpression {
    protected int numberOfArguments;
    protected String expression;
    protected List<String> arguments;
    protected StatementCoverageType coverage = StatementCoverageType.NONE;
    private static final List<String> logNames = List.of("trace", "debug", "info", "warn", "error", "fatal", "log");
    private static final List<String> logGuardNames = List.of("isDebugEnabled", "isEnabled", "isErrorEnabled", "isFatalEnabled", "isInfoEnabled", "isTraceEnabled", "isWarnEnabled");

    public AbstractCall(CompilationUnit cu, String filePath, ASTNode expression, LocationInfo.CodeElementType codeElementType, VariableDeclarationContainer container) {
        super(cu, filePath, expression, codeElementType, container);
    }

    protected AbstractCall() {
    }

    public LeafExpression asLeafExpression() {
        return new LeafExpression(this.getString(), this.getLocationInfo());
    }

    public String getExpression() {
        return this.expression;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public StatementCoverageType getCoverage() {
        return this.coverage;
    }

    public abstract boolean identicalName(AbstractCall var1);

    public abstract String getName();

    public abstract double normalizedNameDistance(AbstractCall var1);

    public abstract AbstractCall update(String var1, String var2);

    public boolean matchesOperation(VariableDeclarationContainer operation, VariableDeclarationContainer callerOperation, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        if (this instanceof OperationInvocation) {
            return ((OperationInvocation)this).matchesOperation(operation, callerOperation, classDiff, modelDiff);
        }
        if (this instanceof MethodReference) {
            MethodReference methodReference = (MethodReference)this;
            return methodReference.getName().equals(operation.getName());
        }
        return false;
    }

    public boolean compatibleExpression(AbstractCall other) {
        if (this instanceof OperationInvocation && other instanceof OperationInvocation) {
            return ((OperationInvocation)this).compatibleExpression((OperationInvocation)other);
        }
        if (this.expression != null && other.expression != null) {
            return this.expression.equals(other.expression);
        }
        return false;
    }

    public boolean differentExpressionNameAndArguments(AbstractCall other) {
        boolean differentExpression = false;
        if (this.expression == null && other.expression != null) {
            differentExpression = true;
        }
        if (this.expression != null && other.expression == null) {
            differentExpression = true;
        }
        if (this.expression != null && other.expression != null) {
            differentExpression = !this.expression.equals(other.expression) && !this.expression.startsWith(other.expression) && !other.expression.startsWith(this.expression);
        }
        boolean differentName = !this.getName().equals(other.getName());
        LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(this.arguments);
        argumentIntersection.retainAll(other.arguments);
        boolean argumentFoundInExpression = false;
        if (this.expression != null) {
            for (String argument : other.arguments) {
                if (!this.expression.contains(argument)) continue;
                argumentFoundInExpression = true;
            }
        }
        if (other.expression != null) {
            for (String argument : this.arguments) {
                if (!other.expression.contains(argument)) continue;
                argumentFoundInExpression = true;
            }
        }
        boolean differentArguments = !this.arguments.equals(other.arguments) && argumentIntersection.isEmpty() && !argumentFoundInExpression;
        return differentExpression && differentName && differentArguments;
    }

    public String actualString() {
        StringBuilder sb = new StringBuilder();
        if (this.expression != null) {
            sb.append(this.expression).append(".");
        }
        sb.append(this.getName());
        sb.append("(");
        int size = this.arguments.size();
        if (size > 0) {
            for (int i = 0; i < size - 1; ++i) {
                sb.append(this.arguments.get(i)).append(",");
            }
            sb.append(this.arguments.get(size - 1));
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean isLogGuard() {
        return this.loggerExpression() && logGuardNames.contains(this.getName());
    }

    public boolean isLog() {
        return this.loggerExpression() && this.matchesLogName();
    }

    public boolean loggerExpression() {
        return this.expression != null && (this.expression.equals("log") || this.expression.equals("LOG") || this.expression.equals("logger") || this.expression.equals("LOGGER") || this.expression.equals("Log"));
    }

    public boolean matchesLogName() {
        return logNames.contains(this.getName()) || this.expression != null && this.expression.equals("Log") && this.getName().equals("e");
    }

    public boolean expressionIsNullOrThis() {
        if (this.expression == null) {
            return true;
        }
        return this.expression.equals("this");
    }

    public boolean identicalExpression(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        return this.identicalExpression(call) || this.identicalExpressionAfterTypeReplacements(call, replacements, parameterToArgumentMap);
    }

    public boolean identicalExpression(AbstractCall call) {
        return this.getExpression() != null && call.getExpression() != null && this.getExpression().equals(call.getExpression()) || this.getExpression() == null && call.getExpression() == null;
    }

    private boolean identicalExpressionAfterTypeReplacements(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        if (this.getExpression() != null && call.getExpression() != null) {
            String expression1 = this.getExpression();
            String expression2 = call.getExpression();
            String expression1AfterReplacements = new String(expression1);
            for (Replacement replacement : replacements) {
                AbstractCall after;
                MethodInvocationReplacement methodInvocationReplacement;
                AbstractCall before;
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE) || replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) && this.expressionCondition(expression1, expression2, parameterToArgumentMap)) {
                    if (replacement.getBefore().equals(expression1) && (replacement.getAfter().equals(expression2) || parameterToArgumentMap.containsKey(expression2) && replacement.getAfter().equals(parameterToArgumentMap.get(expression2)))) {
                        return true;
                    }
                    expression1AfterReplacements = ReplacementUtil.performReplacement(expression1AfterReplacements, expression2, replacement.getBefore(), replacement.getAfter());
                    continue;
                }
                if (!(replacement instanceof MethodInvocationReplacement) || !(before = (methodInvocationReplacement = (MethodInvocationReplacement)replacement).getInvokedOperationBefore()).identicalExpression(after = methodInvocationReplacement.getInvokedOperationAfter()) || !before.equalArguments(after) || before.arguments.size() <= 0 || !expression1.equals(replacement.getBefore()) || !expression2.equals(replacement.getAfter())) continue;
                return true;
            }
            if (expression1AfterReplacements.equals(expression2)) {
                return true;
            }
        }
        return false;
    }

    private boolean expressionCondition(String expression1, String expression2, Map<String, String> parameterToArgumentMap) {
        if (Character.isUpperCase(expression1.charAt(0)) && Character.isUpperCase(expression2.charAt(0))) {
            return true;
        }
        return Character.isUpperCase(expression1.charAt(0)) && !Character.isUpperCase(expression2.charAt(0)) && parameterToArgumentMap.containsKey(expression2);
    }

    public boolean staticInvokerExpressionReplaced(AbstractCall call, Set<Replacement> replacements) {
        if (this.getExpression() != null && call.getExpression() != null) {
            String expression1 = this.getExpression();
            String expression2 = call.getExpression();
            for (Replacement replacement : replacements) {
                if (!replacement.getBefore().equals(expression1) || !replacement.getAfter().equals(expression2) || !Character.isUpperCase(expression1.charAt(0)) || !Character.isUpperCase(expression2.charAt(0))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equalArgumentsExceptForAnonymousClassArguments(AbstractCall call) {
        List<String> arguments1 = this.arguments();
        List<String> arguments2 = call.arguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        int anonymousClassArguments1 = 0;
        int anonymousClassArguments2 = 0;
        for (int i = 0; i < arguments1.size(); ++i) {
            boolean anonymousClassArgument2;
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean anonymousClassArgument1 = argument1.contains("{\n");
            if (anonymousClassArgument1) {
                ++anonymousClassArguments1;
            }
            if (anonymousClassArgument2 = argument2.contains("{\n")) {
                ++anonymousClassArguments2;
            }
            if (anonymousClassArgument1 && anonymousClassArgument2 || argument1.equals(argument2)) continue;
            return false;
        }
        return anonymousClassArguments1 == anonymousClassArguments2 && anonymousClassArguments1 > 0;
    }

    public boolean equalArgumentsExceptForStringLiterals(AbstractCall call) {
        List<String> arguments1 = this.arguments();
        List<String> arguments2 = call.arguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        int stringLiterals1 = 0;
        int stringLiterals2 = 0;
        for (int i = 0; i < arguments1.size(); ++i) {
            boolean stringLiteral2;
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean stringLiteral1 = this.isStringLiteral(argument1);
            if (stringLiteral1) {
                ++stringLiterals1;
            }
            if (stringLiteral2 = this.isStringLiteral(argument2)) {
                ++stringLiterals2;
            }
            if (stringLiteral1 && stringLiteral2 || argument1.equals(argument2)) continue;
            return false;
        }
        return stringLiterals1 == stringLiterals2 && stringLiterals1 > 0;
    }

    public boolean isStringLiteral(String argument) {
        return argument.startsWith("\"") && argument.endsWith("\"");
    }

    public boolean equalArguments(AbstractCall call) {
        if (this instanceof MethodReference && call instanceof MethodReference && !this.identicalName(call)) {
            return false;
        }
        return this.arguments().equals(call.arguments());
    }

    public boolean reorderedArguments(AbstractCall call) {
        return this.arguments().size() > 1 && this.arguments().size() == call.arguments().size() && !this.arguments().equals(call.arguments()) && this.arguments().containsAll(call.arguments());
    }

    public boolean identicalOrReplacedArguments(AbstractCall call, Set<Replacement> replacements, List<UMLOperationBodyMapper> lambdaMappers) {
        List<String> arguments1 = this.arguments();
        List<String> arguments2 = call.arguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        if (this instanceof MethodReference && call instanceof MethodReference && !this.identicalName(call)) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentReplacement = false;
            for (Replacement replacement : replacements) {
                String before = replacement.getBefore();
                String after = replacement.getAfter();
                if (before.equals(argument1) && after.equals(argument2)) {
                    argumentReplacement = true;
                    break;
                }
                if (!argument1.contains(before) || !argument2.contains(after)) continue;
                String before1 = argument1.substring(0, argument1.indexOf(before));
                String before2 = argument2.substring(0, argument2.indexOf(after));
                String after1 = argument1.substring(argument1.indexOf(before) + before.length(), argument1.length());
                String after2 = argument2.substring(argument2.indexOf(after) + after.length(), argument2.length());
                if (!before1.equals(before2) || !after1.equals(after2)) continue;
                argumentReplacement = true;
                break;
            }
            boolean lambdaReplacement = false;
            if (argument1.contains("->") && argument2.contains("->")) {
                for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
                    if (lambdaMapper.nonMappedElementsT1() != 0 || lambdaMapper.nonMappedElementsT2() != 0) continue;
                    lambdaReplacement = true;
                    break;
                }
            }
            if (argument1.equals(argument2) || argumentReplacement || lambdaReplacement) continue;
            return false;
        }
        return true;
    }

    public boolean identicalOrConcatenatedArguments(AbstractCall call) {
        List<String> arguments1 = this.arguments();
        List<String> arguments2 = call.arguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentConcatenated = false;
            if (argument1.contains(" + ") || argument2.contains(" + ")) {
                LinkedHashSet<String> tokens1 = new LinkedHashSet<String>(Arrays.asList(StringBasedHeuristics.SPLIT_CONCAT_STRING_PATTERN.split(argument1)));
                LinkedHashSet<String> tokens2 = new LinkedHashSet<String>(Arrays.asList(StringBasedHeuristics.SPLIT_CONCAT_STRING_PATTERN.split(argument2)));
                LinkedHashSet<String> intersection = new LinkedHashSet<String>(tokens1);
                intersection.retainAll(tokens2);
                int size = intersection.size();
                int threshold = Math.max(tokens1.size(), tokens2.size()) - size;
                if (size > 0 && size >= threshold) {
                    argumentConcatenated = true;
                }
            }
            if (argument1.equals(argument2) || argumentConcatenated) continue;
            return false;
        }
        return true;
    }

    public boolean identicalOrWrappedArguments(AbstractCall call) {
        List<String> arguments1 = this.arguments();
        List<String> arguments2 = call.arguments();
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (int i = 0; i < arguments1.size(); ++i) {
            String argument1 = arguments1.get(i);
            String argument2 = arguments2.get(i);
            boolean argumentWrapped = false;
            if (argument1.contains("(" + argument2 + ")") || argument2.contains("(" + argument1 + ")")) {
                argumentWrapped = true;
            }
            if (argument1.equals(argument2) || argumentWrapped) continue;
            return false;
        }
        return true;
    }

    public boolean allArgumentsReplaced(AbstractCall call, Set<Replacement> replacements) {
        int replacedArguments = 0;
        List<String> arguments1 = this.arguments();
        List<String> arguments2 = call.arguments();
        if (arguments1.size() == arguments2.size()) {
            block0: for (int i = 0; i < arguments1.size(); ++i) {
                String argument1 = arguments1.get(i);
                String argument2 = arguments2.get(i);
                for (Replacement replacement : replacements) {
                    if (!replacement.getBefore().equals(argument1) && !argument1.contains(replacement.getBefore()) || !replacement.getAfter().equals(argument2) && !argument2.contains(replacement.getAfter())) continue;
                    ++replacedArguments;
                    continue block0;
                }
            }
        }
        return replacedArguments > 0 && replacedArguments == arguments1.size();
    }

    public boolean allArgumentsReplaced(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        int replacedArguments = 0;
        List<String> arguments1 = this.arguments();
        List<String> arguments2 = call.arguments();
        if (arguments1.size() == arguments2.size()) {
            block0: for (int i = 0; i < arguments1.size(); ++i) {
                String argument1 = arguments1.get(i);
                String argument2 = arguments2.get(i);
                for (Replacement replacement : replacements) {
                    if (!replacement.getBefore().equals(argument1) && !replacement.getBefore().equals(parameterToArgumentMap.get(argument1)) || !replacement.getAfter().equals(argument2) && !replacement.getAfter().equals(parameterToArgumentMap.get(argument2))) continue;
                    ++replacedArguments;
                    continue block0;
                }
            }
        }
        return replacedArguments > 0 && replacedArguments == arguments1.size();
    }

    public boolean renamedWithIdenticalExpressionAndArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap, double distance, List<UMLOperationBodyMapper> lambdaMappers, boolean matchPairOfRemovedAddedOperationsWithIdenticalBody, boolean argumentsWithVariableDeclarationMapping) {
        boolean identicalOrReplacedArguments = this.identicalOrReplacedArguments(call, replacements, lambdaMappers);
        boolean allArgumentsReplaced = this.allArgumentsReplaced(call, replacements);
        return (this.getExpression() != null && call.getExpression() != null || matchPairOfRemovedAddedOperationsWithIdenticalBody) && this.identicalExpression(call, replacements, parameterToArgumentMap) && !this.identicalName(call) && (this.equalArguments(call) || this.reorderedArguments(call) || allArgumentsReplaced && this.compatibleName(call, distance) || identicalOrReplacedArguments && !allArgumentsReplaced || argumentsWithVariableDeclarationMapping);
    }

    public boolean variableDeclarationInitializersRenamedWithIdenticalArguments(AbstractCall call) {
        return this.coverage.equals((Object)StatementCoverageType.VARIABLE_DECLARATION_INITIALIZER_CALL) && call.coverage.equals((Object)StatementCoverageType.VARIABLE_DECLARATION_INITIALIZER_CALL) && this.getExpression() != null && call.getExpression() != null && !this.identicalName(call) && (this.equalArguments(call) || this.reorderedArguments(call) || this.arguments().size() == 0 || call.arguments().size() == 0);
    }

    public boolean renamedWithDifferentExpressionAndIdenticalArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        int commonTokens;
        boolean expressionBecomesArgument;
        block5: {
            block4: {
                expressionBecomesArgument = false;
                commonTokens = 0;
                if (this.getExpression() == null || call.getExpression() != null || !call.arguments().contains(this.getExpression())) break block4;
                expressionBecomesArgument = true;
                String[] tokens1 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(this.getName());
                String[] tokens2 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(call.getName());
                for (String token1 : tokens1) {
                    for (String token2 : tokens2) {
                        if (!token1.equals(token2)) continue;
                        ++commonTokens;
                    }
                }
                break block5;
            }
            if (this.getExpression() != null || call.getExpression() == null || !this.arguments().contains(call.getExpression())) break block5;
            expressionBecomesArgument = true;
            String[] tokens1 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(this.getName());
            String[] tokens2 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(call.getName());
            for (String token1 : tokens1) {
                for (String token2 : tokens2) {
                    if (!token1.equals(token2)) continue;
                    ++commonTokens;
                }
            }
        }
        return (this.getName().contains(call.getName()) || call.getName().contains(this.getName()) || expressionBecomesArgument && commonTokens > 1) && this.arguments.size() > 0 && call.arguments.size() > 0 && (this.equalArguments(call) || this.reorderedArguments(call) || this.argumentIntersectionSize(call, replacements, parameterToArgumentMap) == Math.min(this.arguments.size(), call.arguments.size())) && (this.getExpression() == null && call.getExpression() != null || call.getExpression() == null && this.getExpression() != null);
    }

    public boolean renamedWithNoExpressionAndArgumentIntersection(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        int argumentIntersectionSize = this.argumentIntersection(call).size();
        return (this.getName().contains(call.getName()) || call.getName().contains(this.getName())) && this.getExpression() == null && call.getExpression() == null && this.arguments.size() > 0 && call.arguments.size() > 0 && ((double)argumentIntersectionSize >= Math.floor(Math.min(this.arguments.size(), call.arguments.size()) / 2) || argumentIntersectionSize > 0 && this.getName().equals("super") && call.getName().equals("super") || this.argumentIntersectionSize(call, replacements, parameterToArgumentMap) == Math.min(this.arguments.size(), call.arguments.size()));
    }

    public boolean renamedWithIdenticalArgumentsAndNoExpression(AbstractCall call, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean allExactLambdaMappers = lambdaMappers.size() > 0;
        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
            if (lambdaMapper.allMappingsAreExactMatches()) continue;
            allExactLambdaMappers = false;
            break;
        }
        return !(this.getExpression() != null || call.getExpression() != null || this.identicalName(call) || !this.compatibleName(call, distance) && !allExactLambdaMappers || !this.equalArguments(call) && !this.reorderedArguments(call));
    }

    public boolean renamedWithIdenticalExpressionAndDifferentArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap, double distance, List<UMLOperationBodyMapper> lambdaMappers) {
        boolean allExactLambdaMappers = lambdaMappers.size() > 0;
        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
            if (lambdaMapper.allMappingsAreExactMatches()) continue;
            allExactLambdaMappers = false;
            break;
        }
        return this.getExpression() != null && call.getExpression() != null && this.identicalExpression(call, replacements, parameterToArgumentMap) && (this.normalizedNameDistance(call) <= distance || allExactLambdaMappers || this.methodNameContainsArgumentName() && call.methodNameContainsArgumentName() || this.argumentIntersectionContainsClassInstanceCreation(call)) && !this.equalArguments(call) && !this.argumentContainsAnonymousClassDeclaration() && !call.argumentContainsAnonymousClassDeclaration();
    }

    private boolean compatibleName(AbstractCall call, double distance) {
        if (this.normalizedNameDistance(call) <= distance) {
            return true;
        }
        return this.compatibleName(call);
    }

    public boolean compatibleName(AbstractCall call) {
        String[] tokens1 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(this.getName());
        String[] tokens2 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(call.getName());
        int commonTokens = 0;
        for (String token1 : tokens1) {
            for (String token2 : tokens2) {
                if (!token1.equals(token2)) continue;
                ++commonTokens;
            }
        }
        if (commonTokens == Math.min(tokens1.length, tokens2.length)) {
            return true;
        }
        if (this.loggerExpression() && call.loggerExpression() && this.getExpression().equals(call.getExpression()) && this.matchesLogName() && call.matchesLogName() && this.arguments().size() == call.arguments().size() && this.arguments().size() == 1) {
            String argument1 = this.arguments().get(0);
            String argument2 = call.arguments().get(0);
            List<String> words1 = AbstractCall.extractWords(argument1);
            List<String> words2 = AbstractCall.extractWords(argument2);
            int commonWords = 0;
            if (words1.size() <= words2.size()) {
                index = 0;
                for (String word1 : words1) {
                    if (words2.contains(word1)) {
                        ++commonWords;
                    }
                    if (word1.equals(words2.get(index) + "ing") || words2.get(index).equals(word1 + "ing")) {
                        ++commonWords;
                    }
                    ++index;
                }
            } else {
                index = 0;
                for (String word2 : words2) {
                    if (words1.contains(word2)) {
                        ++commonWords;
                    }
                    if (word2.equals(words1.get(index) + "ing") || words1.get(index).equals(word2 + "ing")) {
                        ++commonWords;
                    }
                    ++index;
                }
            }
            if (commonWords >= Math.max(words1.size(), words2.size()) / 2) {
                return true;
            }
        }
        return false;
    }

    private static List<String> extractWords(String argument) {
        String[] initialWords = argument.split("\\s");
        ArrayList<String> finalWords = new ArrayList<String>();
        for (String word : initialWords) {
            String w = word.replaceAll("^\"|\"$", "").replaceAll("^\\.|\\.$", "").replaceAll("^\\:|\\:$", "").replaceAll("^\\,|\\,$", "");
            if (w.equals("+") || w.equals("")) continue;
            finalWords.add(w);
        }
        return finalWords;
    }

    private boolean argumentIntersectionContainsClassInstanceCreation(AbstractCall call) {
        for (String argument : this.argumentIntersection(call)) {
            if (!argument.startsWith("new ")) continue;
            return true;
        }
        return false;
    }

    private boolean argumentContainsAnonymousClassDeclaration() {
        for (String argument : this.arguments) {
            if (!argument.contains("{\n")) continue;
            return true;
        }
        return false;
    }

    public boolean methodNameContainsArgumentName() {
        for (String argument : this.arguments) {
            if (!this.getName().toLowerCase().endsWith(argument.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean onlyArgumentsChanged(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        return this.identicalExpression(call, replacements, parameterToArgumentMap) && this.identicalName(call) && !this.equalArguments(call) && this.arguments().size() != call.arguments().size();
    }

    public boolean identicalWithOnlyChangesInAnonymousClassArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        return this.identicalExpression(call, replacements, parameterToArgumentMap) && this.identicalName(call) && !this.equalArguments(call) && this.arguments().size() == call.arguments().size() && this.equalArgumentsExceptForAnonymousClassArguments(call);
    }

    public boolean identicalWithMergedArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        if (this.onlyArgumentsChanged(call, replacements, parameterToArgumentMap)) {
            ArrayList<String> updatedArguments1 = new ArrayList<String>(this.arguments);
            LinkedHashMap commonVariableReplacementMap = new LinkedHashMap();
            for (Replacement replacement : replacements) {
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                String key = replacement.getAfter();
                if (commonVariableReplacementMap.containsKey(key)) {
                    ((Set)commonVariableReplacementMap.get(key)).add(replacement);
                    int index = updatedArguments1.indexOf(replacement.getBefore());
                    if (index == -1) continue;
                    updatedArguments1.remove(index);
                    continue;
                }
                LinkedHashSet<Replacement> r = new LinkedHashSet<Replacement>();
                r.add(replacement);
                commonVariableReplacementMap.put(key, r);
                int index = updatedArguments1.indexOf(replacement.getBefore());
                if (index == -1) continue;
                updatedArguments1.remove(index);
                updatedArguments1.add(index, key);
            }
            if (updatedArguments1.equals(call.arguments)) {
                for (String key : commonVariableReplacementMap.keySet()) {
                    Set r = (Set)commonVariableReplacementMap.get(key);
                    if (r.size() <= 1) continue;
                    replacements.removeAll(r);
                    LinkedHashSet<String> mergedVariables = new LinkedHashSet<String>();
                    for (Replacement replacement : r) {
                        mergedVariables.add(replacement.getBefore());
                    }
                    MergeVariableReplacement merge = new MergeVariableReplacement(mergedVariables, key);
                    replacements.add(merge);
                }
                return true;
            }
        }
        return false;
    }

    public boolean identicalWithDifferentNumberOfArguments(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        int argumentIntersectionSize;
        return this.onlyArgumentsChanged(call, replacements, parameterToArgumentMap) && ((argumentIntersectionSize = this.argumentIntersectionSize(call, replacements, parameterToArgumentMap)) > 0 || this.arguments().size() == 0 || call.arguments().size() == 0);
    }

    public boolean inlinedStatementBecomesAdditionalArgument(AbstractCall call, Set<Replacement> replacements, List<? extends AbstractCodeFragment> statements) {
        if (this.identicalName(call) && this.arguments.size() < call.arguments.size() && this.argumentIntersection(call).size() > 0) {
            int matchedArguments = 0;
            LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements1 = new LinkedHashSet<AbstractCodeFragment>();
            block0: for (String arg : call.arguments) {
                if (this.arguments.contains(arg)) {
                    ++matchedArguments;
                    continue;
                }
                for (AbstractCodeFragment abstractCodeFragment : statements) {
                    VariableDeclaration variableDeclaration;
                    if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || (variableDeclaration = abstractCodeFragment.getVariableDeclarations().get(0)).getInitializer() == null || !arg.equals(variableDeclaration.getInitializer().getExpression())) continue;
                    ++matchedArguments;
                    additionallyMatchedStatements1.add(abstractCodeFragment);
                    continue block0;
                }
            }
            if (matchedArguments == call.arguments.size()) {
                if (additionallyMatchedStatements1.size() > 0) {
                    CompositeReplacement r = new CompositeReplacement(this.actualString(), call.actualString(), additionallyMatchedStatements1, Collections.emptySet());
                    replacements.add(r);
                }
                return true;
            }
        }
        return false;
    }

    public boolean identicalWithInlinedStatements(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap, List<AbstractCodeFragment> statements) {
        if (this.identicalExpression(call, replacements, parameterToArgumentMap) && this.identicalName(call) && this.arguments.size() == call.arguments.size()) {
            LinkedHashSet<Replacement> newReplacements = new LinkedHashSet<Replacement>();
            LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements1 = new LinkedHashSet<AbstractCodeFragment>();
            for (int i = 0; i < this.arguments.size(); ++i) {
                String arg2;
                String arg1 = this.arguments.get(i);
                if (arg1.equals(arg2 = call.arguments.get(i))) continue;
                boolean matchingInlineFound = false;
                for (AbstractCodeFragment statement : statements) {
                    VariableReplacementWithMethodInvocation r;
                    VariableDeclaration variableDeclaration;
                    if (statement.getVariableDeclarations().size() <= 0 || !(variableDeclaration = statement.getVariableDeclarations().get(0)).getVariableName().equals(arg1) || variableDeclaration.getInitializer() == null) continue;
                    AbstractCall statementCall = variableDeclaration.getInitializer().invocationCoveringEntireFragment();
                    if (variableDeclaration.getInitializer().getExpression().equals(arg2)) {
                        matchingInlineFound = true;
                        if (statementCall != null) {
                            r = new VariableReplacementWithMethodInvocation(arg1, variableDeclaration.getInitializer().getExpression(), statementCall, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                            newReplacements.add(r);
                        } else {
                            r = new Replacement(arg1, variableDeclaration.getInitializer().getExpression(), Replacement.ReplacementType.VARIABLE_NAME);
                            newReplacements.add(r);
                        }
                        additionallyMatchedStatements1.add(statement);
                        break;
                    }
                    if (statementCall == null) continue;
                    String actualString = statementCall.actualString();
                    if (arg2.contains(actualString) || actualString.contains(arg2)) {
                        matchingInlineFound = true;
                        r = new VariableReplacementWithMethodInvocation(arg1, variableDeclaration.getInitializer().getExpression(), statementCall, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                        newReplacements.add(r);
                        additionallyMatchedStatements1.add(statement);
                        break;
                    }
                    if (!actualString.contains(".") || !arg2.contains(".") || !actualString.substring(actualString.indexOf(".")).equals(arg2.substring(arg2.indexOf(".")))) continue;
                    matchingInlineFound = true;
                    r = new VariableReplacementWithMethodInvocation(arg1, variableDeclaration.getInitializer().getExpression(), statementCall, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    newReplacements.add(r);
                    additionallyMatchedStatements1.add(statement);
                    String invoker = actualString.substring(0, actualString.indexOf("."));
                    if (!invoker.equals(statementCall.getExpression())) break;
                    String arg2Invoker = arg2.substring(0, arg2.indexOf("."));
                    Replacement rename = new Replacement(invoker, arg2Invoker, Replacement.ReplacementType.VARIABLE_NAME);
                    newReplacements.add(rename);
                    break;
                }
                if (matchingInlineFound) continue;
                return false;
            }
            for (Replacement r : newReplacements) {
                if (replacements.contains(r)) continue;
                replacements.add(r);
            }
            if (additionallyMatchedStatements1.size() > 0) {
                CompositeReplacement r = new CompositeReplacement(this.actualString(), call.actualString(), additionallyMatchedStatements1, Collections.emptySet());
                replacements.add(r);
            }
            return true;
        }
        return false;
    }

    public boolean identicalWithExpressionArgumentSwap(AbstractCall call) {
        if (this.getExpression() != null && call.getExpression() != null && (this.identicalName(call) || this.getName().contains(call.getName()) || call.getName().contains(this.getName()))) {
            Set<String> argumentIntersection;
            int argumentIndex1 = this.arguments().indexOf(call.getExpression());
            int argumentIndex2 = call.arguments().indexOf(this.getExpression());
            if (argumentIndex1 != -1 && argumentIndex2 != -1 && argumentIndex1 == argumentIndex2 && (argumentIntersection = this.argumentIntersection(call)).size() == this.arguments().size() - 1 && argumentIntersection.size() == call.arguments().size() - 1) {
                return true;
            }
        }
        return false;
    }

    public boolean identical(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap, List<UMLOperationBodyMapper> lambdaMappers) {
        return this.identicalExpression(call, replacements, parameterToArgumentMap) && this.identicalName(call) && (this.equalArguments(call) || this.onlyLambdaArgumentsDiffer(call, lambdaMappers));
    }

    private boolean onlyLambdaArgumentsDiffer(AbstractCall call, List<UMLOperationBodyMapper> lambdaMappers) {
        if (lambdaMappers.size() > 0) {
            List<String> arguments1 = this.arguments();
            List<String> arguments2 = call.arguments();
            if (arguments1.size() == arguments2.size()) {
                for (int i = 0; i < arguments1.size(); ++i) {
                    String argument1 = arguments1.get(i);
                    String argument2 = arguments2.get(i);
                    if (argument1.contains("->") && argument2.contains("->")) {
                        for (UMLOperationBodyMapper lambdaMapper : lambdaMappers) {
                            if (lambdaMapper.nonMappedElementsT1() <= 0 || lambdaMapper.nonMappedElementsT2() <= 0 || lambdaMapper.containsCallToExtractedMethod() || lambdaMapper.containsCallToInlinedMethod()) continue;
                            return false;
                        }
                        continue;
                    }
                    if (argument1.equals(argument2)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Set<String> argumentIntersection(AbstractCall call) {
        List<String> args1 = this.preprocessArguments(this.arguments());
        List<String> args2 = this.preprocessArguments(call.arguments());
        LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(args1);
        argumentIntersection.retainAll(args2);
        return argumentIntersection;
    }

    private List<String> preprocessArguments(List<String> arguments) {
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : arguments) {
            if (arg.contains("\n")) {
                args.add(arg.substring(0, arg.indexOf("\n")));
                continue;
            }
            args.add(arg);
        }
        return args;
    }

    private int argumentIntersectionSize(AbstractCall call, Set<Replacement> replacements, Map<String, String> parameterToArgumentMap) {
        Set<String> argumentIntersection = this.argumentIntersection(call);
        int argumentIntersectionSize = argumentIntersection.size();
        for (String parameter : parameterToArgumentMap.keySet()) {
            String argument = parameterToArgumentMap.get(parameter);
            if (!this.arguments().contains(argument) || !call.arguments().contains(parameter)) continue;
            ++argumentIntersectionSize;
        }
        for (Replacement r : replacements) {
            int index1 = this.arguments().indexOf(r.getBefore());
            int index2 = call.arguments().indexOf(r.getAfter());
            if (index1 == -1 && this.arguments().contains(r.getBefore() + ".length")) {
                index1 = this.arguments().indexOf(r.getBefore() + ".length");
            }
            if (index2 == -1 && call.arguments().contains(r.getAfter() + ".length")) {
                index2 = call.arguments().indexOf(r.getAfter() + ".length");
            }
            if (index1 == -1 || index2 == -1) continue;
            if (this.arguments().size() == call.arguments().size()) {
                if (index1 != index2) continue;
                ++argumentIntersectionSize;
                continue;
            }
            ++argumentIntersectionSize;
        }
        return argumentIntersectionSize;
    }

    private int argumentIsStatement(String statement) {
        if (statement.endsWith(";\n")) {
            int index = 0;
            for (String argument : this.arguments()) {
                if (argument.equals("true") || argument.equals("false") || argument.equals("null")) {
                    return -1;
                }
                if (AbstractCall.equalsIgnoringExtraParenthesis(argument, statement.substring(0, statement.length() - 2))) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    private int argumentIsExpression(String expression) {
        if (!expression.endsWith(";\n")) {
            int index = 0;
            for (String argument : this.arguments()) {
                if (argument.equals("true") || argument.equals("false") || argument.equals("null")) {
                    return -1;
                }
                if (AbstractCall.equalsIgnoringExtraParenthesis(argument, expression)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    private int argumentIsReturned(String statement) {
        if (statement.startsWith("return ")) {
            int index = 0;
            for (String argument : this.arguments()) {
                if (argument.equals("true") || argument.equals("false") || argument.equals("null")) {
                    return -1;
                }
                if (AbstractCall.equalsIgnoringExtraParenthesis(argument, statement.substring(7, statement.length() - 2))) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public Replacement makeReplacementForReturnedArgument(String statement) {
        int index = -1;
        index = this.argumentIsReturned(statement);
        if (index != -1 && (this.arguments().size() <= 2 && (index == 0 || this.getName().equals("assertThrows")) || statement.contains(" ? ") && statement.contains(" : "))) {
            String arg = statement.substring(7, statement.length() - 2);
            return new Replacement(this.arguments().get(index), arg, Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION);
        }
        index = this.argumentIsStatement(statement);
        if (index != -1 && (this.arguments().size() <= 2 && (index == 0 || this.getName().equals("assertThrows")) || statement.contains(" ? ") && statement.contains(" : "))) {
            String arg = statement.substring(0, statement.length() - 2);
            return new Replacement(this.arguments().get(index), arg, Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_STATEMENT);
        }
        index = this.argumentIsExpression(statement);
        if (index != -1 && (this.arguments().size() <= 2 && (index == 0 || this.getName().equals("assertThrows")) || statement.contains(" ? ") && statement.contains(" : "))) {
            return new Replacement(this.arguments().get(index), statement, Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_EXPRESSION);
        }
        return null;
    }

    public Replacement makeReplacementForWrappedCall(String statement) {
        int index = -1;
        index = this.argumentIsReturned(statement);
        if (index != -1 && (this.arguments().size() <= 2 && (index == 0 || this.getName().equals("assertThrows")) || statement.contains(" ? ") && statement.contains(" : "))) {
            String arg = statement.substring(7, statement.length() - 2);
            return new Replacement(arg, this.arguments().get(index), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION);
        }
        index = this.argumentIsStatement(statement);
        if (index != -1 && (this.arguments().size() <= 2 && (index == 0 || this.getName().equals("assertThrows")) || statement.contains(" ? ") && statement.contains(" : "))) {
            String arg = statement.substring(0, statement.length() - 2);
            return new Replacement(arg, this.arguments().get(index), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_STATEMENT);
        }
        index = this.argumentIsExpression(statement);
        if (index != -1 && (this.arguments().size() <= 2 && (index == 0 || this.getName().equals("assertThrows")) || statement.contains(" ? ") && statement.contains(" : "))) {
            return new Replacement(statement, this.arguments().get(index), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_EXPRESSION);
        }
        return null;
    }

    public Replacement makeReplacementForWrappedLambda(String statement) {
        if (this.argumentIsLambdaStatement(statement) && (this.arguments().size() == 1 || statement.contains(" ? ") && statement.contains(" : "))) {
            return new Replacement(statement.substring(0, statement.length() - 2), this.arguments().get(0), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_EXPRESSION);
        }
        return null;
    }

    private boolean argumentIsLambdaStatement(String statement) {
        if (statement.endsWith(";\n")) {
            for (String argument : this.arguments()) {
                if (!AbstractCall.equalsIgnoringLambdaArrow(argument, statement.substring(0, statement.length() - 2))) continue;
                return true;
            }
        }
        return false;
    }

    private int argumentIsAssigned(String statement) {
        if (statement.contains("=") && statement.endsWith(";\n")) {
            int index = 0;
            for (String argument : this.arguments()) {
                if (AbstractCall.equalsIgnoringExtraParenthesis(argument, statement.substring(statement.indexOf("=") + 1, statement.length() - 2))) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public Replacement makeReplacementForAssignedArgument(String statement) {
        int index = this.argumentIsAssigned(statement);
        if (index >= 0 && (this.arguments().size() == 1 || statement.contains(" ? ") && statement.contains(" : "))) {
            return new Replacement(statement.substring(statement.indexOf("=") + 1, statement.length() - 2), this.arguments().get(index), Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION);
        }
        return null;
    }

    private static boolean equalsIgnoringExtraParenthesis(String s1, String s2) {
        String methodReferenceName;
        String s2WithoutGenerics;
        String s1WithoutGenerics;
        if (s1.equals(s2)) {
            return true;
        }
        String parenthesizedS1 = "(" + s1 + ")";
        if (parenthesizedS1.equals(s2)) {
            return true;
        }
        String parenthesizedS2 = "(" + s2 + ")";
        if (parenthesizedS2.equals(s1)) {
            return true;
        }
        if (s1.contains(".<") && !s2.contains(".<") && (s1WithoutGenerics = s1.substring(0, s1.indexOf(".<") + 1) + s1.substring(s1.indexOf(">") + 1, s1.length())).equals(s2)) {
            return true;
        }
        if (s2.contains(".<") && !s1.contains(".<") && (s2WithoutGenerics = s2.substring(0, s2.indexOf(".<") + 1) + s2.substring(s2.indexOf(">") + 1, s2.length())).equals(s1)) {
            return true;
        }
        if (s1.contains("::") && !s2.contains("::") && s2.endsWith((methodReferenceName = s1.substring(s1.indexOf("::") + 2, s1.length())) + "()")) {
            return true;
        }
        return s2.contains("::") && !s1.contains("::") && s1.endsWith((methodReferenceName = s2.substring(s2.indexOf("::") + 2, s2.length())) + "()");
    }

    private static boolean equalsIgnoringLambdaArrow(String s1, String s2) {
        if (s1.equals(s2)) {
            return true;
        }
        String arrowS1 = "() -> " + s1;
        if (arrowS1.equals(s2)) {
            return true;
        }
        String arrowS2 = "() -> " + s2;
        return arrowS2.equals(s1);
    }

    protected void update(AbstractCall newCall, String oldExpression, String newExpression) {
        newCall.numberOfArguments = this.numberOfArguments;
        newCall.expression = this.expression != null && this.expression.equals(oldExpression) ? newExpression : this.expression;
        newCall.arguments = new ArrayList<String>();
        for (String argument : this.arguments) {
            newCall.arguments.add(ReplacementUtil.performReplacement(argument, oldExpression, newExpression));
        }
    }

    public Set<String> callChainIntersection(AbstractCall call) {
        if (this instanceof OperationInvocation && call instanceof OperationInvocation) {
            return ((OperationInvocation)this).callChainIntersection((OperationInvocation)call);
        }
        return Collections.emptySet();
    }

    boolean isAssertion() {
        return this.getName().startsWith("assert") || this.getName().equals("fail");
    }

    public static enum StatementCoverageType {
        NONE,
        ONLY_CALL,
        RETURN_CALL,
        THROW_CALL,
        CAST_CALL,
        VARIABLE_DECLARATION_INITIALIZER_CALL;

    }
}

