/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.StringBasedHeuristics;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.VariableReplacementAnalysis;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCodeFragment
implements LocationInfoProvider {
    private int depth;
    private int index;
    private String codeFragmentAfterReplacingParametersWithArguments;

    public String getArgumentizedString() {
        return this.codeFragmentAfterReplacingParametersWithArguments != null ? this.codeFragmentAfterReplacingParametersWithArguments : this.getString();
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public abstract CompositeStatementObject getParent();

    public abstract String getString();

    public abstract List<LeafExpression> getVariables();

    public abstract List<String> getTypes();

    public abstract List<VariableDeclaration> getVariableDeclarations();

    public abstract List<AbstractCall> getMethodInvocations();

    public abstract List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations();

    public abstract List<LeafExpression> getStringLiterals();

    public abstract List<LeafExpression> getCharLiterals();

    public abstract List<LeafExpression> getNumberLiterals();

    public abstract List<LeafExpression> getNullLiterals();

    public abstract List<LeafExpression> getBooleanLiterals();

    public abstract List<LeafExpression> getTypeLiterals();

    public abstract List<AbstractCall> getCreations();

    public abstract List<LeafExpression> getInfixExpressions();

    public abstract List<String> getInfixOperators();

    public abstract List<LeafExpression> getArrayAccesses();

    public abstract List<LeafExpression> getPrefixExpressions();

    public abstract List<LeafExpression> getPostfixExpressions();

    public abstract List<LeafExpression> getThisExpressions();

    public abstract List<LeafExpression> getArguments();

    public abstract List<LeafExpression> getParenthesizedExpressions();

    public abstract List<LeafExpression> getCastExpressions();

    public abstract List<TernaryOperatorExpression> getTernaryOperatorExpressions();

    public abstract List<LambdaExpressionObject> getLambdas();

    public abstract VariableDeclaration searchVariableDeclaration(String var1);

    public abstract VariableDeclaration getVariableDeclaration(String var1);

    public List<LeafExpression> findExpression(String s) {
        HashSet<LocationInfo> locations = new HashSet<LocationInfo>();
        ArrayList<LeafExpression> matchingExpressions = new ArrayList<LeafExpression>();
        for (LeafExpression leafExpression : this.getVariables()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (AbstractCall abstractCall : this.getMethodInvocations()) {
            if (!abstractCall.getString().equals(s)) continue;
            if (!locations.contains(abstractCall.getLocationInfo())) {
                matchingExpressions.add(abstractCall.asLeafExpression());
            }
            locations.add(abstractCall.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getStringLiterals()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getNumberLiterals()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getNullLiterals()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getBooleanLiterals()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getTypeLiterals()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (AbstractCall abstractCall : this.getCreations()) {
            if (!abstractCall.getString().equals(s)) continue;
            if (!locations.contains(abstractCall.getLocationInfo())) {
                matchingExpressions.add(abstractCall.asLeafExpression());
            }
            locations.add(abstractCall.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getInfixExpressions()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getArrayAccesses()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getPrefixExpressions()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getPostfixExpressions()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getThisExpressions()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getCastExpressions()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getParenthesizedExpressions()) {
            if (!leafExpression.getString().equals(s)) continue;
            if (!locations.contains(leafExpression.getLocationInfo())) {
                matchingExpressions.add(leafExpression);
            }
            locations.add(leafExpression.getLocationInfo());
        }
        for (TernaryOperatorExpression ternaryOperatorExpression : this.getTernaryOperatorExpressions()) {
            if (!ternaryOperatorExpression.getString().equals(s)) continue;
            if (!locations.contains(ternaryOperatorExpression.getLocationInfo())) {
                matchingExpressions.add(ternaryOperatorExpression.asLeafExpression());
            }
            locations.add(ternaryOperatorExpression.getLocationInfo());
        }
        for (LeafExpression leafExpression : this.getArguments()) {
            if (!leafExpression.getString().equals(s) || locations.contains(leafExpression.getLocationInfo())) continue;
            matchingExpressions.add(leafExpression);
        }
        return matchingExpressions;
    }

    public boolean isKeyword() {
        String statement = this.getString();
        return statement.startsWith("return;") || statement.startsWith("break;") || statement.startsWith("continue;");
    }

    public boolean isLogCall() {
        AbstractCall call = this.invocationCoveringEntireFragment();
        return call != null && call.isLog();
    }

    public boolean isAssertCall() {
        AbstractCall call = this.invocationCoveringEntireFragment();
        return call != null && call.getName().startsWith("assert");
    }

    public void replaceParametersWithArguments(Map<String, String> parameterToArgumentMap) {
        String afterReplacements = this.getString();
        LinkedHashSet<String> anonymousClassMethodDeclarationLines = new LinkedHashSet<String>();
        if (StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(afterReplacements)) {
            String[] lines;
            for (String line : lines = afterReplacements.split("\\n")) {
                if (!Visitor.METHOD_SIGNATURE_PATTERN.matcher(line = VariableReplacementAnalysis.prepareLine(line)).matches()) continue;
                anonymousClassMethodDeclarationLines.add(line);
            }
        }
        for (String parameter : parameterToArgumentMap.keySet()) {
            String argument;
            if (parameter.equals(argument = parameterToArgumentMap.get(parameter))) continue;
            StringBuffer sb = new StringBuffer();
            Pattern p = Pattern.compile(Pattern.quote(parameter));
            Matcher m = p.matcher(afterReplacements);
            while (m.find()) {
                int start = m.start();
                boolean isArgument = false;
                boolean isInsideStringLiteral = false;
                if (start >= 1) {
                    String previousChar = afterReplacements.substring(start - 1, start);
                    if (previousChar.equals("(") || previousChar.equals(",") || previousChar.equals(" ") || previousChar.equals("=")) {
                        char nextChar;
                        int indexOfNextChar = start + parameter.length();
                        if (afterReplacements.length() > indexOfNextChar && !Character.isLetterOrDigit(nextChar = afterReplacements.charAt(indexOfNextChar))) {
                            isArgument = true;
                        }
                        if (parameter.endsWith(".")) {
                            isArgument = true;
                        }
                    }
                    String beforeMatch = afterReplacements.substring(0, start);
                    String afterMatch = afterReplacements.substring(start + parameter.length(), afterReplacements.length());
                    if (AbstractCodeFragment.quoteBefore(beforeMatch) && AbstractCodeFragment.quoteAfter(afterMatch)) {
                        isInsideStringLiteral = true;
                    }
                } else if (start == 0 && !afterReplacements.startsWith("return ")) {
                    char nextChar;
                    int indexOfNextChar = start + parameter.length();
                    if (afterReplacements.length() > indexOfNextChar && !Character.isLetterOrDigit(nextChar = afterReplacements.charAt(indexOfNextChar))) {
                        isArgument = true;
                    }
                    if (parameter.endsWith(".")) {
                        isArgument = true;
                    }
                }
                boolean isWithinMethodSignature = false;
                for (String methodSignatureLine : anonymousClassMethodDeclarationLines) {
                    int methodSignatureStart = this.getString().indexOf(methodSignatureLine);
                    if (methodSignatureStart == -1 || methodSignatureStart >= start || methodSignatureStart + methodSignatureLine.length() <= start) continue;
                    isWithinMethodSignature = true;
                    break;
                }
                if (!isArgument || isInsideStringLiteral || isWithinMethodSignature) continue;
                m.appendReplacement(sb, Matcher.quoteReplacement(argument));
            }
            m.appendTail(sb);
            afterReplacements = sb.toString();
        }
        this.codeFragmentAfterReplacingParametersWithArguments = afterReplacements;
    }

    private static boolean quoteBefore(String beforeMatch) {
        if (beforeMatch.contains("\"")) {
            if (beforeMatch.contains("+")) {
                int indexOfQuote = beforeMatch.lastIndexOf("\"");
                int indexOfPlus = beforeMatch.lastIndexOf("+");
                return indexOfPlus <= indexOfQuote;
            }
            return true;
        }
        return false;
    }

    private static boolean quoteAfter(String afterMatch) {
        if (afterMatch.contains("\"")) {
            if (afterMatch.contains("+")) {
                int indexOfQuote = afterMatch.indexOf("\"");
                int indexOfPlus = afterMatch.indexOf("+");
                return indexOfPlus >= indexOfQuote;
            }
            return true;
        }
        return false;
    }

    public boolean equalFragment(AbstractCodeFragment other) {
        if (this.getString().equals(other.getString())) {
            return true;
        }
        if (this.getString().contains(other.getString())) {
            return true;
        }
        if (other.getString().contains(this.getString())) {
            return true;
        }
        if (this.codeFragmentAfterReplacingParametersWithArguments != null) {
            return this.codeFragmentAfterReplacingParametersWithArguments.equals(other.getString());
        }
        if (other.codeFragmentAfterReplacingParametersWithArguments != null) {
            return other.codeFragmentAfterReplacingParametersWithArguments.equals(this.getString());
        }
        return false;
    }

    public void resetArgumentization() {
        this.codeFragmentAfterReplacingParametersWithArguments = this.getString();
    }

    public String infixExpressionCoveringTheEntireFragment() {
        String statement = this.getString();
        for (LeafExpression infixExpression : this.getInfixExpressions()) {
            String infix = infixExpression.getString();
            if ((infix + ";\n").equals(statement) || infix.equals(statement)) {
                return infix;
            }
            if (("return " + infix + ";\n").equals(statement)) {
                return infix;
            }
            if (this.expressionIsTheInitializerOfVariableDeclaration(infix)) {
                return infix;
            }
            if (("if(" + infix + ")").equals(statement)) {
                return infix;
            }
            if (!("while(" + infix + ")").equals(statement)) continue;
            return infix;
        }
        return null;
    }

    public ObjectCreation creationCoveringEntireFragment() {
        String statement = this.getString();
        for (AbstractCall creation : this.getCreations()) {
            String objectCreation = creation.getString();
            if ((objectCreation + ";\n").equals(statement) || objectCreation.equals(statement)) {
                creation.coverage = AbstractCall.StatementCoverageType.ONLY_CALL;
                return (ObjectCreation)creation;
            }
            if (("return " + objectCreation + ";\n").equals(statement)) {
                creation.coverage = AbstractCall.StatementCoverageType.RETURN_CALL;
                return (ObjectCreation)creation;
            }
            if (("throw " + objectCreation + ";\n").equals(statement)) {
                creation.coverage = AbstractCall.StatementCoverageType.THROW_CALL;
                return (ObjectCreation)creation;
            }
            if (!this.expressionIsTheInitializerOfVariableDeclaration(objectCreation)) continue;
            creation.coverage = AbstractCall.StatementCoverageType.VARIABLE_DECLARATION_INITIALIZER_CALL;
            return (ObjectCreation)creation;
        }
        return null;
    }

    public AbstractCall invocationCoveringEntireFragment() {
        String statement = this.getString();
        for (AbstractCall invocation : this.getMethodInvocations()) {
            String methodInvocation = invocation.getString();
            if ((methodInvocation + ";\n").equals(statement) || methodInvocation.equals(statement) || ("!" + methodInvocation).equals(statement)) {
                invocation.coverage = AbstractCall.StatementCoverageType.ONLY_CALL;
                return invocation;
            }
            if (("return " + methodInvocation + ";\n").equals(statement)) {
                invocation.coverage = AbstractCall.StatementCoverageType.RETURN_CALL;
                return invocation;
            }
            if (this.isCastExpressionCoveringEntireFragment(methodInvocation)) {
                invocation.coverage = AbstractCall.StatementCoverageType.CAST_CALL;
                return invocation;
            }
            if (this.expressionIsTheInitializerOfVariableDeclaration(methodInvocation)) {
                invocation.coverage = AbstractCall.StatementCoverageType.VARIABLE_DECLARATION_INITIALIZER_CALL;
                return invocation;
            }
            if (!invocation.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.SUPER_CONSTRUCTOR_INVOCATION) && !invocation.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CONSTRUCTOR_INVOCATION)) continue;
            invocation.coverage = AbstractCall.StatementCoverageType.ONLY_CALL;
            return invocation;
        }
        return null;
    }

    public ObjectCreation assignmentCreationCoveringEntireStatement() {
        for (AbstractCall creation : this.getCreations()) {
            if (!this.expressionIsTheRightHandSideOfAssignment(creation.getString())) continue;
            return (ObjectCreation)creation;
        }
        return null;
    }

    public AbstractCall assignmentInvocationCoveringEntireStatement() {
        for (AbstractCall invocation : this.getMethodInvocations()) {
            if (!this.expressionIsTheRightHandSideOfAssignment(invocation.getString())) continue;
            return invocation;
        }
        return null;
    }

    public AbstractCall fieldAssignmentInvocationCoveringEntireStatement(UMLAbstractClassDiff classDiff) {
        for (AbstractCall invocation : this.getMethodInvocations()) {
            if (this.expressionIsTheRightHandSideOfAssignmentAndLeftHandSideIsField(invocation.getString(), classDiff)) {
                return invocation;
            }
            for (AbstractCall creation : this.getCreations()) {
                if (!creation.arguments().contains(invocation.actualString()) || !this.expressionIsTheRightHandSideOfAssignmentAndLeftHandSideIsField(creation.getString(), classDiff)) continue;
                return invocation;
            }
        }
        return null;
    }

    private boolean isCastExpressionCoveringEntireFragment(String expression) {
        String prefix;
        String statement = this.getString();
        int index = -1;
        index = statement.endsWith(";\n") ? statement.indexOf(expression + ";\n") : statement.indexOf(expression);
        if (index != -1 && (prefix = statement.substring(0, index)).contains("(") && prefix.contains(")")) {
            int indexOfOpeningParenthesis = prefix.indexOf("(");
            int indexOfClosingParenthesis = prefix.indexOf(")");
            boolean openingParenthesisInsideSingleQuotes = ReplacementUtil.isInsideSingleQuotes(prefix, indexOfOpeningParenthesis);
            boolean closingParenthesisInsideSingleQuotes = ReplacementUtil.isInsideSingleQuotes(prefix, indexOfClosingParenthesis);
            boolean openingParenthesisInsideDoubleQuotes = ReplacementUtil.isInsideDoubleQuotes(prefix, indexOfOpeningParenthesis);
            boolean closingParenthesisIndideDoubleQuotes = ReplacementUtil.isInsideDoubleQuotes(prefix, indexOfClosingParenthesis);
            if (!(indexOfOpeningParenthesis >= indexOfClosingParenthesis || openingParenthesisInsideSingleQuotes || closingParenthesisInsideSingleQuotes || openingParenthesisInsideDoubleQuotes || closingParenthesisIndideDoubleQuotes)) {
                String casting = prefix.substring(indexOfOpeningParenthesis, indexOfClosingParenthesis + 1);
                if (statement.endsWith(";\n") && ("return " + casting + expression + ";\n").equals(statement)) {
                    return true;
                }
                if (!statement.endsWith(";\n") && (casting + expression).equals(statement)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean containsInitializerOfVariableDeclaration(Set<String> expressions) {
        String initializer;
        List<VariableDeclaration> variableDeclarations = this.getVariableDeclarations();
        return variableDeclarations.size() == 1 && variableDeclarations.get(0).getInitializer() != null && expressions.contains(initializer = variableDeclarations.get(0).getInitializer().toString()) && !this.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT);
    }

    private boolean expressionIsTheInitializerOfVariableDeclaration(String expression) {
        List<VariableDeclaration> variableDeclarations = this.getVariableDeclarations();
        if (variableDeclarations.size() > 0 && variableDeclarations.get(0).getInitializer() != null) {
            String initializerWithoutCasting;
            String initializer = variableDeclarations.get(0).getInitializer().toString();
            if (initializer.equals(expression)) {
                return true;
            }
            if (initializer.startsWith("(") && (initializerWithoutCasting = initializer.substring(initializer.indexOf(")") + 1, initializer.length())).equals(expression)) {
                return true;
            }
        }
        return false;
    }

    private boolean expressionIsTheRightHandSideOfAssignment(String expression) {
        List<LeafExpression> variables;
        String statement = this.getString();
        if (statement.contains("=") && (variables = this.getVariables()).size() > 0) {
            int index;
            String prefix;
            String suffix;
            String s = variables.get(0).getString() + "=" + expression + ";\n";
            if (statement.equals(s)) {
                return true;
            }
            if (statement.startsWith(variables.get(0).getString() + "=") && (suffix = statement.substring(statement.indexOf("=") + 1)).endsWith(expression + ";\n") && (prefix = suffix.substring(0, index = suffix.indexOf(expression + ";\n"))).startsWith("(") && prefix.endsWith(")")) {
                return true;
            }
        }
        return false;
    }

    private boolean expressionIsTheRightHandSideOfAssignmentAndLeftHandSideIsField(String expression, UMLAbstractClassDiff classDiff) {
        List<LeafExpression> variables;
        String statement = this.getString();
        if (statement.contains("=") && (variables = this.getVariables()).size() > 0) {
            String variable = variables.get(0).getString();
            String s = variable + "=" + expression + ";\n";
            if (statement.equals(s) && (variable.startsWith("this.") || classDiff.getOriginalClass().getFieldDeclarationMap().containsKey(variable) || classDiff.getNextClass().getFieldDeclarationMap().containsKey(variable))) {
                return true;
            }
            String beforeAssignment = statement.substring(0, statement.indexOf("="));
            if (variables.size() >= 2 && beforeAssignment.equals(variable + "." + variables.get(1).getString())) {
                return true;
            }
        }
        return false;
    }

    public boolean throwsNewException() {
        return this.getString().startsWith("throw new ");
    }

    public boolean isLastStatement() {
        if (this instanceof AbstractExpression) {
            return false;
        }
        CompositeStatementObject parent = this.getParent();
        if (parent != null && parent.getParent() == null) {
            return this.index == parent.getStatements().size() - 1;
        }
        return false;
    }

    public boolean isLastStatementInParentBlock() {
        if (this instanceof AbstractExpression) {
            return false;
        }
        CompositeStatementObject parent = this.getParent();
        if (parent != null && parent.getParent() != null) {
            return this.index == parent.getStatements().size() - 1;
        }
        return false;
    }

    public boolean countableStatement() {
        String statement = this.getString();
        if (this instanceof AbstractExpression) {
            return true;
        }
        if (this instanceof AbstractStatement && ((AbstractStatement)this).getParent() != null && ((AbstractStatement)this).getParent().statementCount() == 1 && ((AbstractStatement)this).getParent().getParent() == null) {
            return true;
        }
        return !statement.equals("{") && !statement.startsWith("catch(") && !statement.startsWith("case ") && !statement.startsWith("return true;") && !statement.startsWith("return false;") && !statement.startsWith("return this;") && !statement.startsWith("return null;") && !statement.startsWith("return;");
    }
}

