/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.StringBasedHeuristics;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.ClassInstanceCreationWithMethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.IntersectionReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationWithClassInstanceCreationReplacement;
import gr.uom.java.xmi.decomposition.replacement.ObjectCreationReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.VariableReplacementWithMethodInvocation;
import gr.uom.java.xmi.diff.ExtractVariableRefactoring;
import gr.uom.java.xmi.diff.InlineVariableRefactoring;
import gr.uom.java.xmi.diff.RenameOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.util.PrefixSuffixUtils;

public abstract class AbstractCodeMapping {
    private AbstractCodeFragment fragment1;
    private AbstractCodeFragment fragment2;
    private VariableDeclarationContainer operation1;
    private VariableDeclarationContainer operation2;
    private Set<Replacement> replacements;
    private Set<LeafMapping> subExpressionMappings;
    private boolean identicalWithExtractedVariable;
    private boolean identicalWithInlinedVariable;
    private Set<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
    private int matchingArgumentsWithOperationInvocation;

    public AbstractCodeMapping(AbstractCodeFragment fragment1, AbstractCodeFragment fragment2, VariableDeclarationContainer operation1, VariableDeclarationContainer operation2) {
        this.fragment1 = fragment1;
        this.fragment2 = fragment2;
        this.operation1 = operation1;
        this.operation2 = operation2;
        this.replacements = new LinkedHashSet<Replacement>();
        this.subExpressionMappings = new LinkedHashSet<LeafMapping>();
    }

    public abstract double editDistance();

    public boolean equalContainer() {
        return this.operation1.equals(this.operation2);
    }

    public AbstractCodeFragment getFragment1() {
        return this.fragment1;
    }

    public AbstractCodeFragment getFragment2() {
        return this.fragment2;
    }

    public VariableDeclarationContainer getOperation1() {
        return this.operation1;
    }

    public VariableDeclarationContainer getOperation2() {
        return this.operation2;
    }

    public boolean isIdenticalWithExtractedVariable() {
        return this.identicalWithExtractedVariable;
    }

    public boolean isIdenticalWithInlinedVariable() {
        return this.identicalWithInlinedVariable;
    }

    public void addRefactoring(Refactoring r) {
        this.refactorings.add(r);
    }

    public Set<Refactoring> getRefactorings() {
        return this.refactorings;
    }

    public int getMatchingArgumentsWithOperationInvocation() {
        return this.matchingArgumentsWithOperationInvocation;
    }

    public void setMatchingArgumentsWithOperationInvocation(int matchingArgumentsWithOperationInvocation) {
        this.matchingArgumentsWithOperationInvocation = matchingArgumentsWithOperationInvocation;
    }

    public boolean isExact() {
        return (this.fragment1.getArgumentizedString().equals(this.fragment2.getArgumentizedString()) || this.argumentizedStringExactAfterTypeReplacement() || this.fragment1.getString().equals(this.fragment2.getString()) || this.isExactAfterAbstraction() || this.containsIdenticalOrCompositeReplacement()) && !this.fragment1.isKeyword();
    }

    private boolean argumentizedStringExactAfterTypeReplacement() {
        String s1 = this.fragment1.getArgumentizedString();
        String s2 = this.fragment2.getArgumentizedString();
        for (Replacement r : this.replacements) {
            String temp;
            if (!r.getType().equals((Object)Replacement.ReplacementType.TYPE) || !s1.startsWith(r.getBefore()) || !s2.startsWith(r.getAfter()) || !s1.equals(temp = s2.replace(r.getAfter(), r.getBefore())) && !(s1 + ";\n").equals(temp)) continue;
            return true;
        }
        return false;
    }

    private boolean isExactAfterAbstraction() {
        AbstractCall invocation1 = this.fragment1.invocationCoveringEntireFragment();
        AbstractCall invocation2 = this.fragment2.invocationCoveringEntireFragment();
        if (invocation1 != null && invocation2 != null) {
            return invocation1.actualString().equals(invocation2.actualString());
        }
        ObjectCreation creation1 = this.fragment1.creationCoveringEntireFragment();
        ObjectCreation creation2 = this.fragment2.creationCoveringEntireFragment();
        if (creation1 != null && creation2 != null) {
            return creation1.actualString().equals(creation2.actualString());
        }
        return false;
    }

    public void addSubExpressionMapping(LeafMapping leafMapping) {
        this.subExpressionMappings.add(leafMapping);
    }

    public void addSubExpressionMappings(Set<LeafMapping> leafMappings) {
        this.subExpressionMappings.addAll(leafMappings);
    }

    public Set<LeafMapping> getSubExpressionMappings() {
        return this.subExpressionMappings;
    }

    private boolean containsIdenticalOrCompositeReplacement() {
        for (Replacement r : this.replacements) {
            if (r.getType().equals((Object)Replacement.ReplacementType.ARRAY_INITIALIZER_REPLACED_WITH_METHOD_INVOCATION_ARGUMENTS) && r.getBefore().equals(r.getAfter())) {
                return true;
            }
            if (!r.getType().equals((Object)Replacement.ReplacementType.COMPOSITE)) continue;
            return true;
        }
        return false;
    }

    public CompositeReplacement containsCompositeReplacement() {
        for (Replacement r : this.replacements) {
            if (!r.getType().equals((Object)Replacement.ReplacementType.COMPOSITE)) continue;
            return (CompositeReplacement)r;
        }
        return null;
    }

    public void addReplacement(Replacement replacement) {
        this.replacements.add(replacement);
    }

    public void addReplacements(Set<Replacement> replacements) {
        if (replacements != null) {
            this.replacements.addAll(replacements);
        }
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public boolean containsReplacement(Replacement.ReplacementType type) {
        for (Replacement replacement : this.replacements) {
            if (!replacement.getType().equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlyReplacement(Replacement.ReplacementType type) {
        for (Replacement replacement : this.replacements) {
            if (replacement.getType().equals((Object)type)) continue;
            return false;
        }
        return this.replacements.size() > 0;
    }

    public Set<Replacement.ReplacementType> getReplacementTypes() {
        LinkedHashSet<Replacement.ReplacementType> types = new LinkedHashSet<Replacement.ReplacementType>();
        for (Replacement replacement : this.replacements) {
            types.add(replacement.getType());
        }
        return types;
    }

    public String toString() {
        return this.fragment1.toString() + this.fragment2.toString();
    }

    public void temporaryVariableAssignment(Set<Refactoring> refactorings, List<? extends AbstractCodeFragment> nonMappedLeavesT2, boolean insideExtractedOrInlinedMethod) {
        if (this instanceof LeafMapping && this.getFragment1() instanceof AbstractExpression && this.getFragment2() instanceof StatementObject) {
            StatementObject statement = (StatementObject)this.getFragment2();
            List<VariableDeclaration> variableDeclarations = statement.getVariableDeclarations();
            boolean validReplacements = true;
            for (Replacement replacement : this.getReplacements()) {
                if (!(replacement instanceof MethodInvocationReplacement) && !(replacement instanceof ObjectCreationReplacement)) continue;
                validReplacements = false;
                break;
            }
            if (this.getFragment1().getVariableDeclarations().size() == 0 && variableDeclarations.size() == 1 && validReplacements) {
                VariableDeclaration variableDeclaration = variableDeclarations.get(0);
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(variableDeclaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                LeafMapping leafMapping = new LeafMapping(this.getFragment1(), variableDeclaration.getInitializer(), this.operation1, this.operation2);
                ref.addSubExpressionMapping(leafMapping);
                this.processExtractVariableRefactoring(ref, refactorings);
                this.checkForNestedExtractVariable(ref, refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                this.identicalWithExtractedVariable = true;
            }
        }
    }

    private void checkForNestedExtractVariable(ExtractVariableRefactoring parentRefactoring, Set<Refactoring> refactorings, List<? extends AbstractCodeFragment> nonMappedLeavesT2, boolean insideExtractedOrInlinedMethod) {
        for (AbstractCodeFragment abstractCodeFragment : nonMappedLeavesT2) {
            ExtractVariableRefactoring ref2;
            VariableDeclaration variableDeclaration;
            List<VariableDeclaration> variableDeclarations = abstractCodeFragment.getVariableDeclarations();
            if (variableDeclarations.size() != 1 || (variableDeclaration = variableDeclarations.get(0)).getInitializer() == null) continue;
            List<LeafExpression> leafExpressions1 = this.getFragment1().findExpression(variableDeclaration.getInitializer().getString());
            if (leafExpressions1.isEmpty() && !abstractCodeFragment.equals(this.getFragment2())) {
                for (AbstractCall invocation : this.getFragment1().getMethodInvocations()) {
                    if (!variableDeclaration.getInitializer().getString().startsWith(invocation.actualString()) && !variableDeclaration.getInitializer().getString().endsWith(invocation.actualString())) continue;
                    leafExpressions1 = this.getFragment1().findExpression(invocation.actualString());
                }
            }
            if (leafExpressions1.size() <= 0 || !this.isVariableReferenced(parentRefactoring, variableDeclaration) || (ref2 = new ExtractVariableRefactoring(variableDeclaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod)).equals(parentRefactoring)) continue;
            for (LeafExpression subExpression : leafExpressions1) {
                LeafMapping leafMapping2 = new LeafMapping(subExpression, variableDeclaration.getInitializer(), this.operation1, this.operation2);
                ref2.addSubExpressionMapping(leafMapping2);
            }
            this.processExtractVariableRefactoring(ref2, refactorings);
        }
    }

    private boolean isVariableReferenced(ExtractVariableRefactoring parentRefactoring, VariableDeclaration variableDeclaration) {
        if (parentRefactoring.getVariableDeclaration().getInitializer().findExpression(variableDeclaration.getVariableName()).size() > 0) {
            return true;
        }
        if (parentRefactoring.getVariableDeclaration().isAttribute()) {
            for (LeafMapping leafMapping : parentRefactoring.getSubExpressionMappings()) {
                if (!ReplacementUtil.contains(leafMapping.getFragment2().getString(), variableDeclaration.getVariableName())) continue;
                return true;
            }
        }
        for (AbstractCodeMapping abstractCodeMapping : parentRefactoring.getReferences()) {
            if (!variableDeclaration.getScope().subsumes(abstractCodeMapping.getFragment2().getLocationInfo()) || abstractCodeMapping.getFragment2().findExpression(variableDeclaration.getVariableName()).size() <= 0 || abstractCodeMapping.getFragment1().findExpression(variableDeclaration.getVariableName()).size() != 0) continue;
            return true;
        }
        return false;
    }

    private void checkForAliasedVariable(AbstractExpression initializer, Replacement replacement, List<? extends AbstractCodeFragment> nonMappedLeavesT2, UMLAbstractClassDiff classDiff, boolean insideExtractedOrInlinedMethod) {
        block14: {
            block15: {
                String rightHandSide;
                VariableDeclaration aliasedWithVariable;
                block16: {
                    aliasedWithVariable = this.operation2.getVariableDeclaration(initializer.getString());
                    if (aliasedWithVariable == null || aliasedWithVariable.getInitializer() == null) break block15;
                    rightHandSide = aliasedWithVariable.getInitializer().getString();
                    if (!(replacement instanceof VariableReplacementWithMethodInvocation)) break block16;
                    VariableReplacementWithMethodInvocation r = (VariableReplacementWithMethodInvocation)replacement;
                    for (AbstractCall call : aliasedWithVariable.getInitializer().getMethodInvocations()) {
                        if (!call.equals(r.getInvokedOperation())) continue;
                        ExtractVariableRefactoring ref = new ExtractVariableRefactoring(aliasedWithVariable, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                        LeafMapping leafMapping = new LeafMapping(r.getInvokedOperation(), call, this.operation1, this.operation2);
                        ref.addSubExpressionMapping(leafMapping);
                        this.processExtractVariableRefactoring(ref, this.refactorings);
                        this.checkForNestedExtractVariable(ref, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                        if (!this.identical()) break block14;
                        this.identicalWithExtractedVariable = true;
                        break block14;
                    }
                    break block14;
                }
                if (!replacement.getBefore().equals(rightHandSide)) break block14;
                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(aliasedWithVariable.getVariableDeclaration(), this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                List<LeafExpression> list = this.getFragment1().findExpression(rightHandSide);
                List<LeafExpression> leafExpressions2 = aliasedWithVariable.getInitializer().findExpression(rightHandSide);
                if (list.size() == leafExpressions2.size()) {
                    for (int i = 0; i < list.size(); ++i) {
                        LeafMapping leafMapping = new LeafMapping(list.get(i), leafExpressions2.get(i), this.operation1, this.operation2);
                        ref.addSubExpressionMapping(leafMapping);
                    }
                }
                this.processExtractVariableRefactoring(ref, this.refactorings);
                this.checkForNestedExtractVariable(ref, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                if (!this.identical()) break block14;
                this.identicalWithExtractedVariable = true;
                break block14;
            }
            if (classDiff != null) {
                UMLClass addedClass;
                UMLAttribute aliasedWithAttribute = null;
                if (classDiff.getNextClass().containsAttributeWithName(initializer.getString())) {
                    for (UMLAttribute uMLAttribute : classDiff.getNextClass().getAttributes()) {
                        if (!uMLAttribute.getName().equals(initializer.getString())) continue;
                        aliasedWithAttribute = uMLAttribute;
                        break;
                    }
                }
                if (classDiff.getModelDiff() != null && (addedClass = classDiff.getModelDiff().getAddedClass(this.operation2.getClassName())) != null && addedClass.containsAttributeWithName(initializer.getString())) {
                    for (UMLAttribute attribute : addedClass.getAttributes()) {
                        if (!attribute.getName().equals(initializer.getString())) continue;
                        aliasedWithAttribute = attribute;
                        break;
                    }
                }
                if (aliasedWithAttribute != null) {
                    for (AbstractCodeFragment abstractCodeFragment : nonMappedLeavesT2) {
                        if (!abstractCodeFragment.getString().startsWith(initializer.getString() + "=")) continue;
                        String rightHandSide = null;
                        rightHandSide = abstractCodeFragment.getString().endsWith(";\n") ? abstractCodeFragment.getString().substring(abstractCodeFragment.getString().indexOf("=") + 1, abstractCodeFragment.getString().length() - 2) : abstractCodeFragment.getString().substring(abstractCodeFragment.getString().indexOf("=") + 1, abstractCodeFragment.getString().length());
                        if (replacement instanceof VariableReplacementWithMethodInvocation) {
                            VariableReplacementWithMethodInvocation r = (VariableReplacementWithMethodInvocation)replacement;
                            for (AbstractCall call : abstractCodeFragment.getMethodInvocations()) {
                                if (!call.equals(r.getInvokedOperation())) continue;
                                ExtractVariableRefactoring ref = new ExtractVariableRefactoring(aliasedWithAttribute.getVariableDeclaration(), this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                                LeafMapping leafMapping = new LeafMapping(r.getInvokedOperation(), call, this.operation1, this.operation2);
                                ref.addSubExpressionMapping(leafMapping);
                                this.processExtractVariableRefactoring(ref, this.refactorings);
                                this.checkForNestedExtractVariable(ref, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                                if (!this.identical()) break block14;
                                this.identicalWithExtractedVariable = true;
                                break block14;
                            }
                            break;
                        }
                        if (!replacement.getBefore().equals(rightHandSide)) break;
                        ExtractVariableRefactoring ref = new ExtractVariableRefactoring(aliasedWithAttribute.getVariableDeclaration(), this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                        List<LeafExpression> leafExpressions1 = this.getFragment1().findExpression(rightHandSide);
                        List<LeafExpression> leafExpressions2 = abstractCodeFragment.findExpression(rightHandSide);
                        if (leafExpressions1.size() == leafExpressions2.size()) {
                            for (int i = 0; i < leafExpressions1.size(); ++i) {
                                LeafMapping leafMapping = new LeafMapping(leafExpressions1.get(i), leafExpressions2.get(i), this.operation1, this.operation2);
                                ref.addSubExpressionMapping(leafMapping);
                            }
                        }
                        this.processExtractVariableRefactoring(ref, this.refactorings);
                        this.checkForNestedExtractVariable(ref, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                        if (!this.identical()) break;
                        this.identicalWithExtractedVariable = true;
                        break;
                    }
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void temporaryVariableAssignment(AbstractCodeFragment statement, List<? extends AbstractCodeFragment> nonMappedLeavesT2, UMLAbstractClassDiff classDiff, boolean insideExtractedOrInlinedMethod) {
        String argumentizedString;
        Object ref;
        for (VariableDeclaration declaration : statement.getVariableDeclarations()) {
            boolean equalInvocations;
            AbstractCall invocationCoveringTheEntireStatement2;
            VariableDeclaration variableDeclaration1;
            AbstractCall invocation;
            String variableName = declaration.getVariableName();
            AbstractExpression initializer = declaration.getInitializer();
            for (Object replacement : this.getReplacements()) {
                String suffixAfter;
                String after = ((Replacement)replacement).getAfter();
                String before = ((Replacement)replacement).getBefore();
                if (((Replacement)replacement).getType().equals((Object)Replacement.ReplacementType.PARENTHESIZED_EXPRESSION) || ((Replacement)replacement).getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_PARENTHESIZED_EXPRESSION)) {
                    if (after.startsWith("(") && after.endsWith(")")) {
                        after = after.substring(1, after.length() - 1);
                    }
                    if (before.startsWith("(") && before.endsWith(")")) {
                        before = before.substring(1, before.length() - 1);
                    }
                }
                if (((Replacement)replacement).getType().equals((Object)Replacement.ReplacementType.CAST_EXPRESSION)) {
                    String cast1 = null;
                    String cast2 = null;
                    if (after.startsWith("(") && after.contains(")")) {
                        cast1 = after.substring(0, after.indexOf(")") + 1);
                    }
                    if (before.startsWith("(") && before.contains(")")) {
                        cast2 = before.substring(0, before.indexOf(")") + 1);
                    }
                    if (cast1 != null && cast2 != null && cast1.equals(cast2)) {
                        after = after.substring(after.indexOf(")") + 1, after.length());
                        before = before.substring(before.indexOf(")") + 1, before.length());
                    }
                }
                if (replacement instanceof MethodInvocationReplacement) {
                    MethodInvocationReplacement r = (MethodInvocationReplacement)replacement;
                    AbstractCall callBefore = r.getInvokedOperationBefore();
                    AbstractCall callAfter = r.getInvokedOperationAfter();
                    int indexOfArgument2 = callAfter.arguments().indexOf(variableName);
                    if (indexOfArgument2 != -1 && callBefore.arguments().size() == callAfter.arguments().size()) {
                        after = variableName;
                        before = callBefore.arguments().get(indexOfArgument2);
                    }
                }
                if (after.startsWith(variableName + ".") && before.endsWith(suffixAfter = after.substring(variableName.length(), after.length()))) {
                    String prefixBefore = before.substring(0, before.indexOf(suffixAfter));
                    if (initializer != null && (initializer.toString().equals(prefixBefore) || this.overlappingExtractVariable(initializer, prefixBefore, nonMappedLeavesT2, insideExtractedOrInlinedMethod, this.refactorings))) {
                        ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                        List<LeafExpression> subExpressions = this.getFragment1().findExpression(prefixBefore);
                        for (LeafExpression subExpression : subExpressions) {
                            LeafMapping leafMapping = new LeafMapping(subExpression, initializer, this.operation1, this.operation2);
                            ((ExtractVariableRefactoring)ref).addSubExpressionMapping(leafMapping);
                        }
                        this.processExtractVariableRefactoring((ExtractVariableRefactoring)ref, this.refactorings);
                        this.checkForNestedExtractVariable((ExtractVariableRefactoring)ref, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                        if (this.identical()) {
                            this.identicalWithExtractedVariable = true;
                        }
                        return;
                    }
                }
                if (!variableName.equals(after) || initializer == null) continue;
                this.checkForAliasedVariable(initializer, (Replacement)replacement, nonMappedLeavesT2, classDiff, insideExtractedOrInlinedMethod);
                if (!initializer.toString().equals(before) && !initializer.toString().equals("this." + before) && !this.overlappingExtractVariable(initializer, before, nonMappedLeavesT2, insideExtractedOrInlinedMethod, this.refactorings) && (!initializer.toString().equals("(" + declaration.getType() + ")" + before) || this.containsVariableNameReplacement(variableName)) && !this.ternaryMatch(initializer, before) && !this.infixOperandMatch(initializer, before) && !this.wrappedAsArgument(initializer, before) && !this.stringConcatMatch(initializer, before) && !this.reservedTokenMatch(initializer, (Replacement)replacement, before)) continue;
                ExtractVariableRefactoring ref2 = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                List<LeafExpression> subExpressions = this.getFragment1().findExpression(before);
                for (LeafExpression subExpression : subExpressions) {
                    LeafMapping leafMapping = new LeafMapping(subExpression, initializer, this.operation1, this.operation2);
                    ref2.addSubExpressionMapping(leafMapping);
                }
                this.processExtractVariableRefactoring(ref2, this.refactorings);
                this.checkForNestedExtractVariable(ref2, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                if (this.identical()) {
                    this.identicalWithExtractedVariable = true;
                }
                return;
            }
            if (classDiff != null && initializer != null && (invocation = initializer.invocationCoveringEntireFragment()) != null) {
                Object replacement;
                replacement = classDiff.getRefactoringsBeforePostProcessing().iterator();
                while (replacement.hasNext()) {
                    Refactoring refactoring = (Refactoring)replacement.next();
                    if (!(refactoring instanceof RenameOperationRefactoring)) continue;
                    RenameOperationRefactoring rename = (RenameOperationRefactoring)refactoring;
                    if (!invocation.getName().equals(rename.getRenamedOperation().getName())) continue;
                    String initializerBeforeRename = initializer.getString().replace(rename.getRenamedOperation().getName(), rename.getOriginalOperation().getName());
                    if (!this.getFragment1().getString().contains(initializerBeforeRename) || !this.getFragment2().getString().contains(variableName)) continue;
                    ExtractVariableRefactoring ref3 = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                    List<LeafExpression> subExpressions = this.getFragment1().findExpression(initializerBeforeRename);
                    for (LeafExpression subExpression : subExpressions) {
                        LeafMapping leafMapping = new LeafMapping(subExpression, initializer, this.operation1, this.operation2);
                        ref3.addSubExpressionMapping(leafMapping);
                    }
                    this.processExtractVariableRefactoring(ref3, this.refactorings);
                    this.checkForNestedExtractVariable(ref3, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                    return;
                }
            }
            if (classDiff == null || this.getFragment1().getVariableDeclarations().size() <= 0 || initializer == null || !this.getFragment1().getVariableDeclarations().toString().equals(this.getFragment2().getVariableDeclarations().toString()) || (variableDeclaration1 = this.getFragment1().getVariableDeclarations().get(0)).getInitializer() == null || !variableDeclaration1.getInitializer().toString().contains(initializer.toString()) || this.isDefaultValue(variableDeclaration1.getInitializer().toString())) continue;
            boolean callToAddedOperation = false;
            boolean callToDeletedOperation = false;
            AbstractCall invocationCoveringTheEntireStatement1 = this.getFragment1().invocationCoveringEntireFragment();
            if (invocationCoveringTheEntireStatement1 != null) {
                boolean bl = callToDeletedOperation = classDiff.matchesOperation(invocationCoveringTheEntireStatement1, classDiff.getRemovedOperations(), this.operation1) != null;
            }
            if ((invocationCoveringTheEntireStatement2 = this.getFragment2().invocationCoveringEntireFragment()) != null) {
                callToAddedOperation = classDiff.matchesOperation(invocationCoveringTheEntireStatement2, classDiff.getAddedOperations(), this.operation2) != null;
            }
            boolean bl = equalInvocations = invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && (invocationCoveringTheEntireStatement1.equals(invocationCoveringTheEntireStatement2) || this.containsOnlyReplacement(Replacement.ReplacementType.METHOD_INVOCATION_NAME));
            if (callToAddedOperation == callToDeletedOperation || equalInvocations) continue;
            ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
            List<LeafExpression> subExpressions = this.getFragment1().findExpression(initializer.toString());
            for (LeafExpression subExpression : subExpressions) {
                LeafMapping leafMapping = new LeafMapping(subExpression, initializer, this.operation1, this.operation2);
                ((ExtractVariableRefactoring)ref).addSubExpressionMapping(leafMapping);
            }
            this.processExtractVariableRefactoring((ExtractVariableRefactoring)ref, this.refactorings);
            this.checkForNestedExtractVariable((ExtractVariableRefactoring)ref, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
            return;
        }
        if (this.getFragment2().getVariableDeclarations().size() > 0 && this.getFragment2().getVariableDeclarations().get(0).getInitializer() != null && this.replacements.size() == 1) {
            this.checkForAliasedVariable(this.getFragment2().getVariableDeclarations().get(0).getInitializer(), this.replacements.iterator().next(), nonMappedLeavesT2, classDiff, insideExtractedOrInlinedMethod);
        }
        if ((argumentizedString = statement.getArgumentizedString()).contains("=") && (statement.getLocationInfo().before(this.fragment2.getLocationInfo()) || this.fragment2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.DO_STATEMENT))) {
            String beforeAssignment = argumentizedString.substring(0, argumentizedString.indexOf("="));
            String[] tokens = beforeAssignment.split("\\s");
            String variable = tokens[tokens.length - 1];
            String initializer = null;
            initializer = argumentizedString.endsWith(";\n") ? argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length() - 2) : argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length());
            for (Replacement replacement : this.getReplacements()) {
                if (!variable.endsWith(replacement.getAfter()) || !initializer.equals(replacement.getBefore()) && !initializer.contains(": " + replacement.getBefore()) && !initializer.contains("? " + replacement.getBefore())) continue;
                List<VariableDeclaration> variableDeclarations = this.operation2.getVariableDeclarationsInScope(this.fragment2.getLocationInfo());
                for (VariableDeclaration declaration : variableDeclarations) {
                    if (!declaration.getVariableName().equals(variable)) continue;
                    ref = new ExtractVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                    List<LeafExpression> subExpressions = this.getFragment1().findExpression(replacement.getBefore());
                    for (LeafExpression subExpression : subExpressions) {
                        List<LeafExpression> initializerSubExpressions = statement.findExpression(initializer);
                        if (initializerSubExpressions.size() <= 0) continue;
                        LeafMapping leafMapping = new LeafMapping(subExpression, initializerSubExpressions.get(0), this.operation1, this.operation2);
                        ((ExtractVariableRefactoring)ref).addSubExpressionMapping(leafMapping);
                    }
                    this.processExtractVariableRefactoring((ExtractVariableRefactoring)ref, this.refactorings);
                    this.checkForNestedExtractVariable((ExtractVariableRefactoring)ref, this.refactorings, nonMappedLeavesT2, insideExtractedOrInlinedMethod);
                    if (this.identical()) {
                        this.identicalWithExtractedVariable = true;
                    }
                    return;
                }
            }
        }
    }

    private boolean isDefaultValue(String argument) {
        return argument.equals("null") || argument.equals("0") || argument.equals("1") || argument.equals("false") || argument.equals("true");
    }

    public void inlinedVariableAssignment(AbstractCodeFragment statement, List<? extends AbstractCodeFragment> nonMappedLeavesT2, UMLAbstractClassDiff classDiff, boolean insideExtractedOrInlinedMethod) {
        for (VariableDeclaration declaration : statement.getVariableDeclarations()) {
            boolean equalInvocations;
            AbstractCall invocationCoveringTheEntireStatement2;
            VariableDeclaration variableDeclaration2;
            AbstractExpression initializer = declaration.getInitializer();
            String variableName = declaration.getVariableName();
            for (Replacement replacement : this.getReplacements()) {
                String suffixBefore;
                String after = replacement.getAfter();
                String before = replacement.getBefore();
                if (replacement.getType().equals((Object)Replacement.ReplacementType.PARENTHESIZED_EXPRESSION) || replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_PARENTHESIZED_EXPRESSION)) {
                    if (after.startsWith("(") && after.endsWith(")")) {
                        after = after.substring(1, after.length() - 1);
                    }
                    if (before.startsWith("(") && before.endsWith(")")) {
                        before = before.substring(1, before.length() - 1);
                    }
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.CAST_EXPRESSION)) {
                    String cast1 = null;
                    String cast2 = null;
                    if (after.startsWith("(") && after.contains(")")) {
                        cast1 = after.substring(0, after.indexOf(")") + 1);
                    }
                    if (before.startsWith("(") && before.contains(")")) {
                        cast2 = before.substring(0, before.indexOf(")") + 1);
                    }
                    if (cast1 != null && cast2 != null && cast1.equals(cast2)) {
                        after = after.substring(after.indexOf(")") + 1, after.length());
                        before = before.substring(before.indexOf(")") + 1, before.length());
                    }
                }
                if (before.startsWith(variableName + ".") && after.endsWith(suffixBefore = before.substring(variableName.length(), before.length()))) {
                    String prefixAfter = after.substring(0, after.indexOf(suffixBefore));
                    if (initializer != null && (initializer.toString().equals(prefixAfter) || this.overlappingExtractVariable(initializer, prefixAfter, nonMappedLeavesT2, insideExtractedOrInlinedMethod, this.refactorings))) {
                        InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                        List<LeafExpression> subExpressions = this.getFragment2().findExpression(prefixAfter);
                        for (LeafExpression subExpression : subExpressions) {
                            LeafMapping leafMapping = new LeafMapping(initializer, subExpression, this.operation1, this.operation2);
                            ref.addSubExpressionMapping(leafMapping);
                        }
                        this.processInlineVariableRefactoring(ref, this.refactorings);
                        if (this.identical()) {
                            this.identicalWithInlinedVariable = true;
                        }
                        return;
                    }
                }
                if (!variableName.equals(before) || initializer == null || !initializer.toString().equals(after) && !initializer.toString().equals("this." + after) && !this.overlappingExtractVariable(initializer, after, nonMappedLeavesT2, insideExtractedOrInlinedMethod, this.refactorings) && (!initializer.toString().equals("(" + declaration.getType() + ")" + after) || this.containsVariableNameReplacement(variableName)) && !this.ternaryMatch(initializer, after) && !this.infixOperandMatch(initializer, after) && !this.wrappedAsArgument(initializer, after) && !this.stringConcatMatch(initializer, after) && !this.reservedTokenMatch(initializer, replacement, after)) continue;
                InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                List<LeafExpression> subExpressions = this.getFragment2().findExpression(after);
                for (LeafExpression subExpression : subExpressions) {
                    LeafMapping leafMapping = new LeafMapping(initializer, subExpression, this.operation1, this.operation2);
                    ref.addSubExpressionMapping(leafMapping);
                }
                this.processInlineVariableRefactoring(ref, this.refactorings);
                if (this.identical()) {
                    this.identicalWithInlinedVariable = true;
                }
                return;
            }
            if (classDiff == null || this.getFragment1().getVariableDeclarations().size() <= 0 || initializer == null || !this.getFragment1().getVariableDeclarations().toString().equals(this.getFragment2().getVariableDeclarations().toString()) || (variableDeclaration2 = this.getFragment2().getVariableDeclarations().get(0)).getInitializer() == null || !variableDeclaration2.getInitializer().toString().contains(initializer.toString())) continue;
            boolean callToAddedOperation = false;
            boolean callToDeletedOperation = false;
            AbstractCall invocationCoveringTheEntireStatement1 = this.getFragment1().invocationCoveringEntireFragment();
            if (invocationCoveringTheEntireStatement1 != null) {
                boolean bl = callToDeletedOperation = classDiff.matchesOperation(invocationCoveringTheEntireStatement1, classDiff.getRemovedOperations(), this.operation1) != null;
            }
            if ((invocationCoveringTheEntireStatement2 = this.getFragment2().invocationCoveringEntireFragment()) != null) {
                callToAddedOperation = classDiff.matchesOperation(invocationCoveringTheEntireStatement2, classDiff.getAddedOperations(), this.operation2) != null;
            }
            boolean bl = equalInvocations = invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && (invocationCoveringTheEntireStatement1.equals(invocationCoveringTheEntireStatement2) || this.containsOnlyReplacement(Replacement.ReplacementType.METHOD_INVOCATION_NAME));
            if (callToAddedOperation == callToDeletedOperation || equalInvocations) continue;
            InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
            List<LeafExpression> subExpressions = this.getFragment2().findExpression(initializer.toString());
            for (LeafExpression subExpression : subExpressions) {
                LeafMapping leafMapping = new LeafMapping(initializer, subExpression, this.operation1, this.operation2);
                ref.addSubExpressionMapping(leafMapping);
            }
            this.processInlineVariableRefactoring(ref, this.refactorings);
            return;
        }
        String argumentizedString = statement.getArgumentizedString();
        if (argumentizedString.contains("=") && (statement.getLocationInfo().before(this.fragment1.getLocationInfo()) || this.fragment1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.DO_STATEMENT))) {
            String beforeAssignment = argumentizedString.substring(0, argumentizedString.indexOf("="));
            String[] tokens = beforeAssignment.split("\\s");
            String variable = tokens[tokens.length - 1];
            String initializer = null;
            initializer = argumentizedString.endsWith(";\n") ? argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length() - 2) : argumentizedString.substring(argumentizedString.indexOf("=") + 1, argumentizedString.length());
            for (Replacement replacement : this.getReplacements()) {
                if (!variable.endsWith(replacement.getBefore()) || !initializer.equals(replacement.getAfter())) continue;
                List<VariableDeclaration> variableDeclarations = this.operation1.getVariableDeclarationsInScope(this.fragment1.getLocationInfo());
                for (VariableDeclaration declaration : variableDeclarations) {
                    if (!declaration.getVariableName().equals(variable)) continue;
                    InlineVariableRefactoring ref = new InlineVariableRefactoring(declaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                    List<LeafExpression> subExpressions = this.getFragment2().findExpression(replacement.getAfter());
                    for (LeafExpression subExpression : subExpressions) {
                        List<LeafExpression> initializerSubExpressions = statement.findExpression(initializer);
                        if (initializerSubExpressions.size() <= 0) continue;
                        LeafMapping leafMapping = new LeafMapping(initializerSubExpressions.get(0), subExpression, this.operation1, this.operation2);
                        ref.addSubExpressionMapping(leafMapping);
                    }
                    this.processInlineVariableRefactoring(ref, this.refactorings);
                    if (this.identical()) {
                        this.identicalWithInlinedVariable = true;
                    }
                    return;
                }
            }
        }
    }

    private boolean identical() {
        if (this.getReplacements().size() == 1 && this.fragment1.getVariableDeclarations().size() == this.fragment2.getVariableDeclarations().size()) {
            return true;
        }
        if (this.fragment1.getVariableDeclarations().size() == this.fragment2.getVariableDeclarations().size() && this.fragment2.getTernaryOperatorExpressions().size() > 0) {
            TernaryOperatorExpression ternary = this.fragment2.getTernaryOperatorExpressions().get(0);
            AbstractExpression thenExpression = ternary.getThenExpression();
            AbstractExpression elseExpression = ternary.getElseExpression();
            String temp = new String(this.fragment1.getString());
            if (this.replacements.size() > 0) {
                Replacement r = this.replacements.iterator().next();
                for (Refactoring ref : this.refactorings) {
                    ExtractVariableRefactoring extract;
                    if (!(ref instanceof ExtractVariableRefactoring) || (extract = (ExtractVariableRefactoring)ref).getVariableDeclaration().getInitializer() == null || !extract.getVariableDeclaration().getInitializer().getString().equals(r.getBefore())) continue;
                    if ((temp = ReplacementUtil.performReplacement(temp, r.getBefore(), r.getAfter())).endsWith(elseExpression.getString() + ";\n")) {
                        return true;
                    }
                    if (!temp.endsWith(thenExpression.getString() + ";\n")) continue;
                    return true;
                }
            }
        }
        int stringLiteralReplacents = 0;
        for (Replacement r : this.replacements) {
            if ((!r.getBefore().startsWith("\"") || !r.getBefore().endsWith("\"")) && (!r.getAfter().startsWith("\"") || !r.getAfter().endsWith("\""))) continue;
            ++stringLiteralReplacents;
        }
        return stringLiteralReplacents == this.replacements.size();
    }

    private boolean wrappedAsArgument(AbstractExpression initializer, String replacedExpression) {
        ObjectCreation creation;
        int replacementCount = 0;
        for (Replacement r : this.replacements) {
            if (!r.getBefore().equals(replacedExpression) && !r.getAfter().equals(replacedExpression)) continue;
            ++replacementCount;
        }
        if (replacementCount > 1) {
            return false;
        }
        AbstractCall invocation = initializer.invocationCoveringEntireFragment();
        if (invocation != null) {
            if (invocation.arguments().contains(replacedExpression)) {
                return true;
            }
            String expression = invocation.getExpression();
            if (expression != null && (expression.equals(replacedExpression) || ReplacementUtil.contains(expression, replacedExpression))) {
                String subExpression;
                boolean subExpressionIsCallToSameMethod = false;
                if (invocation instanceof OperationInvocation && (subExpression = ((OperationInvocation)invocation).subExpressionIsCallToSameMethod()) != null && ReplacementUtil.contains(subExpression, replacedExpression)) {
                    subExpressionIsCallToSameMethod = true;
                }
                if (!subExpressionIsCallToSameMethod) {
                    return true;
                }
            }
        }
        return (creation = initializer.creationCoveringEntireFragment()) != null && creation.arguments().contains(replacedExpression);
    }

    private boolean infixOperandMatch(AbstractExpression initializer, String replacedExpression) {
        List<LeafExpression> infixExpressions = initializer.getInfixExpressions();
        for (LeafExpression infixExpression : infixExpressions) {
            String infix = infixExpression.getString();
            if (!infix.startsWith(replacedExpression) && !infix.endsWith(replacedExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean ternaryMatch(AbstractExpression initializer, String replacedExpression) {
        List<TernaryOperatorExpression> ternaryList = initializer.getTernaryOperatorExpressions();
        for (TernaryOperatorExpression ternary : ternaryList) {
            if (!ternary.getThenExpression().toString().equals(replacedExpression) && !ternary.getElseExpression().toString().equals(replacedExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean stringConcatMatch(AbstractExpression initializer, String replacedExpression) {
        String s1 = initializer.getString();
        String s2 = replacedExpression;
        if (s1.contains(" + ") && s2.contains(" + ")) {
            LinkedHashSet<String> tokens1 = new LinkedHashSet<String>(Arrays.asList(StringBasedHeuristics.SPLIT_CONCAT_STRING_PATTERN.split(s1)));
            LinkedHashSet<String> tokens2 = new LinkedHashSet<String>(Arrays.asList(StringBasedHeuristics.SPLIT_CONCAT_STRING_PATTERN.split(s2)));
            LinkedHashSet<String> intersection = new LinkedHashSet<String>(tokens1);
            intersection.retainAll(tokens2);
            return intersection.size() == Math.min(tokens1.size(), tokens2.size());
        }
        return false;
    }

    private boolean containsVariableNameReplacement(String variableName) {
        for (Replacement replacement : this.getReplacements()) {
            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || !replacement.getBefore().equals(variableName) && !replacement.getAfter().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private boolean reservedTokenMatch(AbstractExpression initializer, Replacement replacement, String replacedExpression) {
        AbstractCall initializerInvocation = initializer.invocationCoveringEntireFragment();
        AbstractCall replacementInvocation = replacement instanceof VariableReplacementWithMethodInvocation ? ((VariableReplacementWithMethodInvocation)replacement).getInvokedOperation() : null;
        boolean methodInvocationMatch = true;
        if (initializerInvocation != null && replacementInvocation != null) {
            if (!initializerInvocation.getName().equals(replacementInvocation.getName())) {
                methodInvocationMatch = false;
            }
            if (initializerInvocation.identicalName(replacementInvocation) && initializerInvocation.identicalExpression(replacementInvocation)) {
                MethodInvocationReplacement r = new MethodInvocationReplacement(replacementInvocation.actualString(), initializerInvocation.actualString(), replacementInvocation, initializerInvocation, Replacement.ReplacementType.METHOD_INVOCATION_ARGUMENT);
                this.replacements.add(r);
                return true;
            }
        } else if (initializerInvocation != null && replacementInvocation == null) {
            methodInvocationMatch = false;
        } else if (initializerInvocation == null && replacementInvocation != null) {
            methodInvocationMatch = false;
        }
        String initializerReservedTokens = ReplacementUtil.keepReservedTokens(initializer.toString());
        String replacementReservedTokens = ReplacementUtil.keepReservedTokens(replacedExpression);
        return methodInvocationMatch && !initializerReservedTokens.isEmpty() && !initializerReservedTokens.equals("[]") && !initializerReservedTokens.equals(".()") && !initializerReservedTokens.equals(" ()") && initializerReservedTokens.equals(replacementReservedTokens);
    }

    private void processInlineVariableRefactoring(InlineVariableRefactoring ref, Set<Refactoring> refactorings) {
        if (!refactorings.contains(ref)) {
            ref.addReference(this);
            refactorings.add(ref);
        } else {
            for (Refactoring refactoring : refactorings) {
                if (!refactoring.equals(ref)) continue;
                InlineVariableRefactoring inlineVariableRefactoring = (InlineVariableRefactoring)refactoring;
                inlineVariableRefactoring.addReference(this);
                for (LeafMapping newLeafMapping : ref.getSubExpressionMappings()) {
                    inlineVariableRefactoring.addSubExpressionMapping(newLeafMapping);
                }
            }
        }
    }

    private void processExtractVariableRefactoring(ExtractVariableRefactoring ref, Set<Refactoring> refactorings) {
        if (!refactorings.contains(ref)) {
            ref.addReference(this);
            refactorings.add(ref);
        } else {
            for (Refactoring refactoring : refactorings) {
                if (!refactoring.equals(ref)) continue;
                ExtractVariableRefactoring extractVariableRefactoring = (ExtractVariableRefactoring)refactoring;
                extractVariableRefactoring.addReference(this);
                for (LeafMapping newLeafMapping : ref.getSubExpressionMappings()) {
                    extractVariableRefactoring.addSubExpressionMapping(newLeafMapping);
                }
            }
        }
    }

    private boolean overlappingExtractVariable(AbstractExpression initializer, String input, List<? extends AbstractCodeFragment> nonMappedLeavesT2, boolean insideExtractedOrInlinedMethod, Set<Refactoring> refactorings) {
        ExtractVariableRefactoring ref;
        String prefix2;
        String prefix1;
        String output = input;
        for (Refactoring ref2 : refactorings) {
            ExtractVariableRefactoring extractVariable;
            VariableDeclaration variableDeclaration;
            if (!(ref2 instanceof ExtractVariableRefactoring) || (variableDeclaration = (extractVariable = (ExtractVariableRefactoring)ref2).getVariableDeclaration()).getInitializer() == null || !input.contains(variableDeclaration.getInitializer().toString())) continue;
            output = output.replace(variableDeclaration.getInitializer().toString(), variableDeclaration.getVariableName());
        }
        if (initializer.toString().equals(output)) {
            return true;
        }
        String longestCommonSuffix = PrefixSuffixUtils.longestCommonSuffix(initializer.toString(), input);
        if (!longestCommonSuffix.isEmpty() && longestCommonSuffix.startsWith(".") && ((prefix1 = initializer.toString().substring(0, initializer.toString().indexOf(longestCommonSuffix))).equals(prefix2 = input.substring(0, input.indexOf(longestCommonSuffix))) || !prefix1.toUpperCase().equals(prefix1) && !prefix2.toUpperCase().equals(prefix2))) {
            return true;
        }
        String longestCommonPrefix = PrefixSuffixUtils.longestCommonPrefix(initializer.toString(), input);
        if (!(longestCommonSuffix.isEmpty() || longestCommonPrefix.isEmpty() || longestCommonPrefix.equals(initializer.toString()) || longestCommonPrefix.equals(input) || longestCommonSuffix.equals(initializer.toString()) || longestCommonSuffix.equals(input) || longestCommonPrefix.length() + longestCommonSuffix.length() >= input.length() || longestCommonPrefix.length() + longestCommonSuffix.length() >= initializer.toString().length())) {
            String s1 = input.substring(longestCommonPrefix.length(), input.lastIndexOf(longestCommonSuffix));
            String string = initializer.toString().substring(longestCommonPrefix.length(), initializer.toString().lastIndexOf(longestCommonSuffix));
            for (AbstractCodeFragment abstractCodeFragment : nonMappedLeavesT2) {
                VariableDeclaration variable = abstractCodeFragment.getVariableDeclaration(string);
                if (variable == null) continue;
                if (variable.getInitializer() != null && variable.getInitializer().toString().equals(s1)) {
                    ref = new ExtractVariableRefactoring(variable, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                    List<LeafExpression> subExpressions = this.getFragment1().findExpression(s1);
                    for (LeafExpression subExpression : subExpressions) {
                        LeafMapping leafMapping = new LeafMapping(subExpression, variable.getInitializer(), this.operation1, this.operation2);
                        ref.addSubExpressionMapping(leafMapping);
                    }
                    this.processExtractVariableRefactoring(ref, refactorings);
                    return true;
                }
                List<TernaryOperatorExpression> ternaryOperators = abstractCodeFragment.getTernaryOperatorExpressions();
                for (TernaryOperatorExpression ternaryOperator : ternaryOperators) {
                    if (!ternaryOperator.getThenExpression().toString().equals(s1) && !ternaryOperator.getElseExpression().toString().equals(s1)) continue;
                    ExtractVariableRefactoring ref3 = new ExtractVariableRefactoring(variable, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
                    List<LeafExpression> subExpressions = this.getFragment1().findExpression(s1);
                    for (LeafExpression subExpression : subExpressions) {
                        AbstractExpression initializerSubExpression = ternaryOperator.getThenExpression().toString().equals(s1) ? ternaryOperator.getThenExpression() : ternaryOperator.getElseExpression();
                        LeafMapping leafMapping = new LeafMapping(subExpression, initializerSubExpression, this.operation1, this.operation2);
                        ref3.addSubExpressionMapping(leafMapping);
                    }
                    this.processExtractVariableRefactoring(ref3, refactorings);
                    return true;
                }
            }
        }
        for (AbstractCodeFragment abstractCodeFragment : nonMappedLeavesT2) {
            List<LeafExpression> leafExpressions1;
            VariableDeclaration variableDeclaration;
            List<VariableDeclaration> variableDeclarations = abstractCodeFragment.getVariableDeclarations();
            if (variableDeclarations.size() != 1 || (variableDeclaration = variableDeclarations.get(0)).getInitializer() == null || initializer.findExpression(variableDeclaration.getVariableName()).size() <= 0 || (leafExpressions1 = this.getFragment1().findExpression(input)).size() <= 0 || variableDeclaration.getInitializer().findExpression(input).size() <= 0) continue;
            ref = new ExtractVariableRefactoring(variableDeclaration, this.operation1, this.operation2, insideExtractedOrInlinedMethod);
            for (LeafExpression subExpression : leafExpressions1) {
                LeafMapping leafMapping = new LeafMapping(subExpression, variableDeclaration.getInitializer(), this.operation1, this.operation2);
                ref.addSubExpressionMapping(leafMapping);
            }
            this.processExtractVariableRefactoring(ref, refactorings);
            return true;
        }
        return false;
    }

    public Set<Replacement> commonReplacements(AbstractCodeMapping other) {
        LinkedHashSet<Replacement> intersection = new LinkedHashSet<Replacement>(this.replacements);
        intersection.retainAll(other.replacements);
        return intersection;
    }

    public Set<Replacement> getReplacementsInvolvingMethodInvocation() {
        LinkedHashSet<Replacement> replacements = new LinkedHashSet<Replacement>();
        for (Replacement replacement : this.getReplacements()) {
            if (!AbstractCodeMapping.involvesMethodInvocation(replacement)) continue;
            replacements.add(replacement);
        }
        return replacements;
    }

    public Pair<CompositeStatementObject, CompositeStatementObject> nestedUnderCatchBlock() {
        CompositeStatementObject parent1 = this.fragment1.getParent();
        for (CompositeStatementObject parent2 = this.fragment2.getParent(); parent1 != null && parent2 != null; parent1 = parent1.getParent(), parent2 = parent2.getParent()) {
            if (parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE) && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE)) {
                return Pair.of((Object)parent1, (Object)parent2);
            }
            if (!parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FINALLY_BLOCK) || !parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FINALLY_BLOCK)) continue;
            return Pair.of((Object)parent1, (Object)parent2);
        }
        return null;
    }

    private static boolean involvesMethodInvocation(Replacement replacement) {
        return replacement instanceof MethodInvocationReplacement || replacement instanceof VariableReplacementWithMethodInvocation || replacement instanceof ClassInstanceCreationWithMethodInvocationReplacement || replacement instanceof MethodInvocationWithClassInstanceCreationReplacement || replacement.getType().equals((Object)Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION) || replacement.getType().equals((Object)Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION) || replacement.getType().equals((Object)Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_METHOD_INVOCATION) || replacement.getType().equals((Object)Replacement.ReplacementType.METHOD_INVOCATION_REPLACED_WITH_CONDITIONAL_EXPRESSION) || replacement instanceof IntersectionReplacement || replacement.getType().equals((Object)Replacement.ReplacementType.ANONYMOUS_CLASS_DECLARATION);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fragment1 == null ? 0 : this.fragment1.hashCode());
        result = 31 * result + (this.fragment2 == null ? 0 : this.fragment2.hashCode());
        result = 31 * result + (this.operation1 == null ? 0 : this.operation1.hashCode());
        result = 31 * result + (this.operation2 == null ? 0 : this.operation2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCodeMapping other = (AbstractCodeMapping)obj;
        if (this.fragment1 == null ? other.fragment1 != null : !this.fragment1.equals(other.fragment1)) {
            return false;
        }
        if (this.fragment2 == null ? other.fragment2 != null : !this.fragment2.equals(other.fragment2)) {
            return false;
        }
        if (this.operation1 == null ? other.operation1 != null : !this.operation1.equals(other.operation1)) {
            return false;
        }
        return !(this.operation2 == null ? other.operation2 != null : !this.operation2.equals(other.operation2));
    }
}

