/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.TryStatementObject;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class CompositeStatementObject
extends AbstractStatement {
    private List<AbstractStatement> statementList;
    private List<AbstractExpression> expressionList;
    private List<VariableDeclaration> variableDeclarations;
    private Optional<TryStatementObject> tryContainer;
    private LocationInfo locationInfo;

    public CompositeStatementObject(CompilationUnit cu, String filePath, ASTNode statement, int depth, LocationInfo.CodeElementType codeElementType) {
        this.setDepth(depth);
        this.locationInfo = new LocationInfo(cu, filePath, statement, codeElementType);
        this.statementList = new ArrayList<AbstractStatement>();
        this.expressionList = new ArrayList<AbstractExpression>();
        this.variableDeclarations = new ArrayList<VariableDeclaration>();
    }

    public void addStatement(AbstractStatement statement) {
        statement.setIndex(this.statementList.size());
        this.statementList.add(statement);
        statement.setParent(this);
        statement.getVariableDeclarations().stream().forEach(variableDeclaration -> variableDeclaration.getScope().setParentSignature(this.getSignature()));
    }

    public List<AbstractStatement> getStatements() {
        return this.statementList;
    }

    public Optional<TryStatementObject> getTryContainer() {
        return this.tryContainer;
    }

    public void setTryContainer(TryStatementObject tryContainer) {
        this.tryContainer = Optional.ofNullable(tryContainer);
    }

    public List<AbstractStatement> getAllStatements() {
        ArrayList<AbstractStatement> allStatements = new ArrayList<AbstractStatement>();
        for (AbstractStatement statement : this.statementList) {
            allStatements.add(statement);
            if (!(statement instanceof CompositeStatementObject)) continue;
            CompositeStatementObject composite = (CompositeStatementObject)statement;
            allStatements.addAll(composite.getAllStatements());
        }
        return allStatements;
    }

    public void addExpression(AbstractExpression expression) {
        expression.setDepth(this.getDepth());
        expression.setIndex(this.getIndex());
        this.expressionList.add(expression);
        expression.setOwner(this);
        expression.getVariableDeclarations().stream().forEach(variableDeclaration -> variableDeclaration.getScope().setParentSignature(this.getSignature()));
    }

    public List<AbstractExpression> getExpressions() {
        return this.expressionList;
    }

    public void addVariableDeclaration(VariableDeclaration declaration) {
        this.variableDeclarations.add(declaration);
        declaration.getScope().setParentSignature(this.getSignature());
    }

    @Override
    public List<AbstractCodeFragment> getLeaves() {
        ArrayList<AbstractCodeFragment> leaves = new ArrayList<AbstractCodeFragment>();
        for (AbstractStatement statement : this.statementList) {
            leaves.addAll(statement.getLeaves());
        }
        return leaves;
    }

    public List<CompositeStatementObject> getInnerNodes() {
        ArrayList<CompositeStatementObject> innerNodes = new ArrayList<CompositeStatementObject>();
        for (AbstractStatement statement : this.statementList) {
            if (!(statement instanceof CompositeStatementObject)) continue;
            CompositeStatementObject composite = (CompositeStatementObject)statement;
            innerNodes.addAll(composite.getInnerNodes());
        }
        innerNodes.add(this);
        return innerNodes;
    }

    public boolean contains(AbstractCodeFragment fragment) {
        if (fragment instanceof StatementObject) {
            return this.getLeaves().contains(fragment);
        }
        if (fragment instanceof CompositeStatementObject) {
            return this.getInnerNodes().contains(fragment);
        }
        if (fragment instanceof AbstractExpression) {
            return this.getExpressions().contains(fragment);
        }
        return false;
    }

    @Override
    public void resetArgumentization() {
        super.resetArgumentization();
        for (AbstractExpression expression : this.expressionList) {
            expression.resetArgumentization();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.locationInfo.getCodeElementType().getName());
        if (this.expressionList.size() > 0) {
            sb.append("(");
            for (int i = 0; i < this.expressionList.size() - 1; ++i) {
                AbstractExpression expression = this.expressionList.get(i);
                if (expression.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT_PARAMETER_NAME)) {
                    VariableDeclaration parameterDeclaration = this.getVariableDeclaration(expression.toString());
                    if (parameterDeclaration == null) continue;
                    if (parameterDeclaration.isFinal()) {
                        sb.append("final").append(" ");
                    }
                    sb.append(parameterDeclaration.getVariableName()).append(": ");
                    continue;
                }
                sb.append(expression.toString()).append("; ");
            }
            AbstractExpression lastExpression = this.expressionList.get(this.expressionList.size() - 1);
            if (lastExpression.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE_EXCEPTION_NAME)) {
                VariableDeclaration exceptionDeclaration = this.getVariableDeclaration(lastExpression.toString());
                if (exceptionDeclaration != null) {
                    if (exceptionDeclaration.isFinal()) {
                        sb.append("final").append(" ");
                    }
                    sb.append(exceptionDeclaration.getVariableName());
                }
            } else {
                sb.append(lastExpression.toString());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String toStringForStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.locationInfo.getCodeElementType().getName());
        if (this.expressionList.size() > 0) {
            sb.append("(");
            for (int i = 0; i < this.expressionList.size() - 1; ++i) {
                AbstractExpression expression = this.expressionList.get(i);
                if (expression.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT_PARAMETER_NAME)) {
                    VariableDeclaration parameterDeclaration = this.getVariableDeclaration(expression.toString());
                    if (parameterDeclaration == null) continue;
                    if (parameterDeclaration.isFinal()) {
                        sb.append("final").append(" ");
                    }
                    sb.append(parameterDeclaration.getType()).append(" ");
                    sb.append(parameterDeclaration.getVariableName()).append(": ");
                    continue;
                }
                sb.append(expression.toString()).append("; ");
            }
            AbstractExpression lastExpression = this.expressionList.get(this.expressionList.size() - 1);
            if (lastExpression.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE_EXCEPTION_NAME)) {
                VariableDeclaration exceptionDeclaration = this.getVariableDeclaration(lastExpression.toString());
                if (exceptionDeclaration != null) {
                    if (exceptionDeclaration.isFinal()) {
                        sb.append("final").append(" ");
                    }
                    sb.append(exceptionDeclaration.getType()).append(" ");
                    sb.append(exceptionDeclaration.getVariableName());
                }
            } else {
                sb.append(lastExpression.toString());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<LeafExpression> getVariables() {
        ArrayList<LeafExpression> variables = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            variables.addAll(expression.getVariables());
        }
        return variables;
    }

    @Override
    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            types.addAll(expression.getTypes());
        }
        return types;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
        variableDeclarations.addAll(this.variableDeclarations);
        for (AbstractExpression expression : this.expressionList) {
            variableDeclarations.addAll(expression.getVariableDeclarations());
        }
        return variableDeclarations;
    }

    @Override
    public List<AbstractCall> getMethodInvocations() {
        ArrayList<AbstractCall> list = new ArrayList<AbstractCall>();
        for (AbstractExpression expression : this.expressionList) {
            list.addAll(expression.getMethodInvocations());
        }
        return list;
    }

    @Override
    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        ArrayList<AnonymousClassDeclarationObject> anonymousClassDeclarations = new ArrayList<AnonymousClassDeclarationObject>();
        for (AbstractExpression expression : this.expressionList) {
            anonymousClassDeclarations.addAll(expression.getAnonymousClassDeclarations());
        }
        return anonymousClassDeclarations;
    }

    @Override
    public List<LeafExpression> getStringLiterals() {
        ArrayList<LeafExpression> stringLiterals = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            stringLiterals.addAll(expression.getStringLiterals());
        }
        return stringLiterals;
    }

    @Override
    public List<LeafExpression> getCharLiterals() {
        ArrayList<LeafExpression> charLiterals = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            charLiterals.addAll(expression.getCharLiterals());
        }
        return charLiterals;
    }

    @Override
    public List<LeafExpression> getNumberLiterals() {
        ArrayList<LeafExpression> numberLiterals = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            numberLiterals.addAll(expression.getNumberLiterals());
        }
        return numberLiterals;
    }

    @Override
    public List<LeafExpression> getNullLiterals() {
        ArrayList<LeafExpression> nullLiterals = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            nullLiterals.addAll(expression.getNullLiterals());
        }
        return nullLiterals;
    }

    @Override
    public List<LeafExpression> getBooleanLiterals() {
        ArrayList<LeafExpression> booleanLiterals = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            booleanLiterals.addAll(expression.getBooleanLiterals());
        }
        return booleanLiterals;
    }

    @Override
    public List<LeafExpression> getTypeLiterals() {
        ArrayList<LeafExpression> typeLiterals = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            typeLiterals.addAll(expression.getTypeLiterals());
        }
        return typeLiterals;
    }

    @Override
    public List<LeafExpression> getInfixExpressions() {
        ArrayList<LeafExpression> infixExpressions = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            infixExpressions.addAll(expression.getInfixExpressions());
        }
        return infixExpressions;
    }

    @Override
    public List<String> getInfixOperators() {
        ArrayList<String> infixOperators = new ArrayList<String>();
        for (AbstractExpression expression : this.expressionList) {
            infixOperators.addAll(expression.getInfixOperators());
        }
        return infixOperators;
    }

    @Override
    public List<LeafExpression> getArrayAccesses() {
        ArrayList<LeafExpression> arrayAccesses = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            arrayAccesses.addAll(expression.getArrayAccesses());
        }
        return arrayAccesses;
    }

    @Override
    public List<LeafExpression> getPrefixExpressions() {
        ArrayList<LeafExpression> prefixExpressions = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            prefixExpressions.addAll(expression.getPrefixExpressions());
        }
        return prefixExpressions;
    }

    @Override
    public List<LeafExpression> getPostfixExpressions() {
        ArrayList<LeafExpression> postfixExpressions = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            postfixExpressions.addAll(expression.getPostfixExpressions());
        }
        return postfixExpressions;
    }

    @Override
    public List<LeafExpression> getThisExpressions() {
        ArrayList<LeafExpression> thisExpressions = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            thisExpressions.addAll(expression.getThisExpressions());
        }
        return thisExpressions;
    }

    @Override
    public List<LeafExpression> getArguments() {
        ArrayList<LeafExpression> arguments = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            arguments.addAll(expression.getArguments());
        }
        return arguments;
    }

    @Override
    public List<LeafExpression> getParenthesizedExpressions() {
        ArrayList<LeafExpression> parenthesizedExpressions = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            parenthesizedExpressions.addAll(expression.getParenthesizedExpressions());
        }
        return parenthesizedExpressions;
    }

    @Override
    public List<LeafExpression> getCastExpressions() {
        ArrayList<LeafExpression> castExpressions = new ArrayList<LeafExpression>();
        for (AbstractExpression expression : this.expressionList) {
            castExpressions.addAll(expression.getCastExpressions());
        }
        return castExpressions;
    }

    @Override
    public List<TernaryOperatorExpression> getTernaryOperatorExpressions() {
        ArrayList<TernaryOperatorExpression> ternaryOperatorExpressions = new ArrayList<TernaryOperatorExpression>();
        for (AbstractExpression expression : this.expressionList) {
            ternaryOperatorExpressions.addAll(expression.getTernaryOperatorExpressions());
        }
        return ternaryOperatorExpressions;
    }

    @Override
    public List<LambdaExpressionObject> getLambdas() {
        ArrayList<LambdaExpressionObject> lambdas = new ArrayList<LambdaExpressionObject>();
        for (AbstractExpression expression : this.expressionList) {
            lambdas.addAll(expression.getLambdas());
        }
        return lambdas;
    }

    @Override
    public List<AbstractCall> getCreations() {
        ArrayList<AbstractCall> list = new ArrayList<AbstractCall>();
        for (AbstractExpression expression : this.expressionList) {
            list.addAll(expression.getCreations());
        }
        return list;
    }

    public List<AbstractCall> getAllCreations() {
        ArrayList<AbstractCall> list = new ArrayList<AbstractCall>();
        list.addAll(this.getCreations());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                list.addAll(composite.getAllCreations());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            list.addAll(statementObject.getCreations());
            for (LambdaExpressionObject lambda : statementObject.getLambdas()) {
                list.addAll(lambda.getAllCreations());
            }
            for (AnonymousClassDeclarationObject anonymous : statementObject.getAnonymousClassDeclarations()) {
                list.addAll(anonymous.getCreations());
            }
        }
        return list;
    }

    public List<AbstractCall> getAllMethodInvocations() {
        ArrayList<AbstractCall> list = new ArrayList<AbstractCall>();
        list.addAll(this.getMethodInvocations());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                list.addAll(composite.getAllMethodInvocations());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            list.addAll(statementObject.getMethodInvocations());
            for (LambdaExpressionObject lambda : statementObject.getLambdas()) {
                list.addAll(lambda.getAllOperationInvocations());
            }
            for (AnonymousClassDeclarationObject anonymous : statementObject.getAnonymousClassDeclarations()) {
                list.addAll(anonymous.getMethodInvocations());
            }
        }
        return list;
    }

    public List<AnonymousClassDeclarationObject> getAllAnonymousClassDeclarations() {
        ArrayList<AnonymousClassDeclarationObject> anonymousClassDeclarations = new ArrayList<AnonymousClassDeclarationObject>();
        anonymousClassDeclarations.addAll(this.getAnonymousClassDeclarations());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                anonymousClassDeclarations.addAll(composite.getAllAnonymousClassDeclarations());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            anonymousClassDeclarations.addAll(statementObject.getAnonymousClassDeclarations());
        }
        return anonymousClassDeclarations;
    }

    public List<LambdaExpressionObject> getAllLambdas() {
        ArrayList<LambdaExpressionObject> lambdas = new ArrayList<LambdaExpressionObject>();
        lambdas.addAll(this.getLambdas());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                lambdas.addAll(composite.getAllLambdas());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            lambdas.addAll(statementObject.getLambdas());
        }
        return lambdas;
    }

    public List<String> getAllVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        for (LeafExpression variable : this.getVariables()) {
            variables.add(variable.getString());
        }
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                variables.addAll(composite.getAllVariables());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            for (LeafExpression variable : statementObject.getVariables()) {
                variables.add(variable.getString());
            }
        }
        return variables;
    }

    public List<VariableDeclaration> getAllVariableDeclarations() {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
        variableDeclarations.addAll(this.getVariableDeclarations());
        for (AbstractStatement statement : this.statementList) {
            if (statement instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement;
                variableDeclarations.addAll(composite.getAllVariableDeclarations());
                continue;
            }
            if (!(statement instanceof StatementObject)) continue;
            StatementObject statementObject = (StatementObject)statement;
            variableDeclarations.addAll(statementObject.getVariableDeclarations());
            for (LambdaExpressionObject lambda : statementObject.getLambdas()) {
                variableDeclarations.addAll(lambda.getParameters());
                if (lambda.getBody() == null) continue;
                variableDeclarations.addAll(lambda.getBody().getAllVariableDeclarations());
            }
        }
        return variableDeclarations;
    }

    public List<VariableDeclaration> getVariableDeclarationsInScope(LocationInfo location) {
        ArrayList<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
        for (VariableDeclaration variableDeclaration : this.getAllVariableDeclarations()) {
            if (!variableDeclaration.getScope().subsumes(location)) continue;
            variableDeclarations.add(variableDeclaration);
        }
        return variableDeclarations;
    }

    @Override
    public int statementCount() {
        int count = 0;
        if (!this.getString().equals("{")) {
            ++count;
        }
        for (AbstractStatement statement : this.statementList) {
            count += statement.statementCount();
        }
        return count;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public VariableDeclaration getVariableDeclaration(String variableName) {
        List<VariableDeclaration> variableDeclarations = this.getAllVariableDeclarations();
        ArrayList<VariableDeclaration> matchingDeclarations = new ArrayList<VariableDeclaration>();
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(variableName)) continue;
            matchingDeclarations.add(declaration);
        }
        if (matchingDeclarations.size() > 0) {
            return (VariableDeclaration)matchingDeclarations.get(matchingDeclarations.size() - 1);
        }
        return null;
    }

    public Map<String, Set<String>> aliasedVariables() {
        LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
        for (AbstractCodeFragment statement : this.getLeaves()) {
            String firstLine;
            String s = statement.getString();
            if (s.startsWith("this.") || !s.endsWith(";\n") || !(firstLine = s.substring(0, s.indexOf("\n"))).contains("=")) continue;
            String variable = s.substring(0, s.indexOf("="));
            String value = s.substring(s.indexOf("=") + 1, s.indexOf(";\n"));
            if (map.containsKey(value)) {
                ((Set)map.get(value)).add(variable);
                continue;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(variable);
            map.put(value, set);
        }
        return map;
    }

    public Map<String, Set<String>> aliasedAttributes() {
        LinkedHashMap<String, Set<String>> map = new LinkedHashMap<String, Set<String>>();
        for (AbstractCodeFragment statement : this.getLeaves()) {
            String firstLine;
            String s = statement.getString();
            if (!s.startsWith("this.") || !s.endsWith(";\n") || !(firstLine = s.substring(0, s.indexOf("\n"))).contains("=")) continue;
            String attribute = s.substring(5, s.indexOf("="));
            String value = s.substring(s.indexOf("=") + 1, s.indexOf(";\n"));
            if (map.containsKey(value)) {
                ((Set)map.get(value)).add(attribute);
                continue;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(attribute);
            map.put(value, set);
        }
        LinkedHashSet<String> keysToBeRemoved = new LinkedHashSet<String>();
        for (String key : map.keySet()) {
            if (((Set)map.get(key)).size() > 1) continue;
            keysToBeRemoved.add(key);
        }
        for (String key : keysToBeRemoved) {
            map.remove(key);
        }
        return map;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public boolean isBlock() {
        return this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK) || this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.FINALLY_BLOCK) || this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE);
    }

    public boolean isLoop() {
        return this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT) || this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT) || this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.WHILE_STATEMENT) || this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.DO_STATEMENT);
    }

    public CompositeStatementObject loopWithVariables(String currentElementName, String collectionName) {
        for (CompositeStatementObject innerNode : this.getInnerNodes()) {
            if (innerNode.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.ENHANCED_FOR_STATEMENT)) {
                boolean currentElementNameMatched = false;
                for (VariableDeclaration variableDeclaration : innerNode.getVariableDeclarations()) {
                    if (!variableDeclaration.getVariableName().equals(currentElementName)) continue;
                    currentElementNameMatched = true;
                    break;
                }
                boolean collectionNameMatched = false;
                block2: for (Object expression : innerNode.getExpressions()) {
                    for (LeafExpression variable : ((AbstractExpression)expression).getVariables()) {
                        if (!variable.getString().equals(collectionName)) continue;
                        collectionNameMatched = true;
                        continue block2;
                    }
                }
                if (!currentElementNameMatched || !collectionNameMatched) continue;
                return innerNode;
            }
            if (!innerNode.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.FOR_STATEMENT) && !innerNode.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.WHILE_STATEMENT)) continue;
            boolean collectionNameMatched = false;
            block4: for (AbstractExpression abstractExpression : innerNode.getExpressions()) {
                Object expression;
                expression = abstractExpression.getVariables().iterator();
                while (expression.hasNext()) {
                    LeafExpression variable = (LeafExpression)expression.next();
                    if (!variable.getString().equals(collectionName)) continue;
                    collectionNameMatched = true;
                    continue block4;
                }
            }
            boolean currentElementNameMatched = false;
            block6: for (AbstractCodeFragment statement : innerNode.getLeaves()) {
                VariableDeclaration variableDeclaration = statement.getVariableDeclaration(currentElementName);
                if (variableDeclaration == null) continue;
                for (LeafExpression variable : statement.getVariables()) {
                    if (!variable.getString().equals(collectionName)) continue;
                    currentElementNameMatched = true;
                    continue block6;
                }
            }
            if (!currentElementNameMatched || !collectionNameMatched) continue;
            return innerNode;
        }
        return null;
    }

    @Override
    public List<String> stringRepresentation() {
        ArrayList<String> stringRepresentation = new ArrayList<String>();
        stringRepresentation.add(this.toStringForStringRepresentation());
        for (AbstractStatement statement : this.statementList) {
            stringRepresentation.addAll(statement.stringRepresentation());
        }
        if (this.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK)) {
            stringRepresentation.add("}");
        }
        return stringRepresentation;
    }

    public List<String> bodyStringRepresentation() {
        ArrayList<String> stringRepresentation = new ArrayList<String>();
        for (AbstractStatement statement : this.statementList) {
            stringRepresentation.addAll(statement.stringRepresentation());
        }
        if (this.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK)) {
            stringRepresentation.add("}");
        }
        return stringRepresentation;
    }

    public String getSignature() {
        AbstractStatement abstractStatement;
        String statementType = this.getLocationInfo().getCodeElementType().getName() != null ? this.getLocationInfo().getCodeElementType().getName() : this.toString();
        CompositeStatementObject parent = this.getParent();
        if (parent == null) {
            return statementType;
        }
        List sameTypeSibling = parent.getStatements().stream().filter(st -> statementType.equals(st.getLocationInfo().getCodeElementType().getName())).collect(Collectors.toList());
        int typeIndex = 1;
        Iterator iterator = sameTypeSibling.iterator();
        while (iterator.hasNext() && (abstractStatement = (AbstractStatement)iterator.next()).getIndex() != this.getIndex()) {
            ++typeIndex;
        }
        return String.format("%s:%s%d", parent.getSignature(), statementType, typeIndex);
    }
}

