/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class LambdaExpressionObject
implements VariableDeclarationContainer,
LocationInfoProvider {
    private LocationInfo locationInfo;
    private OperationBody body;
    private AbstractExpression expression;
    private List<VariableDeclaration> parameters = new ArrayList<VariableDeclaration>();
    private List<UMLParameter> umlParameters = new ArrayList<UMLParameter>();
    private boolean hasParentheses = false;
    private VariableDeclarationContainer owner;

    public LambdaExpressionObject(CompilationUnit cu, String filePath, LambdaExpression lambda, VariableDeclarationContainer owner) {
        this.owner = owner;
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)lambda, LocationInfo.CodeElementType.LAMBDA_EXPRESSION);
        this.hasParentheses = lambda.hasParentheses();
        List params = lambda.parameters();
        for (org.eclipse.jdt.core.dom.VariableDeclaration param : params) {
            VariableDeclaration parameter = null;
            if (param instanceof VariableDeclarationFragment) {
                parameter = new VariableDeclaration(cu, filePath, (VariableDeclarationFragment)param, (VariableDeclarationContainer)this);
            } else if (param instanceof SingleVariableDeclaration) {
                parameter = new VariableDeclaration(cu, filePath, (SingleVariableDeclaration)param, (VariableDeclarationContainer)this);
                Type parameterType = ((SingleVariableDeclaration)param).getType();
                String parameterName = param.getName().getFullyQualifiedName();
                UMLType type = UMLType.extractTypeObject(cu, filePath, parameterType, param.getExtraDimensions());
                if (((SingleVariableDeclaration)param).isVarargs()) {
                    type.setVarargs();
                }
                UMLParameter umlParameter = new UMLParameter(parameterName, type, "in", ((SingleVariableDeclaration)param).isVarargs());
                umlParameter.setVariableDeclaration(parameter);
                this.umlParameters.add(umlParameter);
            }
            this.parameters.add(parameter);
        }
        if (lambda.getBody() instanceof Block) {
            this.body = new OperationBody(cu, filePath, (Block)lambda.getBody(), this, new ArrayList<UMLAttribute>());
        } else if (lambda.getBody() instanceof Expression) {
            this.expression = new AbstractExpression(cu, filePath, (Expression)lambda.getBody(), LocationInfo.CodeElementType.LAMBDA_EXPRESSION_BODY, this);
            this.expression.setLambdaOwner(this);
            for (VariableDeclaration parameter : this.parameters) {
                parameter.addStatementInScope(this.expression);
            }
        }
    }

    public LambdaExpressionObject(CompilationUnit cu, String filePath, ExpressionMethodReference reference, VariableDeclarationContainer owner) {
        this.owner = owner;
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)reference, LocationInfo.CodeElementType.LAMBDA_EXPRESSION);
        this.expression = new AbstractExpression(cu, filePath, (Expression)reference, LocationInfo.CodeElementType.LAMBDA_EXPRESSION_BODY, this);
    }

    public LambdaExpressionObject(CompilationUnit cu, String filePath, SuperMethodReference reference, VariableDeclarationContainer owner) {
        this.owner = owner;
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)reference, LocationInfo.CodeElementType.LAMBDA_EXPRESSION);
        this.expression = new AbstractExpression(cu, filePath, (Expression)reference, LocationInfo.CodeElementType.LAMBDA_EXPRESSION_BODY, this);
    }

    public LambdaExpressionObject(CompilationUnit cu, String filePath, TypeMethodReference reference, VariableDeclarationContainer owner) {
        this.owner = owner;
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)reference, LocationInfo.CodeElementType.LAMBDA_EXPRESSION);
        this.expression = new AbstractExpression(cu, filePath, (Expression)reference, LocationInfo.CodeElementType.LAMBDA_EXPRESSION_BODY, this);
    }

    public VariableDeclarationContainer getOwner() {
        return this.owner;
    }

    @Override
    public OperationBody getBody() {
        return this.body;
    }

    public AbstractExpression getExpression() {
        return this.expression;
    }

    public List<VariableDeclaration> getParameters() {
        return this.parameters;
    }

    public List<UMLParameter> getUmlParameters() {
        return this.umlParameters;
    }

    @Override
    public List<String> getParameterNameList() {
        ArrayList<String> parameterNameList = new ArrayList<String>();
        for (VariableDeclaration parameter : this.parameters) {
            parameterNameList.add(parameter.getVariableName());
        }
        return parameterNameList;
    }

    @Override
    public List<UMLType> getParameterTypeList() {
        ArrayList<UMLType> parameterTypeList = new ArrayList<UMLType>();
        for (UMLParameter parameter : this.umlParameters) {
            parameterTypeList.add(parameter.getType());
        }
        return parameterTypeList;
    }

    @Override
    public int getNumberOfNonVarargsParameters() {
        int counter = 0;
        for (UMLParameter parameter : this.umlParameters) {
            if (parameter.isVarargs()) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public boolean hasVarargsParameter() {
        for (UMLParameter parameter : this.umlParameters) {
            if (!parameter.isVarargs()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locationInfo == null ? 0 : this.locationInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LambdaExpressionObject other = (LambdaExpressionObject)obj;
        return !(this.locationInfo == null ? other.locationInfo != null : !this.locationInfo.equals(other.locationInfo));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasParentheses) {
            sb.append("(");
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            sb.append(this.parameters.get(i).getVariableName());
            if (i >= this.parameters.size() - 1) continue;
            sb.append(", ");
        }
        if (this.hasParentheses) {
            sb.append(")");
        }
        if (this.parameters.size() > 0 || this.hasParentheses) {
            sb.append(" -> ");
        }
        if (this.expression != null) {
            sb.append(this.expression.getString());
        } else if (this.body != null) {
            List<String> statements = this.body.stringRepresentation();
            for (String statement : statements) {
                sb.append(statement);
            }
        }
        return sb.toString();
    }

    @Override
    public List<VariableDeclaration> getParameterDeclarationList() {
        return this.getParameters();
    }

    @Override
    public List<UMLParameter> getParametersWithoutReturnType() {
        return this.getUmlParameters();
    }

    @Override
    public List<UMLAnonymousClass> getAnonymousClassList() {
        if (this.owner != null) {
            ArrayList<UMLAnonymousClass> anonymousClassList = new ArrayList<UMLAnonymousClass>();
            for (UMLAnonymousClass anonymousClass : this.owner.getAnonymousClassList()) {
                if (!this.locationInfo.subsumes(anonymousClass.getLocationInfo())) continue;
                anonymousClassList.add(anonymousClass);
            }
            return anonymousClassList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<LambdaExpressionObject> getAllLambdas() {
        if (this.expression != null) {
            return this.expression.getLambdas();
        }
        if (this.body != null) {
            return this.body.getAllLambdas();
        }
        return Collections.emptyList();
    }

    @Override
    public List<AbstractCall> getAllOperationInvocations() {
        if (this.expression != null) {
            return new ArrayList<AbstractCall>(this.expression.getMethodInvocations());
        }
        if (this.body != null) {
            return this.body.getAllOperationInvocations();
        }
        return Collections.emptyList();
    }

    @Override
    public List<AbstractCall> getAllCreations() {
        if (this.expression != null) {
            return new ArrayList<AbstractCall>(this.expression.getCreations());
        }
        if (this.body != null) {
            return this.body.getAllCreations();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllVariables() {
        if (this.expression != null) {
            ArrayList<String> variables = new ArrayList<String>();
            for (LeafExpression variable : this.expression.getVariables()) {
                variables.add(variable.getString());
            }
            return variables;
        }
        if (this.body != null) {
            return this.body.getAllVariables();
        }
        return Collections.emptyList();
    }

    @Override
    public List<UMLComment> getComments() {
        if (this.owner != null) {
            ArrayList<UMLComment> comments = new ArrayList<UMLComment>();
            for (UMLComment comment : this.owner.getComments()) {
                if (!this.locationInfo.subsumes(comment.getLocationInfo())) continue;
                comments.add(comment);
            }
            return comments;
        }
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getElementType() {
        return "lambda";
    }

    @Override
    public String getClassName() {
        if (this.owner != null) {
            return this.owner.getClassName();
        }
        return null;
    }

    @Override
    public String toQualifiedString() {
        if (this.owner != null) {
            return this.owner.toQualifiedString() + " -> @" + this.locationInfo;
        }
        return null;
    }

    @Override
    public Map<String, Set<VariableDeclaration>> variableDeclarationMap() {
        LinkedHashMap<String, Set<VariableDeclaration>> variableDeclarationMap = new LinkedHashMap<String, Set<VariableDeclaration>>();
        for (VariableDeclaration declaration : this.getAllVariableDeclarations()) {
            if (variableDeclarationMap.containsKey(declaration.getVariableName())) {
                ((Set)variableDeclarationMap.get(declaration.getVariableName())).add(declaration);
                continue;
            }
            LinkedHashSet<VariableDeclaration> variableDeclarations = new LinkedHashSet<VariableDeclaration>();
            variableDeclarations.add(declaration);
            variableDeclarationMap.put(declaration.getVariableName(), variableDeclarations);
        }
        return variableDeclarationMap;
    }

    @Override
    public UMLAnonymousClass findAnonymousClass(AnonymousClassDeclarationObject anonymousClassDeclaration) {
        for (UMLAnonymousClass anonymousClass : this.getAnonymousClassList()) {
            if (!anonymousClass.getLocationInfo().equals(anonymousClassDeclaration.getLocationInfo())) continue;
            return anonymousClass;
        }
        return null;
    }

    @Override
    public boolean hasTestAnnotation() {
        return false;
    }

    @Override
    public boolean hasParameterizedTestAnnotation() {
        return false;
    }

    @Override
    public boolean hasSetUpAnnotation() {
        return false;
    }

    @Override
    public boolean hasTearDownAnnotation() {
        return false;
    }

    @Override
    public boolean isDeclaredInAnonymousClass() {
        return false;
    }

    @Override
    public Optional<UMLAnonymousClass> getAnonymousClassContainer() {
        return Optional.empty();
    }

    @Override
    public boolean isGetter() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public AbstractCall isDelegate() {
        return null;
    }
}

