/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LeafType;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.StringBasedHeuristics;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.StringDistance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class LeafMapping
extends AbstractCodeMapping
implements Comparable<LeafMapping> {
    private List<Double> levelParentEditDistance;
    private boolean identicalPreviousStatement;
    private boolean identicalPreviousAndNextStatement;
    private boolean equalNumberOfAssertions;

    public LeafMapping(AbstractCodeFragment statement1, AbstractCodeFragment statement2, VariableDeclarationContainer operation1, VariableDeclarationContainer operation2) {
        super(statement1, statement2, operation1, operation2);
    }

    public boolean hasIdenticalPreviousAndNextStatement() {
        if (this.onlyStatementWithinIdenticalComposite()) {
            return true;
        }
        return this.identicalPreviousAndNextStatement;
    }

    public void setEqualNumberOfAssertions(boolean equalNumberOfAssertions) {
        this.equalNumberOfAssertions = equalNumberOfAssertions;
    }

    private boolean identicalAfterConcatenation() {
        String s2;
        String s1 = this.getFragment1().getString();
        if (s1.endsWith(";\n")) {
            s1 = s1.substring(0, s1.length() - 2);
        }
        if ((s2 = this.getFragment2().getString()).endsWith(";\n")) {
            s2 = s2.substring(0, s2.length() - 2);
        }
        return s1.contains(s2) || s2.contains(s1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(LeafMapping o) {
        int parentIndexDiff2;
        int parentIndexDiff1;
        int indexDiff2;
        int depthDiff2;
        int depthDiff1;
        boolean zeroDistanceWithMoreThanTwoParents2;
        void var17_31;
        double distance2;
        boolean concatenationReplacement2;
        CompositeReplacement compositeReplacement1 = this.containsCompositeReplacement();
        CompositeReplacement compositeReplacement2 = o.containsCompositeReplacement();
        boolean concatenationReplacement1 = this.containsReplacement(Replacement.ReplacementType.CONCATENATION) && !this.identicalAfterConcatenation();
        boolean bl = concatenationReplacement2 = o.containsReplacement(Replacement.ReplacementType.CONCATENATION) && !o.identicalAfterConcatenation();
        if (compositeReplacement1 != null || compositeReplacement2 != null) {
            if (compositeReplacement1 != null && compositeReplacement2 == null) {
                return -1;
            }
            if (compositeReplacement1 == null && compositeReplacement2 != null) {
                return 1;
            }
            return -Integer.compare(compositeReplacement1.getTotalAdditionallyMatchedStatements(), compositeReplacement2.getTotalAdditionallyMatchedStatements());
        }
        if (concatenationReplacement1 != concatenationReplacement2) {
            if (concatenationReplacement1 && !concatenationReplacement2) {
                return 1;
            }
            return -1;
        }
        double distance1 = this.editDistance();
        if (distance1 != (distance2 = o.editDistance())) {
            int indexDiff22;
            int indexDiff1;
            void var20_48;
            if (this.isIdenticalWithExtractedVariable() && !o.isIdenticalWithExtractedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithExtractedVariable() && o.isIdenticalWithExtractedVariable()) {
                return 1;
            }
            if (this.isIdenticalWithInlinedVariable() && !o.isIdenticalWithInlinedVariable()) {
                return -1;
            }
            if (!this.isIdenticalWithInlinedVariable() && o.isIdenticalWithInlinedVariable()) {
                return 1;
            }
            this.computeIdenticalPreviousAndNextStatements(o);
            if (this.identicalPreviousAndNextStatement && !o.identicalPreviousAndNextStatement) {
                return -1;
            }
            if (!this.identicalPreviousAndNextStatement && o.identicalPreviousAndNextStatement) {
                return 1;
            }
            if (this.identicalPreviousStatement && !o.identicalPreviousStatement) {
                return -1;
            }
            if (!this.identicalPreviousStatement && o.identicalPreviousStatement) {
                return 1;
            }
            if (this.identicalDepthIndexAndParentType() && !o.identicalDepthIndexAndParentType()) {
                return -1;
            }
            if (!this.identicalDepthIndexAndParentType() && o.identicalDepthIndexAndParentType()) {
                return 1;
            }
            if (this.referencesMapping(o)) {
                return 1;
            }
            if (o.referencesMapping(this)) {
                return -1;
            }
            Set<Replacement.ReplacementType> thisReplacementTypes = this.getReplacementTypes();
            Set<Replacement.ReplacementType> otherReplacementTypes = o.getReplacementTypes();
            LinkedHashSet<Replacement.ReplacementType> intersection = new LinkedHashSet<Replacement.ReplacementType>(thisReplacementTypes);
            intersection.retainAll(otherReplacementTypes);
            if (intersection.size() > 0 && (intersection.equals(thisReplacementTypes) || intersection.equals(otherReplacementTypes))) {
                void var17_28;
                LinkedHashSet<Replacement.ReplacementType> thisReplacementTypesWithoutCommon = new LinkedHashSet<Replacement.ReplacementType>(thisReplacementTypes);
                thisReplacementTypesWithoutCommon.removeAll(intersection);
                LinkedHashSet<Replacement.ReplacementType> otherReplacementTypesWithoutCommon = new LinkedHashSet<Replacement.ReplacementType>(otherReplacementTypes);
                otherReplacementTypesWithoutCommon.removeAll(intersection);
                int sameReplacementCount = 0;
                block0: for (Replacement.ReplacementType replacementType : intersection) {
                    String before = null;
                    Object after = null;
                    for (Replacement r : this.getReplacements()) {
                        if (!r.getType().equals((Object)replacementType)) continue;
                        before = r.getBefore();
                        after = r.getAfter();
                        break;
                    }
                    for (Replacement r : o.getReplacements()) {
                        if (!r.getType().equals((Object)replacementType) || !before.equals(r.getBefore()) && !((String)after).equals(r.getAfter())) continue;
                        ++sameReplacementCount;
                        continue block0;
                    }
                }
                int identicalNodesCount = 0;
                for (Replacement.ReplacementType type : thisReplacementTypesWithoutCommon) {
                    if (type.equals((Object)Replacement.ReplacementType.STRING_LITERAL) && o.getFragment1().getStringLiterals().equals(o.getFragment2().getStringLiterals()) && o.getFragment1().getStringLiterals().size() > 0) {
                        ++identicalNodesCount;
                        continue;
                    }
                    if (!type.equals((Object)Replacement.ReplacementType.NUMBER_LITERAL) || !o.getFragment1().getNumberLiterals().equals(o.getFragment2().getNumberLiterals()) || o.getFragment1().getNumberLiterals().size() <= 0) continue;
                    ++identicalNodesCount;
                }
                for (Replacement.ReplacementType type : otherReplacementTypesWithoutCommon) {
                    if (type.equals((Object)Replacement.ReplacementType.STRING_LITERAL) && this.getFragment1().getStringLiterals().equals(this.getFragment2().getStringLiterals()) && this.getFragment1().getStringLiterals().size() > 0) {
                        ++identicalNodesCount;
                        continue;
                    }
                    if (!type.equals((Object)Replacement.ReplacementType.NUMBER_LITERAL) || !this.getFragment1().getNumberLiterals().equals(this.getFragment2().getNumberLiterals()) || this.getFragment1().getNumberLiterals().size() <= 0) continue;
                    ++identicalNodesCount;
                }
                boolean bl2 = false;
                if (thisReplacementTypesWithoutCommon.size() > 0) {
                    boolean bl3 = identicalNodesCount == thisReplacementTypesWithoutCommon.size();
                } else if (otherReplacementTypesWithoutCommon.size() > 0) {
                    boolean bl4;
                    boolean bl5 = bl4 = identicalNodesCount == otherReplacementTypesWithoutCommon.size();
                }
                if (sameReplacementCount == intersection.size() && var17_28 != false) {
                    if (intersection.equals(thisReplacementTypes) && !intersection.equals(otherReplacementTypes)) {
                        return -1;
                    }
                    if (intersection.equals(otherReplacementTypes) && !intersection.equals(thisReplacementTypes)) {
                        return 1;
                    }
                }
                if (thisReplacementTypes.equals(otherReplacementTypes) && thisReplacementTypes.size() == 1 && thisReplacementTypes.iterator().next().equals((Object)Replacement.ReplacementType.TYPE)) {
                    int thisCompositeTypeReplacements = 0;
                    for (Replacement replacement : this.getReplacements()) {
                        if (replacement.getBefore().contains(".") && replacement.getBefore().endsWith("." + replacement.getAfter())) {
                            ++thisCompositeTypeReplacements;
                            continue;
                        }
                        if (!replacement.getAfter().contains(".") || !replacement.getAfter().endsWith("." + replacement.getBefore())) continue;
                        ++thisCompositeTypeReplacements;
                    }
                    int otherCompositeTypeReplacements = 0;
                    for (Replacement r : o.getReplacements()) {
                        if (r.getBefore().contains(".") && r.getBefore().endsWith("." + r.getAfter())) {
                            ++otherCompositeTypeReplacements;
                            continue;
                        }
                        if (!r.getAfter().contains(".") || !r.getAfter().endsWith("." + r.getBefore())) continue;
                        ++otherCompositeTypeReplacements;
                    }
                    if (thisCompositeTypeReplacements == this.getReplacements().size() && otherCompositeTypeReplacements != o.getReplacements().size()) {
                        return -1;
                    }
                    if (thisCompositeTypeReplacements != this.getReplacements().size() && otherCompositeTypeReplacements == o.getReplacements().size()) {
                        return 1;
                    }
                }
            }
            if (intersection.size() == 1 && intersection.contains((Object)Replacement.ReplacementType.STRING_LITERAL) && this.stringLiteralRatio() > 0.5 && o.stringLiteralRatio() > 0.5) {
                return Double.compare(distance1, distance2);
            }
            List<Double> levelParentEditDistance1 = this.levelParentEditDistance();
            List<Double> levelParentEditDistance2 = o.levelParentEditDistance();
            double nLevelParentEditDistance1 = 0.0;
            double d = 0.0;
            int minSize = Math.min(levelParentEditDistance1.size(), levelParentEditDistance2.size());
            boolean bl6 = false;
            int headZeros2 = 0;
            for (int i = 0; i < minSize; ++i) {
                double d2;
                double d1 = levelParentEditDistance1.get(i);
                if (d1 == 0.0 && (nLevelParentEditDistance1 += d1) == 0.0) {
                    ++var20_48;
                }
                if ((d2 = levelParentEditDistance2.get(i).doubleValue()) != 0.0 || (d += d2) != 0.0) continue;
                ++headZeros2;
            }
            if (levelParentEditDistance1.size() > 2 && levelParentEditDistance2.size() > 2 && (levelParentEditDistance1.contains(0.0) && !levelParentEditDistance2.contains(0.0) || levelParentEditDistance2.contains(0.0) && !levelParentEditDistance1.contains(0.0)) && (levelParentEditDistance1.get(0) == nLevelParentEditDistance1 || levelParentEditDistance2.get(0) == d)) {
                if (nLevelParentEditDistance1 < d && !levelParentEditDistance2.get(0).equals(0.0)) {
                    return -1;
                }
                if (d < nLevelParentEditDistance1 && !levelParentEditDistance1.get(0).equals(0.0)) {
                    return 1;
                }
                if (var20_48 > headZeros2) {
                    return -1;
                }
                if (headZeros2 > var20_48) {
                    return 1;
                }
            }
            if (this.equalNumberOfAssertions && this.getFragment1().isAssertCall() && this.getFragment2().isAssertCall() && o.getFragment1().isAssertCall() && o.getFragment2().isAssertCall() && (indexDiff1 = Math.abs(this.getFragment1().getIndex() - this.getFragment2().getIndex())) != (indexDiff22 = Math.abs(o.getFragment1().getIndex() - o.getFragment2().getIndex()))) {
                return Integer.valueOf(indexDiff1).compareTo(indexDiff22);
            }
            if (this.getMatchingArgumentsWithOperationInvocation() != o.getMatchingArgumentsWithOperationInvocation()) {
                return -Integer.valueOf(this.getMatchingArgumentsWithOperationInvocation()).compareTo(o.getMatchingArgumentsWithOperationInvocation());
            }
            return Double.compare(distance1, distance2);
        }
        if (this.isIdenticalWithExtractedVariable() && !o.isIdenticalWithExtractedVariable()) {
            return -1;
        }
        if (!this.isIdenticalWithExtractedVariable() && o.isIdenticalWithExtractedVariable()) {
            return 1;
        }
        if (this.isIdenticalWithInlinedVariable() && !o.isIdenticalWithInlinedVariable()) {
            return -1;
        }
        if (!this.isIdenticalWithInlinedVariable() && o.isIdenticalWithInlinedVariable()) {
            return 1;
        }
        List<Double> levelParentEditDistance1 = this.levelParentEditDistance();
        List<Double> levelParentEditDistance2 = o.levelParentEditDistance();
        double nLevelParentEditDistance1 = 0.0;
        double nLevelParentEditDistance2 = 0.0;
        int minSize = Math.min(levelParentEditDistance1.size(), levelParentEditDistance2.size());
        boolean bl7 = false;
        int headZeros2 = 0;
        for (int i = 0; i < minSize; ++i) {
            double d2;
            double d = levelParentEditDistance1.get(i);
            if (d == 0.0 && (nLevelParentEditDistance1 += d) == 0.0) {
                ++var17_31;
            }
            if ((d2 = levelParentEditDistance2.get(i).doubleValue()) != 0.0 || (nLevelParentEditDistance2 += d2) != 0.0) continue;
            ++headZeros2;
        }
        boolean identicalCompositeChildren1 = this.identicalCompositeChildrenStructure();
        boolean bl8 = o.identicalCompositeChildrenStructure();
        boolean zeroDistanceWithMoreThanTwoParents1 = nLevelParentEditDistance1 == 0.0 && levelParentEditDistance1.size() > 2;
        boolean bl9 = zeroDistanceWithMoreThanTwoParents2 = nLevelParentEditDistance2 == 0.0 && levelParentEditDistance2.size() > 2;
        if (identicalCompositeChildren1 && !bl8 && !zeroDistanceWithMoreThanTwoParents2) {
            return -1;
        }
        if (!identicalCompositeChildren1 && bl8 && !zeroDistanceWithMoreThanTwoParents1) {
            return 1;
        }
        if (levelParentEditDistance1.size() == levelParentEditDistance2.size()) {
            double min;
            double difference;
            if (nLevelParentEditDistance1 == 0.0 && nLevelParentEditDistance2 > 0.0) {
                return -1;
            }
            if (nLevelParentEditDistance2 == 0.0 && nLevelParentEditDistance1 > 0.0) {
                return 1;
            }
            if (var17_31 > headZeros2) {
                return -1;
            }
            if (headZeros2 > var17_31) {
                return 1;
            }
            if (levelParentEditDistance1.size() == 2 && levelParentEditDistance1.get(1).equals(0.0) && levelParentEditDistance2.size() == 2 && levelParentEditDistance2.get(1).equals(0.0) && !levelParentEditDistance1.get(0).equals(levelParentEditDistance2.get(0)) && (difference = Math.abs(levelParentEditDistance1.get(0) - levelParentEditDistance2.get(0))) > (min = Math.min(levelParentEditDistance1.get(0), levelParentEditDistance2.get(0)))) {
                return Double.compare(levelParentEditDistance1.get(0), levelParentEditDistance2.get(0));
            }
        }
        if ((levelParentEditDistance1.size() != levelParentEditDistance2.size() || levelParentEditDistance1.contains(0.0) && !levelParentEditDistance2.contains(0.0) || levelParentEditDistance2.contains(0.0) && !levelParentEditDistance1.contains(0.0)) && !levelParentEditDistance1.get(0).equals(levelParentEditDistance2.get(0))) {
            if (nLevelParentEditDistance1 < nLevelParentEditDistance2 && !levelParentEditDistance2.get(0).equals(0.0)) {
                return -1;
            }
            if (nLevelParentEditDistance2 < nLevelParentEditDistance1 && !levelParentEditDistance1.get(0).equals(0.0)) {
                return 1;
            }
            if (var17_31 > headZeros2) {
                return -1;
            }
            if (headZeros2 > var17_31) {
                return 1;
            }
        }
        if ((depthDiff1 = Math.abs(this.getFragment1().getDepth() - this.getFragment2().getDepth())) != (depthDiff2 = Math.abs(o.getFragment1().getDepth() - o.getFragment2().getDepth()))) {
            return Integer.valueOf(depthDiff1).compareTo(depthDiff2);
        }
        int indexDiff1 = Math.abs(this.getFragment1().getIndex() - this.getFragment2().getIndex());
        if (indexDiff1 != (indexDiff2 = Math.abs(o.getFragment1().getIndex() - o.getFragment2().getIndex()))) {
            this.computeIdenticalPreviousAndNextStatements(o);
            if (this.identicalPreviousAndNextStatement && !o.identicalPreviousAndNextStatement) {
                return -1;
            }
            if (!this.identicalPreviousAndNextStatement && o.identicalPreviousAndNextStatement) {
                return 1;
            }
            return Integer.valueOf(indexDiff1).compareTo(indexDiff2);
        }
        double parentEditDistance1 = levelParentEditDistance1.get(0);
        double parentEditDistance2 = levelParentEditDistance2.get(0);
        boolean sameVariableDeclarationTypeInParent1 = this.sameVariableDeclarationTypeInParent();
        boolean sameVariableDeclarationTypeInParent2 = o.sameVariableDeclarationTypeInParent();
        if (parentEditDistance1 >= 0.0 && parentEditDistance2 >= 0.0 && sameVariableDeclarationTypeInParent1 != sameVariableDeclarationTypeInParent2) {
            if (sameVariableDeclarationTypeInParent1 && !sameVariableDeclarationTypeInParent2) {
                return -1;
            }
            if (!sameVariableDeclarationTypeInParent1 && sameVariableDeclarationTypeInParent2) {
                return 1;
            }
        }
        Set<String> set1 = this.parentVariableTokenIntersection();
        Set<String> set2 = o.parentVariableTokenIntersection();
        if (parentEditDistance1 >= 0.0 && parentEditDistance2 >= 0.0 && set1.size() != set2.size()) {
            if (set1.size() > set2.size()) {
                return -1;
            }
            if (set1.size() < set2.size()) {
                return 1;
            }
        }
        boolean directParentsReferenceSameVariables1 = this.directParentsReferenceSameVariables();
        boolean directParentsReferenceSameVariables2 = o.directParentsReferenceSameVariables();
        if (parentEditDistance1 >= 0.0 && parentEditDistance2 >= 0.0 && directParentsReferenceSameVariables1 != directParentsReferenceSameVariables2) {
            if (directParentsReferenceSameVariables1 && !directParentsReferenceSameVariables2) {
                return -1;
            }
            if (!directParentsReferenceSameVariables1 && directParentsReferenceSameVariables2) {
                return 1;
            }
        }
        int commonConditionalsInParent1 = this.commonConditionalsInParent();
        int commonConditionalsInParent2 = o.commonConditionalsInParent();
        if (parentEditDistance1 >= 0.0 && parentEditDistance2 >= 0.0 && commonConditionalsInParent1 != commonConditionalsInParent2) {
            if (commonConditionalsInParent1 > commonConditionalsInParent2) {
                return -1;
            }
            if (commonConditionalsInParent1 < commonConditionalsInParent2) {
                return 1;
            }
        }
        if (this.equalContainer() && o.equalContainer() && levelParentEditDistance1.size() == 2 && levelParentEditDistance1.get(1).equals(0.0) && levelParentEditDistance2.size() == 2 && levelParentEditDistance2.get(1).equals(0.0) && !levelParentEditDistance1.get(0).equals(levelParentEditDistance2.get(0)) && (parentIndexDiff1 = this.parentIndexDiff()) != (parentIndexDiff2 = o.parentIndexDiff())) {
            return Integer.valueOf(parentIndexDiff1).compareTo(parentIndexDiff2);
        }
        if (parentEditDistance1 == parentEditDistance2) {
            this.computeIdenticalPreviousAndNextStatements(o);
            if (this.identicalPreviousAndNextStatement && !o.identicalPreviousAndNextStatement) {
                return -1;
            }
            if (!this.identicalPreviousAndNextStatement && o.identicalPreviousAndNextStatement) {
                return 1;
            }
            boolean underElse1 = this.underElse();
            boolean underElse2 = o.underElse();
            if (underElse1 && !underElse2) {
                return -1;
            }
            if (!underElse1 && underElse2) {
                return 1;
            }
            int locationSum1 = this.getFragment1().getLocationInfo().getStartLine() + this.getFragment2().getLocationInfo().getStartLine();
            int locationSum2 = o.getFragment1().getLocationInfo().getStartLine() + o.getFragment2().getLocationInfo().getStartLine();
            return Integer.valueOf(locationSum1).compareTo(locationSum2);
        }
        return Double.compare(parentEditDistance1, parentEditDistance2);
    }

    private boolean underElse() {
        return this.isUnderElseBranch(this.getFragment1()) && this.isUnderElseBranch(this.getFragment2());
    }

    private boolean isUnderElseBranch(AbstractCodeFragment fragment) {
        if (fragment.getParent() != null) {
            CompositeStatementObject child = fragment.getParent();
            if (child.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK) && child.getParent() != null) {
                CompositeStatementObject parent = child.getParent();
                return parent != null && parent.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) && child.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK) && parent.getStatements().size() == 2 && parent.getStatements().indexOf(child) == 1;
            }
            if (child.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
                return child.getStatements().size() == 2 && child.getStatements().indexOf(fragment) == 1;
            }
        }
        return false;
    }

    private boolean onlyStatementWithinIdenticalComposite() {
        CompositeStatementObject thisComp1 = this.getFragment1().getParent();
        CompositeStatementObject thisComp2 = this.getFragment2().getParent();
        if (thisComp1 != null && this.getFragment1().getIndex() == 0 && this.getFragment1().getIndex() == thisComp1.getStatements().size() - 1 && thisComp2 != null && this.getFragment2().getIndex() == 0 && this.getFragment2().getIndex() == thisComp2.getStatements().size() - 1 && thisComp1.getString().equals(thisComp2.getString())) {
            if (thisComp1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK) && thisComp2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK)) {
                if (thisComp1.getParent() != null && thisComp2.getParent() != null && thisComp1.getParent().getString().equals(thisComp2.getParent().getString())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void computeIdenticalPreviousAndNextStatements(LeafMapping o) {
        CompositeStatementObject thisComp1 = this.getFragment1().getParent();
        CompositeStatementObject thisComp2 = this.getFragment2().getParent();
        CompositeStatementObject oComp1 = o.getFragment1().getParent();
        CompositeStatementObject oComp2 = o.getFragment2().getParent();
        if (thisComp1 != null && this.getFragment1().getIndex() > 0 && this.getFragment1().getIndex() < thisComp1.getStatements().size() - 1 && thisComp2 != null && this.getFragment2().getIndex() > 0 && this.getFragment2().getIndex() < thisComp2.getStatements().size() - 1 && oComp1 != null && o.getFragment1().getIndex() > 0 && o.getFragment1().getIndex() < oComp1.getStatements().size() - 1 && oComp2 != null && o.getFragment2().getIndex() > 0 && o.getFragment2().getIndex() < oComp2.getStatements().size() - 1) {
            AbstractCodeFragment thisPrevious1 = thisComp1.getStatements().get(this.getFragment1().getIndex() - 1);
            AbstractCodeFragment thisNext1 = thisComp1.getStatements().get(this.getFragment1().getIndex() + 1);
            AbstractCodeFragment thisPrevious2 = thisComp2.getStatements().get(this.getFragment2().getIndex() - 1);
            AbstractCodeFragment thisNext2 = thisComp2.getStatements().get(this.getFragment2().getIndex() + 1);
            AbstractCodeFragment oPrevious1 = oComp1.getStatements().get(o.getFragment1().getIndex() - 1);
            AbstractCodeFragment oNext1 = oComp1.getStatements().get(o.getFragment1().getIndex() + 1);
            AbstractCodeFragment oPrevious2 = oComp2.getStatements().get(o.getFragment2().getIndex() - 1);
            AbstractCodeFragment oNext2 = oComp2.getStatements().get(o.getFragment2().getIndex() + 1);
            boolean thisEqualPrevious = thisPrevious1.getString().equals(thisPrevious2.getString());
            boolean thisEqualNext = thisNext1.getString().equals(thisNext2.getString());
            boolean thisEqualPreviousAndNext = thisEqualPrevious && thisEqualNext;
            boolean oEqualPrevious = oPrevious1.getString().equals(oPrevious2.getString());
            boolean oEqualNext = oNext1.getString().equals(oNext2.getString());
            boolean oEqualPreviousAndNext = oEqualPrevious && oEqualNext;
            boolean thisVariableDeclarationsWithSameName = false;
            if (this.getFragment1().getVariableDeclarations().size() > 0 && this.getFragment2().getVariableDeclarations().size() > 0 && this.getFragment1().getVariableDeclarations().get(0).getVariableName().equals(this.getFragment2().getVariableDeclarations().get(0).getVariableName())) {
                thisVariableDeclarationsWithSameName = true;
            }
            boolean oVariableDeclarationsWithSameName = false;
            if (o.getFragment1().getVariableDeclarations().size() > 0 && o.getFragment2().getVariableDeclarations().size() > 0 && o.getFragment1().getVariableDeclarations().get(0).getVariableName().equals(o.getFragment2().getVariableDeclarations().get(0).getVariableName())) {
                oVariableDeclarationsWithSameName = true;
            }
            if (thisEqualPreviousAndNext) {
                this.identicalPreviousAndNextStatement = true;
            } else if (thisEqualPrevious && thisNext2 != null && thisNext2.equals(o.getFragment2()) && !oEqualNext && !oVariableDeclarationsWithSameName) {
                this.identicalPreviousStatement = true;
            }
            if (oEqualPreviousAndNext) {
                o.identicalPreviousAndNextStatement = true;
            } else if (oEqualPrevious && oNext2 != null && oNext2.equals(this.getFragment2()) && !thisEqualNext && !thisVariableDeclarationsWithSameName) {
                o.identicalPreviousStatement = true;
            }
        } else if (thisComp1 != null && this.getFragment1().getIndex() > 0 && this.getFragment1().getIndex() == thisComp1.getStatements().size() - 1 && thisComp2 != null && this.getFragment2().getIndex() > 0 && this.getFragment2().getIndex() == thisComp2.getStatements().size() - 1 && oComp1 != null && o.getFragment1().getIndex() > 0 && o.getFragment1().getIndex() == oComp1.getStatements().size() - 1 && oComp2 != null && o.getFragment2().getIndex() > 0 && o.getFragment2().getIndex() == oComp2.getStatements().size() - 1) {
            boolean oEqualPrevious;
            AbstractCodeFragment thisPrevious1 = thisComp1.getStatements().get(this.getFragment1().getIndex() - 1);
            AbstractCodeFragment thisPrevious2 = thisComp2.getStatements().get(this.getFragment2().getIndex() - 1);
            AbstractCodeFragment oPrevious1 = oComp1.getStatements().get(o.getFragment1().getIndex() - 1);
            AbstractCodeFragment oPrevious2 = oComp2.getStatements().get(o.getFragment2().getIndex() - 1);
            boolean thisEqualPrevious = thisPrevious1.getString().equals(thisPrevious2.getString());
            if (thisEqualPrevious) {
                this.identicalPreviousAndNextStatement = true;
            }
            if (oEqualPrevious = oPrevious1.getString().equals(oPrevious2.getString())) {
                o.identicalPreviousAndNextStatement = true;
            }
        }
    }

    private double stringLiteralRatio() {
        int length1 = this.getFragment1().getString().length();
        int stringLiteralLength1 = 0;
        for (LeafExpression s1 : this.getFragment1().getStringLiterals()) {
            stringLiteralLength1 += s1.getString().length();
        }
        double ratio1 = (double)stringLiteralLength1 / (double)length1;
        int length2 = this.getFragment2().getString().length();
        int stringLiteralLength2 = 0;
        for (LeafExpression s2 : this.getFragment2().getStringLiterals()) {
            stringLiteralLength2 += s2.getString().length();
        }
        double ratio2 = (double)stringLiteralLength2 / (double)length2;
        return (ratio1 + ratio2) / 2.0;
    }

    @Override
    public double editDistance() {
        double distance1;
        if (this.getFragment1().getString().equals(this.getFragment2().getString())) {
            distance1 = 0.0;
        } else {
            String s1 = LeafMapping.removeGenericTypeAfterDot(this.getFragment1().getString().toLowerCase());
            String s2 = LeafMapping.removeGenericTypeAfterDot(this.getFragment2().getString().toLowerCase());
            int distance = StringDistance.editDistance(s1, s2);
            distance1 = (double)distance / (double)Math.max(s1.length(), s2.length());
        }
        return distance1;
    }

    private boolean referencesMapping(LeafMapping o) {
        if (this.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && this.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && o.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && o.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && this.getFragment1().equals(o.getFragment1()) && o.getFragment2().getLocationInfo().getEndOffset() < this.getFragment2().getLocationInfo().getStartOffset()) {
            List<VariableDeclaration> variableDeclarations2 = o.getFragment2().getVariableDeclarations();
            List<AbstractCall> creations2 = this.getFragment2().getCreations();
            for (VariableDeclaration declaration2 : variableDeclarations2) {
                for (AbstractCall creation : creations2) {
                    if (((ObjectCreation)creation).getAnonymousClassDeclaration() != null) {
                        return false;
                    }
                    List<String> arguments = creation.arguments();
                    if (arguments.size() != 1 || !arguments.contains(declaration2.getVariableName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String removeGenericTypeAfterDot(String s) {
        int indexOfGenericTypeEnd;
        int indexOfGenericTypeStart;
        if (((String)s).contains(".<") && (indexOfGenericTypeStart = ((String)s).indexOf(".<")) < (indexOfGenericTypeEnd = ((String)s).indexOf(">", indexOfGenericTypeStart))) {
            s = ((String)s).substring(0, indexOfGenericTypeStart) + "." + ((String)s).substring(indexOfGenericTypeEnd + 1, ((String)s).length());
        }
        return s;
    }

    private boolean identicalDepthIndexAndParentType() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        if (this.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT) && this.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT)) {
            return false;
        }
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 != null && parent2 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)parent2.getLocationInfo().getCodeElementType()) && !parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.CATCH_CLAUSE)) {
            if (parent1.getString().equals(parent2.getString()) && !parent1.getString().equals("try")) {
                return true;
            }
            return this.getFragment1().getDepth() == this.getFragment2().getDepth() && this.getFragment1().getIndex() == this.getFragment2().getIndex();
        }
        return false;
    }

    private int parentIndexDiff() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        return Math.abs(parent1.getIndex() - parent2.getIndex());
    }

    private int commonConditionalsInParent() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 != null && parent2 != null && parent1.getExpressions().size() == 1 && parent2.getExpressions().size() == 1) {
            AbstractExpression expr1 = parent1.getExpressions().get(0);
            AbstractExpression expr2 = parent2.getExpressions().get(0);
            String[] subConditions1 = StringBasedHeuristics.SPLIT_CONDITIONAL_PATTERN.split(expr1.getString());
            ArrayList<String> subConditionsAsList1 = new ArrayList<String>();
            for (String s : subConditions1) {
                subConditionsAsList1.add(s.trim());
            }
            String[] subConditions2 = StringBasedHeuristics.SPLIT_CONDITIONAL_PATTERN.split(expr2.getString());
            ArrayList<String> subConditionsAsList2 = new ArrayList<String>();
            for (String s : subConditions2) {
                subConditionsAsList2.add(s.trim());
            }
            Set<String> intersection = StringBasedHeuristics.subConditionIntersection(subConditionsAsList1, subConditionsAsList2);
            int increment = 0;
            block4: for (String s1 : subConditions1) {
                if (intersection.contains(s1) || !s1.contains(".")) continue;
                String suffix1 = s1.substring(s1.indexOf("."));
                for (String s2 : subConditions2) {
                    String suffix2;
                    if (!s2.contains(".") || !suffix1.equals(suffix2 = s2.substring(s2.indexOf(".")))) continue;
                    ++increment;
                    continue block4;
                }
            }
            return intersection.size() + increment;
        }
        return 0;
    }

    private boolean sameVariableDeclarationTypeInParent() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 != null && parent2 != null) {
            List<VariableDeclaration> declarations1 = parent1.getVariableDeclarations();
            List<VariableDeclaration> declarations2 = parent2.getVariableDeclarations();
            if (declarations1.size() == declarations2.size()) {
                for (int i = 0; i < declarations1.size(); ++i) {
                    VariableDeclaration declaration2;
                    VariableDeclaration declaration1 = declarations1.get(i);
                    if (declaration1.equalType(declaration2 = declarations2.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean directParentsReferenceSameVariables() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 == null && parent2 == null) {
            return false;
        }
        if (parent1 == null && parent2 != null) {
            return false;
        }
        if (parent1 != null && parent2 == null) {
            return false;
        }
        List<LeafExpression> variables1 = parent1.getVariables();
        List<LeafExpression> variables2 = parent2.getVariables();
        LinkedHashSet<String> lowerCaseVariables1 = new LinkedHashSet<String>();
        for (LeafExpression variable1 : variables1) {
            if (!Character.isLowerCase(variable1.getString().charAt(0))) continue;
            lowerCaseVariables1.add(variable1.getString());
        }
        LinkedHashSet<String> lowerCaseVariables2 = new LinkedHashSet<String>();
        for (LeafExpression variable2 : variables2) {
            if (!Character.isLowerCase(variable2.getString().charAt(0))) continue;
            lowerCaseVariables2.add(variable2.getString());
        }
        return lowerCaseVariables1.size() > 0 && lowerCaseVariables1.equals(lowerCaseVariables2);
    }

    private Set<String> parentVariableTokenIntersection() {
        CompositeStatementObject parent2;
        CompositeStatementObject parent1;
        for (parent1 = this.getFragment1().getParent(); parent1 != null && parent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent1 = parent1.getParent()) {
        }
        for (parent2 = this.getFragment2().getParent(); parent2 != null && parent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); parent2 = parent2.getParent()) {
        }
        if (parent1 == null && parent2 == null) {
            return Collections.emptySet();
        }
        if (parent1 == null && parent2 != null) {
            return Collections.emptySet();
        }
        if (parent1 != null && parent2 == null) {
            return Collections.emptySet();
        }
        List<LeafExpression> variables1 = parent1.getVariables();
        List<LeafExpression> variables2 = parent2.getVariables();
        if (variables1.size() == 1 && variables2.size() == 1) {
            LinkedHashSet<String> tokens1 = new LinkedHashSet<String>();
            for (LeafExpression variable : variables1) {
                String[] array;
                for (String s : array = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(variable.getString())) {
                    tokens1.add(s.toLowerCase());
                }
            }
            LinkedHashSet<String> tokens2 = new LinkedHashSet<String>();
            for (LeafExpression variable : variables2) {
                String[] array;
                for (String s : array = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(variable.getString())) {
                    tokens2.add(s.toLowerCase());
                }
            }
            tokens1.retainAll(tokens2);
            return tokens1;
        }
        return Collections.emptySet();
    }

    public double levelParentEditDistanceSum() {
        return this.levelParentEditDistance().stream().collect(Collectors.summingDouble(Double::doubleValue));
    }

    private List<Double> levelParentEditDistance() {
        CompositeStatementObject firstLevelParent2;
        CompositeStatementObject firstLevelParent1;
        if (this.levelParentEditDistance != null) {
            return this.levelParentEditDistance;
        }
        ArrayList<Double> levelParentEditDistance = new ArrayList<Double>();
        for (firstLevelParent1 = this.getFragment1().getParent(); firstLevelParent1 != null && firstLevelParent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); firstLevelParent1 = firstLevelParent1.getParent()) {
        }
        for (firstLevelParent2 = this.getFragment2().getParent(); firstLevelParent2 != null && firstLevelParent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); firstLevelParent2 = firstLevelParent2.getParent()) {
        }
        double firstLevel = this.parentEditDistance(firstLevelParent1, firstLevelParent2);
        levelParentEditDistance.add(firstLevel);
        CompositeStatementObject currentLevel1 = firstLevelParent1;
        CompositeStatementObject currentLevel2 = firstLevelParent2;
        while (currentLevel1 != null && currentLevel2 != null) {
            CompositeStatementObject secondLevelParent2;
            CompositeStatementObject secondLevelParent1;
            for (secondLevelParent1 = currentLevel1.getParent(); secondLevelParent1 != null && secondLevelParent1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); secondLevelParent1 = secondLevelParent1.getParent()) {
            }
            for (secondLevelParent2 = currentLevel2.getParent(); secondLevelParent2 != null && secondLevelParent2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.BLOCK); secondLevelParent2 = secondLevelParent2.getParent()) {
            }
            double secondLevel = this.parentEditDistance(secondLevelParent1, secondLevelParent2);
            levelParentEditDistance.add(secondLevel);
            currentLevel1 = secondLevelParent1;
            currentLevel2 = secondLevelParent2;
        }
        this.levelParentEditDistance = levelParentEditDistance;
        return levelParentEditDistance;
    }

    private double parentEditDistance(CompositeStatementObject parent1, CompositeStatementObject parent2) {
        if (parent1 == null && parent2 == null) {
            return 0.0;
        }
        if (parent1 == null && parent2 != null) {
            String s2 = parent2.getString();
            int distance = StringDistance.editDistance("{", s2);
            double normalized = (double)distance / (double)Math.max(1, s2.length());
            return normalized;
        }
        if (parent1 != null && parent2 == null) {
            String s1 = parent1.getString();
            int distance = StringDistance.editDistance(s1, "{");
            double normalized = (double)distance / (double)Math.max(s1.length(), 1);
            return normalized;
        }
        String s1 = parent1.getString();
        String s2 = parent2.getString();
        if (!s1.equals(parent1.getArgumentizedString()) && s2.equals(parent1.getArgumentizedString())) {
            return 0.0;
        }
        if (!s2.equals(parent2.getArgumentizedString()) && s1.equals(parent2.getArgumentizedString())) {
            return 0.0;
        }
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    private boolean identicalCompositeChildrenStructure() {
        CompositeStatementObject parent1 = this.getFragment1().getParent();
        CompositeStatementObject parent2 = this.getFragment2().getParent();
        if (parent1 != null && parent2 != null) {
            List<AbstractStatement> statements1 = parent1.getStatements();
            List<AbstractStatement> statements2 = parent2.getStatements();
            ArrayList<CompositeStatementObject> composites1 = new ArrayList<CompositeStatementObject>();
            for (AbstractStatement abstractStatement : statements1) {
                if (!(abstractStatement instanceof CompositeStatementObject)) continue;
                composites1.add((CompositeStatementObject)abstractStatement);
            }
            ArrayList<CompositeStatementObject> composites2 = new ArrayList<CompositeStatementObject>();
            for (AbstractStatement statement2 : statements2) {
                if (!(statement2 instanceof CompositeStatementObject)) continue;
                composites2.add((CompositeStatementObject)statement2);
            }
            if (composites1.size() == composites2.size() && composites1.size() == 1) {
                CompositeStatementObject compositeStatementObject = (CompositeStatementObject)composites1.get(0);
                CompositeStatementObject comp2 = (CompositeStatementObject)composites2.get(0);
                List<CompositeStatementObject> innerNodes1 = compositeStatementObject.getInnerNodes();
                List<CompositeStatementObject> innerNodes2 = comp2.getInnerNodes();
                int count = 0;
                if (innerNodes1.size() == innerNodes2.size()) {
                    for (int i = 0; i < innerNodes1.size() && innerNodes1.get(i).getString().equals(innerNodes2.get(i).getString()); ++i) {
                        ++count;
                    }
                }
                if (count == innerNodes1.size() && count > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public Set<String> callChainIntersection() {
        AbstractCall invocation1 = this.getFragment1().invocationCoveringEntireFragment();
        AbstractCall invocation2 = this.getFragment2().invocationCoveringEntireFragment();
        return invocation1.callChainIntersection(invocation2);
    }
}

