/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.diff.StringDistance;
import java.util.ArrayList;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.TypeMethodReference;

public class MethodReference
extends AbstractCall {
    private String methodName;
    private volatile int hashCode = 0;

    public MethodReference(CompilationUnit cu, String filePath, ExpressionMethodReference reference, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)reference, LocationInfo.CodeElementType.METHOD_REFERENCE, container);
        this.methodName = reference.getName().getIdentifier();
        this.expression = Visitor.stringify((ASTNode)reference.getExpression());
        this.arguments = new ArrayList();
    }

    public MethodReference(CompilationUnit cu, String filePath, SuperMethodReference reference, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)reference, LocationInfo.CodeElementType.METHOD_REFERENCE, container);
        this.methodName = reference.getName().getIdentifier();
        this.arguments = new ArrayList();
        this.expression = reference.getQualifier() != null ? reference.getQualifier().getFullyQualifiedName() + ".super" : "super";
    }

    public MethodReference(CompilationUnit cu, String filePath, TypeMethodReference reference, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)reference, LocationInfo.CodeElementType.METHOD_REFERENCE, container);
        this.methodName = reference.getName().getIdentifier();
        this.expression = UMLType.extractTypeObject(cu, filePath, reference.getType(), 0).toQualifiedString();
        this.arguments = new ArrayList();
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public boolean identicalName(AbstractCall call) {
        return this.getMethodName().equals(call.getName());
    }

    @Override
    public String getName() {
        return this.getMethodName();
    }

    @Override
    public double normalizedNameDistance(AbstractCall call) {
        String s1 = this.getMethodName().toLowerCase();
        String s2 = call.getName().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    private MethodReference() {
    }

    @Override
    public AbstractCall update(String oldExpression, String newExpression) {
        MethodReference newReference = new MethodReference();
        newReference.methodName = this.methodName;
        newReference.locationInfo = this.locationInfo;
        this.update(newReference, oldExpression, newExpression);
        return newReference;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MethodReference) {
            MethodReference invocation = (MethodReference)o;
            return this.methodName.equals(invocation.methodName) && this.numberOfArguments == invocation.numberOfArguments && this.expression != null == (invocation.expression != null);
        }
        if (o instanceof OperationInvocation) {
            OperationInvocation invocation = (OperationInvocation)o;
            return this.methodName.equals(invocation.getMethodName()) && this.numberOfArguments == invocation.numberOfArguments && this.expression != null == (invocation.expression != null);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.methodName);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.expression != null ? 1 : 0;
            result = 37 * result + this.methodName.hashCode();
            this.hashCode = result = 37 * result + this.numberOfArguments;
        }
        return this.hashCode;
    }

    @Override
    public String actualString() {
        StringBuilder sb = new StringBuilder();
        if (this.expression != null) {
            sb.append(this.expression).append("::");
        }
        sb.append(this.getName());
        return sb.toString();
    }
}

