/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.StringBasedHeuristics;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.diff.StringDistance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Type;

public class ObjectCreation
extends AbstractCall {
    private UMLType type;
    private String anonymousClassDeclaration;
    private boolean isArray = false;
    private volatile int hashCode = 0;

    public ObjectCreation(CompilationUnit cu, String filePath, ClassInstanceCreation creation, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)creation, LocationInfo.CodeElementType.CLASS_INSTANCE_CREATION, container);
        this.type = UMLType.extractTypeObject(cu, filePath, creation.getType(), 0);
        this.numberOfArguments = creation.arguments().size();
        this.arguments = new ArrayList();
        List args = creation.arguments();
        for (Expression argument : args) {
            this.arguments.add(Visitor.stringify((ASTNode)argument));
        }
        if (creation.getExpression() != null) {
            this.expression = Visitor.stringify((ASTNode)creation.getExpression());
        }
        if (creation.getAnonymousClassDeclaration() != null) {
            this.anonymousClassDeclaration = Visitor.stringify((ASTNode)creation.getAnonymousClassDeclaration());
        }
    }

    public ObjectCreation(CompilationUnit cu, String filePath, ArrayCreation creation, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)creation, LocationInfo.CodeElementType.ARRAY_CREATION, container);
        this.isArray = true;
        this.type = UMLType.extractTypeObject(cu, filePath, (Type)creation.getType(), 0);
        this.numberOfArguments = creation.dimensions().size();
        this.arguments = new ArrayList();
        List args = creation.dimensions();
        for (Expression argument : args) {
            this.arguments.add(Visitor.stringify((ASTNode)argument));
        }
        if (creation.getInitializer() != null) {
            this.anonymousClassDeclaration = Visitor.stringify((ASTNode)creation.getInitializer());
        }
    }

    @Override
    public String getName() {
        return this.getType().toString();
    }

    public UMLType getType() {
        return this.type;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getAnonymousClassDeclaration() {
        return this.anonymousClassDeclaration;
    }

    private ObjectCreation() {
    }

    @Override
    public ObjectCreation update(String oldExpression, String newExpression) {
        ObjectCreation newObjectCreation = new ObjectCreation();
        newObjectCreation.type = this.type;
        newObjectCreation.locationInfo = this.locationInfo;
        this.update(newObjectCreation, oldExpression, newExpression);
        return newObjectCreation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectCreation) {
            ObjectCreation creation = (ObjectCreation)o;
            return this.type.equals(creation.type) && this.isArray == creation.isArray && this.numberOfArguments == creation.numberOfArguments;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(this.type);
        sb.append("(");
        if (this.numberOfArguments > 0) {
            for (int i = 0; i < this.numberOfArguments - 1; ++i) {
                sb.append("arg" + i).append(", ");
            }
            sb.append("arg" + (this.numberOfArguments - 1));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.type.hashCode();
            result = 37 * result + (this.isArray ? 1 : 0);
            this.hashCode = result = 37 * result + this.numberOfArguments;
        }
        return this.hashCode;
    }

    public boolean identicalArrayInitializer(ObjectCreation other) {
        if (this.isArray && other.isArray) {
            if (this.anonymousClassDeclaration != null && other.anonymousClassDeclaration != null) {
                if (this.anonymousClassDeclaration.equals(other.anonymousClassDeclaration)) {
                    return true;
                }
                if (this.anonymousClassDeclaration.startsWith("{") && this.anonymousClassDeclaration.endsWith("}") && other.anonymousClassDeclaration.startsWith("{") && other.anonymousClassDeclaration.endsWith("}")) {
                    String s1 = this.anonymousClassDeclaration.substring(1, this.anonymousClassDeclaration.length() - 1);
                    String s2 = other.anonymousClassDeclaration.substring(1, other.anonymousClassDeclaration.length() - 1);
                    List<String> tokens1 = Arrays.asList(StringBasedHeuristics.SPLIT_COMMA_PATTERN.split(s1));
                    List<String> tokens2 = Arrays.asList(StringBasedHeuristics.SPLIT_COMMA_PATTERN.split(s2));
                    if (tokens1.size() > 0 && tokens2.size() > 0 && (tokens1.containsAll(tokens2) || tokens2.containsAll(tokens1))) {
                        return true;
                    }
                }
            } else if (this.anonymousClassDeclaration == null && other.anonymousClassDeclaration == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public double normalizedNameDistance(AbstractCall call) {
        String s1 = this.getType().toString().toLowerCase();
        String s2 = ((ObjectCreation)call).getType().toString().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    @Override
    public boolean identicalName(AbstractCall call) {
        if (call instanceof ObjectCreation) {
            return this.getType().equals(((ObjectCreation)call).getType());
        }
        return false;
    }

    @Override
    public String actualString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(super.actualString());
        return sb.toString();
    }
}

