/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LeafType;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLImport;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.MethodReference;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.StringBasedHeuristics;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.diff.StringDistance;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLClassBaseDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.refactoringminer.util.PrefixSuffixUtils;

public class OperationInvocation
extends AbstractCall {
    private String methodName;
    private List<String> subExpressions = new ArrayList<String>();
    private volatile int hashCode = 0;
    private static Map<String, String> PRIMITIVE_WRAPPER_CLASS_MAP;
    private static Map<String, List<String>> PRIMITIVE_TYPE_WIDENING_MAP;
    private static Map<String, List<String>> PRIMITIVE_TYPE_NARROWING_MAP;
    private static List<String> PRIMITIVE_TYPE_LIST;

    public OperationInvocation(CompilationUnit cu, String filePath, MethodInvocation invocation, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)invocation, LocationInfo.CodeElementType.METHOD_INVOCATION, container);
        this.methodName = invocation.getName().getIdentifier();
        this.numberOfArguments = invocation.arguments().size();
        this.arguments = new ArrayList();
        List args = invocation.arguments();
        for (Expression argument : args) {
            this.arguments.add(Visitor.stringify((ASTNode)argument));
        }
        if (invocation.getExpression() != null) {
            this.expression = Visitor.stringify((ASTNode)invocation.getExpression());
            this.processExpression(invocation.getExpression(), this.subExpressions);
        }
    }

    private void processExpression(Expression expression, List<String> subExpressions) {
        if (expression instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)expression;
            if (invocation.getExpression() != null) {
                String expressionAsString = Visitor.stringify((ASTNode)invocation.getExpression());
                String invocationAsString = Visitor.stringify((ASTNode)invocation);
                String suffix = invocationAsString.substring(expressionAsString.length() + 1, invocationAsString.length());
                subExpressions.add(0, suffix);
                this.processExpression(invocation.getExpression(), subExpressions);
            } else {
                subExpressions.add(0, Visitor.stringify((ASTNode)invocation));
            }
        } else if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation creation = (ClassInstanceCreation)expression;
            if (creation.getExpression() != null) {
                String expressionAsString = Visitor.stringify((ASTNode)creation.getExpression());
                String invocationAsString = Visitor.stringify((ASTNode)creation);
                String suffix = invocationAsString.substring(expressionAsString.length() + 1, invocationAsString.length());
                subExpressions.add(0, suffix);
                this.processExpression(creation.getExpression(), subExpressions);
            } else {
                subExpressions.add(0, Visitor.stringify((ASTNode)creation));
            }
        }
    }

    public OperationInvocation(CompilationUnit cu, String filePath, SuperMethodInvocation invocation, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)invocation, LocationInfo.CodeElementType.SUPER_METHOD_INVOCATION, container);
        this.methodName = invocation.getName().getIdentifier();
        this.numberOfArguments = invocation.arguments().size();
        this.arguments = new ArrayList();
        this.expression = "super";
        this.subExpressions.add("super");
        List args = invocation.arguments();
        for (Expression argument : args) {
            this.arguments.add(Visitor.stringify((ASTNode)argument));
        }
    }

    public OperationInvocation(CompilationUnit cu, String filePath, SuperConstructorInvocation invocation, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)invocation, LocationInfo.CodeElementType.SUPER_CONSTRUCTOR_INVOCATION, container);
        this.methodName = "super";
        this.numberOfArguments = invocation.arguments().size();
        this.arguments = new ArrayList();
        List args = invocation.arguments();
        for (Expression argument : args) {
            this.arguments.add(Visitor.stringify((ASTNode)argument));
        }
        if (invocation.getExpression() != null) {
            this.expression = Visitor.stringify((ASTNode)invocation.getExpression());
            this.processExpression(invocation.getExpression(), this.subExpressions);
        }
    }

    public OperationInvocation(CompilationUnit cu, String filePath, ConstructorInvocation invocation, VariableDeclarationContainer container) {
        super(cu, filePath, (ASTNode)invocation, LocationInfo.CodeElementType.CONSTRUCTOR_INVOCATION, container);
        this.methodName = "this";
        this.numberOfArguments = invocation.arguments().size();
        this.arguments = new ArrayList();
        List args = invocation.arguments();
        for (Expression argument : args) {
            this.arguments.add(Visitor.stringify((ASTNode)argument));
        }
    }

    private OperationInvocation() {
    }

    @Override
    public OperationInvocation update(String oldExpression, String newExpression) {
        OperationInvocation newOperationInvocation = new OperationInvocation();
        newOperationInvocation.methodName = this.methodName;
        newOperationInvocation.locationInfo = this.locationInfo;
        this.update(newOperationInvocation, oldExpression, newExpression);
        newOperationInvocation.subExpressions = new ArrayList<String>();
        for (String argument : this.subExpressions) {
            newOperationInvocation.subExpressions.add(ReplacementUtil.performReplacement(argument, oldExpression, newExpression));
        }
        return newOperationInvocation;
    }

    @Override
    public String getName() {
        return this.getMethodName();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getSubExpressions() {
        return this.subExpressions;
    }

    public int numberOfSubExpressions() {
        return this.subExpressions.size();
    }

    @Override
    public boolean matchesOperation(VariableDeclarationContainer operation, VariableDeclarationContainer callerOperation, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        boolean constructorCall = false;
        if (this.methodName.equals("this") && operation.getClassName().equals(callerOperation.getClassName()) && operation.getName().equals(callerOperation.getName())) {
            constructorCall = true;
        }
        if (!this.methodName.equals(operation.getName()) && !constructorCall) {
            return false;
        }
        Map<String, Set<VariableDeclaration>> variableDeclarationMap = callerOperation.variableDeclarationMap();
        Map<String, VariableDeclaration> parentFieldDeclarationMap = null;
        Map<String, VariableDeclaration> childFieldDeclarationMap = null;
        if (modelDiff != null) {
            Object childCallerClass;
            UMLAbstractClass parentCallerClass = modelDiff.findClassInParentModel(callerOperation.getClassName());
            if (parentCallerClass != null) {
                parentFieldDeclarationMap = parentCallerClass.getFieldDeclarationMap();
            }
            if ((childCallerClass = modelDiff.findClassInChildModel(callerOperation.getClassName())) != null) {
                childFieldDeclarationMap = ((UMLAbstractClass)childCallerClass).getFieldDeclarationMap();
            }
        }
        ArrayList<UMLType> inferredArgumentTypes = new ArrayList<UMLType>();
        block0: for (Object arg : this.arguments) {
            Object type;
            int indexOfOpeningParenthesis = ((String)arg).indexOf("(");
            int indexOfOpeningSquareBracket = ((String)arg).indexOf("[");
            boolean openingParenthesisBeforeSquareBracket = false;
            boolean openingSquareBracketBeforeParenthesis = false;
            if (indexOfOpeningParenthesis != -1 && indexOfOpeningSquareBracket != -1) {
                if (indexOfOpeningParenthesis < indexOfOpeningSquareBracket) {
                    openingParenthesisBeforeSquareBracket = true;
                } else if (indexOfOpeningSquareBracket < indexOfOpeningParenthesis) {
                    openingSquareBracketBeforeParenthesis = true;
                }
            } else if (indexOfOpeningParenthesis != -1 && indexOfOpeningSquareBracket == -1) {
                openingParenthesisBeforeSquareBracket = true;
            } else if (indexOfOpeningParenthesis == -1 && indexOfOpeningSquareBracket != -1) {
                openingSquareBracketBeforeParenthesis = true;
            }
            if (variableDeclarationMap.containsKey(arg)) {
                Set<VariableDeclaration> variableDeclarations = variableDeclarationMap.get(arg);
                for (VariableDeclaration variableDeclaration : variableDeclarations) {
                    if (!variableDeclaration.getScope().subsumes(this.getLocationInfo())) continue;
                    inferredArgumentTypes.add(variableDeclaration.getType() != null ? variableDeclaration.getType() : null);
                    continue block0;
                }
                continue;
            }
            if (parentFieldDeclarationMap != null && parentFieldDeclarationMap.containsKey(arg) || childFieldDeclarationMap != null && childFieldDeclarationMap.containsKey(arg)) {
                VariableDeclaration variableDeclaration;
                VariableDeclaration variableDeclaration2;
                boolean variableDeclarationFound = false;
                if (parentFieldDeclarationMap != null && parentFieldDeclarationMap.containsKey(arg) && (variableDeclaration2 = parentFieldDeclarationMap.get(arg)).getScope().subsumes(this.getLocationInfo())) {
                    inferredArgumentTypes.add(variableDeclaration2.getType() != null ? variableDeclaration2.getType() : null);
                    variableDeclarationFound = true;
                }
                if (variableDeclarationFound || childFieldDeclarationMap == null || !childFieldDeclarationMap.containsKey(arg) || !(variableDeclaration = childFieldDeclarationMap.get(arg)).getScope().subsumes(this.getLocationInfo())) continue;
                inferredArgumentTypes.add(variableDeclaration.getType() != null ? variableDeclaration.getType() : null);
                continue;
            }
            if (((String)arg).startsWith("\"") && ((String)arg).endsWith("\"")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("String"));
                continue;
            }
            if (StringDistance.isNumeric((String)arg)) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("int"));
                continue;
            }
            if (((String)arg).startsWith("'") && ((String)arg).endsWith("'")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("char"));
                continue;
            }
            if (((String)arg).endsWith(".class")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("Class"));
                continue;
            }
            if (((String)arg).equals("true")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("boolean"));
                continue;
            }
            if (((String)arg).equals("false")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("boolean"));
                continue;
            }
            if (((String)arg).startsWith("new ") && ((String)arg).contains("(") && openingParenthesisBeforeSquareBracket) {
                type = ((String)arg).substring(4, ((String)arg).indexOf("("));
                inferredArgumentTypes.add(UMLType.extractTypeObject((String)type));
                continue;
            }
            if (((String)arg).startsWith("new ") && ((String)arg).contains("[") && openingSquareBracketBeforeParenthesis) {
                type = ((String)arg).substring(4, ((String)arg).indexOf("["));
                for (int i = 0; i < ((String)arg).length(); ++i) {
                    if (((String)arg).charAt(i) == '[') {
                        type = (String)type + "[]";
                        continue;
                    }
                    if (((String)arg).charAt(i) == '\n' || ((String)arg).charAt(i) == '{') break;
                }
                inferredArgumentTypes.add(UMLType.extractTypeObject((String)type));
                continue;
            }
            if (indexOfOpeningParenthesis == 0 && ((String)arg).contains(")") && !((String)arg).contains("->") && !((String)arg).contains("::") && ((String)arg).indexOf(")") < ((String)arg).length()) {
                String cast = ((String)arg).substring(indexOfOpeningParenthesis + 1, ((String)arg).indexOf(")"));
                if (cast.charAt(0) == '(') continue;
                inferredArgumentTypes.add(UMLType.extractTypeObject(cast));
                continue;
            }
            if (((String)arg).endsWith(".getClassLoader()")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("ClassLoader"));
                continue;
            }
            if (((String)arg).contains(" + ") && !StringBasedHeuristics.containsMethodSignatureOfAnonymousClass((String)arg)) {
                String[] tokens = StringBasedHeuristics.SPLIT_CONCAT_STRING_PATTERN.split((CharSequence)arg);
                if (tokens[0].startsWith("\"") && tokens[0].endsWith("\"")) {
                    inferredArgumentTypes.add(UMLType.extractTypeObject("String"));
                    continue;
                }
                inferredArgumentTypes.add(null);
                continue;
            }
            if (((String)arg).contains("[") && openingSquareBracketBeforeParenthesis && ((String)arg).lastIndexOf("]") == ((String)arg).length() - 1) {
                VariableDeclaration variableDeclaration;
                LeafType elementType;
                VariableDeclaration variableDeclaration2;
                String arrayVariable = ((String)arg).substring(0, indexOfOpeningSquareBracket);
                if (variableDeclarationMap.containsKey(arrayVariable)) {
                    Set<VariableDeclaration> variableDeclarations = variableDeclarationMap.get(arrayVariable);
                    for (VariableDeclaration variableDeclaration3 : variableDeclarations) {
                        if (!variableDeclaration3.getScope().subsumes(this.getLocationInfo())) continue;
                        LeafType elementType2 = variableDeclaration3.getType() != null ? UMLType.extractTypeObject(variableDeclaration3.getType().getClassType()) : null;
                        inferredArgumentTypes.add(elementType2);
                        continue block0;
                    }
                    continue;
                }
                if ((parentFieldDeclarationMap == null || !parentFieldDeclarationMap.containsKey(arrayVariable)) && (childFieldDeclarationMap == null || !childFieldDeclarationMap.containsKey(arrayVariable))) continue;
                boolean variableDeclarationFound = false;
                if (parentFieldDeclarationMap != null && parentFieldDeclarationMap.containsKey(arrayVariable) && (variableDeclaration2 = parentFieldDeclarationMap.get(arrayVariable)).getScope().subsumes(this.getLocationInfo())) {
                    elementType = variableDeclaration2.getType() != null ? UMLType.extractTypeObject(variableDeclaration2.getType().getClassType()) : null;
                    inferredArgumentTypes.add(elementType);
                    variableDeclarationFound = true;
                }
                if (variableDeclarationFound || childFieldDeclarationMap == null || !childFieldDeclarationMap.containsKey(arrayVariable) || !(variableDeclaration = childFieldDeclarationMap.get(arrayVariable)).getScope().subsumes(this.getLocationInfo())) continue;
                elementType = variableDeclaration.getType() != null ? UMLType.extractTypeObject(variableDeclaration.getType().getClassType()) : null;
                inferredArgumentTypes.add(elementType);
                continue;
            }
            inferredArgumentTypes.add(null);
        }
        int i = 0;
        for (UMLParameter parameter : operation.getParametersWithoutReturnType()) {
            UMLType parameterType = parameter.getType();
            if (!(inferredArgumentTypes.size() <= i || inferredArgumentTypes.get(i) == null || parameterType.getClassType().equals(((UMLType)inferredArgumentTypes.get(i)).toString()) || parameterType.toString().equals(((UMLType)inferredArgumentTypes.get(i)).toString()) || this.compatibleTypes(parameter, (UMLType)inferredArgumentTypes.get(i), classDiff, modelDiff))) {
                return false;
            }
            ++i;
        }
        UMLType lastInferredArgumentType = inferredArgumentTypes.size() > 0 ? (UMLType)inferredArgumentTypes.get(inferredArgumentTypes.size() - 1) : null;
        return this.numberOfArguments == operation.getParameterTypeList().size() || this.varArgsMatch(operation, lastInferredArgumentType);
    }

    /*
     * WARNING - void declaration
     */
    private boolean compatibleTypes(UMLParameter parameter, UMLType type, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        String type1 = parameter.getType().toString();
        String type2 = type.toString();
        if (OperationInvocation.collectionMatch(parameter.getType(), type)) {
            return true;
        }
        if (type1.equals("Throwable") && type2.endsWith("Exception")) {
            return true;
        }
        if (type1.equals("Exception") && type2.endsWith("Exception")) {
            return true;
        }
        if (OperationInvocation.isPrimitiveType(type1) && OperationInvocation.isPrimitiveType(type2)) {
            if (OperationInvocation.isWideningPrimitiveConversion(type2, type1)) {
                return true;
            }
            if (OperationInvocation.isNarrowingPrimitiveConversion(type2, type1)) {
                return true;
            }
        } else if (OperationInvocation.isPrimitiveType(type1) && !OperationInvocation.isPrimitiveType(type2) ? PRIMITIVE_WRAPPER_CLASS_MAP.get(type1).equals(type2) : OperationInvocation.isPrimitiveType(type2) && !OperationInvocation.isPrimitiveType(type1) && PRIMITIVE_WRAPPER_CLASS_MAP.get(type2).equals(type1)) {
            return true;
        }
        if (modelDiff != null) {
            UMLAbstractClass subClassInParentModel = modelDiff.findClassInParentModel(type2);
            if (!parameter.isVarargs() && subClassInParentModel instanceof UMLClass) {
                UMLClass subClass = (UMLClass)subClassInParentModel;
                if (subClass.getSuperclass() != null && subClass.getSuperclass().equalClassType(parameter.getType())) {
                    return true;
                }
                for (UMLType uMLType : subClass.getImplementedInterfaces()) {
                    if (!uMLType.equalClassType(parameter.getType())) continue;
                    return true;
                }
            }
            UMLAbstractClass subClassInChildModel = modelDiff.findClassInChildModel(type2);
            if (!parameter.isVarargs() && subClassInChildModel instanceof UMLClass) {
                UMLClass subClass = (UMLClass)subClassInChildModel;
                if (subClass.getSuperclass() != null && subClass.getSuperclass().equalClassType(parameter.getType())) {
                    return true;
                }
                for (UMLType implementedInterface : subClass.getImplementedInterfaces()) {
                    if (!implementedInterface.equalClassType(parameter.getType())) continue;
                    return true;
                }
            }
        }
        if (!parameter.isVarargs() && type1.endsWith("Object") && !type2.endsWith("Object")) {
            return true;
        }
        if (parameter.isVarargs() && type1.endsWith("Object[]") && (type2.equals("Throwable") || type2.endsWith("Exception"))) {
            return true;
        }
        if (parameter.getType().equalsWithSubType(type)) {
            return true;
        }
        if (parameter.getType().isParameterized() && type.isParameterized() && parameter.getType().getClassType().equals(type.getClassType())) {
            return true;
        }
        if (modelDiff != null && modelDiff.isSubclassOf(type.getClassType(), parameter.getType().getClassType())) {
            return true;
        }
        UMLClassBaseDiff subclassDiff = this.getUMLClassDiff(modelDiff, type);
        UMLClassBaseDiff superclassDiff = this.getUMLClassDiff(modelDiff, parameter.getType());
        if (superclassDiff != null && subclassDiff == null) {
            return true;
        }
        if (classDiff != null) {
            void var10_14;
            List<UMLImport> imports = classDiff.getNextClass().getImportedTypes();
            Object var10_13 = null;
            String qualifiedType2Prefix = null;
            for (UMLImport umlImport : imports) {
                if (umlImport.getName().endsWith("." + type1)) {
                    String string = umlImport.getName().substring(0, umlImport.getName().indexOf("." + type1));
                }
                if (!umlImport.getName().endsWith("." + type2)) continue;
                qualifiedType2Prefix = umlImport.getName().substring(0, umlImport.getName().indexOf("." + type2));
            }
            if (var10_14 != null && qualifiedType2Prefix != null && var10_14.equals(qualifiedType2Prefix)) {
                return true;
            }
        }
        return false;
    }

    public static boolean collectionMatch(UMLType parameterType, UMLType type) {
        if ((parameterType.getClassType().equals("Iterable") || parameterType.getClassType().equals("Collection")) && (type.getClassType().endsWith("List") || type.getClassType().endsWith("Set") || type.getClassType().endsWith("Collection"))) {
            UMLType typeArgument;
            if (parameterType.getTypeArguments().equals(type.getTypeArguments())) {
                return true;
            }
            if (parameterType.getTypeArguments().size() == 1 && (typeArgument = parameterType.getTypeArguments().get(0)).toString().length() == 1 && Character.isUpperCase(typeArgument.toString().charAt(0))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isWideningPrimitiveConversion(String type1, String type2) {
        return PRIMITIVE_TYPE_WIDENING_MAP.containsKey(type1) && PRIMITIVE_TYPE_WIDENING_MAP.get(type1).contains(type2);
    }

    private static boolean isNarrowingPrimitiveConversion(String type1, String type2) {
        return PRIMITIVE_TYPE_NARROWING_MAP.containsKey(type1) && PRIMITIVE_TYPE_NARROWING_MAP.get(type1).contains(type2);
    }

    private static boolean isPrimitiveType(String argumentTypeClassName) {
        return PRIMITIVE_TYPE_LIST.contains(argumentTypeClassName);
    }

    private UMLClassBaseDiff getUMLClassDiff(UMLModelDiff modelDiff, UMLType type) {
        UMLClassBaseDiff classDiff = null;
        if (modelDiff != null && (classDiff = modelDiff.getUMLClassDiff(type.getClassType())) == null) {
            classDiff = modelDiff.getUMLClassDiff(type);
        }
        return classDiff;
    }

    private boolean varArgsMatch(VariableDeclarationContainer operation, UMLType lastInferredArgumentType) {
        if (this.numberOfArguments == operation.getNumberOfNonVarargsParameters()) {
            return true;
        }
        if (operation.hasVarargsParameter() && this.numberOfArguments > operation.getNumberOfNonVarargsParameters()) {
            List<UMLType> parameterTypeList = operation.getParameterTypeList();
            UMLType lastParameterType = parameterTypeList.get(parameterTypeList.size() - 1);
            if (lastParameterType.equals(lastInferredArgumentType)) {
                return true;
            }
            if (lastInferredArgumentType != null && lastParameterType.getClassType().equals(lastInferredArgumentType.getClassType())) {
                return true;
            }
        }
        return false;
    }

    public boolean compatibleExpression(OperationInvocation other) {
        if (this.expression != null && other.expression != null) {
            if (this.expression.startsWith("new ") && !other.expression.startsWith("new ")) {
                return false;
            }
            if (!this.expression.startsWith("new ") && other.expression.startsWith("new ")) {
                return false;
            }
        }
        if (this.expression != null && this.expression.startsWith("new ") && other.expression == null) {
            return false;
        }
        if (other.expression != null && other.expression.startsWith("new ") && this.expression == null) {
            return false;
        }
        if (this.subExpressions.size() > 1 || other.subExpressions.size() > 1) {
            Set<String> intersection = this.subExpressionIntersection(other);
            int thisUnmatchedSubExpressions = this.subExpressions().size() - intersection.size();
            int otherUnmatchedSubExpressions = other.subExpressions().size() - intersection.size();
            if (thisUnmatchedSubExpressions > intersection.size() || otherUnmatchedSubExpressions > intersection.size()) {
                return false;
            }
        }
        return true;
    }

    public Set<String> callChainIntersection(OperationInvocation other) {
        LinkedHashSet<String> s1 = new LinkedHashSet<String>(this.subExpressions);
        s1.add(this.actualString());
        LinkedHashSet<String> s2 = new LinkedHashSet<String>(other.subExpressions);
        s2.add(other.actualString());
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(s1);
        intersection.retainAll(s2);
        return intersection;
    }

    private Set<String> subExpressionIntersection(OperationInvocation other) {
        Set<String> subExpressions1 = this.subExpressions();
        Set<String> subExpressions2 = other.subExpressions();
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(subExpressions1);
        intersection.retainAll(subExpressions2);
        if (subExpressions1.size() == subExpressions2.size()) {
            Iterator<String> it1 = subExpressions1.iterator();
            Iterator<String> it2 = subExpressions2.iterator();
            while (it1.hasNext()) {
                String subExpression1 = it1.next();
                String subExpression2 = it2.next();
                if (intersection.contains(subExpression1) || !OperationInvocation.differInThisDot(subExpression1, subExpression2)) continue;
                intersection.add(subExpression1);
            }
        }
        return intersection;
    }

    private static boolean differInThisDot(String subExpression1, String subExpression2) {
        block5: {
            block4: {
                if (subExpression1.length() >= subExpression2.length()) break block4;
                Object modified = subExpression1;
                String previousCommonPrefix = "";
                String commonPrefix = null;
                while ((commonPrefix = PrefixSuffixUtils.longestCommonPrefix((String)modified, subExpression2)).length() > previousCommonPrefix.length()) {
                    if (((String)(modified = commonPrefix + "this." + ((String)modified).substring(commonPrefix.length(), ((String)modified).length()))).equals(subExpression2)) {
                        return true;
                    }
                    previousCommonPrefix = commonPrefix;
                }
                break block5;
            }
            if (subExpression1.length() <= subExpression2.length()) break block5;
            Object modified = subExpression2;
            String previousCommonPrefix = "";
            String commonPrefix = null;
            while ((commonPrefix = PrefixSuffixUtils.longestCommonPrefix((String)modified, subExpression1)).length() > previousCommonPrefix.length()) {
                if (((String)(modified = commonPrefix + "this." + ((String)modified).substring(commonPrefix.length(), ((String)modified).length()))).equals(subExpression1)) {
                    return true;
                }
                previousCommonPrefix = commonPrefix;
            }
        }
        return false;
    }

    private Set<String> subExpressions() {
        LinkedHashSet<String> subExpressions = new LinkedHashSet<String>(this.subExpressions);
        String thisExpression = this.expression;
        if (thisExpression != null) {
            if (thisExpression.contains(".")) {
                int start = 0;
                int indexOfDot = 0;
                while (start < thisExpression.length() && (indexOfDot = thisExpression.indexOf(".", start)) != -1) {
                    String subString = thisExpression.substring(start, indexOfDot);
                    if (!subExpressions.contains(subString) && !OperationInvocation.dotInsideArguments(indexOfDot, thisExpression)) {
                        subExpressions.add(subString);
                    }
                    start = indexOfDot + 1;
                }
            } else if (!subExpressions.contains(thisExpression)) {
                subExpressions.add(thisExpression);
            }
        }
        return subExpressions;
    }

    private static boolean dotInsideArguments(int indexOfDot, String thisExpression) {
        boolean openingParenthesisFound = false;
        for (int i = indexOfDot; i >= 0; --i) {
            if (thisExpression.charAt(i) != '(') continue;
            openingParenthesisFound = true;
            break;
        }
        boolean closingParenthesisFound = false;
        for (int i = indexOfDot; i < thisExpression.length(); ++i) {
            if (thisExpression.charAt(i) != ')') continue;
            closingParenthesisFound = true;
            break;
        }
        return openingParenthesisFound && closingParenthesisFound;
    }

    @Override
    public double normalizedNameDistance(AbstractCall call) {
        String s1 = this.getMethodName().toLowerCase();
        String s2 = call.getName().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OperationInvocation) {
            OperationInvocation invocation = (OperationInvocation)o;
            return this.methodName.equals(invocation.methodName) && this.numberOfArguments == invocation.numberOfArguments && this.expression != null == (invocation.expression != null);
        }
        if (o instanceof MethodReference) {
            MethodReference invocation = (MethodReference)o;
            return this.methodName.equals(invocation.getMethodName()) && this.numberOfArguments == invocation.numberOfArguments && this.expression != null == (invocation.expression != null);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.methodName);
        sb.append("(");
        if (this.numberOfArguments > 0) {
            for (int i = 0; i < this.numberOfArguments - 1; ++i) {
                sb.append("arg" + i).append(", ");
            }
            sb.append("arg" + (this.numberOfArguments - 1));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.expression != null ? 1 : 0;
            result = 37 * result + this.methodName.hashCode();
            this.hashCode = result = 37 * result + this.numberOfArguments;
        }
        return this.hashCode;
    }

    @Override
    public boolean identicalName(AbstractCall call) {
        return this.getMethodName().equals(call.getName());
    }

    public boolean typeInferenceMatch(UMLOperation operationToBeMatched, Map<String, UMLType> typeInferenceMapFromContext) {
        List<UMLParameter> parameters = operationToBeMatched.getParametersWithoutReturnType();
        if (operationToBeMatched.hasVarargsParameter()) {
            if (this.arguments().size() < parameters.size()) {
                int i = 0;
                for (String argument : this.arguments()) {
                    UMLType paremeterType;
                    UMLType argumentType;
                    if (typeInferenceMapFromContext.containsKey(argument) && !(argumentType = typeInferenceMapFromContext.get(argument)).equals(paremeterType = parameters.get(i).getType())) {
                        return false;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                for (UMLParameter parameter : parameters) {
                    String argument = this.arguments().get(i);
                    if (typeInferenceMapFromContext.containsKey(argument)) {
                        UMLType paremeterType;
                        UMLType argumentType = typeInferenceMapFromContext.get(argument);
                        UMLType uMLType = paremeterType = parameter.isVarargs() ? UMLType.extractTypeObject(parameter.getType().getClassType()) : parameter.getType();
                        if (!argumentType.equals(paremeterType)) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            for (String argument : this.arguments()) {
                UMLType paremeterType;
                UMLType argumentType;
                if (typeInferenceMapFromContext.containsKey(argument) && !(argumentType = typeInferenceMapFromContext.get(argument)).equals(paremeterType = parameters.get(i).getType())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private int subExpressionsWithStringLiteralArgument() {
        int count = 0;
        for (String subExpression : this.subExpressions) {
            int endIndex;
            int startIndex;
            String argument;
            if (!subExpression.contains("(") || !subExpression.contains(")") || !this.isStringLiteral(argument = subExpression.substring(startIndex = subExpression.indexOf("(") + 1, endIndex = subExpression.lastIndexOf(")")))) continue;
            ++count;
        }
        return count;
    }

    private Set<String> parametersUsedInSubExpressionArguments() {
        List<String> parameterNames = this.container.getParameterNameList();
        LinkedHashSet<String> matchedParameterNames = new LinkedHashSet<String>();
        block0: for (String subExpression : this.subExpressions) {
            int endIndex;
            int startIndex;
            String argument;
            if (!subExpression.contains("(") || !subExpression.contains(")") || (argument = subExpression.substring(startIndex = subExpression.indexOf("(") + 1, endIndex = subExpression.lastIndexOf(")"))).isEmpty()) continue;
            boolean found = false;
            for (String parameterName : parameterNames) {
                if (!argument.contains(parameterName)) continue;
                matchedParameterNames.add(parameterName);
                found = true;
                break;
            }
            if (found) continue;
            Map<String, Set<VariableDeclaration>> map = this.container.variableDeclarationMap();
            for (String variableName : map.keySet()) {
                if (!argument.contains(variableName)) continue;
                Set<VariableDeclaration> variableDeclarations = map.get(variableName);
                for (VariableDeclaration variableDeclaration : variableDeclarations) {
                    if (variableDeclaration.getInitializer() == null) continue;
                    for (String parameterName : parameterNames) {
                        if (!variableDeclaration.getInitializer().getString().contains(parameterName)) continue;
                        matchedParameterNames.add(parameterName);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                continue block0;
            }
        }
        return matchedParameterNames;
    }

    public boolean identicalWithExpressionCallChainDifference(OperationInvocation other) {
        Set<String> subExpressionIntersection = this.subExpressionIntersection(other);
        if ((this.identicalName(other) || this.compatibleName(other)) && (this.equalArguments(other) || this.equalArgumentsExceptForStringLiterals(other)) && subExpressionIntersection.size() > 0) {
            Set<String> parametersInArguments2;
            if (subExpressionIntersection.size() >= this.subExpressions.size() - this.subExpressionsWithStringLiteralArgument() || subExpressionIntersection.size() >= other.subExpressions.size() - other.subExpressionsWithStringLiteralArgument()) {
                return true;
            }
            Set<String> parametersInArguments1 = this.parametersUsedInSubExpressionArguments();
            if (parametersInArguments1.equals(parametersInArguments2 = other.parametersUsedInSubExpressionArguments()) && (subExpressionIntersection.size() >= this.subExpressions.size() - parametersInArguments1.size() || subExpressionIntersection.size() >= other.subExpressions.size() - parametersInArguments2.size())) {
                return true;
            }
        }
        return false;
    }

    public String subExpressionIsCallToSameMethod() {
        for (String expression : this.subExpressions) {
            if (!expression.startsWith(this.getName() + "(")) continue;
            return expression;
        }
        return null;
    }

    static {
        PRIMITIVE_TYPE_LIST = new ArrayList<String>(Arrays.asList("byte", "short", "int", "long", "float", "double", "char", "boolean"));
        PRIMITIVE_WRAPPER_CLASS_MAP = new HashMap<String, String>();
        PRIMITIVE_WRAPPER_CLASS_MAP.put("boolean", "Boolean");
        PRIMITIVE_WRAPPER_CLASS_MAP.put("byte", "Byte");
        PRIMITIVE_WRAPPER_CLASS_MAP.put("char", "Character");
        PRIMITIVE_WRAPPER_CLASS_MAP.put("float", "Float");
        PRIMITIVE_WRAPPER_CLASS_MAP.put("int", "Integer");
        PRIMITIVE_WRAPPER_CLASS_MAP.put("long", "Long");
        PRIMITIVE_WRAPPER_CLASS_MAP.put("short", "Short");
        PRIMITIVE_WRAPPER_CLASS_MAP.put("double", "Double");
        PRIMITIVE_WRAPPER_CLASS_MAP = Collections.unmodifiableMap(PRIMITIVE_WRAPPER_CLASS_MAP);
        PRIMITIVE_TYPE_WIDENING_MAP = new HashMap<String, List<String>>();
        PRIMITIVE_TYPE_WIDENING_MAP.put("byte", Arrays.asList("short", "int", "long", "float", "double"));
        PRIMITIVE_TYPE_WIDENING_MAP.put("short", Arrays.asList("int", "long", "float", "double"));
        PRIMITIVE_TYPE_WIDENING_MAP.put("char", Arrays.asList("int", "long", "float", "double"));
        PRIMITIVE_TYPE_WIDENING_MAP.put("int", Arrays.asList("long", "float", "double"));
        PRIMITIVE_TYPE_WIDENING_MAP.put("long", Arrays.asList("float", "double"));
        PRIMITIVE_TYPE_WIDENING_MAP.put("float", Arrays.asList("double"));
        PRIMITIVE_TYPE_WIDENING_MAP = Collections.unmodifiableMap(PRIMITIVE_TYPE_WIDENING_MAP);
        PRIMITIVE_TYPE_NARROWING_MAP = new HashMap<String, List<String>>();
        PRIMITIVE_TYPE_NARROWING_MAP.put("short", Arrays.asList("byte", "char"));
        PRIMITIVE_TYPE_NARROWING_MAP.put("char", Arrays.asList("byte", "short"));
        PRIMITIVE_TYPE_NARROWING_MAP.put("int", Arrays.asList("byte", "short", "char"));
        PRIMITIVE_TYPE_NARROWING_MAP.put("long", Arrays.asList("byte", "short", "char", "int"));
        PRIMITIVE_TYPE_NARROWING_MAP.put("float", Arrays.asList("byte", "short", "char", "int", "long"));
        PRIMITIVE_TYPE_NARROWING_MAP.put("double", Arrays.asList("byte", "short", "char", "int", "long", "float"));
        PRIMITIVE_TYPE_NARROWING_MAP = Collections.unmodifiableMap(PRIMITIVE_TYPE_NARROWING_MAP);
    }
}

