/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractStatement;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class StatementObject
extends AbstractStatement {
    private String statement;
    private LocationInfo locationInfo;
    private List<LeafExpression> variables;
    private List<String> types;
    private List<VariableDeclaration> variableDeclarations;
    private List<AbstractCall> methodInvocations;
    private List<AnonymousClassDeclarationObject> anonymousClassDeclarations;
    private List<LeafExpression> stringLiterals;
    private List<LeafExpression> charLiterals;
    private List<LeafExpression> numberLiterals;
    private List<LeafExpression> nullLiterals;
    private List<LeafExpression> booleanLiterals;
    private List<LeafExpression> typeLiterals;
    private List<AbstractCall> creations;
    private List<LeafExpression> infixExpressions;
    private List<String> infixOperators;
    private List<LeafExpression> arrayAccesses;
    private List<LeafExpression> prefixExpressions;
    private List<LeafExpression> postfixExpressions;
    private List<LeafExpression> thisExpressions;
    private List<LeafExpression> arguments;
    private List<LeafExpression> parenthesizedExpressions;
    private List<LeafExpression> castExpressions;
    private List<TernaryOperatorExpression> ternaryOperatorExpressions;
    private List<LambdaExpressionObject> lambdas;

    public StatementObject(CompilationUnit cu, String filePath, Statement statement, int depth, LocationInfo.CodeElementType codeElementType, VariableDeclarationContainer container) {
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)statement, codeElementType);
        Visitor visitor = new Visitor(cu, filePath, container);
        statement.accept((ASTVisitor)visitor);
        this.variables = visitor.getVariables();
        this.types = visitor.getTypes();
        this.variableDeclarations = visitor.getVariableDeclarations();
        this.methodInvocations = visitor.getMethodInvocations();
        this.anonymousClassDeclarations = visitor.getAnonymousClassDeclarations();
        this.stringLiterals = visitor.getStringLiterals();
        this.charLiterals = visitor.getCharLiterals();
        this.numberLiterals = visitor.getNumberLiterals();
        this.nullLiterals = visitor.getNullLiterals();
        this.booleanLiterals = visitor.getBooleanLiterals();
        this.typeLiterals = visitor.getTypeLiterals();
        this.creations = visitor.getCreations();
        this.infixExpressions = visitor.getInfixExpressions();
        this.infixOperators = visitor.getInfixOperators();
        this.arrayAccesses = visitor.getArrayAccesses();
        this.prefixExpressions = visitor.getPrefixExpressions();
        this.postfixExpressions = visitor.getPostfixExpressions();
        this.thisExpressions = visitor.getThisExpressions();
        this.arguments = visitor.getArguments();
        this.parenthesizedExpressions = visitor.getParenthesizedExpressions();
        this.castExpressions = visitor.getCastExpressions();
        this.ternaryOperatorExpressions = visitor.getTernaryOperatorExpressions();
        this.lambdas = visitor.getLambdas();
        this.setDepth(depth);
        String statementAsString = Visitor.stringify((ASTNode)statement);
        if (Visitor.METHOD_INVOCATION_PATTERN.matcher(statementAsString).matches()) {
            if (statement instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
                StringBuilder sb = new StringBuilder();
                List modifiers = variableDeclarationStatement.modifiers();
                for (IExtendedModifier modifier : modifiers) {
                    sb.append(modifier.toString()).append(" ");
                }
                sb.append(Visitor.stringify((ASTNode)variableDeclarationStatement.getType()));
                List fragments = variableDeclarationStatement.fragments();
                for (VariableDeclarationFragment fragment : fragments) {
                    sb.append(fragment.getName().getIdentifier());
                    Expression initializer = fragment.getInitializer();
                    if (initializer == null) continue;
                    sb.append(" = ");
                    if (initializer instanceof MethodInvocation) {
                        MethodInvocation methodInvocation = (MethodInvocation)initializer;
                        sb.append(Visitor.processMethodInvocation(methodInvocation));
                        continue;
                    }
                    if (!(initializer instanceof ClassInstanceCreation)) continue;
                    ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)initializer;
                    sb.append(Visitor.processClassInstanceCreation(classInstanceCreation));
                }
                this.statement = sb.toString();
            } else if (statement instanceof ReturnStatement) {
                ReturnStatement returnStatement = (ReturnStatement)statement;
                StringBuilder sb = new StringBuilder();
                sb.append("return").append(" ");
                Expression expression = returnStatement.getExpression();
                if (expression instanceof MethodInvocation) {
                    MethodInvocation methodInvocation = (MethodInvocation)expression;
                    sb.append(Visitor.processMethodInvocation(methodInvocation));
                } else if (expression instanceof ClassInstanceCreation) {
                    ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                    sb.append(Visitor.processClassInstanceCreation(classInstanceCreation));
                }
                this.statement = sb.toString();
            } else if (statement instanceof ExpressionStatement) {
                ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                StringBuilder sb = new StringBuilder();
                Expression expression = expressionStatement.getExpression();
                if (expression instanceof MethodInvocation) {
                    MethodInvocation methodInvocation = (MethodInvocation)expression;
                    sb.append(Visitor.processMethodInvocation(methodInvocation));
                } else if (expression instanceof ClassInstanceCreation) {
                    ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                    sb.append(Visitor.processClassInstanceCreation(classInstanceCreation));
                }
                this.statement = sb.toString();
            } else {
                this.statement = statementAsString;
            }
        } else {
            this.statement = statementAsString;
        }
    }

    @Override
    public List<AbstractCodeFragment> getLeaves() {
        ArrayList<AbstractCodeFragment> leaves = new ArrayList<AbstractCodeFragment>();
        leaves.add(this);
        return leaves;
    }

    public String toString() {
        return this.statement;
    }

    @Override
    public List<LeafExpression> getVariables() {
        return this.variables;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    @Override
    public List<AbstractCall> getMethodInvocations() {
        return this.methodInvocations;
    }

    @Override
    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return this.anonymousClassDeclarations;
    }

    @Override
    public List<LeafExpression> getStringLiterals() {
        return this.stringLiterals;
    }

    @Override
    public List<LeafExpression> getCharLiterals() {
        return this.charLiterals;
    }

    @Override
    public List<LeafExpression> getNumberLiterals() {
        return this.numberLiterals;
    }

    @Override
    public List<LeafExpression> getNullLiterals() {
        return this.nullLiterals;
    }

    @Override
    public List<LeafExpression> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    @Override
    public List<LeafExpression> getTypeLiterals() {
        return this.typeLiterals;
    }

    @Override
    public List<AbstractCall> getCreations() {
        return this.creations;
    }

    @Override
    public List<LeafExpression> getInfixExpressions() {
        return this.infixExpressions;
    }

    @Override
    public List<String> getInfixOperators() {
        return this.infixOperators;
    }

    @Override
    public List<LeafExpression> getArrayAccesses() {
        return this.arrayAccesses;
    }

    @Override
    public List<LeafExpression> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    @Override
    public List<LeafExpression> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    @Override
    public List<LeafExpression> getThisExpressions() {
        return this.thisExpressions;
    }

    @Override
    public List<LeafExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public List<LeafExpression> getParenthesizedExpressions() {
        return this.parenthesizedExpressions;
    }

    @Override
    public List<LeafExpression> getCastExpressions() {
        return this.castExpressions;
    }

    @Override
    public List<TernaryOperatorExpression> getTernaryOperatorExpressions() {
        return this.ternaryOperatorExpressions;
    }

    @Override
    public List<LambdaExpressionObject> getLambdas() {
        return this.lambdas;
    }

    @Override
    public int statementCount() {
        return 1;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    @Override
    public VariableDeclaration getVariableDeclaration(String variableName) {
        List<VariableDeclaration> variableDeclarations = this.getVariableDeclarations();
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(variableName)) continue;
            return declaration;
        }
        for (LambdaExpressionObject lambda : this.getLambdas()) {
            for (VariableDeclaration declaration : lambda.getParameters()) {
                if (!declaration.getVariableName().equals(variableName)) continue;
                return declaration;
            }
        }
        return null;
    }

    @Override
    public List<String> stringRepresentation() {
        ArrayList<String> stringRepresentation = new ArrayList<String>();
        stringRepresentation.add(this.toString());
        return stringRepresentation;
    }
}

