/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LeafType;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.ReplacementUtil;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.VariableReplacementAnalysis;
import gr.uom.java.xmi.decomposition.Visitor;
import gr.uom.java.xmi.decomposition.replacement.AddVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.CompositeReplacement;
import gr.uom.java.xmi.decomposition.replacement.IntersectionReplacement;
import gr.uom.java.xmi.decomposition.replacement.MergeVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.MethodInvocationReplacement;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.SplitVariableReplacement;
import gr.uom.java.xmi.decomposition.replacement.SwapArgumentReplacement;
import gr.uom.java.xmi.decomposition.replacement.VariableReplacementWithMethodInvocation;
import gr.uom.java.xmi.diff.ExtractVariableRefactoring;
import gr.uom.java.xmi.diff.InvertConditionRefactoring;
import gr.uom.java.xmi.diff.LeafMappingProvider;
import gr.uom.java.xmi.diff.MergeConditionalRefactoring;
import gr.uom.java.xmi.diff.SplitConditionalRefactoring;
import gr.uom.java.xmi.diff.StringDistance;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLOperationDiff;
import gr.uom.java.xmi.diff.UMLParameterDiff;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.util.PrefixSuffixUtils;

public class StringBasedHeuristics {
    protected static final Pattern SPLIT_CONDITIONAL_PATTERN = Pattern.compile("( \\|\\| )|( && )|( \\? )|( : )");
    protected static final Pattern SPLIT_CONCAT_STRING_PATTERN = Pattern.compile("(\\s)*( \\+ )(\\s)*");
    protected static final Pattern SPLIT_COMMA_PATTERN = Pattern.compile("(\\s)*(\\,)(\\s)*");

    protected static boolean containsMethodSignatureOfAnonymousClass(String s) {
        String[] lines = s.split("\\n");
        if (s.contains(" -> ")) {
            if (lines.length > 1) {
                return true;
            }
            if (lines.length == 1 && s.endsWith(";\n")) {
                return true;
            }
        }
        for (String line : lines) {
            if (!Visitor.METHOD_SIGNATURE_PATTERN.matcher(line = VariableReplacementAnalysis.prepareLine(line)).matches()) continue;
            return true;
        }
        return false;
    }

    protected static boolean argumentsWithIdenticalMethodCalls(Set<String> arguments1, Set<String> arguments2, Set<String> variables1, Set<String> variables2) {
        int identicalMethodCalls = 0;
        if (arguments1.size() == arguments2.size()) {
            Iterator<String> it1 = arguments1.iterator();
            Iterator<String> it2 = arguments2.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                String s2;
                String s1;
                String arg1 = it1.next();
                String arg2 = it2.next();
                if (!arg1.contains("(") || !arg2.contains("(") || !arg1.contains(")") || !arg2.contains(")")) continue;
                int indexOfOpeningParenthesis1 = arg1.indexOf("(");
                int indexOfClosingParenthesis1 = arg1.lastIndexOf(")");
                boolean openingParenthesisInsideSingleQuotes1 = ReplacementUtil.isInsideSingleQuotes(arg1, indexOfOpeningParenthesis1);
                boolean openingParenthesisInsideDoubleQuotes1 = ReplacementUtil.isInsideDoubleQuotes(arg1, indexOfOpeningParenthesis1);
                boolean closingParenthesisInsideSingleQuotes1 = ReplacementUtil.isInsideSingleQuotes(arg1, indexOfClosingParenthesis1);
                boolean closingParenthesisInsideDoubleQuotes1 = ReplacementUtil.isInsideDoubleQuotes(arg1, indexOfClosingParenthesis1);
                int indexOfOpeningParenthesis2 = arg2.indexOf("(");
                int indexOfClosingParenthesis2 = arg2.lastIndexOf(")");
                boolean openingParenthesisInsideSingleQuotes2 = ReplacementUtil.isInsideSingleQuotes(arg2, indexOfOpeningParenthesis2);
                boolean openingParenthesisInsideDoubleQuotes2 = ReplacementUtil.isInsideDoubleQuotes(arg2, indexOfOpeningParenthesis2);
                boolean closingParenthesisInsideSingleQuotes2 = ReplacementUtil.isInsideSingleQuotes(arg2, indexOfClosingParenthesis2);
                boolean closingParenthesisInsideDoubleQuotes2 = ReplacementUtil.isInsideDoubleQuotes(arg2, indexOfClosingParenthesis2);
                if (openingParenthesisInsideSingleQuotes1 || closingParenthesisInsideSingleQuotes1 || openingParenthesisInsideDoubleQuotes1 || closingParenthesisInsideDoubleQuotes1 || openingParenthesisInsideSingleQuotes2 || closingParenthesisInsideSingleQuotes2 || openingParenthesisInsideDoubleQuotes2 || closingParenthesisInsideDoubleQuotes2 || !(s1 = arg1.substring(0, indexOfOpeningParenthesis1)).equals(s2 = arg2.substring(0, indexOfOpeningParenthesis2)) || s1.length() <= 0) continue;
                String args1 = arg1.substring(indexOfOpeningParenthesis1 + 1, indexOfClosingParenthesis1);
                String args2 = arg2.substring(indexOfOpeningParenthesis2 + 1, indexOfClosingParenthesis2);
                if (!variables1.contains(args1) || !variables2.contains(args2)) continue;
                ++identicalMethodCalls;
            }
        }
        return identicalMethodCalls == arguments1.size() && arguments1.size() > 0;
    }

    protected static boolean equalAfterParenthesisElimination(String s1, String s2) {
        String updatedS1 = s1.replace("(", "");
        updatedS1 = updatedS1.replace(")", "");
        String updatedS2 = s2.replace("(", "");
        return updatedS1.equals(updatedS2 = updatedS2.replace(")", "")) || updatedS1.equals("return " + updatedS2) || updatedS2.equals("return " + updatedS1);
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean differOnlyInCastExpressionOrPrefixOperatorOrInfixOperand(String s1, String s2, Map<String, List<AbstractCall>> methodInvocationMap1, Map<String, List<AbstractCall>> methodInvocationMap2, AbstractCodeFragment fragment1, AbstractCodeFragment fragment2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, UMLOperationBodyMapper.ReplacementInfo info, UMLOperationBodyMapper mapper) {
        VariableDeclarationContainer container1 = mapper.getContainer1();
        VariableDeclarationContainer container2 = mapper.getContainer2();
        List<LeafExpression> infixExpressions1 = fragment1.getInfixExpressions();
        List<LeafExpression> infixExpressions2 = fragment2.getInfixExpressions();
        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(s1, s2);
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
            String[] expressions2;
            String[] expressions1;
            String diff2;
            int endIndexS1;
            int beginIndexS1 = s1.indexOf(commonPrefix) + commonPrefix.length();
            String diff1 = beginIndexS1 > (endIndexS1 = s1.lastIndexOf(commonSuffix)) ? "" : s1.substring(beginIndexS1, endIndexS1);
            int beginIndexS2 = s2.indexOf(commonPrefix) + commonPrefix.length();
            int endIndexS2 = s2.lastIndexOf(commonSuffix);
            String string = diff2 = beginIndexS2 > endIndexS2 ? "" : s2.substring(beginIndexS2, endIndexS2);
            if (diff1.isEmpty() && diff2.equals("this.")) {
                return true;
            }
            if (diff2.isEmpty() && diff1.equals("this.")) {
                return true;
            }
            if (diff1.isEmpty() && (diff2.equals("+") || diff2.equals("-")) && commonSuffix.startsWith("=")) {
                return true;
            }
            if (diff2.isEmpty() && (diff1.equals("+") || diff1.equals("-")) && commonSuffix.startsWith("=")) {
                return true;
            }
            if (!diff1.isEmpty() && !diff2.isEmpty() && diff1.equals("/") && diff2.equals("*")) {
                return true;
            }
            if (!diff1.isEmpty() && !diff2.isEmpty() && diff1.equals("*") && diff2.equals("/")) {
                return true;
            }
            if (commonPrefix.equals("for(") && commonSuffix.equals(")") && diff1.contains(";") && diff2.contains(";") && (expressions1 = diff1.split(";")).length == (expressions2 = diff2.split(";")).length) {
                int matches = 0;
                LinkedHashSet<AbstractCodeFragment> linkedHashSet = new LinkedHashSet<AbstractCodeFragment>();
                LinkedHashSet<AbstractCodeFragment> linkedHashSet2 = new LinkedHashSet<AbstractCodeFragment>();
                for (int i = 0; i < expressions1.length; ++i) {
                    VariableDeclaration variableDeclaration;
                    String e2;
                    String e1 = expressions1[i].trim();
                    if (e1.equals(e2 = expressions2[i].trim())) {
                        ++matches;
                        continue;
                    }
                    if (e1.endsWith(e2)) {
                        ++matches;
                        for (AbstractCodeFragment abstractCodeFragment : info.getStatements2()) {
                            if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !e2.startsWith((variableDeclaration = abstractCodeFragment.getVariableDeclarations().get(0)).getVariableName() + "=") || !e1.startsWith(variableDeclaration.getType() + " " + variableDeclaration.getVariableName() + "=")) continue;
                            linkedHashSet2.add(abstractCodeFragment);
                        }
                        continue;
                    }
                    if (e2.endsWith(e1)) {
                        ++matches;
                        for (AbstractCodeFragment abstractCodeFragment : info.getStatements1()) {
                            if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !e1.startsWith((variableDeclaration = abstractCodeFragment.getVariableDeclarations().get(0)).getVariableName() + "=") || !e2.startsWith(variableDeclaration.getType() + " " + variableDeclaration.getVariableName() + "=")) continue;
                            linkedHashSet.add(abstractCodeFragment);
                        }
                        continue;
                    }
                    if (e1.length() > 2 && e2.length() > 2 && e1.endsWith("++") && e2.startsWith("++")) {
                        String string2;
                        String var1 = e1.substring(0, e1.length() - 2);
                        if (!var1.equals(string2 = e2.substring(2, e2.length()))) continue;
                        ++matches;
                        continue;
                    }
                    if (e1.length() <= 2 || e2.length() <= 2 || !e2.endsWith("++") || !e1.startsWith("++")) continue;
                    String var2 = e2.substring(0, e2.length() - 2);
                    String string3 = e1.substring(2, e1.length());
                    if (!string3.equals(var2)) continue;
                    ++matches;
                }
                if (matches == expressions1.length) {
                    CompositeStatementObject comp1;
                    LeafMapping leafMapping;
                    CompositeStatementObject comp2;
                    if (linkedHashSet.size() == 1 && fragment2 instanceof CompositeStatementObject && (comp2 = (CompositeStatementObject)fragment2).getExpressions().size() > 0) {
                        leafMapping = new LeafMapping((AbstractCodeFragment)linkedHashSet.iterator().next(), comp2.getExpressions().get(0), container1, container2);
                        info.addSubExpressionMapping(leafMapping);
                    }
                    if (linkedHashSet2.size() == 1 && fragment1 instanceof CompositeStatementObject && (comp1 = (CompositeStatementObject)fragment1).getExpressions().size() > 0) {
                        leafMapping = new LeafMapping(comp1.getExpressions().get(0), (AbstractCodeFragment)linkedHashSet2.iterator().next(), container1, container2);
                        info.addSubExpressionMapping(leafMapping);
                    }
                    return true;
                }
            }
            if (!diff1.isEmpty() && !diff2.isEmpty() && diff1.length() > 2 && diff2.length() > 2 && diff1.endsWith("++") && diff2.startsWith("++")) {
                String var2;
                String var1 = diff1.substring(0, diff1.length() - 2);
                if (var1.equals(var2 = diff2.substring(2, diff2.length()))) {
                    return true;
                }
                for (Replacement replacement : info.getReplacements()) {
                    if (!replacement.getBefore().equals(var1) || !replacement.getAfter().equals(var2)) continue;
                    return true;
                }
            } else if (!diff1.isEmpty() && !diff2.isEmpty() && diff1.length() > 2 && diff2.length() > 2 && diff2.endsWith("++") && diff1.startsWith("++")) {
                String var2 = diff2.substring(0, diff2.length() - 2);
                String var1 = diff1.substring(2, diff1.length());
                if (var1.equals(var2)) {
                    return true;
                }
                for (Replacement replacement : info.getReplacements()) {
                    if (!replacement.getBefore().equals(var1) || !replacement.getAfter().equals(var2)) continue;
                    return true;
                }
            }
            if (StringBasedHeuristics.cast(diff1, diff2)) {
                for (Replacement r4 : info.getReplacements()) {
                    if (!r4.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS) || !s2.startsWith(r4.getAfter() + "=")) continue;
                    if (variableDeclarations1.size() == 0 && !r4.getBefore().contains("[") && !r4.getBefore().contains("]")) {
                        if (!r4.getAfter().contains("[") || !r4.getAfter().contains("]") || variableDeclarations2.size() != 0) continue;
                        String arrayName = r4.getAfter().substring(0, r4.getAfter().indexOf("["));
                        for (AbstractCodeFragment abstractCodeFragment : info.getStatements2()) {
                            if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !abstractCodeFragment.getVariableDeclarations().get(0).getVariableName().equals(arrayName)) continue;
                            return false;
                        }
                        continue;
                    }
                    if (variableDeclarations2.size() != 0 || r4.getAfter().contains("[") || r4.getAfter().contains("]") || !r4.getBefore().contains("[") || !r4.getBefore().contains("]") || variableDeclarations1.size() != 0) continue;
                    String arrayName = r4.getBefore().substring(0, r4.getBefore().indexOf("["));
                    for (AbstractCodeFragment abstractCodeFragment : info.getStatements1()) {
                        if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !abstractCodeFragment.getVariableDeclarations().get(0).getVariableName().equals(arrayName)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (StringBasedHeuristics.cast(diff2, diff1)) {
                for (Replacement r : info.getReplacements()) {
                    if (!r.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS) || !s2.startsWith(r.getAfter() + "=")) continue;
                    if (variableDeclarations1.size() == 0 && !r.getBefore().contains("[") && !r.getBefore().contains("]")) {
                        if (!r.getAfter().contains("[") || !r.getAfter().contains("]") || variableDeclarations2.size() != 0) continue;
                        String arrayName = r.getAfter().substring(0, r.getAfter().indexOf("["));
                        for (AbstractCodeFragment abstractCodeFragment : info.getStatements2()) {
                            if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !abstractCodeFragment.getVariableDeclarations().get(0).getVariableName().equals(arrayName)) continue;
                            return false;
                        }
                        continue;
                    }
                    if (variableDeclarations2.size() != 0 || r.getAfter().contains("[") || r.getAfter().contains("]") || !r.getBefore().contains("[") || !r.getBefore().contains("]") || variableDeclarations1.size() != 0) continue;
                    String arrayName = r.getBefore().substring(0, r.getBefore().indexOf("["));
                    for (AbstractCodeFragment abstractCodeFragment : info.getStatements1()) {
                        if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !abstractCodeFragment.getVariableDeclarations().get(0).getVariableName().equals(arrayName)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (diff1.isEmpty()) {
                String updatedS2;
                String updatedS1;
                if (diff2.equals("!") || diff2.equals("~")) {
                    Replacement r2 = new Replacement(s1, s2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                    info.addReplacement(r2);
                    return true;
                }
                if (infixExpressions2.size() - infixExpressions1.size() == 1 && !diff2.isEmpty() && StringBasedHeuristics.countOperators(diff2) == 1) {
                    for (LeafExpression infixExpression : infixExpressions2) {
                        String infix = infixExpression.getString();
                        if (infix.equals(diff2) || !infix.startsWith(diff2) && !infix.endsWith(diff2) || StringBasedHeuristics.variableDeclarationNameReplaced(variableDeclarations1, variableDeclarations2, info.getReplacements()) || StringBasedHeuristics.returnExpressionReplaced(s1, s2, info.getReplacements())) continue;
                        return true;
                    }
                }
                if (variableDeclarations1.isEmpty() && variableDeclarations2.size() == 1 && s1.startsWith("for(") && s2.startsWith("for(") && (updatedS1 = "for(" + variableDeclarations2.get(0).getType().toString() + " " + commonSuffix).equals(s2)) {
                    return true;
                }
                if (variableDeclarations1.size() == 1 && variableDeclarations2.isEmpty() && s1.startsWith("for(") && s2.startsWith("for(") && (updatedS2 = "for(" + variableDeclarations1.get(0).getType().toString() + " " + commonSuffix).equals(s1)) {
                    return true;
                }
            }
            if (diff2.isEmpty()) {
                if (diff1.equals("!") || diff1.equals("~")) {
                    Replacement r = new Replacement(s1, s2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                    info.addReplacement(r);
                    return true;
                }
                if (infixExpressions1.size() - infixExpressions2.size() == 1 && !diff1.isEmpty() && StringBasedHeuristics.countOperators(diff1) == 1) {
                    for (LeafExpression infixExpression : infixExpressions1) {
                        String infix = infixExpression.getString();
                        if (infix.equals(diff1) || !infix.startsWith(diff1) && !infix.endsWith(diff1) || StringBasedHeuristics.variableDeclarationNameReplaced(variableDeclarations1, variableDeclarations2, info.getReplacements()) || StringBasedHeuristics.returnExpressionReplaced(s1, s2, info.getReplacements())) continue;
                        return true;
                    }
                }
            }
            for (String key1 : methodInvocationMap1.keySet()) {
                for (AbstractCall abstractCall : methodInvocationMap1.get(key1)) {
                    if (!abstractCall.actualString().equals(diff1) || !abstractCall.arguments().contains(diff2) || abstractCall.arguments().size() != 1 && (!diff2.contains(" ? ") || !diff2.contains(" : ")) || StringBasedHeuristics.variableDeclarationNameReplaced(variableDeclarations1, variableDeclarations2, info.getReplacements()) || StringBasedHeuristics.returnExpressionReplaced(s1, s2, info.getReplacements())) continue;
                    VariableReplacementWithMethodInvocation variableReplacementWithMethodInvocation = new VariableReplacementWithMethodInvocation(diff1, diff2, abstractCall, VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE);
                    info.addReplacement(variableReplacementWithMethodInvocation);
                    return true;
                }
            }
            for (String key2 : methodInvocationMap2.keySet()) {
                for (AbstractCall abstractCall : methodInvocationMap2.get(key2)) {
                    if (!abstractCall.actualString().equals(diff2) || !abstractCall.arguments().contains(diff1) || abstractCall.arguments().size() != 1 && (!diff1.contains(" ? ") || !diff1.contains(" : ")) || StringBasedHeuristics.variableDeclarationNameReplaced(variableDeclarations1, variableDeclarations2, info.getReplacements()) || StringBasedHeuristics.returnExpressionReplaced(s1, s2, info.getReplacements())) continue;
                    VariableReplacementWithMethodInvocation variableReplacementWithMethodInvocation = new VariableReplacementWithMethodInvocation(diff1, diff2, abstractCall, VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION);
                    info.addReplacement(variableReplacementWithMethodInvocation);
                    return true;
                }
            }
            for (LeafExpression infixExpression2 : infixExpressions2) {
                void var26_69;
                String infix = infixExpression2.getString();
                if (!infix.equals(diff1) && !infix.equals("(" + diff1) && !infix.equals(diff1 + ")")) continue;
                for (Replacement replacement : info.getReplacements()) {
                    if (!diff1.contains(replacement.getAfter())) continue;
                    return false;
                }
                IntersectionReplacement intersectionReplacement = new IntersectionReplacement(s1, s2, Replacement.ReplacementType.CONCATENATION);
                Object var26_67 = null;
                for (LeafExpression expression : infixExpressions1) {
                    if (!expression.getString().equals(infix)) continue;
                    LeafExpression leafExpression = expression;
                    break;
                }
                if (var26_69 == null) continue;
                LeafMapping leafMapping = new LeafMapping((AbstractCodeFragment)var26_69, infixExpression2, container1, container2);
                intersectionReplacement.addSubExpressionMapping(leafMapping);
                info.getReplacements().add(intersectionReplacement);
                return true;
            }
        }
        return false;
    }

    private static int countOperators(String input) {
        int count = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '+' && c != '-') continue;
            ++count;
        }
        return count;
    }

    private static boolean returnExpressionReplaced(String s1, String s2, Set<Replacement> replacements) {
        if (s1.startsWith("return ") && s2.startsWith("return ")) {
            for (Replacement r : replacements) {
                if (!s1.equals("return " + r.getAfter() + ";\n") && !s2.equals("return " + r.getAfter() + ";\n")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean variableDeclarationNameReplaced(List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, Set<Replacement> replacements) {
        if (variableDeclarations1.size() == variableDeclarations2.size() && variableDeclarations1.size() == 1) {
            VariableDeclaration declaration1 = variableDeclarations1.get(0);
            VariableDeclaration declaration2 = variableDeclarations2.get(0);
            for (Replacement r : replacements) {
                if (!r.getBefore().equals(declaration1.getVariableName()) || !r.getAfter().equals(declaration2.getVariableName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean cast(String diff1, String diff2) {
        return diff1.isEmpty() && diff2.startsWith("(") && diff2.endsWith(")") || diff2.equals("(" + diff1 + ")");
    }

    protected static boolean differOnlyInThrow(String s1, String s2) {
        return StringBasedHeuristics.differOnlyInPrefix(s1, s2, "", "throw ");
    }

    protected static boolean differOnlyInFinalModifier(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        return StringBasedHeuristics.differOnlyInPrefix(s1, s2, "for(", "for(final ") || StringBasedHeuristics.differOnlyInPrefix(s1, s2, "catch(", "catch(final ") || StringBasedHeuristics.catchDifferInFinalModifierAndExceptionName(s1, s2, variableDeclarations1, variableDeclarations2, replacementInfo) || StringBasedHeuristics.enhancedForDifferInFinalModifierAndFormalParameterName(s1, s2, variableDeclarations1, variableDeclarations2, replacementInfo);
    }

    private static boolean enhancedForDifferInFinalModifierAndFormalParameterName(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        if (s1.startsWith("for(") && s2.startsWith("for(") && variableDeclarations1.size() > 0 && variableDeclarations1.size() == variableDeclarations2.size()) {
            VariableDeclaration v1 = variableDeclarations1.get(0);
            VariableDeclaration v2 = variableDeclarations2.get(0);
            if (v1.getType().equals(v2.getType())) {
                if (s1.startsWith("for(final ") && s2.startsWith("for(")) {
                    String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
                    String constructedS1 = "for(final " + v1.getVariableName() + commonSuffix;
                    String constructedS2 = "for(" + v2.getVariableName() + commonSuffix;
                    if (constructedS1.equals(s1) && constructedS2.equals(s2)) {
                        return true;
                    }
                } else if (s1.startsWith("for(") && s2.startsWith("for(final ")) {
                    String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
                    String constructedS1 = "for(" + v1.getVariableName() + commonSuffix;
                    String constructedS2 = "for(final " + v2.getVariableName() + commonSuffix;
                    if (constructedS1.equals(s1) && constructedS2.equals(s2)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean catchDifferInFinalModifierAndExceptionName(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        if (s1.startsWith("catch(") && s2.startsWith("catch(") && variableDeclarations1.size() > 0 && variableDeclarations1.size() == variableDeclarations2.size()) {
            VariableDeclaration v1 = variableDeclarations1.get(0);
            VariableDeclaration v2 = variableDeclarations2.get(0);
            if (v1.getType().equals(v2.getType()) && (s1.startsWith("catch(final ") && s2.startsWith("catch(") || s1.startsWith("catch(") && s2.startsWith("catch(final ")) && !v1.getVariableName().equals(v2.getVariableName())) {
                Replacement r = new Replacement(v1.getVariableName(), v2.getVariableName(), Replacement.ReplacementType.VARIABLE_NAME);
                replacementInfo.addReplacement(r);
                return true;
            }
        }
        return false;
    }

    protected static boolean differOnlyInThis(String s1, String s2) {
        if (StringBasedHeuristics.differOnlyInPrefix(s1, s2, "", "this.")) {
            return true;
        }
        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(s1, s2);
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
            String diff2;
            int endIndexS1;
            int beginIndexS1 = s1.indexOf(commonPrefix) + commonPrefix.length();
            String diff1 = beginIndexS1 > (endIndexS1 = s1.lastIndexOf(commonSuffix)) ? "" : s1.substring(beginIndexS1, endIndexS1);
            int beginIndexS2 = s2.indexOf(commonPrefix) + commonPrefix.length();
            int endIndexS2 = s2.lastIndexOf(commonSuffix);
            String string = diff2 = beginIndexS2 > endIndexS2 ? "" : s2.substring(beginIndexS2, endIndexS2);
            if (diff1.isEmpty() && diff2.equals("this.")) {
                return true;
            }
            if (diff2.isEmpty() && diff1.equals("this.")) {
                return true;
            }
            if (diff1.isEmpty() && diff2.equals("!= null")) {
                return true;
            }
            if (diff2.isEmpty() && diff1.equals("!= null")) {
                return true;
            }
            if (diff1.isEmpty() && diff2.equals("== null")) {
                return true;
            }
            if (diff2.isEmpty() && diff1.equals("== null")) {
                return true;
            }
        }
        return false;
    }

    protected static boolean differOnlyInDefaultInitializer(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2) {
        if (variableDeclarations1.size() > 0 && variableDeclarations1.toString().equals(variableDeclarations2.toString())) {
            StringBuilder tmpS1 = new StringBuilder();
            StringBuilder tmpS2 = new StringBuilder();
            int defaultInitializers = 0;
            for (int i = 0; i < variableDeclarations1.size(); ++i) {
                VariableDeclaration variableDeclaration1 = variableDeclarations1.get(i);
                tmpS1.append(StringBasedHeuristics.variableDeclarationAsString(variableDeclaration1));
                VariableDeclaration variableDeclaration2 = variableDeclarations2.get(i);
                tmpS2.append(StringBasedHeuristics.variableDeclarationAsString(variableDeclaration2));
                if (i < variableDeclarations1.size() - 1) {
                    tmpS1.append(", ");
                    tmpS2.append(", ");
                }
                if (variableDeclaration1.getInitializer() == null && variableDeclaration2.getInitializer() != null && (variableDeclaration2.getInitializer().getExpression().equals("null") || variableDeclaration2.getInitializer().getExpression().equals("0") || variableDeclaration2.getInitializer().getExpression().equals("false") || StringBasedHeuristics.numberLiteralInitializer(variableDeclaration2))) {
                    ++defaultInitializers;
                    continue;
                }
                if (variableDeclaration2.getInitializer() != null || variableDeclaration1.getInitializer() == null || !variableDeclaration1.getInitializer().getExpression().equals("null") && !variableDeclaration1.getInitializer().getExpression().equals("0") && !variableDeclaration1.getInitializer().getExpression().equals("false") && !StringBasedHeuristics.numberLiteralInitializer(variableDeclaration1)) continue;
                ++defaultInitializers;
            }
            tmpS1.append(";\n");
            tmpS2.append(";\n");
            if (s1.equals(tmpS1.toString()) && s2.equals(tmpS2.toString()) && defaultInitializers == variableDeclarations1.size()) {
                return true;
            }
        }
        return false;
    }

    private static boolean numberLiteralInitializer(VariableDeclaration variableDeclaration) {
        return variableDeclaration.getInitializer().getNumberLiterals().size() > 0 && variableDeclaration.getInitializer().getExpression().equals(variableDeclaration.getInitializer().getNumberLiterals().get(0).getString());
    }

    private static String variableDeclarationAsString(VariableDeclaration variableDeclaration) {
        StringBuilder sb = new StringBuilder();
        sb.append(variableDeclaration.getType());
        sb.append(" ");
        sb.append(variableDeclaration.getVariableName());
        if (variableDeclaration.getInitializer() != null) {
            sb.append("=").append(variableDeclaration.getInitializer());
        }
        return sb.toString();
    }

    private static boolean differOnlyInPrefix(String s1, String s2, String prefixWithout, String prefixWith) {
        String suffix2;
        String suffix1;
        if (s1.startsWith(prefixWithout) && s2.startsWith(prefixWith) && (suffix1 = s1.substring(prefixWithout.length(), s1.length())).equals(suffix2 = s2.substring(prefixWith.length(), s2.length()))) {
            return true;
        }
        return s1.startsWith(prefixWith) && s2.startsWith(prefixWithout) && (suffix1 = s1.substring(prefixWith.length(), s1.length())).equals(suffix2 = s2.substring(prefixWithout.length(), s2.length()));
    }

    protected static boolean identicalVariableDeclarationsWithDifferentNames(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        if (variableDeclarations1.size() == variableDeclarations2.size() && variableDeclarations1.size() == 1) {
            VariableDeclaration declaration1 = variableDeclarations1.get(0);
            VariableDeclaration declaration2 = variableDeclarations2.get(0);
            if (!declaration1.getVariableName().equals(declaration2.getVariableName())) {
                String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
                String composedString1 = null;
                String composedString2 = null;
                if (s1.startsWith("catch(final ") && s2.startsWith("catch(final ") && declaration1.equalType(declaration2)) {
                    composedString1 = "catch(final " + declaration1.getVariableName() + ")";
                    composedString2 = "catch(final " + declaration2.getVariableName() + ")";
                } else if (s1.startsWith("catch(") && s2.startsWith("catch(") && declaration1.equalType(declaration2)) {
                    composedString1 = "catch(" + declaration1.getVariableName() + ")";
                    composedString2 = "catch(" + declaration2.getVariableName() + ")";
                } else {
                    composedString1 = declaration1.getType() + " " + declaration1.getVariableName() + commonSuffix;
                    composedString2 = declaration2.getType() + " " + declaration2.getVariableName() + commonSuffix;
                }
                if (s1.equals(composedString1) && s2.equals(composedString2)) {
                    Replacement replacement = new Replacement(declaration1.getVariableName(), declaration2.getVariableName(), Replacement.ReplacementType.VARIABLE_NAME);
                    replacementInfo.addReplacement(replacement);
                    return true;
                }
                if (s1.startsWith("catch(") && s2.startsWith("catch(") && !declaration1.equalType(declaration2)) {
                    boolean containsAnotherUnmatchedCatch1 = false;
                    for (AbstractCodeFragment abstractCodeFragment : replacementInfo.getStatements1()) {
                        if (!abstractCodeFragment.getString().startsWith("catch(")) continue;
                        containsAnotherUnmatchedCatch1 = true;
                        break;
                    }
                    boolean containsAnotherUnmatchedCatch2 = false;
                    for (AbstractCodeFragment abstractCodeFragment : replacementInfo.getStatements2()) {
                        if (!abstractCodeFragment.getString().startsWith("catch(")) continue;
                        containsAnotherUnmatchedCatch2 = true;
                        break;
                    }
                    if (!containsAnotherUnmatchedCatch1 && !containsAnotherUnmatchedCatch2) {
                        if (!declaration1.getVariableName().equals(declaration2.getVariableName())) {
                            Replacement replacement = new Replacement(declaration1.getVariableName(), declaration2.getVariableName(), Replacement.ReplacementType.VARIABLE_NAME);
                            replacementInfo.addReplacement(replacement);
                        }
                        Replacement replacement = new Replacement(declaration1.getType().toString(), declaration2.getType().toString(), Replacement.ReplacementType.TYPE);
                        replacementInfo.addReplacement(replacement);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean oneIsVariableDeclarationTheOtherIsVariableAssignment(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        if (variableDeclarations1.size() > 0 && variableDeclarations2.size() > 0) {
            String name1 = variableDeclarations1.get(0).getVariableName();
            String name2 = variableDeclarations2.get(0).getVariableName();
            AbstractExpression abstractExpression = variableDeclarations1.get(0).getInitializer();
            AbstractExpression initializer2 = variableDeclarations2.get(0).getInitializer();
            if (abstractExpression != null && initializer2 != null && !name1.equals(name2) && !abstractExpression.getString().equals(initializer2.getString())) {
                return false;
            }
        }
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (s1.contains("=") && s2.contains("=")) {
            if (s1.equals(commonSuffix) || s2.equals(commonSuffix)) {
                if (replacementInfo.getReplacements().size() == 2) {
                    sb = new StringBuilder();
                    boolean bl = false;
                    for (Replacement replacement : replacementInfo.getReplacements()) {
                        void var7_9;
                        sb.append(replacement.getAfter());
                        if (var7_9 == false) {
                            sb.append("=");
                        } else if (var7_9 == true) {
                            sb.append(";\n");
                        }
                        ++var7_9;
                    }
                    if (commonSuffix.equals(sb.toString())) {
                        return false;
                    }
                } else if (replacementInfo.getReplacements().size() == 1 && commonSuffix.endsWith("=false;\n")) {
                    sb = new StringBuilder();
                    for (Replacement r : replacementInfo.getReplacements()) {
                        sb.append(r.getAfter());
                    }
                    sb.append("=false;\n");
                    if (commonSuffix.equals(sb.toString())) {
                        return false;
                    }
                } else if (replacementInfo.getReplacements().size() == 1 && commonSuffix.endsWith("=true;\n")) {
                    sb = new StringBuilder();
                    for (Replacement r : replacementInfo.getReplacements()) {
                        sb.append(r.getAfter());
                    }
                    sb.append("=true;\n");
                    if (commonSuffix.equals(sb.toString())) {
                        return false;
                    }
                } else {
                    void var7_13;
                    String prefix = null;
                    prefix = s1.equals(commonSuffix) ? s2.substring(0, s2.indexOf(commonSuffix)) : s1.substring(0, s1.indexOf(commonSuffix));
                    boolean bl = false;
                    for (int i = 0; i < prefix.length(); ++i) {
                        if (prefix.charAt(i) != ' ') continue;
                        ++var7_13;
                    }
                    if (var7_13 > 2) {
                        return false;
                    }
                }
                for (Replacement replacement : replacementInfo.getReplacements()) {
                    if (variableDeclarations1.size() > 0 && replacement.getBefore().equals(variableDeclarations1.get(0).getVariableName())) {
                        if (!replacement.getAfter().contains("[") || !replacement.getAfter().contains("]") || variableDeclarations2.size() != 0) continue;
                        String arrayName = replacement.getAfter().substring(0, replacement.getAfter().indexOf("["));
                        for (AbstractCodeFragment abstractCodeFragment : replacementInfo.getStatements2()) {
                            if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !abstractCodeFragment.getVariableDeclarations().get(0).getVariableName().equals(arrayName)) continue;
                            return false;
                        }
                        continue;
                    }
                    if (variableDeclarations2.size() <= 0 || !replacement.getAfter().equals(variableDeclarations2.get(0).getVariableName()) || !replacement.getBefore().contains("[") || !replacement.getBefore().contains("]") || variableDeclarations1.size() != 0) continue;
                    String arrayName = replacement.getBefore().substring(0, replacement.getBefore().indexOf("["));
                    for (AbstractCodeFragment abstractCodeFragment : replacementInfo.getStatements1()) {
                        if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !abstractCodeFragment.getVariableDeclarations().get(0).getVariableName().equals(arrayName)) continue;
                        return false;
                    }
                }
                return true;
            }
            if (commonSuffix.contains("=") && replacementInfo.getReplacements().size() == 0) {
                int i;
                int numberOfSpaces;
                for (AbstractCodeFragment abstractCodeFragment : replacementInfo.getStatements1()) {
                    for (VariableDeclaration variableDeclaration : abstractCodeFragment.getVariableDeclarations()) {
                        if (!s1.equals(variableDeclaration.getVariableName() + "." + commonSuffix)) continue;
                        String string = s2.substring(0, s2.indexOf(commonSuffix));
                        numberOfSpaces = 0;
                        for (i = 0; i < string.length(); ++i) {
                            if (string.charAt(i) != ' ') continue;
                            ++numberOfSpaces;
                        }
                        if (numberOfSpaces > 2) continue;
                        return true;
                    }
                }
                for (AbstractCodeFragment abstractCodeFragment : replacementInfo.getStatements2()) {
                    for (VariableDeclaration variableDeclaration : abstractCodeFragment.getVariableDeclarations()) {
                        if (!s2.equals(variableDeclaration.getVariableName() + "." + commonSuffix)) continue;
                        String string = s1.substring(0, s1.indexOf(commonSuffix));
                        numberOfSpaces = 0;
                        for (i = 0; i < string.length(); ++i) {
                            if (string.charAt(i) != ' ') continue;
                            ++numberOfSpaces;
                        }
                        if (numberOfSpaces > 2) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected static boolean oneIsVariableDeclarationTheOtherIsReturnStatement(String s1, String s2, List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2) {
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!(commonSuffix.equals("null;\n") || commonSuffix.equals("true;\n") || commonSuffix.equals("false;\n") || commonSuffix.equals("0;\n"))) {
            if (s1.startsWith("return ") && s1.substring(7, s1.length()).equals(commonSuffix) && s2.contains("=") && s2.substring(s2.indexOf("=") + 1, s2.length()).equals(commonSuffix)) {
                return true;
            }
            if (s2.startsWith("return ") && s2.substring(7, s2.length()).equals(commonSuffix) && s1.contains("=") && s1.substring(s1.indexOf("=") + 1, s1.length()).equals(commonSuffix)) {
                return true;
            }
        }
        if (variableDeclarations1.size() == 0 && variableDeclarations2.size() == 0 && commonSuffix.equals("0;\n")) {
            if (s1.startsWith("return ") && s1.substring(7, s1.length()).equals(commonSuffix) && s2.contains("=") && s2.substring(s2.indexOf("=") + 1, s2.length()).equals(commonSuffix)) {
                return true;
            }
            if (s2.startsWith("return ") && s2.substring(7, s2.length()).equals(commonSuffix) && s1.contains("=") && s1.substring(s1.indexOf("=") + 1, s1.length()).equals(commonSuffix)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean equalAfterNewArgumentAdditions(String s1, String s2, UMLOperationBodyMapper.ReplacementInfo replacementInfo, VariableDeclarationContainer container1, VariableDeclarationContainer container2, UMLOperationDiff operationSignatureDiff, UMLAbstractClassDiff classDiff) {
        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(s1, s2);
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!(commonPrefix.isEmpty() || commonSuffix.isEmpty() || commonPrefix.equals("return "))) {
            String characterAfterCommonPrefix;
            Object diff2;
            int endIndexS1;
            int beginIndexS1 = s1.indexOf(commonPrefix) + commonPrefix.length();
            Object diff1 = beginIndexS1 > (endIndexS1 = s1.lastIndexOf(commonSuffix)) ? "" : s1.substring(beginIndexS1, endIndexS1);
            int beginIndexS2 = s2.indexOf(commonPrefix) + commonPrefix.length();
            int endIndexS2 = s2.lastIndexOf(commonSuffix);
            Object object = diff2 = beginIndexS2 > endIndexS2 ? "" : s2.substring(beginIndexS2, endIndexS2);
            if (beginIndexS1 > endIndexS1 && ((String)(diff2 = (String)diff2 + commonSuffix.substring(0, beginIndexS1 - endIndexS1))).charAt(((String)diff2).length() - 1) == ',') {
                diff2 = ((String)diff2).substring(0, ((String)diff2).length() - 1);
            }
            String string = characterAfterCommonPrefix = s1.equals(commonPrefix) ? "" : Character.toString(s1.charAt(commonPrefix.length()));
            if (commonPrefix.contains(",") && commonPrefix.lastIndexOf(",") < commonPrefix.length() - 1 && !characterAfterCommonPrefix.equals(",") && !characterAfterCommonPrefix.equals(")")) {
                String prepend = commonPrefix.substring(commonPrefix.lastIndexOf(",") + 1, commonPrefix.length());
                diff1 = prepend + (String)diff1;
                diff2 = prepend + (String)diff2;
            }
            if (((String)diff1).contains(",") && ((String)diff2).contains(",")) {
                String beforeComma1 = ((String)diff1).substring(0, ((String)diff1).indexOf(","));
                String afterComma1 = ((String)diff1).substring(((String)diff1).indexOf(",") + 1, ((String)diff1).length());
                String beforeComma2 = ((String)diff2).substring(0, ((String)diff2).indexOf(","));
                String afterComma2 = ((String)diff2).substring(((String)diff2).indexOf(",") + 1, ((String)diff2).length());
                if (beforeComma1.equals(afterComma2) && beforeComma2.equals(afterComma1)) {
                    boolean conflictReplacement = false;
                    for (Replacement replacement : replacementInfo.getReplacements()) {
                        if (!replacement.getAfter().equals(beforeComma2)) continue;
                        conflictReplacement = true;
                        break;
                    }
                    if (!conflictReplacement) {
                        SwapArgumentReplacement r = new SwapArgumentReplacement(beforeComma1, beforeComma2);
                        replacementInfo.getReplacements().add(r);
                        return true;
                    }
                }
            }
            if (((String)diff1).isEmpty() || container1.getParameterNameList().contains(diff1) && !container2.getParameterNameList().contains(diff1) && !StringBasedHeuristics.containsMethodSignatureOfAnonymousClass((String)diff2) || classDiff != null && classDiff.getOriginalClass().containsAttributeWithName((String)diff1) && !classDiff.getNextClass().containsAttributeWithName((String)diff1) && !StringBasedHeuristics.containsMethodSignatureOfAnonymousClass((String)diff2)) {
                StringBuilder concat;
                Object matchingReplacement;
                ArrayList<Object> matchingAddedParameters = new ArrayList<Object>();
                List<Object> addedParameters = operationSignatureDiff != null ? operationSignatureDiff.getAddedParameters() : Collections.emptyList();
                for (Object addedParameter : addedParameters) {
                    if (!((String)diff2).contains(((UMLParameter)addedParameter).getName())) continue;
                    matchingAddedParameters.add(addedParameter);
                }
                if (matchingAddedParameters.size() > 0) {
                    LinkedHashSet<String> splitVariables;
                    Replacement matchingReplacement2 = null;
                    for (Replacement replacement : replacementInfo.getReplacements()) {
                        if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) {
                            List<Object> parameterDiffList = operationSignatureDiff != null ? operationSignatureDiff.getParameterDiffList() : Collections.emptyList();
                            for (UMLParameterDiff uMLParameterDiff : parameterDiffList) {
                                if (!uMLParameterDiff.isNameChanged() || !replacement.getBefore().equals(uMLParameterDiff.getRemovedParameter().getName()) || !replacement.getAfter().equals(uMLParameterDiff.getAddedParameter().getName())) continue;
                                matchingReplacement2 = replacement;
                                break;
                            }
                        }
                        if (matchingReplacement2 == null) continue;
                        break;
                    }
                    if (matchingReplacement2 != null) {
                        splitVariables = new LinkedHashSet();
                        splitVariables.add(matchingReplacement2.getAfter());
                        StringBuilder concat2 = new StringBuilder();
                        int counter = 0;
                        for (UMLParameter uMLParameter : matchingAddedParameters) {
                            splitVariables.add(uMLParameter.getName());
                            concat2.append(uMLParameter.getName());
                            if (counter < matchingAddedParameters.size() - 1) {
                                concat2.append(",");
                            }
                            ++counter;
                        }
                        SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement(matchingReplacement2.getBefore(), splitVariables);
                        if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat2.toString().equals(diff2)) {
                            replacementInfo.getReplacements().remove(matchingReplacement2);
                            replacementInfo.getReplacements().add(splitVariableReplacement);
                            return true;
                        }
                    } else if (((String)diff1).isEmpty() && replacementInfo.getReplacements().isEmpty()) {
                        LinkedHashSet<String> addedVariables = new LinkedHashSet<String>();
                        StringBuilder concat3 = new StringBuilder();
                        int counter = 0;
                        for (UMLParameter uMLParameter : matchingAddedParameters) {
                            addedVariables.add(uMLParameter.getName());
                            concat3.append(uMLParameter.getName());
                            if (counter < matchingAddedParameters.size() - 1) {
                                concat3.append(",");
                            }
                            ++counter;
                        }
                        if (concat3.toString().equals(diff2)) {
                            AddVariableReplacement addVariableReplacement = new AddVariableReplacement(addedVariables);
                            replacementInfo.getReplacements().add(addVariableReplacement);
                            return true;
                        }
                    }
                    if (container1.getParameterNameList().contains(diff1)) {
                        splitVariables = new LinkedHashSet<String>();
                        StringBuilder concat4 = new StringBuilder();
                        int counter = 0;
                        for (UMLParameter uMLParameter : matchingAddedParameters) {
                            splitVariables.add(uMLParameter.getName());
                            concat4.append(uMLParameter.getName());
                            if (counter < matchingAddedParameters.size() - 1) {
                                concat4.append(",");
                            }
                            ++counter;
                        }
                        SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement((String)diff1, splitVariables);
                        if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat4.toString().equals(diff2)) {
                            replacementInfo.getReplacements().add(splitVariableReplacement);
                            return true;
                        }
                    }
                }
                if (classDiff != null) {
                    ArrayList<UMLAttribute> matchingAttributes = new ArrayList<UMLAttribute>();
                    for (UMLAttribute attribute : classDiff.getNextClass().getAttributes()) {
                        if (!((String)diff2).contains(attribute.getName())) continue;
                        matchingAttributes.add(attribute);
                    }
                    if (matchingAttributes.size() > 0) {
                        LinkedHashSet<String> splitVariables;
                        matchingReplacement = null;
                        for (Replacement replacement : replacementInfo.getReplacements()) {
                            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || !classDiff.getOriginalClass().containsAttributeWithName(replacement.getBefore()) || !classDiff.getNextClass().containsAttributeWithName(replacement.getAfter())) continue;
                            matchingReplacement = replacement;
                            break;
                        }
                        if (matchingReplacement != null) {
                            splitVariables = new LinkedHashSet<String>();
                            splitVariables.add(((Replacement)matchingReplacement).getAfter());
                            concat = new StringBuilder();
                            boolean bl = false;
                            for (UMLAttribute attribute : matchingAttributes) {
                                void var22_45;
                                splitVariables.add(attribute.getName());
                                concat.append(attribute.getName());
                                if (var22_45 < matchingAttributes.size() - 1) {
                                    concat.append(",");
                                }
                                ++var22_45;
                            }
                            SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement(((Replacement)matchingReplacement).getBefore(), splitVariables);
                            if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                                replacementInfo.getReplacements().remove(matchingReplacement);
                                replacementInfo.getReplacements().add(splitVariableReplacement);
                                return true;
                            }
                        } else if (((String)diff1).isEmpty() && replacementInfo.getReplacements().isEmpty()) {
                            LinkedHashSet<String> addedVariables = new LinkedHashSet<String>();
                            concat = new StringBuilder();
                            boolean bl = false;
                            for (UMLAttribute attribute : matchingAttributes) {
                                void var22_47;
                                addedVariables.add(attribute.getName());
                                concat.append(attribute.getName());
                                if (var22_47 < matchingAttributes.size() - 1) {
                                    concat.append(",");
                                }
                                ++var22_47;
                            }
                            if (concat.toString().equals(diff2)) {
                                AddVariableReplacement addVariableReplacement = new AddVariableReplacement(addedVariables);
                                replacementInfo.getReplacements().add(addVariableReplacement);
                                return true;
                            }
                        }
                        if (classDiff.getOriginalClass().containsAttributeWithName((String)diff1)) {
                            splitVariables = new LinkedHashSet();
                            concat = new StringBuilder();
                            boolean bl = false;
                            for (UMLAttribute attribute : matchingAttributes) {
                                void var22_49;
                                splitVariables.add(attribute.getName());
                                concat.append(attribute.getName());
                                if (var22_49 < matchingAttributes.size() - 1) {
                                    concat.append(",");
                                }
                                ++var22_49;
                            }
                            SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement((String)diff1, splitVariables);
                            if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                                replacementInfo.getReplacements().add(splitVariableReplacement);
                                return true;
                            }
                        }
                    }
                }
                ArrayList<VariableDeclaration> matchingVariableDeclarations = new ArrayList<VariableDeclaration>();
                for (VariableDeclaration declaration : container2.getAllVariableDeclarations()) {
                    if (!((String)diff2).contains(declaration.getVariableName())) continue;
                    matchingVariableDeclarations.add(declaration);
                }
                if (matchingVariableDeclarations.size() > 0) {
                    LinkedHashSet<String> splitVariables;
                    matchingReplacement = null;
                    for (Replacement replacement : replacementInfo.getReplacements()) {
                        boolean isCastExpression;
                        if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) continue;
                        int n = s1.indexOf(replacement.getAfter());
                        int n2 = s2.indexOf(replacement.getAfter());
                        int characterIndex1 = n + replacement.getAfter().length();
                        int characterIndex2 = n2 + replacement.getAfter().length();
                        boolean isVariableDeclarationReplacement = !(characterIndex1 >= s1.length() || s1.charAt(characterIndex1) != '=' && s1.charAt(characterIndex1) != '.' || characterIndex2 >= s2.length() || s2.charAt(characterIndex2) != '=' && s2.charAt(characterIndex2) != '.');
                        boolean bl = isCastExpression = n > 0 && s1.charAt(n - 1) == ')' && n2 > 0 && s2.charAt(n2 - 1) == ')';
                        if (isVariableDeclarationReplacement || isCastExpression || container1.getVariableDeclaration(replacement.getBefore()) == null || container2.getVariableDeclaration(replacement.getAfter()) == null) continue;
                        matchingReplacement = replacement;
                        break;
                    }
                    if (matchingReplacement != null) {
                        splitVariables = new LinkedHashSet<String>();
                        splitVariables.add(((Replacement)matchingReplacement).getAfter());
                        concat = new StringBuilder();
                        boolean bl = false;
                        for (VariableDeclaration declaration : matchingVariableDeclarations) {
                            void var22_52;
                            splitVariables.add(declaration.getVariableName());
                            concat.append(declaration.getVariableName());
                            if (var22_52 < matchingVariableDeclarations.size() - 1) {
                                concat.append(",");
                            }
                            ++var22_52;
                        }
                        SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement(((Replacement)matchingReplacement).getBefore(), splitVariables);
                        if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                            replacementInfo.getReplacements().remove(matchingReplacement);
                            replacementInfo.getReplacements().add(splitVariableReplacement);
                            return true;
                        }
                    } else if (((String)diff1).isEmpty() && replacementInfo.getReplacements().isEmpty()) {
                        LinkedHashSet<String> addedVariables = new LinkedHashSet<String>();
                        concat = new StringBuilder();
                        boolean bl = false;
                        for (VariableDeclaration declaration : matchingVariableDeclarations) {
                            void var22_54;
                            addedVariables.add(declaration.getVariableName());
                            concat.append(declaration.getVariableName());
                            if (var22_54 < matchingVariableDeclarations.size() - 1) {
                                concat.append(",");
                            }
                            ++var22_54;
                        }
                        if (concat.toString().equals(diff2)) {
                            AddVariableReplacement addVariableReplacement = new AddVariableReplacement(addedVariables);
                            replacementInfo.getReplacements().add(addVariableReplacement);
                            return true;
                        }
                    }
                    if (container1.getVariableDeclaration((String)diff1) != null) {
                        splitVariables = new LinkedHashSet();
                        concat = new StringBuilder();
                        boolean bl = false;
                        for (VariableDeclaration declaration : matchingVariableDeclarations) {
                            void var22_56;
                            splitVariables.add(declaration.getVariableName());
                            concat.append(declaration.getVariableName());
                            if (var22_56 < matchingVariableDeclarations.size() - 1) {
                                concat.append(",");
                            }
                            ++var22_56;
                        }
                        SplitVariableReplacement splitVariableReplacement = new SplitVariableReplacement((String)diff1, splitVariables);
                        if (!splitVariableReplacement.getSplitVariables().contains(splitVariableReplacement.getBefore()) && concat.toString().equals(diff2)) {
                            replacementInfo.getReplacements().add(splitVariableReplacement);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    protected static boolean equalAfterArgumentMerge(String s1, String s2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        LinkedHashMap commonVariableReplacementMap = new LinkedHashMap();
        boolean mergeFound = false;
        for (Replacement replacement : replacementInfo.getReplacements()) {
            Replacement r;
            String diff2;
            int endIndexS2;
            int beginIndexS2;
            String diff1;
            int endIndexS1;
            int beginIndexS1;
            String commonSuffix;
            String commonPrefix;
            LinkedHashSet<Replacement> replacements;
            String reservedTokens2;
            Object reservedTokens1;
            int index;
            String key;
            if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME)) {
                key = replacement.getAfter();
                if (commonVariableReplacementMap.containsKey(key)) {
                    ((Set)commonVariableReplacementMap.get(key)).add(replacement);
                    index = ((String)s1).indexOf(key);
                    if (index != -1) {
                        if (!((String)s1).endsWith(key) && ((String)s1).charAt(index + key.length()) == ',') {
                            s1 = ((String)s1).substring(0, index) + ((String)s1).substring(index + key.length() + 1, ((String)s1).length());
                        } else if (index > 0 && ((String)s1).charAt(index - 1) == ',') {
                            s1 = ((String)s1).substring(0, index - 1) + ((String)s1).substring(index + key.length(), ((String)s1).length());
                        }
                    }
                } else {
                    LinkedHashSet<Replacement> replacements2 = new LinkedHashSet<Replacement>();
                    replacements2.add(replacement);
                    commonVariableReplacementMap.put(key, replacements2);
                }
                if (!((String)s1).equals(s2)) continue;
                mergeFound = true;
                continue;
            }
            if (!replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_THIS_EXPRESSION) || (index = ((String)s1).indexOf(key = replacement.getAfter())) == -1) continue;
            if (!((String)s1).endsWith(key) && ((String)s1).charAt(index + key.length()) == ',') {
                reservedTokens1 = ReplacementUtil.keepReservedTokens((String)(s1 = ((String)s1).substring(0, index) + ((String)s1).substring(index + key.length() + 1, ((String)s1).length())));
                if (!StringBasedHeuristics.compatibleReservedTokens((String)reservedTokens1, reservedTokens2 = ReplacementUtil.keepReservedTokens(s2))) continue;
                replacements = new LinkedHashSet<Replacement>();
                replacements.add(replacement);
                commonVariableReplacementMap.put(key, replacements);
                if (((String)s1).contains("=") && !s2.contains("=") && !((String)s1).startsWith("return ") && s2.startsWith("return ")) {
                    s1 = ((String)s1).substring(((String)s1).indexOf("=") + 1);
                    s2 = s2.substring(7);
                }
                commonPrefix = PrefixSuffixUtils.longestCommonPrefix((String)s1, s2);
                commonSuffix = PrefixSuffixUtils.longestCommonSuffix((String)s1, s2);
                if (commonPrefix.isEmpty() || commonSuffix.isEmpty()) continue;
                beginIndexS1 = ((String)s1).indexOf(commonPrefix) + commonPrefix.length();
                diff1 = beginIndexS1 > (endIndexS1 = ((String)s1).lastIndexOf(commonSuffix)) ? "" : ((String)s1).substring(beginIndexS1, endIndexS1);
                beginIndexS2 = s2.indexOf(commonPrefix) + commonPrefix.length();
                endIndexS2 = s2.lastIndexOf(commonSuffix);
                String string = diff2 = beginIndexS2 > endIndexS2 ? "" : s2.substring(beginIndexS2, endIndexS2);
                if (diff1.isEmpty() || diff2.isEmpty() || !diff2.equals(key)) continue;
                r = new Replacement(diff1, diff2, replacement.getType());
                ((Set)commonVariableReplacementMap.get(key)).add(r);
                mergeFound = true;
                continue;
            }
            if (index <= 0 || ((String)s1).charAt(index - 1) != ',' || !StringBasedHeuristics.compatibleReservedTokens((String)(reservedTokens1 = ReplacementUtil.keepReservedTokens((String)(s1 = ((String)s1).substring(0, index - 1) + ((String)s1).substring(index + key.length(), ((String)s1).length())))), reservedTokens2 = ReplacementUtil.keepReservedTokens(s2))) continue;
            replacements = new LinkedHashSet();
            replacements.add(replacement);
            commonVariableReplacementMap.put(key, replacements);
            if (((String)s1).contains("=") && !s2.contains("=") && !((String)s1).startsWith("return ") && s2.startsWith("return ")) {
                s1 = ((String)s1).substring(((String)s1).indexOf("=") + 1);
                s2 = s2.substring(7);
            }
            commonPrefix = PrefixSuffixUtils.longestCommonPrefix((String)s1, s2);
            commonSuffix = PrefixSuffixUtils.longestCommonSuffix((String)s1, s2);
            if (commonPrefix.isEmpty() || commonSuffix.isEmpty()) continue;
            beginIndexS1 = ((String)s1).indexOf(commonPrefix) + commonPrefix.length();
            diff1 = beginIndexS1 > (endIndexS1 = ((String)s1).lastIndexOf(commonSuffix)) ? "" : ((String)s1).substring(beginIndexS1, endIndexS1);
            beginIndexS2 = s2.indexOf(commonPrefix) + commonPrefix.length();
            endIndexS2 = s2.lastIndexOf(commonSuffix);
            String string = diff2 = beginIndexS2 > endIndexS2 ? "" : s2.substring(beginIndexS2, endIndexS2);
            if (diff1.isEmpty() || diff2.isEmpty() || !diff2.equals(key)) continue;
            r = new Replacement(diff1, diff2, replacement.getType());
            ((Set)commonVariableReplacementMap.get(key)).add(r);
            mergeFound = true;
        }
        if (mergeFound) {
            for (String key : commonVariableReplacementMap.keySet()) {
                Set replacements = (Set)commonVariableReplacementMap.get(key);
                if (replacements.size() <= 1) continue;
                replacementInfo.getReplacements().removeAll(replacements);
                LinkedHashSet<String> mergedVariables = new LinkedHashSet<String>();
                for (Replacement replacement : replacements) {
                    mergedVariables.add(replacement.getBefore());
                }
                MergeVariableReplacement merge = new MergeVariableReplacement(mergedVariables, key);
                replacementInfo.getReplacements().add(merge);
            }
            return true;
        }
        return false;
    }

    private static boolean compatibleReservedTokens(String reservedTokens1, String reservedTokens2) {
        if (reservedTokens1.equals(reservedTokens2)) {
            return true;
        }
        if (reservedTokens1.contains("(") && reservedTokens2.contains("(")) {
            String s1 = reservedTokens1.substring(reservedTokens1.indexOf("("));
            String s2 = reservedTokens2.substring(reservedTokens2.indexOf("("));
            return s1.equals(s2);
        }
        return false;
    }

    protected static boolean validStatementForConcatComparison(AbstractCodeFragment statement1, AbstractCodeFragment statement2) {
        List<VariableDeclaration> variableDeclarations1 = statement1.getVariableDeclarations();
        List<VariableDeclaration> variableDeclarations2 = statement2.getVariableDeclarations();
        if (variableDeclarations1.size() == variableDeclarations2.size()) {
            return true;
        }
        if (variableDeclarations1.size() > 0 && variableDeclarations2.size() == 0 && statement2.getString().startsWith("return ")) {
            return true;
        }
        return variableDeclarations1.size() == 0 && variableDeclarations2.size() > 0 && statement1.getString().startsWith("return ");
    }

    protected static boolean containsValidOperatorReplacements(UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        List<Replacement> operatorReplacements = replacementInfo.getReplacements(Replacement.ReplacementType.INFIX_OPERATOR);
        for (Replacement replacement : operatorReplacements) {
            if (replacement.getBefore().equals("==") && !replacement.getAfter().equals("!=")) {
                return false;
            }
            if (replacement.getBefore().equals("!=") && !replacement.getAfter().equals("==")) {
                return false;
            }
            if (replacement.getBefore().equals("&&") && !replacement.getAfter().equals("||")) {
                return false;
            }
            if (!replacement.getBefore().equals("||") || replacement.getAfter().equals("&&")) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean commonConcat(String s1, String s2, Map<String, String> parameterToArgumentMap, UMLOperationBodyMapper.ReplacementInfo info, AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperationBodyMapper mapper) {
        boolean arrayCreation2;
        VariableDeclarationContainer container1 = mapper.getContainer1();
        VariableDeclarationContainer container2 = mapper.getContainer2();
        ObjectCreation creationCoveringTheEntireStatement1 = statement1.creationCoveringEntireFragment();
        ObjectCreation creationCoveringTheEntireStatement2 = statement2.creationCoveringEntireFragment();
        boolean arrayCreation1 = creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement1.isArray();
        boolean bl = arrayCreation2 = creationCoveringTheEntireStatement2 != null && creationCoveringTheEntireStatement2.isArray();
        if (!(arrayCreation1 || arrayCreation2 || StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(s1) || StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(s2))) {
            int i;
            if (s1.contains(" + ") && s2.contains(" + ")) {
                tokens1 = new LinkedHashSet<String>(Arrays.asList(SPLIT_CONCAT_STRING_PATTERN.split(s1)));
                tokens2 = new LinkedHashSet<String>(Arrays.asList(SPLIT_CONCAT_STRING_PATTERN.split(s2)));
                LinkedHashSet<String> intersection = new LinkedHashSet<String>();
                for (String string : tokens1) {
                    for (String string2 : tokens2) {
                        String string3;
                        if (string.equals(string2)) {
                            intersection.add(string);
                            continue;
                        }
                        if (string.equals(string2 + ";\n")) {
                            intersection.add(string2);
                            continue;
                        }
                        if (string2.equals(string + ";\n")) {
                            intersection.add(string);
                            continue;
                        }
                        if (string2.endsWith("+=" + string)) {
                            intersection.add(string);
                            continue;
                        }
                        if (string.endsWith("+=" + string2)) {
                            intersection.add(string2);
                            continue;
                        }
                        if (!string.endsWith(");\n") || !string2.endsWith(";\n") || (string3 = PrefixSuffixUtils.longestCommonPrefix(string, string2)).length() != string.length() - 3 || string3.length() != string2.length() - 2) continue;
                        intersection.add(string3);
                    }
                }
                filteredIntersection = new LinkedHashSet();
                for (Object common : intersection) {
                    boolean bl2 = false;
                    for (Replacement r : info.getReplacements()) {
                        if (!r.getBefore().contains((CharSequence)common) && !r.getAfter().contains((CharSequence)common)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    filteredIntersection.add(common);
                }
                LinkedHashSet<LeafMapping> linkedHashSet = new LinkedHashSet<LeafMapping>();
                for (String string : filteredIntersection) {
                    List<LeafExpression> list = statement1.findExpression(string);
                    expressions2 = statement2.findExpression(string);
                    if (list.size() != expressions2.size()) continue;
                    for (i = 0; i < list.size(); ++i) {
                        LeafMapping leafMapping = new LeafMapping(list.get(i), expressions2.get(i), container1, container2);
                        linkedHashSet.add(leafMapping);
                    }
                }
                int size = filteredIntersection.size();
                int n = Math.max(tokens1.size(), tokens2.size()) - size;
                if (size > 0 && size > n || size > 1 && size >= n || size > 1 && linkedHashSet.size() == size) {
                    ArrayList<String> arrayList = new ArrayList<String>(tokens1);
                    ArrayList<String> tokens2AsList = new ArrayList<String>(tokens2);
                    int counter = 0;
                    boolean allTokensMatchInTheSameOrder = true;
                    for (Object s : filteredIntersection) {
                        if (!((String)arrayList.get(counter)).equals(s)) {
                            allTokensMatchInTheSameOrder = false;
                            break;
                        }
                        if (!((String)tokens2AsList.get(counter)).equals(s)) {
                            allTokensMatchInTheSameOrder = false;
                            break;
                        }
                        ++counter;
                    }
                    if (allTokensMatchInTheSameOrder && tokens1.size() == size + 1 && tokens2.size() == size + 1) {
                        return false;
                    }
                    IntersectionReplacement r = new IntersectionReplacement(s1, s2, Replacement.ReplacementType.CONCATENATION);
                    for (LeafMapping m : linkedHashSet) {
                        r.addSubExpressionMapping(m);
                    }
                    info.getReplacements().add(r);
                    return true;
                }
            } else if (s1.contains(" + ") && !s2.contains(" + ") && !s1.contains(",") && s2.contains(",")) {
                tokens1 = Arrays.asList(SPLIT_CONCAT_STRING_PATTERN.split(s1));
                tokens2 = Arrays.asList(SPLIT_COMMA_PATTERN.split(s2));
                commonTokens = new ArrayList<String>();
                for (String string : tokens1) {
                    if (!tokens2.contains(string)) continue;
                    commonTokens.add(string);
                }
                filteredIntersection = new LinkedHashSet();
                for (Object common : commonTokens) {
                    boolean bl3 = false;
                    for (Replacement r : info.getReplacements()) {
                        if (!r.getBefore().contains((CharSequence)common) && !r.getAfter().contains((CharSequence)common)) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    filteredIntersection.add(common);
                }
                if (filteredIntersection.size() > 0) {
                    IntersectionReplacement intersectionReplacement = new IntersectionReplacement(s1, s2, Replacement.ReplacementType.CONCATENATION);
                    for (String string : filteredIntersection) {
                        List<LeafExpression> list = statement1.findExpression(string);
                        expressions2 = statement2.findExpression(string);
                        if (list.size() != expressions2.size()) continue;
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            LeafMapping leafMapping = new LeafMapping(list.get(i2), expressions2.get(i2), container1, container2);
                            intersectionReplacement.addSubExpressionMapping(leafMapping);
                        }
                    }
                    info.getReplacements().add(intersectionReplacement);
                    return true;
                }
            } else if (s1.contains(" + ") ^ s2.contains(" + ") && s1.contains(",") && s2.contains(",")) {
                tokens1 = Arrays.asList(SPLIT_COMMA_PATTERN.split(s1));
                tokens2 = Arrays.asList(SPLIT_COMMA_PATTERN.split(s2));
                commonTokens = new ArrayList();
                block13: for (String string : tokens1) {
                    String token1WithoutDoubleQuotes = string.replaceAll("\"", "");
                    if (tokens2.contains(string)) {
                        commonTokens.add(string);
                        continue;
                    }
                    for (String string4 : tokens2) {
                        String token2WithoutDoubleQuotes = string4.replaceAll("\"", "");
                        if (token2WithoutDoubleQuotes.contains(token1WithoutDoubleQuotes)) {
                            commonTokens.add(string);
                            continue block13;
                        }
                        if (!token1WithoutDoubleQuotes.contains(token2WithoutDoubleQuotes)) continue;
                        commonTokens.add(string4);
                        continue block13;
                    }
                }
                filteredIntersection = new LinkedHashSet<Object>();
                for (Object common : commonTokens) {
                    boolean bl4 = false;
                    for (Replacement r : info.getReplacements()) {
                        if (!r.getBefore().contains((CharSequence)common) && !r.getAfter().contains((CharSequence)common) && !((String)common).contains(r.getBefore()) && !((String)common).contains(r.getAfter())) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) continue;
                    filteredIntersection.add(common);
                }
                if (filteredIntersection.size() == Math.min(tokens1.size(), tokens2.size())) {
                    IntersectionReplacement intersectionReplacement = new IntersectionReplacement(s1, s2, Replacement.ReplacementType.CONCATENATION);
                    for (String string : filteredIntersection) {
                        List<LeafExpression> list = statement1.findExpression(string);
                        expressions2 = statement2.findExpression(string);
                        if (list.size() != expressions2.size()) continue;
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            LeafMapping leafMapping = new LeafMapping(list.get(i3), expressions2.get(i3), container1, container2);
                            intersectionReplacement.addSubExpressionMapping(leafMapping);
                        }
                    }
                    info.getReplacements().add(intersectionReplacement);
                    return true;
                }
            } else if (s1.contains(",") && s1.contains("(") && s1.contains(")") && !s2.contains(",") && !s2.contains("(") && !s2.contains(")")) {
                List<LeafExpression> variables1 = statement1.getVariables();
                List<LeafExpression> variables2 = statement2.getVariables();
                List<VariableDeclaration> variableDeclarations1 = statement1.getVariableDeclarations();
                List<VariableDeclaration> variableDeclarations2 = statement2.getVariableDeclarations();
                if (variableDeclarations1.size() > 0 && variableDeclarations2.size() > 0 && variableDeclarations1.toString().equals(variableDeclarations2.toString()) || variables1.size() > 0 && variables2.size() > 0 && statement1.getString().startsWith(variables1.get(0).getString() + "=") && statement2.getString().startsWith(variables2.get(0).getString() + "=") && variables1.get(0).getString().equals(variables2.get(0).getString())) {
                    List<String> list = Arrays.asList(SPLIT_COMMA_PATTERN.split(s1.substring(s1.indexOf("(") + 1, s1.lastIndexOf(")"))));
                    int count = 0;
                    for (String string : list) {
                        void var20_62;
                        if (string.startsWith("-")) {
                            String string5 = "- " + string.substring(1);
                        }
                        if (!ReplacementUtil.contains(s2, (String)var20_62)) continue;
                        ++count;
                    }
                    if (count > 1 && count == list.size()) {
                        IntersectionReplacement intersectionReplacement = new IntersectionReplacement(s1, s2, Replacement.ReplacementType.CONCATENATION);
                        for (String key : list) {
                            List<LeafExpression> expressions1 = statement1.findExpression(key);
                            List<LeafExpression> expressions2 = statement2.findExpression(key);
                            if (expressions1.size() != expressions2.size()) continue;
                            for (int i4 = 0; i4 < expressions1.size(); ++i4) {
                                LeafMapping leafMapping = new LeafMapping(expressions1.get(i4), expressions2.get(i4), container1, container2);
                                intersectionReplacement.addSubExpressionMapping(leafMapping);
                            }
                        }
                        info.getReplacements().add(intersectionReplacement);
                        return true;
                    }
                }
            }
            List<String> arguments1 = null;
            AbstractCall invocation1 = null;
            if (creationCoveringTheEntireStatement1 != null) {
                arguments1 = creationCoveringTheEntireStatement1.arguments();
            } else {
                invocation1 = statement1.invocationCoveringEntireFragment();
                if (invocation1 != null) {
                    arguments1 = invocation1.arguments();
                } else {
                    invocation1 = statement1.assignmentInvocationCoveringEntireStatement();
                    if (invocation1 != null) {
                        arguments1 = invocation1.arguments();
                    }
                }
            }
            List<String> arguments2 = null;
            AbstractCall invocation2 = null;
            if (creationCoveringTheEntireStatement2 != null) {
                arguments2 = creationCoveringTheEntireStatement2.arguments();
            } else {
                invocation2 = statement2.invocationCoveringEntireFragment();
                if (invocation2 != null) {
                    arguments2 = invocation2.arguments();
                } else {
                    invocation2 = statement2.assignmentInvocationCoveringEntireStatement();
                    if (invocation2 != null) {
                        arguments2 = invocation2.arguments();
                    }
                }
            }
            if (arguments1 != null && arguments2 != null) {
                void var20_68;
                void var19_47;
                LinkedHashSet<Replacement> linkedHashSet = new LinkedHashSet<Replacement>();
                int equalArguments = 0;
                boolean bl5 = false;
                boolean bl6 = false;
                int minSize = Math.min(arguments1.size(), arguments2.size());
                block22: for (i = 0; i < minSize; ++i) {
                    Object concatenatedString;
                    StringBuilder sb;
                    String arg2;
                    String arg1 = arguments1.get(i);
                    if (arg1.equals(arg2 = arguments2.get(i))) {
                        ++equalArguments;
                        continue;
                    }
                    if (!arg1.contains(" + ") && arg2.contains(" + ")) {
                        boolean tokenMatchesArgument = false;
                        LinkedHashSet<String> tokens2 = new LinkedHashSet<String>(Arrays.asList(SPLIT_CONCAT_STRING_PATTERN.split(arg2)));
                        sb = new StringBuilder();
                        sb.append("\"");
                        for (String token : tokens2) {
                            if (arguments1.contains(token) && arguments1.size() == arguments2.size() && tokens2.size() <= 2) {
                                tokenMatchesArgument = true;
                            }
                            if (token.startsWith("\"") && token.endsWith("\"") && token.length() > 1) {
                                sb.append(token.substring(1, token.length() - 1));
                                continue;
                            }
                            if (parameterToArgumentMap.containsKey(token)) {
                                sb.append(parameterToArgumentMap.get(token));
                                continue;
                            }
                            sb.append(token);
                        }
                        sb.append("\"");
                        concatenatedString = sb.toString();
                        if (((String)concatenatedString).equals(arg1)) {
                            linkedHashSet.add(new Replacement(arg1, arg2, Replacement.ReplacementType.CONCATENATION));
                            ++var19_47;
                        } else if (StringDistance.editDistance((String)concatenatedString, arg1) < tokens2.size()) {
                            linkedHashSet.add(new Replacement(arg1, arg2, Replacement.ReplacementType.CONCATENATION));
                            ++var19_47;
                        }
                        if (!tokenMatchesArgument) continue;
                        linkedHashSet.add(new Replacement(arg1, arg2, Replacement.ReplacementType.CONCATENATION));
                        ++var19_47;
                        continue;
                    }
                    if (!arg2.contains(" + ") && arg1.contains(" + ")) {
                        boolean tokenMatchesArgument = false;
                        LinkedHashSet<String> tokens1 = new LinkedHashSet<String>(Arrays.asList(SPLIT_CONCAT_STRING_PATTERN.split(arg1)));
                        sb = new StringBuilder();
                        sb.append("\"");
                        for (String token : tokens1) {
                            if (arguments2.contains(token) && arguments1.size() == arguments2.size() && tokens1.size() <= 2) {
                                tokenMatchesArgument = true;
                            }
                            if (token.startsWith("\"") && token.endsWith("\"") && token.length() > 1) {
                                sb.append(token.substring(1, token.length() - 1));
                                continue;
                            }
                            if (parameterToArgumentMap.containsKey(token)) {
                                sb.append(parameterToArgumentMap.get(token));
                                continue;
                            }
                            sb.append(token);
                        }
                        sb.append("\"");
                        concatenatedString = sb.toString();
                        if (((String)concatenatedString).equals(arg2)) {
                            linkedHashSet.add(new Replacement(arg1, arg2, Replacement.ReplacementType.CONCATENATION));
                            ++var19_47;
                        } else if (StringDistance.editDistance((String)concatenatedString, arg2) < tokens1.size()) {
                            linkedHashSet.add(new Replacement(arg1, arg2, Replacement.ReplacementType.CONCATENATION));
                            ++var19_47;
                        }
                        if (!tokenMatchesArgument) continue;
                        linkedHashSet.add(new Replacement(arg1, arg2, Replacement.ReplacementType.CONCATENATION));
                        ++var19_47;
                        continue;
                    }
                    for (Replacement replacement : info.getReplacements()) {
                        if (!replacement.getBefore().equals(arg1) || !replacement.getAfter().equals(arg2)) continue;
                        ++var20_68;
                        continue block22;
                    }
                }
                if (equalArguments + var20_68 + var19_47 == minSize && var19_47 > 0) {
                    info.getReplacements().addAll(linkedHashSet);
                    return true;
                }
            }
        }
        return false;
    }

    protected static boolean equalAfterInfixExpressionExpansion(String s1, String s2, UMLOperationBodyMapper.ReplacementInfo replacementInfo, List<LeafExpression> infixExpressions1) {
        LinkedHashSet<Replacement> replacementsToBeRemoved = new LinkedHashSet<Replacement>();
        LinkedHashSet<Replacement> replacementsToBeAdded = new LinkedHashSet<Replacement>();
        String originalArgumentizedString1 = replacementInfo.getArgumentizedString1();
        for (Replacement replacement : replacementInfo.getReplacements()) {
            String before = replacement.getBefore();
            for (LeafExpression infixExpression1 : infixExpressions1) {
                String temp;
                int distanceRaw;
                String infix = infixExpression1.getString();
                if (!infix.startsWith(before)) continue;
                String suffix = infix.substring(before.length(), infix.length());
                String after = replacement.getAfter();
                if (!s1.contains(after + suffix) || (distanceRaw = StringDistance.editDistance(temp = ReplacementUtil.performReplacement(replacementInfo.getArgumentizedString1(), after + suffix, after), replacementInfo.getArgumentizedString2())) < 0 || distanceRaw >= replacementInfo.getRawDistance()) continue;
                replacementsToBeRemoved.add(replacement);
                Replacement newReplacement = new Replacement(infix, after, Replacement.ReplacementType.INFIX_EXPRESSION);
                replacementsToBeAdded.add(newReplacement);
                replacementInfo.setArgumentizedString1(temp);
            }
        }
        if (replacementInfo.getRawDistance() == 0) {
            replacementInfo.removeReplacements(replacementsToBeRemoved);
            replacementInfo.addReplacements(replacementsToBeAdded);
            return true;
        }
        replacementInfo.setArgumentizedString1(originalArgumentizedString1);
        return false;
    }

    protected static boolean invocationWithEverythingReplaced(AbstractCall invocationCoveringTheEntireStatement1, AbstractCall invocationCoveringTheEntireStatement2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.identicalName(invocationCoveringTheEntireStatement2) && invocationCoveringTheEntireStatement1.getExpression() != null && invocationCoveringTheEntireStatement2.getExpression() != null) {
            List<String> arguments1 = invocationCoveringTheEntireStatement1.arguments();
            List<String> arguments2 = invocationCoveringTheEntireStatement2.arguments();
            String expression1 = invocationCoveringTheEntireStatement1.getExpression();
            String expression2 = invocationCoveringTheEntireStatement2.getExpression();
            int minArguments = Math.min(arguments1.size(), arguments2.size());
            int replacedArguments = 0;
            boolean expressionReplaced = false;
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getBefore().contains(" -> ") == replacement.getAfter().contains(" -> ")) continue;
                if (arguments1.contains(replacement.getBefore()) && arguments2.contains(replacement.getAfter())) {
                    ++replacedArguments;
                }
                if (!expression1.equals(replacement.getBefore()) || !expression2.equals(replacement.getAfter())) continue;
                expressionReplaced = true;
            }
            if (replacedArguments == minArguments && minArguments > 0 && expressionReplaced) {
                return true;
            }
        }
        return false;
    }

    protected static boolean thisConstructorCallWithEverythingReplaced(AbstractCall invocationCoveringTheEntireStatement1, AbstractCall invocationCoveringTheEntireStatement2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        if (invocationCoveringTheEntireStatement1 != null && invocationCoveringTheEntireStatement2 != null && invocationCoveringTheEntireStatement1.getName().equals("this") && invocationCoveringTheEntireStatement2.getName().equals("this")) {
            List<String> arguments1 = invocationCoveringTheEntireStatement1.arguments();
            List<String> arguments2 = invocationCoveringTheEntireStatement2.arguments();
            Set<String> argumentIntersection = invocationCoveringTheEntireStatement1.argumentIntersection(invocationCoveringTheEntireStatement2);
            int minArguments = Math.min(arguments1.size(), arguments2.size());
            int replacedArguments = 0;
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (!arguments1.contains(replacement.getBefore()) || !arguments2.contains(replacement.getAfter())) continue;
                ++replacedArguments;
            }
            if (replacedArguments == minArguments || replacedArguments > argumentIntersection.size()) {
                return true;
            }
        }
        return false;
    }

    protected static boolean classInstanceCreationWithEverythingReplaced(AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperationBodyMapper.ReplacementInfo replacementInfo, Map<String, String> parameterToArgumentMap) {
        String string1 = statement1.getString();
        String string2 = statement2.getString();
        if (StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(string1) && string1.contains("\n")) {
            string1 = string1.substring(0, string1.indexOf("\n"));
        }
        if (StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(string2) && string2.contains("\n")) {
            string2 = string2.substring(0, string2.indexOf("\n"));
        }
        if (string1.contains("=") && string1.endsWith(";\n") && string2.startsWith("return ") && string2.endsWith(";\n")) {
            int n;
            boolean typeReplacement = false;
            boolean compatibleTypes = false;
            boolean classInstanceCreationReplacement = false;
            String assignment1 = string1.substring(string1.indexOf("=") + 1, string1.lastIndexOf(";\n"));
            String assignment2 = string2.substring(7, string2.lastIndexOf(";\n"));
            UMLType type1 = null;
            UMLType type2 = null;
            ObjectCreation objectCreation1 = null;
            ObjectCreation objectCreation2 = null;
            LinkedHashMap<String, String> argumentToParameterMap = new LinkedHashMap<String, String>();
            List<AbstractCall> creations1 = statement1.getCreations();
            for (AbstractCall abstractCall : creations1) {
                if (!abstractCall.getString().equals(assignment1)) continue;
                objectCreation1 = (ObjectCreation)abstractCall;
                type1 = objectCreation1.getType();
            }
            List<AbstractCall> creations2 = statement2.getCreations();
            for (AbstractCall creation2 : creations2) {
                if (!creation2.getString().equals(assignment2)) continue;
                objectCreation2 = (ObjectCreation)creation2;
                type2 = objectCreation2.getType();
                for (String argument : objectCreation2.arguments()) {
                    if (!parameterToArgumentMap.containsKey(argument)) continue;
                    argumentToParameterMap.put(parameterToArgumentMap.get(argument), argument);
                }
            }
            boolean bl = false;
            if (type1 != null && type2 != null) {
                compatibleTypes = type1.compatibleTypes(type2);
                n = Math.min(objectCreation1.arguments().size(), objectCreation2.arguments().size());
            }
            int replacedArguments = 0;
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) {
                    typeReplacement = true;
                    if (!string1.contains("new " + replacement.getBefore() + "(") || !string2.contains("new " + replacement.getAfter() + "(")) continue;
                    classInstanceCreationReplacement = true;
                    continue;
                }
                if (objectCreation1 != null && objectCreation2 != null && objectCreation1.arguments().contains(replacement.getBefore()) && (objectCreation2.arguments().contains(replacement.getAfter()) || objectCreation2.arguments().contains(argumentToParameterMap.get(replacement.getAfter())))) {
                    ++replacedArguments;
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.CLASS_INSTANCE_CREATION) || !assignment1.equals(replacement.getBefore()) || !assignment2.equals(replacement.getAfter())) continue;
                classInstanceCreationReplacement = true;
            }
            if (typeReplacement && !compatibleTypes && replacedArguments == n && classInstanceCreationReplacement) {
                return true;
            }
        } else if (string1.startsWith("return ") && string1.endsWith(";\n") && string2.contains("=") && string2.endsWith(";\n")) {
            int n;
            boolean typeReplacement = false;
            boolean compatibleTypes = false;
            boolean classInstanceCreationReplacement = false;
            String assignment1 = string1.substring(7, string1.lastIndexOf(";\n"));
            String assignment2 = string2.substring(string2.indexOf("=") + 1, string2.lastIndexOf(";\n"));
            UMLType type1 = null;
            UMLType type2 = null;
            ObjectCreation objectCreation1 = null;
            ObjectCreation objectCreation2 = null;
            LinkedHashMap<String, String> argumentToParameterMap = new LinkedHashMap<String, String>();
            List<AbstractCall> creations1 = statement1.getCreations();
            for (AbstractCall abstractCall : creations1) {
                if (!abstractCall.getString().equals(assignment1)) continue;
                objectCreation1 = (ObjectCreation)abstractCall;
                type1 = objectCreation1.getType();
            }
            List<AbstractCall> creations2 = statement2.getCreations();
            Iterator iterator = creations2.iterator();
            while (iterator.hasNext()) {
                AbstractCall creation2 = (AbstractCall)iterator.next();
                if (!creation2.getString().equals(assignment2)) continue;
                objectCreation2 = (ObjectCreation)creation2;
                type2 = objectCreation2.getType();
                for (String argument : objectCreation2.arguments()) {
                    if (!parameterToArgumentMap.containsKey(argument)) continue;
                    argumentToParameterMap.put(parameterToArgumentMap.get(argument), argument);
                }
            }
            boolean bl = false;
            if (type1 != null && type2 != null) {
                compatibleTypes = type1.compatibleTypes(type2);
                n = Math.min(objectCreation1.arguments().size(), objectCreation2.arguments().size());
            }
            int replacedArguments = 0;
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) {
                    typeReplacement = true;
                    if (!string1.contains("new " + replacement.getBefore() + "(") || !string2.contains("new " + replacement.getAfter() + "(")) continue;
                    classInstanceCreationReplacement = true;
                    continue;
                }
                if (objectCreation1 != null && objectCreation2 != null && objectCreation1.arguments().contains(replacement.getBefore()) && (objectCreation2.arguments().contains(replacement.getAfter()) || objectCreation2.arguments().contains(argumentToParameterMap.get(replacement.getAfter())))) {
                    ++replacedArguments;
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.CLASS_INSTANCE_CREATION) || !assignment1.equals(replacement.getBefore()) || !assignment2.equals(replacement.getAfter())) continue;
                classInstanceCreationReplacement = true;
            }
            if (typeReplacement && !compatibleTypes && replacedArguments == n && classInstanceCreationReplacement) {
                return true;
            }
        }
        return false;
    }

    protected static boolean variableAssignmentWithEverythingReplaced(AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperationBodyMapper.ReplacementInfo replacementInfo, UMLOperationBodyMapper mapper) {
        boolean containsMethodSignatureOfAnonymousClass2;
        String string1 = statement1.getString();
        String string2 = statement2.getString();
        boolean containsMethodSignatureOfAnonymousClass1 = StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(string1);
        if (containsMethodSignatureOfAnonymousClass1 && string1.contains("\n")) {
            string1 = string1.substring(0, string1.indexOf("\n"));
        }
        if ((containsMethodSignatureOfAnonymousClass2 = StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(string2)) && string2.contains("\n")) {
            string2 = string2.substring(0, string2.indexOf("\n"));
        }
        if (string1.contains("=") && string1.endsWith(";\n") && string2.contains("=") && string2.endsWith(";\n")) {
            boolean typeReplacement = false;
            boolean compatibleTypes = false;
            boolean variableRename = false;
            boolean classInstanceCreationReplacement = false;
            boolean equalArguments = false;
            boolean rightHandSideReplacement = false;
            String variableName1 = string1.substring(0, string1.indexOf("="));
            String variableName2 = string2.substring(0, string2.indexOf("="));
            String assignment1 = string1.substring(string1.indexOf("=") + 1, string1.lastIndexOf(";\n"));
            String assignment2 = string2.substring(string2.indexOf("=") + 1, string2.lastIndexOf(";\n"));
            boolean fieldInitializationWithParemeter1 = false;
            boolean fieldInitializationWithParemeter2 = false;
            if (mapper.getContainer1().isConstructor() && mapper.getContainer2().isConstructor() && mapper.getClassDiff() != null) {
                for (UMLAttribute removedAttribute : mapper.getClassDiff().getOriginalClass().getAttributes()) {
                    if (!variableName1.equals(removedAttribute.getName()) && !variableName1.equals("this." + removedAttribute.getName())) continue;
                    for (String parameterName : mapper.getContainer1().getParameterNameList()) {
                        if (!assignment1.equals(parameterName) && !assignment1.contains(parameterName + ".")) continue;
                        fieldInitializationWithParemeter1 = true;
                        break;
                    }
                    if (!fieldInitializationWithParemeter1) continue;
                    break;
                }
                for (UMLAttribute addedAttribute : mapper.getClassDiff().getNextClass().getAttributes()) {
                    if (!variableName2.equals(addedAttribute.getName()) && !variableName2.equals("this." + addedAttribute.getName())) continue;
                    for (String parameterName : mapper.getContainer2().getParameterNameList()) {
                        if (!assignment2.equals(parameterName) && !assignment2.contains(parameterName + ".")) continue;
                        fieldInitializationWithParemeter2 = true;
                        break;
                    }
                    if (!fieldInitializationWithParemeter2) continue;
                    break;
                }
            }
            UMLType type1 = null;
            UMLType type2 = null;
            AbstractCall inv1 = null;
            AbstractCall inv2 = null;
            List<AbstractCall> creations1 = statement1.getCreations();
            for (AbstractCall abstractCall : creations1) {
                if (!abstractCall.getString().equals(assignment1)) continue;
                ObjectCreation objectCreation = (ObjectCreation)abstractCall;
                type1 = objectCreation.getType();
                inv1 = objectCreation;
            }
            List<AbstractCall> creations2 = statement2.getCreations();
            for (AbstractCall creation2 : creations2) {
                if (!creation2.getString().equals(assignment2)) continue;
                ObjectCreation objectCreation = (ObjectCreation)creation2;
                type2 = objectCreation.getType();
                inv2 = objectCreation;
            }
            if (type1 != null && type2 != null) {
                compatibleTypes = type1.compatibleTypes(type2);
            }
            for (AbstractCall invocation1 : statement1.getMethodInvocations()) {
                if (!invocation1.getString().equals(assignment1)) continue;
                inv1 = invocation1;
            }
            for (AbstractCall invocation2 : statement2.getMethodInvocations()) {
                if (!invocation2.getString().equals(assignment2)) continue;
                inv2 = invocation2;
            }
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE)) {
                    typeReplacement = true;
                    if (!string1.contains("new " + replacement.getBefore() + "(") || !string2.contains("new " + replacement.getAfter() + "(")) continue;
                    classInstanceCreationReplacement = true;
                    continue;
                }
                if ((replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS)) && (variableName1.equals(replacement.getBefore()) || variableName1.endsWith(" " + replacement.getBefore()) || variableName1.equals("this." + replacement.getBefore())) && (variableName2.equals(replacement.getAfter()) || variableName2.endsWith(" " + replacement.getAfter()) || variableName2.equals("this." + replacement.getAfter())) && !variableName1.equals("this." + variableName2) && !variableName2.equals("this." + variableName1)) {
                    variableRename = true;
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) && assignment1.equals(replacement.getBefore()) && assignment2.equals(replacement.getAfter()) && !mapper.getContainer1().isConstructor() && !mapper.getContainer2().isConstructor() && !mapper.getContainer1().getName().equals(mapper.getContainer2().getName()) && StringBasedHeuristics.zeroCallsToExtractedMethodsOrParentMapperWithNonIdenticalSignature(mapper)) {
                    rightHandSideReplacement = true;
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_NULL_LITERAL) && assignment1.equals(replacement.getBefore()) && assignment2.equals(replacement.getAfter())) {
                    rightHandSideReplacement = true;
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_CLASS_INSTANCE_CREATION) && assignment1.equals(replacement.getBefore()) && assignment2.equals(replacement.getAfter()) && !StringBasedHeuristics.referencedParameterForClassInstanceCreationReplacement(replacement, mapper.getContainer1(), mapper.getContainer2())) {
                    rightHandSideReplacement = true;
                    continue;
                }
                if (replacement instanceof VariableReplacementWithMethodInvocation && assignment1.equals(replacement.getBefore()) && assignment2.equals(replacement.getAfter()) && !assignment1.startsWith(assignment2) && !assignment2.startsWith(assignment1) && !StringBasedHeuristics.referencedParameter((VariableReplacementWithMethodInvocation)replacement, mapper.getContainer1(), mapper.getContainer2())) {
                    rightHandSideReplacement = true;
                    continue;
                }
                if (!replacement.getType().equals((Object)Replacement.ReplacementType.CLASS_INSTANCE_CREATION) || !assignment1.equals(replacement.getBefore()) || !assignment2.equals(replacement.getAfter())) continue;
                classInstanceCreationReplacement = true;
            }
            if (inv1 != null && inv2 != null) {
                boolean bl = equalArguments = inv1.equalArguments(inv2) && inv1.arguments().size() > 0;
            }
            if (typeReplacement && !compatibleTypes && variableRename && classInstanceCreationReplacement && !equalArguments) {
                return true;
            }
            if (variableRename && rightHandSideReplacement) {
                String[] stringArray = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(variableName1);
                String[] tokens2 = LeafType.CAMEL_CASE_SPLIT_PATTERN.split(variableName2);
                int commonTokens = 0;
                for (String token1 : stringArray) {
                    for (String token2 : tokens2) {
                        if (!token1.equals(token2)) continue;
                        ++commonTokens;
                    }
                }
                if ((double)commonTokens < (double)Math.max(stringArray.length, tokens2.length) / 2.0) {
                    return true;
                }
            }
            if (variableRename && inv1 != null && inv2 != null && inv1.differentExpressionNameAndArguments(inv2)) {
                if (inv1.arguments().size() > inv2.arguments().size()) {
                    for (String argument : inv1.arguments()) {
                        for (AbstractCall invocation1 : statement1.getMethodInvocations()) {
                            if (!invocation1.getString().equals(argument) || invocation1.differentExpressionNameAndArguments(inv2)) continue;
                            return false;
                        }
                    }
                } else if (inv1.arguments().size() < inv2.arguments().size()) {
                    for (String argument : inv2.arguments()) {
                        for (AbstractCall invocation2 : statement2.getMethodInvocations()) {
                            if (!invocation2.getString().equals(argument) || inv1.differentExpressionNameAndArguments(invocation2)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            if (variableRename && fieldInitializationWithParemeter1 != fieldInitializationWithParemeter2 && inv2 == null) {
                return true;
            }
        } else if (string1.contains("=") && statement1.getString().endsWith(";\n") && string2.contains("=") && statement2.getString().endsWith(";\n") && containsMethodSignatureOfAnonymousClass1 != containsMethodSignatureOfAnonymousClass2) {
            boolean variableRename = false;
            boolean rightHandSideReplacement = false;
            String variableName1 = string1.substring(0, string1.indexOf("="));
            String variableName2 = string2.substring(0, string2.indexOf("="));
            String assignment1 = statement1.getString().substring(statement1.getString().indexOf("=") + 1, statement1.getString().lastIndexOf(";\n"));
            String assignment2 = statement2.getString().substring(statement2.getString().indexOf("=") + 1, statement2.getString().lastIndexOf(";\n"));
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if ((replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) || replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS)) && (variableName1.equals(replacement.getBefore()) || variableName1.endsWith(" " + replacement.getBefore()) || variableName1.equals("this." + replacement.getBefore())) && (variableName2.equals(replacement.getAfter()) || variableName2.endsWith(" " + replacement.getAfter()) || variableName2.equals("this." + replacement.getAfter())) && !variableName1.equals("this." + variableName2) && !variableName2.equals("this." + variableName1)) {
                    variableRename = true;
                    continue;
                }
                if (!assignment1.equals(replacement.getBefore()) || !assignment2.equals(replacement.getAfter())) continue;
                rightHandSideReplacement = true;
            }
            if (variableRename && rightHandSideReplacement) {
                return true;
            }
        }
        return false;
    }

    private static boolean zeroCallsToExtractedMethodsOrParentMapperWithNonIdenticalSignature(UMLOperationBodyMapper mapper) {
        if (mapper.getCallsToExtractedMethod() == 0) {
            return true;
        }
        if (mapper.getParentMapper() != null) {
            return !mapper.getParentMapper().getContainer1().equals(mapper.getParentMapper().getContainer2());
        }
        return false;
    }

    private static boolean referencedParameterForClassInstanceCreationReplacement(Replacement replacement, VariableDeclarationContainer container1, VariableDeclarationContainer container2) {
        UMLType type2;
        int index2;
        UMLType type1;
        int index1;
        block9: {
            block8: {
                index1 = -1;
                type1 = null;
                index2 = -1;
                type2 = null;
                if (!replacement.getAfter().contains("new ")) break block8;
                int counter = 0;
                for (VariableDeclaration parameter : container1.getParameterDeclarationList()) {
                    if (parameter.getVariableName().equals(replacement.getBefore())) {
                        index1 = counter;
                        type1 = parameter.getType();
                    }
                    ++counter;
                }
                counter = 0;
                for (VariableDeclaration parameter : container2.getParameterDeclarationList()) {
                    if (replacement.getAfter().contains(parameter.getVariableName())) {
                        index2 = counter;
                        type2 = parameter.getType();
                    }
                    ++counter;
                }
                break block9;
            }
            if (!replacement.getBefore().contains("new ")) break block9;
            int counter = 0;
            for (VariableDeclaration parameter : container1.getParameterDeclarationList()) {
                if (replacement.getBefore().contains(parameter.getVariableName())) {
                    index1 = counter;
                    type1 = parameter.getType();
                }
                ++counter;
            }
            counter = 0;
            for (VariableDeclaration parameter : container2.getParameterDeclarationList()) {
                if (parameter.getVariableName().equals(replacement.getAfter())) {
                    index2 = counter;
                    type2 = parameter.getType();
                }
                ++counter;
            }
        }
        return type1 != null && type2 != null && type1.equals(type2) && index1 == index2;
    }

    private static boolean referencedParameter(VariableReplacementWithMethodInvocation replacement, VariableDeclarationContainer container1, VariableDeclarationContainer container2) {
        UMLType type2;
        int index2;
        UMLType type1;
        int index1;
        block9: {
            block8: {
                index1 = -1;
                type1 = null;
                index2 = -1;
                type2 = null;
                if (!replacement.getDirection().equals((Object)VariableReplacementWithMethodInvocation.Direction.VARIABLE_TO_INVOCATION)) break block8;
                int counter = 0;
                for (VariableDeclaration parameter : container1.getParameterDeclarationList()) {
                    if (parameter.getVariableName().equals(replacement.getBefore())) {
                        index1 = counter;
                        type1 = parameter.getType();
                    }
                    ++counter;
                }
                counter = 0;
                for (VariableDeclaration parameter : container2.getParameterDeclarationList()) {
                    if (replacement.getAfter().contains(parameter.getVariableName())) {
                        index2 = counter;
                        type2 = parameter.getType();
                    }
                    ++counter;
                }
                break block9;
            }
            if (!replacement.getDirection().equals((Object)VariableReplacementWithMethodInvocation.Direction.INVOCATION_TO_VARIABLE)) break block9;
            int counter = 0;
            for (VariableDeclaration parameter : container1.getParameterDeclarationList()) {
                if (replacement.getBefore().contains(parameter.getVariableName())) {
                    index1 = counter;
                    type1 = parameter.getType();
                }
                ++counter;
            }
            counter = 0;
            for (VariableDeclaration parameter : container2.getParameterDeclarationList()) {
                if (parameter.getVariableName().equals(replacement.getAfter())) {
                    index2 = counter;
                    type2 = parameter.getType();
                }
                ++counter;
            }
        }
        return type1 != null && type2 != null && type1.equals(type2) && index1 == index2;
    }

    protected static boolean operatorExpressionWithEverythingReplaced(AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperationBodyMapper.ReplacementInfo replacementInfo, Map<String, String> parameterToArgumentMap) {
        String string1 = statement1.getString();
        String string2 = statement2.getString();
        if (StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(string1) && string1.contains("\n")) {
            string1 = string1.substring(0, string1.indexOf("\n"));
        }
        if (StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(string2) && string2.contains("\n")) {
            string2 = string2.substring(0, string2.indexOf("\n"));
        }
        List<String> operators1 = statement1.getInfixOperators();
        List<String> operators2 = statement2.getInfixOperators();
        if (operators1.size() == 1 && operators2.size() == 1) {
            String operator1 = operators1.get(0);
            String operator2 = operators2.get(0);
            int indexOfOperator1 = string1.indexOf(operator1);
            int indexOfOperator2 = string2.indexOf(operator2);
            if (indexOfOperator1 != -1 && indexOfOperator2 != -1) {
                String leftOperand1 = string1.substring(0, indexOfOperator1);
                String leftOperand2 = string2.substring(0, indexOfOperator2);
                String rightOperand1 = string1.substring(indexOfOperator1 + operator1.length(), string1.length());
                String rightOperand2 = string2.substring(indexOfOperator2 + operator2.length(), string2.length());
                boolean operatorReplacement = false;
                boolean leftOperandReplacement = false;
                boolean rightOperandReplacement = false;
                for (Replacement replacement : replacementInfo.getReplacements()) {
                    if (parameterToArgumentMap.containsValue(replacement.getAfter())) {
                        for (String key : parameterToArgumentMap.keySet()) {
                            if (!parameterToArgumentMap.get(key).equals(replacement.getAfter())) continue;
                            if (leftOperand1.contains(replacement.getBefore()) && leftOperand2.contains(key)) {
                                leftOperandReplacement = true;
                            }
                            if (!rightOperand1.contains(replacement.getBefore()) || !rightOperand2.contains(key)) break;
                            rightOperandReplacement = true;
                            break;
                        }
                    }
                    if (replacement.getType().equals((Object)Replacement.ReplacementType.INFIX_OPERATOR)) {
                        if (!replacement.getBefore().equals(operator1) || !replacement.getAfter().equals(operator2)) continue;
                        operatorReplacement = true;
                        continue;
                    }
                    if (leftOperand1.contains(replacement.getBefore()) && leftOperand2.contains(replacement.getAfter())) {
                        leftOperandReplacement = true;
                        continue;
                    }
                    if (!rightOperand1.contains(replacement.getBefore()) || !rightOperand2.contains(replacement.getAfter())) continue;
                    rightOperandReplacement = true;
                }
                if (operatorReplacement && leftOperandReplacement && rightOperandReplacement) {
                    return true;
                }
            }
        } else if (replacementInfo.getReplacements().size() > 1) {
            StringBuilder stringBefore = new StringBuilder();
            StringBuilder stringAfter = new StringBuilder();
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.INFIX_OPERATOR)) {
                    stringBefore.append(" " + replacement.getBefore() + " ");
                    stringAfter.append(" " + replacement.getAfter() + " ");
                    continue;
                }
                stringBefore.append(replacement.getBefore());
                stringAfter.append(replacement.getAfter());
            }
            if (statement1.getString().startsWith("return ") && statement2.getString().startsWith("return ")) {
                return statement1.getString().equals("return " + stringBefore + ";\n") && statement2.getString().equals("return " + stringAfter + ";\n");
            }
            if (statement1.getString().startsWith("if(") && statement2.getString().startsWith("if(")) {
                return statement1.getString().equals("if(" + stringBefore + ")") && statement2.getString().equals("if(" + stringAfter + ")");
            }
            if (statement1.getString().startsWith("while(") && statement2.getString().startsWith("while(")) {
                return statement1.getString().equals("while(" + stringBefore + ")") && statement2.getString().equals("while(" + stringAfter + ")");
            }
        }
        return false;
    }

    protected static boolean variableDeclarationsWithEverythingReplaced(List<VariableDeclaration> variableDeclarations1, List<VariableDeclaration> variableDeclarations2, UMLOperationBodyMapper.ReplacementInfo replacementInfo) {
        if (variableDeclarations1.size() == 1 && variableDeclarations2.size() == 1) {
            boolean typeReplacement = false;
            boolean variableRename = false;
            boolean initializerReplacement = false;
            boolean nullInitializer = false;
            boolean zeroArgumentClassInstantiation = false;
            boolean classInstantiationArgumentReplacement = false;
            UMLType type1 = variableDeclarations1.get(0).getType();
            UMLType type2 = variableDeclarations2.get(0).getType();
            AbstractExpression initializer1 = variableDeclarations1.get(0).getInitializer();
            AbstractExpression initializer2 = variableDeclarations2.get(0).getInitializer();
            if (initializer1 == null && initializer2 == null) {
                nullInitializer = true;
            } else if (initializer1 != null && initializer2 != null) {
                boolean bl = nullInitializer = initializer1.getExpression().equals("null") || initializer2.getExpression().equals("null");
                if (initializer1.getCreations().size() == 1 && initializer2.getCreations().size() == 1) {
                    ObjectCreation creation1 = (ObjectCreation)initializer1.getCreations().get(0);
                    ObjectCreation creation2 = (ObjectCreation)initializer2.getCreations().get(0);
                    if (creation1.arguments().size() == 0 && creation2.arguments().size() == 0) {
                        zeroArgumentClassInstantiation = true;
                    } else if (creation1.arguments().size() == 1 && creation2.arguments().size() == 1) {
                        String argument1 = creation1.arguments().get(0);
                        String argument2 = creation2.arguments().get(0);
                        for (Replacement replacement : replacementInfo.getReplacements()) {
                            if (!replacement.getBefore().equals(argument1) || !replacement.getAfter().equals(argument2)) continue;
                            classInstantiationArgumentReplacement = true;
                            break;
                        }
                    }
                }
                AbstractCall invocation1 = initializer1.invocationCoveringEntireFragment();
                AbstractCall invocation2 = initializer2.invocationCoveringEntireFragment();
                if (invocation1 != null && invocation2 != null && invocation1.getCoverage().equals((Object)AbstractCall.StatementCoverageType.CAST_CALL) != invocation2.getCoverage().equals((Object)AbstractCall.StatementCoverageType.CAST_CALL)) {
                    initializerReplacement = true;
                }
            }
            for (Replacement replacement : replacementInfo.getReplacements()) {
                if (replacement.getType().equals((Object)Replacement.ReplacementType.TYPE) && type1 != null && type1.toQualifiedString().equals(replacement.getBefore()) && type2 != null && type2.toQualifiedString().equals(replacement.getAfter())) {
                    typeReplacement = true;
                    continue;
                }
                if (replacement.getType().equals((Object)Replacement.ReplacementType.VARIABLE_NAME) && variableDeclarations1.get(0).getVariableName().equals(replacement.getBefore()) && variableDeclarations2.get(0).getVariableName().equals(replacement.getAfter())) {
                    variableRename = true;
                    continue;
                }
                if (initializer1 == null || !initializer1.getExpression().equals(replacement.getBefore()) || initializer2 == null || !initializer2.getExpression().equals(replacement.getAfter())) continue;
                initializerReplacement = true;
            }
            if (typeReplacement && !type1.compatibleTypes(type2) && variableRename && (initializerReplacement || nullInitializer || zeroArgumentClassInstantiation || classInstantiationArgumentReplacement)) {
                return true;
            }
        }
        return false;
    }

    protected static String statementWithoutAnonymous(AbstractCodeFragment statement, AnonymousClassDeclarationObject anonymousClassDeclaration, VariableDeclarationContainer operation) {
        String[] stringArray;
        int index = statement.getString().indexOf(anonymousClassDeclaration.toString());
        if (index != -1) {
            return statement.getString().substring(0, index);
        }
        for (LambdaExpressionObject lambdaExpressionObject : statement.getLambdas()) {
            OperationBody body = lambdaExpressionObject.getBody();
            if (body == null) continue;
            List<AbstractCodeFragment> leaves = body.getCompositeStatement().getLeaves();
            Iterator<AbstractCodeFragment> iterator = leaves.iterator();
            while (iterator.hasNext()) {
                AbstractCodeFragment leaf = iterator.next();
                for (AnonymousClassDeclarationObject anonymousObject : leaf.getAnonymousClassDeclarations()) {
                    String statementWithoutAnonymous;
                    if (!anonymousObject.getLocationInfo().equals(anonymousClassDeclaration.getLocationInfo()) || (statementWithoutAnonymous = StringBasedHeuristics.statementWithoutAnonymous(leaf, anonymousClassDeclaration, operation)) == null) continue;
                    return statementWithoutAnonymous;
                }
            }
        }
        ArrayList<UMLOperation> anonymousOperations = new ArrayList<UMLOperation>();
        for (AnonymousClassDeclarationObject anonymousObject : statement.getAnonymousClassDeclarations()) {
            for (UMLAnonymousClass anonymousClass : operation.getAnonymousClassList()) {
                if (!anonymousClass.getLocationInfo().equals(anonymousObject.getLocationInfo())) continue;
                anonymousOperations.addAll(anonymousClass.getOperations());
            }
        }
        for (UMLOperation anonymousOperation : anonymousOperations) {
            OperationBody body = anonymousOperation.getBody();
            if (body == null) continue;
            List<AbstractCodeFragment> leaves = body.getCompositeStatement().getLeaves();
            for (AbstractCodeFragment leaf : leaves) {
                for (AnonymousClassDeclarationObject anonymousObject : leaf.getAnonymousClassDeclarations()) {
                    if (!anonymousObject.getLocationInfo().equals(anonymousClassDeclaration.getLocationInfo()) && !anonymousObject.getLocationInfo().subsumes(anonymousClassDeclaration.getLocationInfo())) continue;
                    return StringBasedHeuristics.statementWithoutAnonymous(leaf, anonymousClassDeclaration, anonymousOperation);
                }
            }
        }
        if (statement.getAnonymousClassDeclarations().indexOf(anonymousClassDeclaration) > 0 && (stringArray = anonymousClassDeclaration.toString().split("\\R")).length > 1) {
            String methodDeclaration = stringArray[1].trim().replaceAll("\\s*final", "final");
            index = statement.getString().indexOf(methodDeclaration);
            if (index != -1) {
                return statement.getString().substring(0, index - 2);
            }
        }
        return null;
    }

    protected static boolean onlyDifferentInvoker(String s1, String s2, AbstractCall invocationCoveringTheEntireStatement1, AbstractCall invocationCoveringTheEntireStatement2) {
        String s1AfterReplacement;
        String s2AfterReplacement;
        int index;
        String s1AfterReplacement2;
        return invocationCoveringTheEntireStatement1.identicalName(invocationCoveringTheEntireStatement2) && (invocationCoveringTheEntireStatement1.getExpression() == null && invocationCoveringTheEntireStatement2.getExpression() != null ? (s1AfterReplacement2 = s1.substring(0, index = s1.indexOf(invocationCoveringTheEntireStatement1.getName())) + invocationCoveringTheEntireStatement2.getExpression() + "." + s1.substring(index)).equals(s2) : (invocationCoveringTheEntireStatement1.getExpression() != null && invocationCoveringTheEntireStatement2.getExpression() == null ? (s2AfterReplacement = s2.substring(0, index = s2.indexOf(invocationCoveringTheEntireStatement2.getName())) + invocationCoveringTheEntireStatement1.getExpression() + "." + s2.substring(index)).equals(s1) : invocationCoveringTheEntireStatement1.getExpression() != null && invocationCoveringTheEntireStatement2.getExpression() != null && (s1AfterReplacement = ReplacementUtil.performReplacement(s1, s2, invocationCoveringTheEntireStatement1.getExpression(), invocationCoveringTheEntireStatement2.getExpression())).equals(s2)));
    }

    protected static boolean extractedToVariable(String s1, String s2, AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperationBodyMapper.ReplacementInfo info) {
        String prefix1;
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(s1, s2);
        if (!commonSuffix.isEmpty() && commonSuffix.startsWith("new ") && statement2.getVariableDeclarations().size() > 0 && statement1.getVariableDeclarations().size() == 0 && !(prefix1 = s1.substring(0, s1.indexOf(commonSuffix))).isEmpty()) {
            if (prefix1.startsWith("return ")) {
                prefix1 = prefix1.substring(7);
            }
            for (AbstractCodeFragment abstractCodeFragment : info.getStatements2()) {
                if (!abstractCodeFragment.getString().contains(prefix1) || !abstractCodeFragment.getString().contains(statement2.getVariableDeclarations().get(0).getVariableName())) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean identicalAfterVariableAndTypeReplacements(String s1, String s2, Set<Replacement> replacements) {
        String s1AfterReplacements = new String(s1);
        for (Replacement replacement : replacements) {
            String before = replacement.getBefore();
            String after = replacement.getAfter();
            if (before.contains("\n") && after.contains("\n")) {
                before = before.substring(0, before.indexOf("\n"));
                after = after.substring(0, after.indexOf("\n"));
                if (before.endsWith("{") && after.endsWith("{")) {
                    before = before.substring(0, before.length() - 1);
                    after = after.substring(0, after.length() - 1);
                }
            }
            s1AfterReplacements = ReplacementUtil.performReplacement(s1AfterReplacements, s2, before, after);
        }
        return s1AfterReplacements.equals(s2);
    }

    protected static VariableDeclaration declarationWithArrayInitializer(List<VariableDeclaration> declarations) {
        for (VariableDeclaration declaration : declarations) {
            AbstractExpression initializer = declaration.getInitializer();
            if (initializer == null || !initializer.getString().startsWith("{") || !initializer.getString().endsWith("}")) continue;
            return declaration;
        }
        return null;
    }

    protected static Set<String> subConditionIntersection(List<String> subConditionsAsList1, List<String> subConditionsAsList2) {
        LinkedHashSet<String> intersection = new LinkedHashSet<String>();
        block0: for (String c1 : subConditionsAsList1) {
            for (String c2 : subConditionsAsList2) {
                String commonSuffix;
                String commonPrefix;
                boolean pass;
                String suffix2;
                String suffix1;
                String prefix2;
                String prefix1;
                if (c1.equals(c2)) {
                    intersection.add(c1);
                    continue block0;
                }
                if (c1.equals("(" + c2)) {
                    intersection.add(c2);
                    continue block0;
                }
                if (c1.equals(c2 + ")")) {
                    intersection.add(c2);
                    continue block0;
                }
                if (c1.equals("!" + c2) || c1.equals("!(" + c2 + ")")) {
                    intersection.add(c2);
                    continue block0;
                }
                if (c2.equals("(" + c1)) {
                    intersection.add(c1);
                    continue block0;
                }
                if (c2.equals(c1 + ")")) {
                    intersection.add(c1);
                    continue block0;
                }
                if (c2.equals("!" + c1) || c2.equals("!(" + c1 + ")")) {
                    intersection.add(c1);
                    continue block0;
                }
                if (c1.contains("!=") && c2.contains("==")) {
                    prefix1 = c1.substring(0, c1.indexOf("!="));
                    prefix2 = c2.substring(0, c2.indexOf("=="));
                    suffix1 = c1.substring(c1.indexOf("!=") + 2);
                    suffix2 = c2.substring(c2.indexOf("==") + 2);
                    if (!prefix1.equals(prefix2) || !suffix1.equals(suffix2)) continue;
                    intersection.add(c1);
                    continue block0;
                }
                if (c1.contains("==") && c2.contains("!=")) {
                    prefix1 = c1.substring(0, c1.indexOf("=="));
                    prefix2 = c2.substring(0, c2.indexOf("!="));
                    suffix1 = c1.substring(c1.indexOf("==") + 2);
                    suffix2 = c2.substring(c2.indexOf("!=") + 2);
                    if (!prefix1.equals(prefix2) || !suffix1.equals(suffix2)) continue;
                    intersection.add(c1);
                    continue block0;
                }
                if (!c1.contains(".equals(") || !c1.contains(")") || !c2.contains(".equals(") || !c2.contains(")")) continue;
                String arg1 = c1.substring(c1.indexOf(".equals(") + 8, c1.lastIndexOf(")"));
                String arg2 = c2.substring(c2.indexOf(".equals(") + 8, c2.lastIndexOf(")"));
                String prefix12 = c1.substring(0, c1.indexOf(".equals("));
                String prefix22 = c2.substring(0, c2.indexOf(".equals("));
                if (arg2.equals(prefix12)) {
                    pass = false;
                    if (arg1.equals(prefix22)) {
                        pass = true;
                    } else {
                        if (arg1.startsWith("!")) {
                            arg1 = arg1.substring(1);
                        }
                        if (prefix22.startsWith("!")) {
                            prefix22 = prefix22.substring(1);
                        }
                        commonPrefix = PrefixSuffixUtils.longestCommonPrefix(arg1, prefix22);
                        commonSuffix = PrefixSuffixUtils.longestCommonSuffix(arg1, prefix22);
                        if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
                            pass = true;
                        }
                    }
                    if (pass) {
                        intersection.add(arg2);
                        continue block0;
                    }
                }
                if (!arg1.equals(prefix22)) continue;
                pass = false;
                if (arg2.equals(prefix12)) {
                    pass = true;
                } else {
                    if (arg2.startsWith("!")) {
                        arg2 = arg2.substring(1);
                    }
                    if (prefix12.startsWith("!")) {
                        prefix12 = prefix12.substring(1);
                    }
                    commonPrefix = PrefixSuffixUtils.longestCommonPrefix(arg2, prefix12);
                    commonSuffix = PrefixSuffixUtils.longestCommonSuffix(arg2, prefix12);
                    if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
                        pass = true;
                    }
                }
                if (!pass) continue;
                intersection.add(arg1);
                continue block0;
            }
        }
        return intersection;
    }

    private static int checkForInvertedConditionals(List<String> subConditionsAsList1, List<String> subConditionsAsList2, UMLOperationBodyMapper.ReplacementInfo info) {
        int invertedConditionals = 0;
        block0: for (String subCondition1 : subConditionsAsList1) {
            for (String subCondition2 : subConditionsAsList2) {
                int invertCount;
                Replacement r2;
                boolean prefixReplaced;
                String suffix2;
                String suffix1;
                String prefix2;
                String prefix1;
                Replacement r22;
                if (subCondition1.equals("!" + subCondition2) || subCondition1.equals("!(" + subCondition2 + ")")) {
                    r22 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                    info.addReplacement(r22);
                    ++invertedConditionals;
                    continue block0;
                }
                if (subCondition2.equals("!" + subCondition1) || subCondition2.equals("!(" + subCondition1 + ")")) {
                    r22 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                    info.addReplacement(r22);
                    ++invertedConditionals;
                    continue block0;
                }
                if (subCondition1.contains("==") && subCondition2.contains("!=")) {
                    boolean bothPrefixAndSuffixReplaced;
                    prefix1 = subCondition1.substring(0, subCondition1.indexOf("==")).trim();
                    prefix2 = subCondition2.substring(0, subCondition2.indexOf("!=")).trim();
                    suffix1 = subCondition1.substring(subCondition1.indexOf("==") + 2).trim();
                    suffix2 = subCondition2.substring(subCondition2.indexOf("!=") + 2).trim();
                    prefixReplaced = false;
                    boolean suffixReplaced = false;
                    for (Replacement r : info.getReplacements()) {
                        if (r.getBefore().equals(r.getAfter())) continue;
                        if (r.getAfter().equals(prefix1) && r.getAfter().equals(prefix2)) {
                            prefixReplaced = true;
                        }
                        if (!r.getAfter().equals(suffix1) || !r.getAfter().equals(suffix2)) continue;
                        suffixReplaced = true;
                    }
                    boolean bl = bothPrefixAndSuffixReplaced = prefixReplaced && suffixReplaced;
                    if (!prefix1.equals(prefix2) || !suffix1.equals(suffix2) || bothPrefixAndSuffixReplaced) continue;
                    r2 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                    info.addReplacement(r2);
                    ++invertedConditionals;
                    continue block0;
                }
                if (subCondition1.contains("!=") && subCondition2.contains("==")) {
                    boolean bothPrefixAndSuffixReplaced;
                    prefix1 = subCondition1.substring(0, subCondition1.indexOf("!=")).trim();
                    prefix2 = subCondition2.substring(0, subCondition2.indexOf("==")).trim();
                    suffix1 = subCondition1.substring(subCondition1.indexOf("!=") + 2).trim();
                    suffix2 = subCondition2.substring(subCondition2.indexOf("==") + 2).trim();
                    prefixReplaced = false;
                    boolean suffixReplaced = false;
                    for (Replacement r : info.getReplacements()) {
                        if (r.getBefore().equals(r.getAfter())) continue;
                        if (r.getAfter().equals(prefix1) && r.getAfter().equals(prefix2)) {
                            prefixReplaced = true;
                        }
                        if (!r.getAfter().equals(suffix1) || !r.getAfter().equals(suffix2)) continue;
                        suffixReplaced = true;
                    }
                    boolean bl = bothPrefixAndSuffixReplaced = prefixReplaced && suffixReplaced;
                    if (!prefix1.equals(prefix2) || !suffix1.equals(suffix2) || bothPrefixAndSuffixReplaced) continue;
                    r2 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                    info.addReplacement(r2);
                    ++invertedConditionals;
                    continue block0;
                }
                if (!subCondition1.contains(".equals(") || !subCondition1.contains(")") || !subCondition2.contains(".equals(") || !subCondition2.contains(")")) continue;
                String arg1 = subCondition1.substring(subCondition1.indexOf(".equals(") + 8, subCondition1.lastIndexOf(")"));
                String arg2 = subCondition2.substring(subCondition2.indexOf(".equals(") + 8, subCondition2.lastIndexOf(")"));
                String prefix12 = subCondition1.substring(0, subCondition1.indexOf(".equals("));
                String prefix22 = subCondition2.substring(0, subCondition2.indexOf(".equals("));
                if (arg2.equals(prefix12) && !arg1.equals(prefix22)) {
                    invertCount = 0;
                    if (arg1.startsWith("!")) {
                        arg1 = arg1.substring(1);
                        ++invertCount;
                    }
                    if (prefix22.startsWith("!")) {
                        prefix22 = prefix22.substring(1);
                        ++invertCount;
                    }
                    String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(arg1, prefix22);
                    String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(arg1, prefix22);
                    if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty() && invertCount == 1) {
                        r2 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                        info.addReplacement(r2);
                        ++invertedConditionals;
                        continue block0;
                    }
                }
                if (!arg1.equals(prefix22) || arg2.equals(prefix12)) continue;
                invertCount = 0;
                if (arg2.startsWith("!")) {
                    arg2 = arg2.substring(1);
                    ++invertCount;
                }
                if (prefix12.startsWith("!")) {
                    prefix12 = prefix12.substring(1);
                    ++invertCount;
                }
                String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(arg2, prefix12);
                String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(arg2, prefix12);
                if (commonPrefix.isEmpty() || commonSuffix.isEmpty() || invertCount != 1) continue;
                r2 = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
                info.addReplacement(r2);
                ++invertedConditionals;
                continue block0;
            }
        }
        return invertedConditionals;
    }

    private static String prepareConditional(String s) {
        int indexOfEquals;
        String conditional = s;
        if (s.startsWith("if(") && s.endsWith(")")) {
            conditional = s.substring(3, s.length() - 1);
        }
        if (s.startsWith("do(") && s.endsWith(")")) {
            conditional = s.substring(3, s.length() - 1);
        }
        if (s.startsWith("while(") && s.endsWith(")")) {
            conditional = s.substring(6, s.length() - 1);
        }
        if (s.startsWith("return ") && s.endsWith(";\n")) {
            conditional = s.substring(7, s.length() - 2);
        }
        if ((indexOfEquals = s.indexOf("=")) > -1 && s.charAt(indexOfEquals + 1) != '=' && s.charAt(indexOfEquals - 1) != '!' && s.endsWith(";\n")) {
            conditional = s.substring(indexOfEquals + 1, s.length() - 2);
        }
        return conditional;
    }

    protected static boolean commonConditional(String s1, String s2, Map<String, String> parameterToArgumentMap, UMLOperationBodyMapper.ReplacementInfo info, AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperationBodyMapper mapper) {
        boolean arrayCreation2;
        Set<Replacement> initialReplacements = info.getReplacements();
        Set<Refactoring> refactorings = mapper.getRefactoringsAfterPostProcessing();
        VariableDeclarationContainer container1 = mapper.getContainer1();
        VariableDeclarationContainer container2 = mapper.getContainer2();
        Set<AbstractCodeMapping> mappings = mapper.getMappings();
        UMLOperationBodyMapper parentMapper = mapper.getParentMapper();
        ObjectCreation creationCoveringTheEntireStatement1 = statement1.creationCoveringEntireFragment();
        ObjectCreation creationCoveringTheEntireStatement2 = statement2.creationCoveringEntireFragment();
        boolean arrayCreation1 = creationCoveringTheEntireStatement1 != null && creationCoveringTheEntireStatement1.isArray();
        boolean bl = arrayCreation2 = creationCoveringTheEntireStatement2 != null && creationCoveringTheEntireStatement2.isArray();
        if (!(arrayCreation1 || arrayCreation2 || StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(s1) || StringBasedHeuristics.containsMethodSignatureOfAnonymousClass(s2))) {
            Replacement r;
            boolean containsNotOperator;
            boolean bl2;
            ArrayList<String> ternaryConditionals1 = new ArrayList<String>();
            for (TernaryOperatorExpression ternaryOperatorExpression : statement1.getTernaryOperatorExpressions()) {
                String string = ternaryOperatorExpression.getCondition().getString();
                String temp0 = new String(string);
                for (Replacement replacement : info.getReplacements()) {
                    temp0 = ReplacementUtil.performReplacement(temp0, replacement.getBefore(), replacement.getAfter());
                }
                ternaryConditionals1.add(temp0);
                String thenExpression = ternaryOperatorExpression.getThenExpression().getString();
                String temp1 = new String(thenExpression);
                for (Replacement replacement : info.getReplacements()) {
                    temp1 = ReplacementUtil.performReplacement(temp1, replacement.getBefore(), replacement.getAfter());
                }
                ternaryConditionals1.add(temp1);
                String elseExpression = ternaryOperatorExpression.getElseExpression().getString();
                String temp2 = new String(elseExpression);
                for (Replacement replacement : info.getReplacements()) {
                    temp2 = ReplacementUtil.performReplacement(temp2, replacement.getBefore(), replacement.getAfter());
                }
                ternaryConditionals1.add(temp2);
            }
            ArrayList<String> ternaryConditionals2 = new ArrayList<String>();
            for (TernaryOperatorExpression ternaryOperatorExpression : statement2.getTernaryOperatorExpressions()) {
                ternaryConditionals2.add(ternaryOperatorExpression.getCondition().getString());
                ternaryConditionals2.add(ternaryOperatorExpression.getThenExpression().getString());
                ternaryConditionals2.add(ternaryOperatorExpression.getElseExpression().getString());
            }
            boolean bl3 = false;
            for (Replacement replacement : info.getReplacements()) {
                if (!replacement.getAfter().contains(" ? ") || !replacement.getAfter().contains(" : ")) continue;
                bl2 = true;
            }
            boolean bl4 = !bl2 && ternaryConditionals1.isEmpty() != ternaryConditionals2.isEmpty() && (statement1.getLocationInfo().getCodeElementType().equals((Object)statement2.getLocationInfo().getCodeElementType()) || statement1 instanceof AbstractExpression);
            boolean containLogicalOperator = s1.contains("||") || s1.contains("&&") || s2.contains("||") || s2.contains("&&");
            boolean bl5 = containsNotOperator = s1.contains("!") != s2.contains("!");
            if (containLogicalOperator || bl4 || containsNotOperator) {
                AbstractCall invocation1;
                ArrayList<String> subConditionsAsList1 = new ArrayList<String>();
                ArrayList<String> subConditionsAsList2 = new ArrayList<String>();
                LinkedHashMap<String, LeafExpression> subConditionMap1 = new LinkedHashMap<String, LeafExpression>();
                LinkedHashMap<String, LeafExpression> subConditionMap2 = new LinkedHashMap<String, LeafExpression>();
                LinkedHashMap<String, LeafExpression> subConditionMap = null;
                if (bl4 && (!containLogicalOperator || statement1 instanceof AbstractExpression)) {
                    if (ternaryConditionals1.isEmpty() && ternaryConditionals2.size() > 0) {
                        conditional1 = StringBasedHeuristics.prepareConditional(s1);
                        String[] subConditions1 = SPLIT_CONDITIONAL_PATTERN.split((CharSequence)conditional1);
                        for (String s : subConditions1) {
                            String[] trimmed = s.trim();
                            subConditionsAsList1.add((String)trimmed);
                            List<LeafExpression> leafExpressions = statement1.findExpression((String)trimmed);
                            if (leafExpressions.size() <= 0) continue;
                            subConditionMap1.put((String)trimmed, leafExpressions.get(0));
                        }
                        for (String ternaryConditional : ternaryConditionals2) {
                            String[] subConditions2;
                            String conditional2 = StringBasedHeuristics.prepareConditional(ternaryConditional);
                            for (String s : subConditions2 = SPLIT_CONDITIONAL_PATTERN.split(conditional2)) {
                                Iterator<CompositeStatementObject> trimmed = s.trim();
                                subConditionsAsList2.add((String)((Object)trimmed));
                                List<LeafExpression> leafExpressions = statement2.findExpression((String)((Object)trimmed));
                                if (leafExpressions.size() <= 0) continue;
                                subConditionMap2.put((String)((Object)trimmed), leafExpressions.get(0));
                            }
                        }
                    } else if (ternaryConditionals2.isEmpty() && ternaryConditionals1.size() > 0) {
                        String[] subConditions2;
                        for (String ternaryConditional : ternaryConditionals1) {
                            String[] subConditions1;
                            String[] conditional1 = StringBasedHeuristics.prepareConditional(ternaryConditional);
                            for (String s : subConditions1 = SPLIT_CONDITIONAL_PATTERN.split((CharSequence)conditional1)) {
                                String trimmed = s.trim();
                                subConditionsAsList1.add(trimmed);
                                leafExpressions = statement1.findExpression(trimmed);
                                if (leafExpressions.size() <= 0) continue;
                                subConditionMap1.put(trimmed, leafExpressions.get(0));
                            }
                        }
                        String conditional2 = StringBasedHeuristics.prepareConditional(s2);
                        for (String s : subConditions2 = SPLIT_CONDITIONAL_PATTERN.split(conditional2)) {
                            String trimmed = s.trim();
                            subConditionsAsList2.add(trimmed);
                            List<LeafExpression> leafExpressions = statement2.findExpression(trimmed);
                            if (leafExpressions.size() <= 0) continue;
                            subConditionMap2.put(trimmed, leafExpressions.get(0));
                        }
                    }
                } else {
                    String trimmed;
                    conditional1 = StringBasedHeuristics.prepareConditional(s1);
                    String conditional2 = StringBasedHeuristics.prepareConditional(s2);
                    String[] subConditions1 = SPLIT_CONDITIONAL_PATTERN.split((CharSequence)conditional1);
                    String[] subConditions2 = SPLIT_CONDITIONAL_PATTERN.split(conditional2);
                    for (String s : subConditions1) {
                        trimmed = s.trim();
                        subConditionsAsList1.add(trimmed);
                        leafExpressions = statement1.findExpression(trimmed);
                        if (leafExpressions.size() <= 0) continue;
                        subConditionMap1.put(trimmed, leafExpressions.get(0));
                    }
                    for (String s : subConditions2) {
                        trimmed = s.trim();
                        subConditionsAsList2.add(trimmed);
                        leafExpressions = statement2.findExpression(trimmed);
                        if (leafExpressions.size() <= 0) continue;
                        subConditionMap2.put(trimmed, leafExpressions.get(0));
                    }
                }
                Set<String> intersection = StringBasedHeuristics.subConditionIntersection(subConditionsAsList1, subConditionsAsList2);
                Set<String> intersection2 = null;
                int matches = StringBasedHeuristics.matchCount(intersection, info);
                boolean pass = StringBasedHeuristics.pass(subConditionsAsList1, subConditionsAsList2, intersection, matches);
                int invertedConditionals = 0;
                if (pass && info.getReplacements(Replacement.ReplacementType.TYPE).isEmpty() && StringBasedHeuristics.validMethodInvocationReplacement(info)) {
                    IntersectionReplacement r2 = new IntersectionReplacement(s1, s2, Replacement.ReplacementType.CONDITIONAL);
                    StringBasedHeuristics.createLeafMappings(container1, container2, subConditionMap1, subConditionMap2, intersection, r2);
                    info.addReplacement(r2);
                    CompositeStatementObject root1 = statement1.getParent();
                    CompositeStatementObject root2 = statement2.getParent();
                    LinkedHashSet<CompositeStatementObject> ifNodes1 = new LinkedHashSet<CompositeStatementObject>();
                    LinkedHashSet<CompositeStatementObject> ifNodes2 = new LinkedHashSet<CompositeStatementObject>();
                    if (root1 != null && root1.getParent() != null && root1.getParent().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) && !mapper.alreadyMatched1(root1.getParent())) {
                        ifNodes1.add(root1.getParent());
                        if (StringBasedHeuristics.hasElseIfBranch(root1.getParent())) {
                            ifNodes1.add((CompositeStatementObject)root1.getParent().getStatements().get(1));
                        }
                    }
                    if (root2 != null && root2.getParent() != null && root2.getParent().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) && !mapper.alreadyMatched2(root2.getParent())) {
                        ifNodes2.add(root2.getParent());
                        if (StringBasedHeuristics.hasElseIfBranch(root2.getParent())) {
                            ifNodes2.add((CompositeStatementObject)root2.getParent().getStatements().get(1));
                        }
                    }
                    if (root1 != null && root1.getParent() == null && statement1 instanceof CompositeStatementObject && root2 != null && root2.getParent() == null && statement2 instanceof CompositeStatementObject) {
                        root1 = (CompositeStatementObject)statement1;
                        root2 = (CompositeStatementObject)statement2;
                    }
                    if (root1 != null && root2 != null) {
                        for (CompositeStatementObject innerNode : root1.getInnerNodes()) {
                            if (!innerNode.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) || mapper.alreadyMatched1(innerNode)) continue;
                            ifNodes1.add(innerNode);
                        }
                        if (root1.getParent() != null && parentMapper == null) {
                            for (CompositeStatementObject innerNode : root1.getParent().getInnerNodes()) {
                                if (!innerNode.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) || mapper.alreadyMatched1(innerNode)) continue;
                                ifNodes1.add(innerNode);
                            }
                        }
                        for (CompositeStatementObject innerNode : root2.getInnerNodes()) {
                            if (!innerNode.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) || mapper.alreadyMatched2(innerNode)) continue;
                            ifNodes2.add(innerNode);
                        }
                        if (root2.getParent() != null && parentMapper == null) {
                            for (CompositeStatementObject innerNode : root2.getParent().getInnerNodes()) {
                                if (!innerNode.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) || mapper.alreadyMatched2(innerNode)) continue;
                                ifNodes2.add(innerNode);
                            }
                        }
                    }
                    int identicalIfNodes1 = 0;
                    int identicalIfNodes2 = 0;
                    if (ifNodes1.size() == ifNodes2.size()) {
                        List<CompositeStatementObject> innerNodes1 = container1.getBody().getCompositeStatement().getInnerNodes();
                        List<CompositeStatementObject> innerNodes2 = container2.getBody().getCompositeStatement().getInnerNodes();
                        for (CompositeStatementObject ifNode1 : ifNodes1) {
                            if (!StringBasedHeuristics.identicalCompositeInTheOtherContainer(ifNode1, innerNodes2)) continue;
                            ++identicalIfNodes1;
                        }
                        for (CompositeStatementObject ifNode2 : ifNodes2) {
                            if (!StringBasedHeuristics.identicalCompositeInTheOtherContainer(ifNode2, innerNodes1)) continue;
                            ++identicalIfNodes2;
                        }
                    }
                    if (ifNodes1.size() - identicalIfNodes1 < ifNodes2.size() - identicalIfNodes2) {
                        boolean splitConditional = false;
                        for (CompositeStatementObject ifNode2 : ifNodes2) {
                            int matches2;
                            List<AbstractExpression> expressions2 = ifNode2.getExpressions();
                            if (expressions2.size() <= 0 || statement2.equals(ifNode2) || ifNode2.getExpressions().contains(statement2) || StringBasedHeuristics.containsIdenticalIfNode(ifNodes1, ifNode2) || !StringBasedHeuristics.sequentiallySplitConditional(statement1, ifNode2, statement2, mappings)) continue;
                            AbstractExpression ifExpression2 = expressions2.get(0);
                            String conditional = ifExpression2.getString();
                            String[] subConditions = SPLIT_CONDITIONAL_PATTERN.split(conditional);
                            ArrayList<String> subConditionsAsList = new ArrayList<String>();
                            subConditionMap = new LinkedHashMap<String, LeafExpression>();
                            for (String s : subConditions) {
                                String trimmed = s.trim();
                                subConditionsAsList.add(trimmed);
                                List<LeafExpression> leafExpressions = ifNode2.findExpression(trimmed);
                                if (leafExpressions.size() <= 0) continue;
                                subConditionMap.put(trimmed, leafExpressions.get(0));
                            }
                            intersection2 = StringBasedHeuristics.subConditionIntersection(subConditionsAsList1, subConditionsAsList);
                            boolean pass2 = StringBasedHeuristics.pass(subConditionsAsList1, subConditionsAsList, intersection2, matches2 = StringBasedHeuristics.matchCount(intersection2, info));
                            if (pass2 && !intersection.containsAll(intersection2)) {
                                LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements2 = new LinkedHashSet<AbstractCodeFragment>();
                                additionallyMatchedStatements2.add(ifNode2);
                                CompositeReplacement composite = new CompositeReplacement(statement1.getString(), ifNode2.getString(), new LinkedHashSet<AbstractCodeFragment>(), additionallyMatchedStatements2);
                                info.addReplacement(composite);
                                splitConditional = true;
                                invertedConditionals = StringBasedHeuristics.checkForInvertedConditionals(subConditionsAsList1, subConditionsAsList, info);
                                continue;
                            }
                            if (!(statement1 instanceof CompositeStatementObject)) continue;
                            CompositeStatementObject composite1 = (CompositeStatementObject)statement1;
                            for (AbstractExpression expression : composite1.getExpressions()) {
                                String originalConditional1 = StringBasedHeuristics.prepareConditional(expression.getString());
                                String[] originalSubConditions1 = SPLIT_CONDITIONAL_PATTERN.split(originalConditional1);
                                ArrayList<String> originalSubConditionsAsList1 = new ArrayList<String>();
                                for (String s : originalSubConditions1) {
                                    originalSubConditionsAsList1.add(s.trim());
                                }
                                for (LeafMapping commonElement : r2.getSubExpressionMappings()) {
                                    originalSubConditionsAsList1.remove(commonElement.getFragment1().getString());
                                }
                                for (String subCondition1 : originalSubConditionsAsList1) {
                                    block26: for (String subCondition2 : subConditionsAsList) {
                                        int endIndexS1;
                                        if (subCondition1.equals(subCondition2)) {
                                            boolean replacementFound = false;
                                            for (Replacement initialReplacement : initialReplacements) {
                                                if (!subCondition1.contains(initialReplacement.getBefore())) continue;
                                                replacementFound = true;
                                                break;
                                            }
                                            if (!replacementFound) {
                                                LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements2 = new LinkedHashSet<AbstractCodeFragment>();
                                                additionallyMatchedStatements2.add(ifNode2);
                                                CompositeReplacement composite = new CompositeReplacement(statement1.getString(), ifNode2.getString(), new LinkedHashSet<AbstractCodeFragment>(), additionallyMatchedStatements2);
                                                info.addReplacement(composite);
                                                splitConditional = true;
                                            }
                                        }
                                        if (subCondition1.endsWith(" != null") && subCondition2.endsWith(" != null") || subCondition1.endsWith(" == null") && subCondition2.endsWith(" == null")) {
                                            String prefix1 = subCondition1.substring(0, subCondition1.length() - 8);
                                            String prefix2 = subCondition2.substring(0, subCondition2.length() - 8);
                                            for (AbstractCodeMapping mapping : mappings) {
                                                VariableDeclaration variableDeclaration1 = mapping.getFragment1().getVariableDeclaration(prefix1);
                                                VariableDeclaration variableDeclaration2 = mapping.getFragment2().getVariableDeclaration(prefix1);
                                                if (variableDeclaration1 == null || variableDeclaration2 == null) continue;
                                                boolean relatedVariables = false;
                                                if (variableDeclaration1.getInitializer() != null && variableDeclaration1.getInitializer().getExpression().startsWith(prefix2 + ".")) {
                                                    relatedVariables = true;
                                                }
                                                if (variableDeclaration2.getInitializer() != null && variableDeclaration2.getInitializer().getExpression().startsWith(prefix2 + ".")) {
                                                    relatedVariables = true;
                                                }
                                                if (!relatedVariables) continue;
                                                LinkedHashSet<AbstractCodeFragment> linkedHashSet = new LinkedHashSet<AbstractCodeFragment>();
                                                linkedHashSet.add(ifNode2);
                                                CompositeReplacement composite = new CompositeReplacement(statement1.getString(), ifNode2.getString(), new LinkedHashSet<AbstractCodeFragment>(), linkedHashSet);
                                                info.addReplacement(composite);
                                                splitConditional = true;
                                                break;
                                            }
                                        }
                                        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(subCondition1, subCondition2);
                                        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(subCondition1, subCondition2);
                                        if (commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
                                            int endIndexS12 = subCondition1.lastIndexOf(commonSuffix);
                                            String diff1 = subCondition1.substring(0, endIndexS12);
                                            int endIndexS2 = subCondition2.lastIndexOf(commonSuffix);
                                            String diff2 = subCondition2.substring(0, endIndexS2);
                                            for (AbstractCodeFragment abstractCodeFragment : info.getStatements2()) {
                                                VariableDeclaration variableDeclaration;
                                                if (abstractCodeFragment.getVariableDeclarations().size() <= 0 || !(variableDeclaration = abstractCodeFragment.getVariableDeclarations().get(0)).getVariableName().equals(diff2) || variableDeclaration.getInitializer() == null || !variableDeclaration.getInitializer().getString().equals(diff1)) continue;
                                                LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements2 = new LinkedHashSet<AbstractCodeFragment>();
                                                additionallyMatchedStatements2.add(ifNode2);
                                                CompositeReplacement composite = new CompositeReplacement(statement1.getString(), ifNode2.getString(), new LinkedHashSet<AbstractCodeFragment>(), additionallyMatchedStatements2);
                                                info.addReplacement(composite);
                                                splitConditional = true;
                                                ExtractVariableRefactoring extract = new ExtractVariableRefactoring(variableDeclaration, container1, container2, parentMapper != null);
                                                List<LeafExpression> subExpressions = expression.findExpression(variableDeclaration.getInitializer().getString());
                                                for (LeafExpression subExpression : subExpressions) {
                                                    LeafMapping leafMapping = new LeafMapping(subExpression, variableDeclaration.getInitializer(), container1, container2);
                                                    extract.addSubExpressionMapping(leafMapping);
                                                }
                                                refactorings.add(extract);
                                                continue block26;
                                            }
                                            continue;
                                        }
                                        if (commonPrefix.isEmpty() || commonSuffix.isEmpty()) continue;
                                        int beginIndexS1 = subCondition1.indexOf(commonPrefix) + commonPrefix.length();
                                        String diff1 = beginIndexS1 > (endIndexS1 = subCondition1.lastIndexOf(commonSuffix)) ? "" : subCondition1.substring(beginIndexS1, endIndexS1);
                                        int beginIndexS2 = subCondition2.indexOf(commonPrefix) + commonPrefix.length();
                                        int endIndexS2 = subCondition2.lastIndexOf(commonSuffix);
                                        String string = beginIndexS2 > endIndexS2 ? "" : subCondition2.substring(beginIndexS2, endIndexS2);
                                        for (Replacement replacement : info.getReplacements()) {
                                            String tmp;
                                            if (!diff1.contains(replacement.getBefore()) || !string.contains(replacement.getAfter()) || !(tmp = string.replace(replacement.getAfter(), replacement.getBefore())).equals(diff1) && (tmp.length() != diff1.length() || StringDistance.editDistance(diff1, tmp) > 1)) continue;
                                            LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements2 = new LinkedHashSet<AbstractCodeFragment>();
                                            additionallyMatchedStatements2.add(ifNode2);
                                            CompositeReplacement composite = new CompositeReplacement(statement1.getString(), ifNode2.getString(), new LinkedHashSet<AbstractCodeFragment>(), additionallyMatchedStatements2);
                                            info.addReplacement(composite);
                                            splitConditional = true;
                                            continue block26;
                                        }
                                    }
                                }
                            }
                        }
                        if (splitConditional) {
                            List<Replacement> compositeReplacements = info.getReplacements(Replacement.ReplacementType.COMPOSITE);
                            LinkedHashSet<AbstractCodeFragment> splitConditionals = new LinkedHashSet<AbstractCodeFragment>();
                            if (statement2 instanceof AbstractExpression) {
                                CompositeStatementObject owner = ((AbstractExpression)statement2).getOwner();
                                if (owner != null) {
                                    splitConditionals.add(owner);
                                }
                            } else {
                                splitConditionals.add(statement2);
                            }
                            for (Replacement compositeReplacement : compositeReplacements) {
                                splitConditionals.addAll(((CompositeReplacement)compositeReplacement).getAdditionallyMatchedStatements2());
                            }
                            if (StringBasedHeuristics.sequentiallySplitConditionals(statement1, splitConditionals, mappings)) {
                                SplitConditionalRefactoring split = new SplitConditionalRefactoring(statement1, splitConditionals, container1, container2);
                                boolean splitConditionalConflict = false;
                                LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
                                for (Refactoring refactoring : refactorings) {
                                    if (!(refactoring instanceof SplitConditionalRefactoring)) continue;
                                    SplitConditionalRefactoring oldSplit = (SplitConditionalRefactoring)refactoring;
                                    if (!split.getOriginalConditional().equals(oldSplit.getOriginalConditional()) || split.equals(oldSplit)) continue;
                                    splitConditionalConflict = true;
                                    refactoringsToBeRemoved.add(refactoring);
                                    break;
                                }
                                refactorings.removeAll(refactoringsToBeRemoved);
                                if (!splitConditionalConflict) {
                                    refactorings.add(split);
                                    StringBasedHeuristics.createLeafMappings(container1, container2, subConditionMap1, subConditionMap2, intersection, split);
                                    StringBasedHeuristics.createLeafMappings(container1, container2, subConditionMap1, subConditionMap, intersection2, split);
                                }
                            }
                        }
                        StringBasedHeuristics.checkForMergeConditionals(statement1, statement2, mapper, refactorings, container1, container2, mappings, subConditionsAsList2, subConditionMap1, subConditionMap2, subConditionMap, intersection, intersection2, ifNodes1, ifNodes2, info, parameterToArgumentMap);
                    } else if (ifNodes1.size() > ifNodes2.size()) {
                        StringBasedHeuristics.checkForMergeConditionals(statement1, statement2, mapper, refactorings, container1, container2, mappings, subConditionsAsList2, subConditionMap1, subConditionMap2, subConditionMap, intersection, intersection2, ifNodes1, ifNodes2, info, parameterToArgumentMap);
                    }
                }
                invertedConditionals = StringBasedHeuristics.checkForInvertedConditionals(subConditionsAsList1, subConditionsAsList2, info);
                boolean onlyInfixOperatorReplacementsFound = false;
                if (matches == 0 && invertedConditionals == 0 && intersection.size() > 0) {
                    String element;
                    int count = 0;
                    boolean invalidReplacement = false;
                    for (Replacement r3 : initialReplacements) {
                        if (r3.getType().equals((Object)Replacement.ReplacementType.CONDITIONAL) || r3.getType().equals((Object)Replacement.ReplacementType.INVERT_CONDITIONAL) || r3.getType().equals((Object)Replacement.ReplacementType.NULL_LITERAL_CHECK_REPLACED_WITH_OPTIONAL_IS_EMPTY_CHECK) || r3.getType().equals((Object)Replacement.ReplacementType.NULL_LITERAL_CHECK_REPLACED_WITH_OPTIONAL_IS_PRESENT_CHECK) || r3.getType().equals((Object)Replacement.ReplacementType.NULL_LITERAL_REPLACED_WITH_OPTIONAL_EMPTY)) continue;
                        ++count;
                        if (!(r3.getBefore().equals("<") && r3.getAfter().equals("!=") || r3.getBefore().equals(">") && r3.getAfter().equals("!=") || r3.getBefore().equals("<=") && r3.getAfter().equals("!=") || r3.getBefore().equals(">=") && r3.getAfter().equals("!=") || r3.getBefore().equals("<") && r3.getAfter().equals("==") || r3.getBefore().equals(">") && r3.getAfter().equals("==") || r3.getBefore().equals("<=") && r3.getAfter().equals("==")) && (!r3.getBefore().equals(">=") || !r3.getAfter().equals("=="))) continue;
                        invalidReplacement = true;
                    }
                    boolean singleNullCheck = false;
                    if (intersection.size() == 1 && ((element = intersection.iterator().next()).contains("== null") || element.contains("!= null"))) {
                        singleNullCheck = true;
                    }
                    if (count > 0 && !singleNullCheck && !invalidReplacement && info.getReplacements(Replacement.ReplacementType.INFIX_OPERATOR).size() == count) {
                        onlyInfixOperatorReplacementsFound = true;
                    }
                }
                if ((invertedConditionals > 0 || matches > 0 || onlyInfixOperatorReplacementsFound) && info.getReplacements(Replacement.ReplacementType.TYPE).isEmpty() && StringBasedHeuristics.validMethodInvocationReplacement(info) && !StringBasedHeuristics.includesLocalVariable(statement1, statement2, intersection, container1, container2)) {
                    List<Replacement> operatorReplacements = info.getReplacements(Replacement.ReplacementType.INFIX_OPERATOR);
                    boolean booleanOperatorReversed = false;
                    for (Replacement r2 : operatorReplacements) {
                        if (r2.getBefore().equals("&&") && r2.getAfter().equals("||")) {
                            booleanOperatorReversed = true;
                            continue;
                        }
                        if (r2.getBefore().equals("||") && r2.getAfter().equals("&&")) {
                            booleanOperatorReversed = true;
                            continue;
                        }
                        if (r2.getBefore().equals("==") && r2.getAfter().equals("!=")) {
                            booleanOperatorReversed = true;
                            continue;
                        }
                        if (!r2.getBefore().equals("!=") || !r2.getAfter().equals("==")) continue;
                        booleanOperatorReversed = true;
                    }
                    if (matches == invertedConditionals && (booleanOperatorReversed || !containLogicalOperator)) {
                        if (statement1 instanceof AbstractExpression) {
                            CompositeStatementObject owner = ((AbstractExpression)statement1).getOwner();
                            if (owner != null) {
                                InvertConditionRefactoring invert = new InvertConditionRefactoring(owner, statement2, container1, container2);
                                refactorings.add(invert);
                            }
                        } else {
                            InvertConditionRefactoring invert = new InvertConditionRefactoring(statement1, statement2, container1, container2);
                            refactorings.add(invert);
                        }
                    }
                    return true;
                }
                if (!pass && statement1 instanceof AbstractExpression && !(statement2 instanceof AbstractExpression) && (invocation1 = statement1.invocationCoveringEntireFragment()) != null) {
                    for (AbstractCall invocation2 : statement2.getMethodInvocations()) {
                        if (!invocation1.compatibleName(invocation2) || invocation1.arguments().size() != invocation2.arguments().size()) continue;
                        if (subConditionsAsList2.size() > 1) {
                            Replacement r2;
                            r2 = new IntersectionReplacement(s1, s2, Replacement.ReplacementType.CONDITIONAL);
                            LeafMapping leafMapping = new LeafMapping(invocation1, invocation2, container1, container2);
                            ((IntersectionReplacement)r2).addSubExpressionMapping(leafMapping);
                            info.addReplacement(r2);
                        }
                        if (statement1.getString().contains("!" + invocation1.actualString()) && !statement2.getString().contains("!" + invocation2.actualString())) {
                            r2 = new Replacement("!" + invocation1.actualString(), invocation2.actualString(), Replacement.ReplacementType.INVERT_CONDITIONAL);
                            info.addReplacement(r2);
                        } else if (!statement1.getString().contains("!" + invocation1.actualString()) && statement2.getString().contains("!" + invocation2.actualString())) {
                            r2 = new Replacement(invocation1.actualString(), "!" + invocation2.actualString(), Replacement.ReplacementType.INVERT_CONDITIONAL);
                            info.addReplacement(r2);
                        }
                        return true;
                    }
                }
            }
            if (s1.contains(" >= ") && s2.contains(" <= ") && (r = StringBasedHeuristics.invertConditionalDirection(s1, s2, " >= ", " <= ")) != null) {
                info.addReplacement(r);
                return true;
            }
            if (s1.contains(" <= ") && s2.contains(" >= ") && (r = StringBasedHeuristics.invertConditionalDirection(s1, s2, " <= ", " >= ")) != null) {
                info.addReplacement(r);
                return true;
            }
            if (s1.contains(" > ") && s2.contains(" < ") && (r = StringBasedHeuristics.invertConditionalDirection(s1, s2, " > ", " < ")) != null) {
                info.addReplacement(r);
                return true;
            }
            if (s1.contains(" < ") && s2.contains(" > ") && (r = StringBasedHeuristics.invertConditionalDirection(s1, s2, " < ", " > ")) != null) {
                info.addReplacement(r);
                return true;
            }
        }
        return false;
    }

    private static boolean identicalCompositeInTheOtherContainer(CompositeStatementObject innedNode1, List<CompositeStatementObject> innerNodes2) {
        for (CompositeStatementObject innerNode2 : innerNodes2) {
            if (!innerNode2.getString().equals(innedNode1.getString())) continue;
            return true;
        }
        return false;
    }

    private static boolean validMethodInvocationReplacement(UMLOperationBodyMapper.ReplacementInfo info) {
        AbstractCall after;
        MethodInvocationReplacement r;
        AbstractCall before;
        List<Replacement> replacements = info.getReplacements(Replacement.ReplacementType.METHOD_INVOCATION);
        if (replacements.isEmpty()) {
            return true;
        }
        return replacements.size() == 1 && (before = (r = (MethodInvocationReplacement)replacements.get(0)).getInvokedOperationBefore()).identicalName(after = r.getInvokedOperationAfter()) && before.identicalWithExpressionArgumentSwap(after);
    }

    private static void checkForMergeConditionals(AbstractCodeFragment statement1, AbstractCodeFragment statement2, UMLOperationBodyMapper mapper, Set<Refactoring> refactorings, VariableDeclarationContainer container1, VariableDeclarationContainer container2, Set<AbstractCodeMapping> mappings, List<String> subConditionsAsList2, Map<String, LeafExpression> subConditionMap1, Map<String, LeafExpression> subConditionMap2, Map<String, LeafExpression> subConditionMap, Set<String> intersection, Set<String> intersection2, Set<CompositeStatementObject> ifNodes1, Set<CompositeStatementObject> ifNodes2, UMLOperationBodyMapper.ReplacementInfo info, Map<String, String> parameterToArgumentMap) {
        boolean mergeConditional = false;
        for (CompositeStatementObject ifNode1 : ifNodes1) {
            int matches2;
            List<AbstractExpression> expressions1 = ifNode1.getExpressions();
            if (expressions1.size() <= 0 || statement1.equals(ifNode1) || ifNode1.getExpressions().contains(statement1) || StringBasedHeuristics.containsIdenticalIfNode(ifNodes2, ifNode1) || !StringBasedHeuristics.sequentiallyMergedConditional(ifNode1, statement1, statement2, mappings)) continue;
            AbstractExpression ifExpression1 = expressions1.get(0);
            String conditional = ifExpression1.getString();
            String[] subConditions = SPLIT_CONDITIONAL_PATTERN.split(conditional);
            ArrayList<String> subConditionsAsList = new ArrayList<String>();
            subConditionMap = new LinkedHashMap<String, LeafExpression>();
            for (String s : subConditions) {
                String trimmed = s.trim();
                String temp1 = new String(trimmed);
                List<LeafExpression> leafExpressions = ifNode1.findExpression(trimmed);
                for (Replacement replacement : info.getReplacements()) {
                    if (replacement instanceof IntersectionReplacement) continue;
                    temp1 = ReplacementUtil.performReplacement(temp1, replacement.getBefore(), replacement.getAfter());
                }
                subConditionsAsList.add(temp1);
                if (leafExpressions.size() <= 0) continue;
                subConditionMap.put(temp1, leafExpressions.get(0));
            }
            intersection2 = StringBasedHeuristics.subConditionIntersection(subConditionsAsList, subConditionsAsList2);
            boolean pass2 = StringBasedHeuristics.pass(subConditionsAsList, subConditionsAsList2, intersection2, matches2 = StringBasedHeuristics.matchCount(intersection2, info));
            if (!pass2 || intersection.containsAll(intersection2)) continue;
            LinkedHashSet<AbstractCodeFragment> additionallyMatchedStatements1 = new LinkedHashSet<AbstractCodeFragment>();
            additionallyMatchedStatements1.add(ifNode1);
            CompositeReplacement composite = new CompositeReplacement(ifNode1.getString(), statement2.getString(), additionallyMatchedStatements1, new LinkedHashSet<AbstractCodeFragment>());
            info.addReplacement(composite);
            mergeConditional = true;
        }
        if (mergeConditional) {
            List<Replacement> compositeReplacements = info.getReplacements(Replacement.ReplacementType.COMPOSITE);
            LinkedHashSet<AbstractCodeFragment> mergedConditionals = new LinkedHashSet<AbstractCodeFragment>();
            if (statement1 instanceof AbstractExpression) {
                CompositeStatementObject owner = ((AbstractExpression)statement1).getOwner();
                if (owner != null) {
                    mergedConditionals.add(owner);
                }
            } else {
                mergedConditionals.add(statement1);
            }
            for (Replacement compositeReplacement : compositeReplacements) {
                mergedConditionals.addAll(((CompositeReplacement)compositeReplacement).getAdditionallyMatchedStatements1());
            }
            if (StringBasedHeuristics.sequentiallyMergedConditionals(mergedConditionals, statement2, mappings)) {
                MergeConditionalRefactoring merge = new MergeConditionalRefactoring(mergedConditionals, statement2, container1, container2);
                boolean mergeConditionalsConflict = false;
                LinkedHashSet<Refactoring> refactoringsToBeRemoved = new LinkedHashSet<Refactoring>();
                for (Refactoring refactoring : refactorings) {
                    if (!(refactoring instanceof MergeConditionalRefactoring)) continue;
                    MergeConditionalRefactoring oldMerge = (MergeConditionalRefactoring)refactoring;
                    if (!merge.getMergedConditionals().equals(oldMerge.getMergedConditionals()) || merge.equals(oldMerge)) continue;
                    mergeConditionalsConflict = true;
                    refactoringsToBeRemoved.add(refactoring);
                    break;
                }
                refactorings.removeAll(refactoringsToBeRemoved);
                if (!mergeConditionalsConflict) {
                    refactorings.add(merge);
                    StringBasedHeuristics.createLeafMappings(container1, container2, subConditionMap1, subConditionMap2, intersection, merge);
                    StringBasedHeuristics.createLeafMappings(container1, container2, subConditionMap, subConditionMap2, intersection2, merge);
                    mapper.createMultiMappingsForDuplicatedStatements(mergedConditionals, statement2, parameterToArgumentMap);
                }
            }
        }
    }

    private static void createLeafMappings(VariableDeclarationContainer container1, VariableDeclarationContainer container2, Map<String, LeafExpression> subConditionMap1, Map<String, LeafExpression> subConditionMap2, Set<String> intersection, LeafMappingProvider provider) {
        for (String key : intersection) {
            String suffix;
            String prefix;
            LeafExpression leaf2;
            LeafExpression leaf1 = subConditionMap1.get(key);
            if (leaf1 == null) {
                leaf1 = subConditionMap1.get("!" + key);
            }
            if (leaf1 == null) {
                leaf1 = subConditionMap1.get("!(" + key + ")");
            }
            if ((leaf2 = subConditionMap2.get(key)) == null) {
                leaf2 = subConditionMap2.get("!" + key);
            }
            if (leaf2 == null) {
                leaf2 = subConditionMap2.get("!(" + key + ")");
            }
            if (leaf2 == null && key.contains("==")) {
                prefix = key.substring(0, key.indexOf("=="));
                suffix = key.substring(key.indexOf("==") + 2);
                leaf2 = subConditionMap2.get(prefix + "!=" + suffix);
            }
            if (leaf2 == null && key.contains("!=")) {
                prefix = key.substring(0, key.indexOf("!="));
                suffix = key.substring(key.indexOf("!=") + 2);
                leaf2 = subConditionMap2.get(prefix + "==" + suffix);
            }
            if (leaf1 == null || leaf2 == null) continue;
            LeafMapping leafMapping = new LeafMapping(leaf1, leaf2, container1, container2);
            provider.addSubExpressionMapping(leafMapping);
        }
    }

    private static int matchCount(Set<String> intersection, UMLOperationBodyMapper.ReplacementInfo info) {
        int matches = 0;
        if (!intersection.isEmpty()) {
            for (String element : intersection) {
                boolean replacementFound = false;
                for (Replacement r : info.getReplacements()) {
                    boolean getterReplacement = false;
                    if (r instanceof VariableReplacementWithMethodInvocation) {
                        getterReplacement = ((VariableReplacementWithMethodInvocation)r).getterReplacement();
                    }
                    if (element.equals(r.getAfter()) || element.equals("(" + r.getAfter()) || element.equals(r.getAfter() + ")")) {
                        replacementFound = true;
                        break;
                    }
                    if (element.equals("!" + r.getAfter())) {
                        replacementFound = true;
                        break;
                    }
                    if (r.getType().equals((Object)Replacement.ReplacementType.INFIX_OPERATOR) && element.contains(r.getAfter())) {
                        replacementFound = true;
                        break;
                    }
                    if (r.getType().equals((Object)Replacement.ReplacementType.INFIX_EXPRESSION) && element.contains(r.getAfter())) {
                        replacementFound = true;
                        break;
                    }
                    if (getterReplacement || !ReplacementUtil.contains(element, r.getAfter()) || !element.startsWith(r.getAfter()) || !element.endsWith(" != null") && !element.endsWith(" == null") && !element.endsWith(" != 0") && !element.endsWith(" == 0")) continue;
                    replacementFound = true;
                    break;
                }
                if (replacementFound) continue;
                ++matches;
            }
        }
        return matches;
    }

    private static boolean pass(List<String> subConditionsAsList1, List<String> subConditionsAsList2, Set<String> intersection, int matches) {
        boolean pass = false;
        pass = matches == 1 && intersection.size() == 1 && intersection.iterator().next().endsWith("null") ? matches == Math.min(subConditionsAsList1.size(), subConditionsAsList2.size()) : matches > 0;
        return pass;
    }

    private static boolean includesLocalVariable(AbstractCodeFragment statement1, AbstractCodeFragment statement2, Set<String> intersection, VariableDeclarationContainer container1, VariableDeclarationContainer container2) {
        if (statement1 instanceof AbstractExpression) {
            for (String commonString : intersection) {
                if (!statement1.getString().equals(commonString) && !statement1.getString().equals("!" + commonString) || container1.getVariableDeclaration(commonString) == null) continue;
                return true;
            }
        }
        if (statement2 instanceof AbstractExpression) {
            for (String commonString : intersection) {
                if (!statement2.getString().equals(commonString) && !statement2.getString().equals("!" + commonString) || container2.getVariableDeclaration(commonString) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsIdenticalIfNode(Set<CompositeStatementObject> ifNodes1, CompositeStatementObject ifNode2) {
        for (CompositeStatementObject ifNode1 : ifNodes1) {
            if (!ifNode1.getString().equals(ifNode2.getString())) continue;
            return true;
        }
        return false;
    }

    private static Replacement invertConditionalDirection(String s1, String s2, String operator1, String operator2) {
        int j;
        int indexS1 = s1.indexOf(operator1);
        int indexS2 = s2.indexOf(operator2);
        int i = indexS1 + operator1.length();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (j = indexS2 - 1; i < s1.length() && j >= 0; ++i, --j) {
            sb1.append(s1.charAt(i));
            sb2.insert(0, s2.charAt(j));
            if (!sb1.toString().equals(sb2.toString())) continue;
            String subCondition1 = operator1 + sb1.toString();
            String subCondition2 = sb2.toString() + operator2;
            Replacement r = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
            return r;
        }
        i = indexS1 - 1;
        sb1 = new StringBuilder();
        sb2 = new StringBuilder();
        for (j = indexS2 + operator2.length(); i >= 0 && j < s2.length(); --i, ++j) {
            sb1.insert(0, s1.charAt(i));
            sb2.append(s2.charAt(j));
            if (!sb1.toString().equals(sb2.toString())) continue;
            String subCondition1 = sb1.toString() + operator1;
            String subCondition2 = operator2 + sb2.toString();
            Replacement r = new Replacement(subCondition1, subCondition2, Replacement.ReplacementType.INVERT_CONDITIONAL);
            return r;
        }
        return null;
    }

    private static boolean sequentiallyMergedConditionals(Set<AbstractCodeFragment> mergedConditionals, AbstractCodeFragment statement2, Set<AbstractCodeMapping> mappings) {
        for (AbstractCodeMapping abstractCodeMapping : mappings) {
            boolean nestedFragment2;
            int nestedFragment1 = 0;
            for (AbstractCodeFragment mergedConditional : mergedConditionals) {
                if (!mergedConditional.getLocationInfo().subsumes(abstractCodeMapping.getFragment1().getLocationInfo()) && !StringBasedHeuristics.subsumedByOther(mergedConditionals, mergedConditional)) continue;
                ++nestedFragment1;
            }
            boolean bl = nestedFragment2 = statement2.getLocationInfo().subsumes(abstractCodeMapping.getFragment2().getLocationInfo()) || statement2.getTernaryOperatorExpressions().size() > 0;
            if (nestedFragment1 != mergedConditionals.size() || !nestedFragment2) continue;
            return true;
        }
        boolean leafConditional1 = false;
        for (AbstractCodeFragment mergedConditional : mergedConditionals) {
            if (!(mergedConditional instanceof StatementObject)) continue;
            leafConditional1 = true;
            break;
        }
        boolean bl = statement2 instanceof StatementObject;
        if (leafConditional1 && bl) {
            return true;
        }
        if (statement2.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
            String[] subConditions2;
            ArrayList<String> subConditionsAsList2 = new ArrayList<String>();
            CompositeStatementObject comp2 = (CompositeStatementObject)statement2;
            String conditional2 = StringBasedHeuristics.prepareConditional(comp2.getExpressions().get(0).getString());
            for (String s : subConditions2 = SPLIT_CONDITIONAL_PATTERN.split(conditional2)) {
                subConditionsAsList2.add(s.trim());
            }
            int invertedMergedConditionals = 0;
            for (AbstractCodeFragment mergedConditional : mergedConditionals) {
                ArrayList<String> subConditionsAsList1 = new ArrayList<String>();
                if (mergedConditional.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
                    String[] subConditions1;
                    CompositeStatementObject comp1 = (CompositeStatementObject)mergedConditional;
                    String conditional1 = StringBasedHeuristics.prepareConditional(comp1.getExpressions().get(0).getString());
                    for (String s : subConditions1 = SPLIT_CONDITIONAL_PATTERN.split(conditional1)) {
                        subConditionsAsList1.add(s.trim());
                    }
                }
                Set<String> intersection = StringBasedHeuristics.subConditionIntersection(subConditionsAsList1, subConditionsAsList2);
                int invertedConditions = 0;
                for (String intersectionElement : intersection) {
                    if (subConditionsAsList2.contains(intersectionElement)) continue;
                    ++invertedConditions;
                }
                if (invertedConditions != intersection.size()) continue;
                ++invertedMergedConditionals;
            }
            if (invertedMergedConditionals == mergedConditionals.size()) {
                for (AbstractCodeFragment leaf : comp2.getLeaves()) {
                    if (!leaf.isKeyword() && !leaf.getString().equals("return false;\n") && !leaf.getString().equals("return true;\n") || !statement2.getLocationInfo().subsumes(leaf.getLocationInfo()) && !statement2.getLocationInfo().before(leaf.getLocationInfo())) continue;
                    return true;
                }
            }
        }
        return StringBasedHeuristics.conditionalsUnderTheSameParent(mergedConditionals);
    }

    private static boolean sequentiallyMergedConditional(AbstractCodeFragment mergedConditional, AbstractCodeFragment statement1, AbstractCodeFragment statement2, Set<AbstractCodeMapping> mappings) {
        for (AbstractCodeMapping mapping : mappings) {
            boolean nestedFragment1 = false;
            if (mergedConditional.getLocationInfo().subsumes(mapping.getFragment1().getLocationInfo())) {
                nestedFragment1 = true;
            } else if (mergedConditional instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)mergedConditional;
                for (AbstractCodeFragment leaf : composite.getLeaves()) {
                    if (!leaf.isKeyword() && !leaf.getString().equals("return false;\n") && !leaf.getString().equals("return true;\n") || !statement1.getLocationInfo().subsumes(leaf.getLocationInfo()) && !statement1.getLocationInfo().before(leaf.getLocationInfo())) continue;
                    nestedFragment1 = true;
                    break;
                }
            }
            boolean nestedFragment2 = false;
            if (statement2.getLocationInfo().subsumes(mapping.getFragment2().getLocationInfo())) {
                nestedFragment2 = true;
            } else if (statement2 instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement2;
                for (AbstractCodeFragment leaf : composite.getLeaves()) {
                    if (!leaf.isKeyword() && !leaf.getString().equals("return false;\n") && !leaf.getString().equals("return true;\n") || !statement2.getLocationInfo().subsumes(leaf.getLocationInfo()) && !statement2.getLocationInfo().before(leaf.getLocationInfo())) continue;
                    nestedFragment2 = true;
                    break;
                }
            }
            if (!nestedFragment1 || !nestedFragment2) continue;
            return true;
        }
        return mergedConditional instanceof StatementObject || statement2 instanceof StatementObject;
    }

    private static boolean sequentiallySplitConditionals(AbstractCodeFragment statement1, Set<AbstractCodeFragment> splitConditionals, Set<AbstractCodeMapping> mappings) {
        boolean bl;
        for (AbstractCodeMapping abstractCodeMapping : mappings) {
            boolean nestedFragment1;
            int nestedFragment2 = 0;
            for (AbstractCodeFragment splitConditional : splitConditionals) {
                if (!splitConditional.getLocationInfo().subsumes(abstractCodeMapping.getFragment2().getLocationInfo()) && !StringBasedHeuristics.subsumedByOther(splitConditionals, splitConditional)) continue;
                ++nestedFragment2;
            }
            boolean bl2 = nestedFragment1 = statement1.getLocationInfo().subsumes(abstractCodeMapping.getFragment1().getLocationInfo()) || statement1.getTernaryOperatorExpressions().size() > 0;
            if (nestedFragment2 != splitConditionals.size() || !nestedFragment1) continue;
            return true;
        }
        boolean leafConditional2 = false;
        for (AbstractCodeFragment splitConditional : splitConditionals) {
            if (!(splitConditional instanceof StatementObject)) continue;
            leafConditional2 = true;
            break;
        }
        if ((bl = statement1 instanceof StatementObject) && leafConditional2) {
            return true;
        }
        if (statement1.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
            String[] subConditions1;
            ArrayList<String> subConditionsAsList1 = new ArrayList<String>();
            CompositeStatementObject comp1 = (CompositeStatementObject)statement1;
            String conditional1 = StringBasedHeuristics.prepareConditional(comp1.getExpressions().get(0).getString());
            for (String s : subConditions1 = SPLIT_CONDITIONAL_PATTERN.split(conditional1)) {
                subConditionsAsList1.add(s.trim());
            }
            int invertedSplitConditionals = 0;
            for (AbstractCodeFragment splitConditional : splitConditionals) {
                ArrayList<String> subConditionsAsList2 = new ArrayList<String>();
                if (splitConditional.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
                    String[] subConditions2;
                    CompositeStatementObject comp2 = (CompositeStatementObject)splitConditional;
                    String conditional2 = StringBasedHeuristics.prepareConditional(comp2.getExpressions().get(0).getString());
                    for (String s : subConditions2 = SPLIT_CONDITIONAL_PATTERN.split(conditional2)) {
                        subConditionsAsList2.add(s.trim());
                    }
                }
                Set<String> intersection = StringBasedHeuristics.subConditionIntersection(subConditionsAsList2, subConditionsAsList1);
                int invertedConditions = 0;
                for (String intersectionElement : intersection) {
                    if (subConditionsAsList1.contains(intersectionElement)) continue;
                    ++invertedConditions;
                }
                if (invertedConditions != intersection.size()) continue;
                ++invertedSplitConditionals;
            }
            if (invertedSplitConditionals == splitConditionals.size()) {
                for (AbstractCodeFragment leaf : comp1.getLeaves()) {
                    if (!leaf.isKeyword() && !leaf.getString().equals("return false;\n") && !leaf.getString().equals("return true;\n") || !statement1.getLocationInfo().subsumes(leaf.getLocationInfo()) && !statement1.getLocationInfo().before(leaf.getLocationInfo())) continue;
                    return true;
                }
            }
        }
        return StringBasedHeuristics.conditionalsUnderTheSameParent(splitConditionals);
    }

    private static boolean sequentiallySplitConditional(AbstractCodeFragment statement1, AbstractCodeFragment splitConditional, AbstractCodeFragment statement2, Set<AbstractCodeMapping> mappings) {
        for (AbstractCodeMapping mapping : mappings) {
            boolean nestedFragment2 = false;
            if (splitConditional.getLocationInfo().subsumes(mapping.getFragment2().getLocationInfo())) {
                nestedFragment2 = true;
            } else if (splitConditional instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)splitConditional;
                for (AbstractCodeFragment leaf : composite.getLeaves()) {
                    if (!leaf.isKeyword() && !leaf.getString().equals("return false;\n") && !leaf.getString().equals("return true;\n") || !statement2.getLocationInfo().subsumes(leaf.getLocationInfo()) && !statement2.getLocationInfo().before(leaf.getLocationInfo())) continue;
                    nestedFragment2 = true;
                    break;
                }
            }
            boolean nestedFragment1 = false;
            if (statement1.getLocationInfo().subsumes(mapping.getFragment1().getLocationInfo())) {
                nestedFragment1 = true;
            } else if (statement1 instanceof CompositeStatementObject) {
                CompositeStatementObject composite = (CompositeStatementObject)statement1;
                for (AbstractCodeFragment leaf : composite.getLeaves()) {
                    if (!leaf.isKeyword() && !leaf.getString().equals("return false;\n") && !leaf.getString().equals("return true;\n") || !statement1.getLocationInfo().subsumes(leaf.getLocationInfo()) && !statement1.getLocationInfo().before(leaf.getLocationInfo())) continue;
                    nestedFragment1 = true;
                    break;
                }
            }
            if (!nestedFragment2 || !nestedFragment1) continue;
            return true;
        }
        return statement1 instanceof StatementObject || splitConditional instanceof StatementObject;
    }

    private static boolean conditionalsUnderTheSameParent(Set<AbstractCodeFragment> conditionals) {
        CompositeStatementObject parent = null;
        int commonParentCount = 0;
        for (AbstractCodeFragment fragment : conditionals) {
            if (parent == null) {
                parent = fragment.getParent();
                ++commonParentCount;
                continue;
            }
            if (parent == null || !parent.equals(fragment.getParent())) continue;
            ++commonParentCount;
        }
        return conditionals.size() > 1 && commonParentCount == conditionals.size();
    }

    private static boolean subsumedByOther(Set<AbstractCodeFragment> conditionals, AbstractCodeFragment conditional) {
        for (AbstractCodeFragment otherConditional : conditionals) {
            if (otherConditional.equals(conditional)) continue;
            if (otherConditional.getLocationInfo().subsumes(conditional.getLocationInfo()) || otherConditional.getLocationInfo().startsAtTheEndLineOf(conditional.getLocationInfo()) || conditional.getLocationInfo().startsAtTheEndLineOf(otherConditional.getLocationInfo()) || otherConditional.getLocationInfo().nextLine(conditional.getLocationInfo()) || conditional.getLocationInfo().nextLine(otherConditional.getLocationInfo())) {
                return true;
            }
            if (conditional.getParent() == null || !StringBasedHeuristics.isElseIfBranch(conditional, conditional.getParent()) || !conditional.getParent().getLocationInfo().subsumes(otherConditional.getLocationInfo())) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasElseIfBranch(CompositeStatementObject parent) {
        if (parent != null && parent.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT)) {
            return parent.getStatements().size() == 2 && parent.getStatements().get(1).getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT);
        }
        return false;
    }

    protected static boolean isElseIfBranch(AbstractCodeFragment child, CompositeStatementObject parent) {
        return parent.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) && child.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.IF_STATEMENT) && parent.getStatements().size() == 2 && parent.getStatements().indexOf(child) == 1;
    }
}

