/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLModifier;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.VariableDeclarationProvider;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.VariableScope;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class VariableDeclaration
implements LocationInfoProvider,
VariableDeclarationProvider {
    private String variableName;
    private AbstractExpression initializer;
    private UMLType type;
    private boolean varargsParameter;
    private LocationInfo locationInfo;
    private boolean isParameter;
    private boolean isAttribute;
    private boolean isEnumConstant;
    private VariableScope scope;
    private boolean isFinal;
    private List<UMLAnnotation> annotations = new ArrayList<UMLAnnotation>();
    private List<UMLModifier> modifiers = new ArrayList<UMLModifier>();

    public VariableDeclaration(CompilationUnit cu, String filePath, VariableDeclarationFragment fragment, VariableDeclarationContainer container) {
        List extendedModifiers = null;
        if (fragment.getParent() instanceof VariableDeclarationStatement) {
            parent = (VariableDeclarationStatement)fragment.getParent();
            extendedModifiers = parent.modifiers();
            modifiers = parent.getModifiers();
            if ((modifiers & 0x10) != 0) {
                this.isFinal = true;
            }
        } else if (fragment.getParent() instanceof VariableDeclarationExpression) {
            parent = (VariableDeclarationExpression)fragment.getParent();
            extendedModifiers = parent.modifiers();
            modifiers = parent.getModifiers();
            if ((modifiers & 0x10) != 0) {
                this.isFinal = true;
            }
        } else if (fragment.getParent() instanceof FieldDeclaration) {
            parent = (FieldDeclaration)fragment.getParent();
            extendedModifiers = parent.modifiers();
            modifiers = parent.getModifiers();
            if ((modifiers & 0x10) != 0) {
                this.isFinal = true;
            }
        }
        if (extendedModifiers != null) {
            for (IExtendedModifier extendedModifier : extendedModifiers) {
                if (extendedModifier.isAnnotation()) {
                    Annotation annotation = (Annotation)extendedModifier;
                    this.annotations.add(new UMLAnnotation(cu, filePath, annotation));
                    continue;
                }
                if (!extendedModifier.isModifier()) continue;
                Modifier modifier = (Modifier)extendedModifier;
                this.modifiers.add(new UMLModifier(cu, filePath, modifier));
            }
        }
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)fragment, VariableDeclaration.extractVariableDeclarationType((org.eclipse.jdt.core.dom.VariableDeclaration)fragment));
        this.variableName = fragment.getName().getIdentifier();
        this.initializer = fragment.getInitializer() != null ? new AbstractExpression(cu, filePath, fragment.getInitializer(), LocationInfo.CodeElementType.VARIABLE_DECLARATION_INITIALIZER, container) : null;
        Type astType = VariableDeclaration.extractType((org.eclipse.jdt.core.dom.VariableDeclaration)fragment);
        if (astType != null) {
            this.type = UMLType.extractTypeObject(cu, filePath, astType, fragment.getExtraDimensions());
        }
        ASTNode scopeNode = VariableDeclaration.getScopeNode((org.eclipse.jdt.core.dom.VariableDeclaration)fragment);
        int startOffset = 0;
        startOffset = this.locationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.FIELD_DECLARATION) ? scopeNode.getStartPosition() : fragment.getStartPosition();
        int endOffset = scopeNode.getStartPosition() + scopeNode.getLength();
        this.scope = new VariableScope(cu, filePath, startOffset, endOffset);
    }

    public VariableDeclaration(CompilationUnit cu, String filePath, SingleVariableDeclaration fragment, VariableDeclarationContainer container) {
        int modifiers = fragment.getModifiers();
        if ((modifiers & 0x10) != 0) {
            this.isFinal = true;
        }
        List extendedModifiers = fragment.modifiers();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            if (extendedModifier.isAnnotation()) {
                Annotation annotation = (Annotation)extendedModifier;
                this.annotations.add(new UMLAnnotation(cu, filePath, annotation));
                continue;
            }
            if (!extendedModifier.isModifier()) continue;
            Modifier modifier = (Modifier)extendedModifier;
            this.modifiers.add(new UMLModifier(cu, filePath, modifier));
        }
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)fragment, VariableDeclaration.extractVariableDeclarationType((org.eclipse.jdt.core.dom.VariableDeclaration)fragment));
        this.variableName = fragment.getName().getIdentifier();
        this.initializer = fragment.getInitializer() != null ? new AbstractExpression(cu, filePath, fragment.getInitializer(), LocationInfo.CodeElementType.VARIABLE_DECLARATION_INITIALIZER, container) : null;
        Type astType = VariableDeclaration.extractType((org.eclipse.jdt.core.dom.VariableDeclaration)fragment);
        this.type = UMLType.extractTypeObject(cu, filePath, astType, fragment.getExtraDimensions());
        int startOffset = fragment.getStartPosition();
        ASTNode scopeNode = VariableDeclaration.getScopeNode((org.eclipse.jdt.core.dom.VariableDeclaration)fragment);
        int endOffset = scopeNode.getStartPosition() + scopeNode.getLength();
        this.scope = new VariableScope(cu, filePath, startOffset, endOffset);
    }

    public VariableDeclaration(CompilationUnit cu, String filePath, SingleVariableDeclaration fragment, VariableDeclarationContainer container, boolean varargs) {
        this(cu, filePath, fragment, container);
        this.varargsParameter = varargs;
        if (varargs) {
            this.type.setVarargs();
        }
    }

    public VariableDeclaration(CompilationUnit cu, String filePath, EnumConstantDeclaration fragment) {
        int modifiers = fragment.getModifiers();
        if ((modifiers & 0x10) != 0) {
            this.isFinal = true;
        }
        this.isEnumConstant = true;
        List extendedModifiers = fragment.modifiers();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            if (extendedModifier.isAnnotation()) {
                Annotation annotation = (Annotation)extendedModifier;
                this.annotations.add(new UMLAnnotation(cu, filePath, annotation));
                continue;
            }
            if (!extendedModifier.isModifier()) continue;
            Modifier modifier = (Modifier)extendedModifier;
            this.modifiers.add(new UMLModifier(cu, filePath, modifier));
        }
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)fragment, LocationInfo.CodeElementType.ENUM_CONSTANT_DECLARATION);
        this.variableName = fragment.getName().getIdentifier();
        this.initializer = null;
        if (fragment.getParent() instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)fragment.getParent();
            this.type = UMLType.extractTypeObject(enumDeclaration.getName().getIdentifier());
        }
        ASTNode scopeNode = fragment.getParent();
        int startOffset = scopeNode.getStartPosition();
        int endOffset = scopeNode.getStartPosition() + scopeNode.getLength();
        this.scope = new VariableScope(cu, filePath, startOffset, endOffset);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public AbstractExpression getInitializer() {
        return this.initializer;
    }

    public UMLType getType() {
        return this.type;
    }

    public VariableScope getScope() {
        return this.scope;
    }

    public boolean isLocalVariable() {
        return !this.isParameter && !this.isAttribute && !this.isEnumConstant;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setParameter(boolean isParameter) {
        this.isParameter = isParameter;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    public boolean isEnumConstant() {
        return this.isEnumConstant;
    }

    public boolean isVarargsParameter() {
        return this.varargsParameter;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public List<UMLModifier> getModifiers() {
        return this.modifiers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableDeclaration other = (VariableDeclaration)obj;
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.variableName == null ? other.variableName != null : !this.variableName.equals(other.variableName));
    }

    public boolean sameKind(VariableDeclaration other) {
        return this.isParameter == other.isParameter && this.isEnumConstant == other.isEnumConstant && this.isAttribute == other.isAttribute;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.variableName).append(" : ");
        if (this.varargsParameter) {
            sb.append(this.type.toString().substring(0, this.type.toString().lastIndexOf("[]")));
            sb.append("...");
        } else {
            sb.append(this.type);
        }
        return sb.toString();
    }

    public String toQualifiedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.variableName).append(" : ");
        if (this.varargsParameter) {
            sb.append(this.type.toQualifiedString().substring(0, this.type.toQualifiedString().lastIndexOf("[]")));
            sb.append("...");
        } else {
            sb.append(this.type.toQualifiedString());
        }
        return sb.toString();
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    private static ASTNode getScopeNode(org.eclipse.jdt.core.dom.VariableDeclaration variableDeclaration) {
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            return variableDeclaration.getParent();
        }
        if (variableDeclaration instanceof VariableDeclarationFragment) {
            return variableDeclaration.getParent().getParent();
        }
        return null;
    }

    private static LocationInfo.CodeElementType extractVariableDeclarationType(org.eclipse.jdt.core.dom.VariableDeclaration variableDeclaration) {
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            return LocationInfo.CodeElementType.SINGLE_VARIABLE_DECLARATION;
        }
        if (variableDeclaration instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableDeclaration;
            if (fragment.getParent() instanceof VariableDeclarationStatement) {
                return LocationInfo.CodeElementType.VARIABLE_DECLARATION_STATEMENT;
            }
            if (fragment.getParent() instanceof VariableDeclarationExpression) {
                return LocationInfo.CodeElementType.VARIABLE_DECLARATION_EXPRESSION;
            }
            if (fragment.getParent() instanceof FieldDeclaration) {
                return LocationInfo.CodeElementType.FIELD_DECLARATION;
            }
            if (fragment.getParent() instanceof LambdaExpression) {
                return LocationInfo.CodeElementType.LAMBDA_EXPRESSION_PARAMETER;
            }
        }
        return null;
    }

    private static Type extractType(org.eclipse.jdt.core.dom.VariableDeclaration variableDeclaration) {
        Type returnedVariableType = null;
        if (variableDeclaration instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)variableDeclaration;
            returnedVariableType = singleVariableDeclaration.getType();
        } else if (variableDeclaration instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)variableDeclaration;
            if (fragment.getParent() instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)fragment.getParent();
                returnedVariableType = variableDeclarationStatement.getType();
            } else if (fragment.getParent() instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)fragment.getParent();
                returnedVariableType = variableDeclarationExpression.getType();
            } else if (fragment.getParent() instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)fragment.getParent();
                returnedVariableType = fieldDeclaration.getType();
            }
        }
        return returnedVariableType;
    }

    public boolean equalVariableDeclarationType(VariableDeclaration other) {
        return this.locationInfo.getCodeElementType().equals((Object)other.locationInfo.getCodeElementType());
    }

    public boolean equalType(VariableDeclaration other) {
        if (this.getType() == null && other.getType() == null) {
            return true;
        }
        if (this.getType() != null && other.getType() != null) {
            return this.getType().equals(other.getType());
        }
        return false;
    }

    public boolean equalQualifiedType(VariableDeclaration other) {
        if (this.getType() == null && other.getType() == null) {
            return true;
        }
        if (this.getType() != null && other.getType() != null) {
            return this.getType().equalsQualified(other.getType());
        }
        return false;
    }

    @Override
    public VariableDeclaration getVariableDeclaration() {
        return this;
    }

    public void addStatementInScope(AbstractCodeFragment statement) {
        if (this.scope.subsumes(statement.getLocationInfo())) {
            List<LeafExpression> variables = statement.getVariables();
            boolean matchFound = false;
            for (LeafExpression variable : variables) {
                if (!variable.getString().equals(this.variableName) && (!this.isAttribute || !variable.getString().equals("this." + this.variableName))) continue;
                this.scope.addStatementUsingVariable(statement);
                matchFound = true;
                break;
            }
            if (!matchFound) {
                for (LeafExpression variable : variables) {
                    if (!variable.getString().startsWith(this.variableName + ".")) continue;
                    this.scope.addStatementUsingVariable(statement);
                    break;
                }
            }
        }
    }

    public Set<AbstractCodeFragment> getStatementsInScopeUsingVariable() {
        return this.scope.getStatementsInScopeUsingVariable();
    }
}

