/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class VariableReferenceExtractor {
    public static Set<AbstractCodeMapping> findReferences(VariableDeclaration declaration1, VariableDeclaration declaration2, Set<AbstractCodeMapping> mappings, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        LinkedHashSet<AbstractCodeMapping> references = new LinkedHashSet<AbstractCodeMapping>();
        Set<AbstractCodeFragment> statementsUsingVariable1 = declaration1.getStatementsInScopeUsingVariable();
        Set<AbstractCodeFragment> statementsUsingVariable2 = declaration2.getStatementsInScopeUsingVariable();
        for (AbstractCodeMapping mapping : mappings) {
            AbstractCodeFragment fragment1 = mapping.getFragment1();
            AbstractCodeFragment fragment2 = mapping.getFragment2();
            if (statementsUsingVariable1.contains(fragment1) && statementsUsingVariable2.contains(fragment2)) {
                references.add(mapping);
            }
            AbstractCall invocation1 = fragment1.invocationCoveringEntireFragment();
            AbstractCall invocation2 = fragment2.invocationCoveringEntireFragment();
            if (invocation1 == null || invocation2 == null || !invocation1.matchesOperation(mapping.getOperation1(), mapping.getOperation1(), classDiff, modelDiff) || !invocation2.matchesOperation(mapping.getOperation2(), mapping.getOperation2(), classDiff, modelDiff) || !statementsUsingVariable1.contains(fragment1) || !statementsUsingVariable2.contains(fragment2)) continue;
            references.add(mapping);
        }
        return references;
    }

    public static Set<AbstractCodeMapping> findReturnReferences(Set<AbstractCodeMapping> mappings) {
        LinkedHashSet<AbstractCodeMapping> references = new LinkedHashSet<AbstractCodeMapping>();
        for (AbstractCodeMapping mapping : mappings) {
            if (!mapping.getFragment1().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.RETURN_STATEMENT) || !mapping.getFragment2().getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.RETURN_STATEMENT)) continue;
            references.add(mapping);
        }
        return references;
    }

    public static Set<AbstractCodeMapping> findReferences(VariableDeclaration declaration1, VariableDeclaration declaration2, List<UMLOperationBodyMapper> operationBodyMapperList, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        LinkedHashSet<AbstractCodeMapping> references = new LinkedHashSet<AbstractCodeMapping>();
        for (UMLOperationBodyMapper mapper : operationBodyMapperList) {
            references.addAll(VariableReferenceExtractor.findReferences(declaration1, declaration2, mapper.getMappings(), classDiff, modelDiff));
        }
        return references;
    }
}

