/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.ASTFlattener;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.MethodReference;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.TernaryOperatorExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;

public class Visitor
extends ASTVisitor {
    public static final Pattern METHOD_INVOCATION_PATTERN = Pattern.compile("!(\\w|\\.)*@\\w*");
    public static final Pattern METHOD_SIGNATURE_PATTERN = Pattern.compile("(public|protected|private|static|\\s) +[\\w\\<\\>\\[\\]]+\\s+(\\w+) *\\([^\\)]*\\) *(\\{?|[^;])");
    private CompilationUnit cu;
    private String filePath;
    private VariableDeclarationContainer container;
    private List<LeafExpression> variables = new ArrayList<LeafExpression>();
    private List<String> types = new ArrayList<String>();
    private List<AbstractCall> methodInvocations = new ArrayList<AbstractCall>();
    private List<VariableDeclaration> variableDeclarations = new ArrayList<VariableDeclaration>();
    private List<AnonymousClassDeclarationObject> anonymousClassDeclarations = new ArrayList<AnonymousClassDeclarationObject>();
    private List<LeafExpression> stringLiterals = new ArrayList<LeafExpression>();
    private List<LeafExpression> charLiterals = new ArrayList<LeafExpression>();
    private List<LeafExpression> numberLiterals = new ArrayList<LeafExpression>();
    private List<LeafExpression> nullLiterals = new ArrayList<LeafExpression>();
    private List<LeafExpression> booleanLiterals = new ArrayList<LeafExpression>();
    private List<LeafExpression> typeLiterals = new ArrayList<LeafExpression>();
    private List<AbstractCall> creations = new ArrayList<AbstractCall>();
    private List<LeafExpression> infixExpressions = new ArrayList<LeafExpression>();
    private List<String> infixOperators = new ArrayList<String>();
    private List<LeafExpression> arrayAccesses = new ArrayList<LeafExpression>();
    private List<LeafExpression> prefixExpressions = new ArrayList<LeafExpression>();
    private List<LeafExpression> postfixExpressions = new ArrayList<LeafExpression>();
    private List<LeafExpression> thisExpressions = new ArrayList<LeafExpression>();
    private List<LeafExpression> arguments = new ArrayList<LeafExpression>();
    private List<LeafExpression> parenthesizedExpressions = new ArrayList<LeafExpression>();
    private List<LeafExpression> castExpressions = new ArrayList<LeafExpression>();
    private List<TernaryOperatorExpression> ternaryOperatorExpressions = new ArrayList<TernaryOperatorExpression>();
    private List<LambdaExpressionObject> lambdas = new ArrayList<LambdaExpressionObject>();
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode current = this.root = new DefaultMutableTreeNode();

    public Visitor(CompilationUnit cu, String filePath, VariableDeclarationContainer container) {
        this.cu = cu;
        this.filePath = filePath;
        this.container = container;
    }

    public boolean visit(ArrayAccess node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.ARRAY_ACCESS, this.container);
        this.arrayAccesses.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getArrayAccesses().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(PrefixExpression node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.PREFIX_EXPRESSION, this.container);
        this.prefixExpressions.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getPrefixExpressions().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(PostfixExpression node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.POSTFIX_EXPRESSION, this.container);
        this.postfixExpressions.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getPostfixExpressions().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(ConditionalExpression node) {
        TernaryOperatorExpression ternary = new TernaryOperatorExpression(this.cu, this.filePath, node, this.container);
        this.ternaryOperatorExpressions.add(ternary);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTernaryOperatorExpressions().add(ternary);
        }
        return super.visit(node);
    }

    public boolean visit(InfixExpression node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.INFIX_EXPRESSION, this.container);
        this.infixExpressions.add(expression);
        this.infixOperators.add(node.getOperator().toString());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getInfixExpressions().add(expression);
            anonymous.getInfixOperators().add(node.getOperator().toString());
        }
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        ObjectCreation creation = new ObjectCreation(this.cu, this.filePath, node, this.container);
        this.creations.add(creation);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getCreations().add(creation);
        }
        return super.visit(node);
    }

    public boolean visit(ArrayCreation node) {
        List expressions;
        ArrayInitializer initializer;
        ObjectCreation creation = new ObjectCreation(this.cu, this.filePath, node, this.container);
        String nodeAsString = Visitor.stringify((ASTNode)node);
        this.creations.add(creation);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getCreations().add(creation);
        }
        if ((initializer = node.getInitializer()) != null && (expressions = initializer.expressions()).size() > 10) {
            return false;
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (!(node.getParent() instanceof LambdaExpression)) {
            VariableDeclaration variableDeclaration = new VariableDeclaration(this.cu, this.filePath, node, this.container);
            this.variableDeclarations.add(variableDeclaration);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariableDeclarations().add(variableDeclaration);
            }
        }
        return super.visit(node);
    }

    public boolean visit(SingleVariableDeclaration node) {
        VariableDeclaration variableDeclaration = new VariableDeclaration(this.cu, this.filePath, node, this.container, node.isVarargs());
        this.variableDeclarations.add(variableDeclaration);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getVariableDeclarations().add(variableDeclaration);
        }
        return super.visit(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        DefaultMutableTreeNode childNode = this.insertNode(node);
        AnonymousClassDeclarationObject childAnonymous = (AnonymousClassDeclarationObject)childNode.getUserObject();
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            currentAnonymous.getAnonymousClassDeclarations().add(childAnonymous);
        }
        this.anonymousClassDeclarations.add(childAnonymous);
        this.current = childNode;
        return super.visit(node);
    }

    public void endVisit(AnonymousClassDeclaration node) {
        DefaultMutableTreeNode parentNode = this.deleteNode(node);
        this.removeAnonymousData();
        this.current = parentNode;
    }

    private void removeAnonymousData() {
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            Visitor.removeLast(this.variables, anonymous.getVariables());
            Visitor.removeLastString(this.types, anonymous.getTypes());
            Visitor.removeLast(this.methodInvocations, anonymous.getMethodInvocations());
            Visitor.removeLast(this.creations, anonymous.getCreations());
            this.variableDeclarations.removeAll(anonymous.getVariableDeclarations());
            Visitor.removeLast(this.stringLiterals, anonymous.getStringLiterals());
            Visitor.removeLast(this.charLiterals, anonymous.getCharLiterals());
            Visitor.removeLast(this.nullLiterals, anonymous.getNullLiterals());
            Visitor.removeLast(this.booleanLiterals, anonymous.getBooleanLiterals());
            Visitor.removeLast(this.typeLiterals, anonymous.getTypeLiterals());
            Visitor.removeLast(this.numberLiterals, anonymous.getNumberLiterals());
            Visitor.removeLast(this.infixExpressions, anonymous.getInfixExpressions());
            Visitor.removeLastString(this.infixOperators, anonymous.getInfixOperators());
            Visitor.removeLast(this.postfixExpressions, anonymous.getPostfixExpressions());
            Visitor.removeLast(this.prefixExpressions, anonymous.getPrefixExpressions());
            Visitor.removeLast(this.thisExpressions, anonymous.getThisExpressions());
            Visitor.removeLast(this.parenthesizedExpressions, anonymous.getParenthesizedExpressions());
            Visitor.removeLast(this.castExpressions, anonymous.getCastExpressions());
            Visitor.removeLast(this.arguments, anonymous.getArguments());
            this.ternaryOperatorExpressions.removeAll(anonymous.getTernaryOperatorExpressions());
            this.anonymousClassDeclarations.removeAll(anonymous.getAnonymousClassDeclarations());
            this.lambdas.removeAll(anonymous.getLambdas());
            Visitor.removeLast(this.arrayAccesses, anonymous.getArrayAccesses());
        }
    }

    private static void removeLastString(List<String> parentList, List<String> childList) {
        for (int i = childList.size() - 1; i >= 0; --i) {
            String element = childList.get(i);
            int lastIndex = parentList.lastIndexOf(element);
            parentList.remove(lastIndex);
        }
    }

    private static void removeLast(List<? extends LeafExpression> parentList, List<? extends LeafExpression> childList) {
        for (int i = childList.size() - 1; i >= 0; --i) {
            LeafExpression element = childList.get(i);
            int lastIndex = parentList.lastIndexOf(element);
            parentList.remove(lastIndex);
        }
    }

    private DefaultMutableTreeNode deleteNode(AnonymousClassDeclaration childAnonymous) {
        Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
        DefaultMutableTreeNode childNode = this.findNode(childAnonymous);
        DefaultMutableTreeNode parentNode = this.root;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)currentNode.getUserObject();
            if (currentAnonymous == null || !this.isParent((ASTNode)childAnonymous, (ASTNode)currentAnonymous.getAstNode())) continue;
            parentNode = currentNode;
            break;
        }
        parentNode.remove(childNode);
        AnonymousClassDeclarationObject childAnonymousObject = (AnonymousClassDeclarationObject)childNode.getUserObject();
        childAnonymousObject.setAstNode(null);
        return parentNode;
    }

    private DefaultMutableTreeNode insertNode(AnonymousClassDeclaration childAnonymous) {
        Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
        AnonymousClassDeclarationObject anonymousObject = new AnonymousClassDeclarationObject(this.cu, this.filePath, childAnonymous);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(anonymousObject);
        DefaultMutableTreeNode parentNode = this.root;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)currentNode.getUserObject();
            if (currentAnonymous == null || !this.isParent((ASTNode)childAnonymous, (ASTNode)currentAnonymous.getAstNode())) continue;
            parentNode = currentNode;
            break;
        }
        parentNode.add(childNode);
        return childNode;
    }

    private DefaultMutableTreeNode findNode(AnonymousClassDeclaration anonymous) {
        Enumeration<TreeNode> enumeration = this.root.postorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AnonymousClassDeclarationObject currentAnonymous = (AnonymousClassDeclarationObject)currentNode.getUserObject();
            if (currentAnonymous == null || !currentAnonymous.getAstNode().equals((Object)anonymous)) continue;
            return currentNode;
        }
        return null;
    }

    private boolean isParent(ASTNode child, ASTNode parent) {
        ASTNode current = child;
        while (current.getParent() != null) {
            if (current.getParent().equals((Object)parent)) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.STRING_LITERAL, this.container);
        this.stringLiterals.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getStringLiterals().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(CharacterLiteral node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.CHAR_LITERAL, this.container);
        this.charLiterals.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getCharLiterals().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(NumberLiteral node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.NUMBER_LITERAL, this.container);
        this.numberLiterals.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getNumberLiterals().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(NullLiteral node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.NULL_LITERAL, this.container);
        this.nullLiterals.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getNullLiterals().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(BooleanLiteral node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.BOOLEAN_LITERAL, this.container);
        this.booleanLiterals.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getBooleanLiterals().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(TypeLiteral node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.TYPE_LITERAL, this.container);
        this.typeLiterals.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypeLiterals().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(ThisExpression node) {
        if (!(node.getParent() instanceof FieldAccess)) {
            LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.THIS_EXPRESSION, this.container);
            this.thisExpressions.add(expression);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getThisExpressions().add(expression);
            }
        }
        return super.visit(node);
    }

    public boolean visit(SimpleName node) {
        if (node.getParent() instanceof FieldAccess && ((FieldAccess)node.getParent()).getExpression() instanceof ThisExpression) {
            FieldAccess fieldAccess = (FieldAccess)node.getParent();
            LeafExpression fieldAccessExpression = new LeafExpression(this.cu, this.filePath, (ASTNode)fieldAccess, LocationInfo.CodeElementType.FIELD_ACCESS, this.container);
            this.variables.add(fieldAccessExpression);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(fieldAccessExpression);
            }
        } else if (!(node.getParent() instanceof MethodInvocation && ((MethodInvocation)node.getParent()).getName().equals((Object)node) || node.getParent() instanceof SuperMethodInvocation && ((SuperMethodInvocation)node.getParent()).getName().equals((Object)node) || node.getParent() instanceof Type || node.getParent() instanceof MarkerAnnotation && ((MarkerAnnotation)node.getParent()).getTypeName().equals((Object)node) || node.getParent() instanceof MethodDeclaration && ((MethodDeclaration)node.getParent()).getName().equals((Object)node) || node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof MethodDeclaration || node.getParent() instanceof SingleVariableDeclaration && node.getParent().getParent() instanceof CatchClause || node.getParent() instanceof QualifiedName && (node.getParent().getParent() instanceof QualifiedName || node.getParent().getParent() instanceof MethodInvocation || node.getParent().getParent() instanceof SuperMethodInvocation || node.getParent().getParent() instanceof ClassInstanceCreation))) {
            LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.SIMPLE_NAME, this.container);
            this.variables.add(expression);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(expression);
            }
        }
        return super.visit(node);
    }

    public boolean visit(ArrayType node) {
        this.types.add(Visitor.stringify((ASTNode)node));
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(Visitor.stringify((ASTNode)node));
        }
        return false;
    }

    public boolean visit(ParameterizedType node) {
        this.types.add(Visitor.stringify((ASTNode)node));
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(Visitor.stringify((ASTNode)node));
        }
        return false;
    }

    public boolean visit(WildcardType node) {
        this.types.add(Visitor.stringify((ASTNode)node));
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(Visitor.stringify((ASTNode)node));
        }
        return false;
    }

    public boolean visit(QualifiedType node) {
        this.types.add(Visitor.stringify((ASTNode)node));
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(Visitor.stringify((ASTNode)node));
        }
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.types.add(Visitor.stringify((ASTNode)node));
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(Visitor.stringify((ASTNode)node));
        }
        return false;
    }

    public boolean visit(SimpleType node) {
        Name name = node.getName();
        this.types.add(name.getFullyQualifiedName());
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getTypes().add(name.getFullyQualifiedName());
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node, this.container);
        this.methodInvocations.add(invocation);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getMethodInvocations().add(invocation);
        }
        return super.visit(node);
    }

    public boolean visit(ExpressionMethodReference node) {
        MethodReference reference = new MethodReference(this.cu, this.filePath, node, this.container);
        this.methodInvocations.add(reference);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getMethodInvocations().add(reference);
        }
        return super.visit(node);
    }

    public boolean visit(SuperMethodReference node) {
        MethodReference reference = new MethodReference(this.cu, this.filePath, node, this.container);
        this.methodInvocations.add(reference);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getMethodInvocations().add(reference);
        }
        return super.visit(node);
    }

    public boolean visit(TypeMethodReference node) {
        MethodReference reference = new MethodReference(this.cu, this.filePath, node, this.container);
        this.methodInvocations.add(reference);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getMethodInvocations().add(reference);
        }
        return super.visit(node);
    }

    public static String processMethodInvocation(MethodInvocation node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getName().getIdentifier());
        sb.append("(");
        List arguments = node.arguments();
        if (arguments.size() > 0) {
            for (int i = 0; i < arguments.size() - 1; ++i) {
                sb.append(Visitor.stringify((ASTNode)arguments.get(i))).append(", ");
            }
            sb.append(Visitor.stringify((ASTNode)arguments.get(arguments.size() - 1)));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String processClassInstanceCreation(ClassInstanceCreation node) {
        StringBuilder sb = new StringBuilder();
        sb.append("new").append(" ");
        sb.append(Visitor.stringify((ASTNode)node.getType()));
        List arguments = node.arguments();
        if (arguments.size() > 0) {
            for (int i = 0; i < arguments.size() - 1; ++i) {
                sb.append(Visitor.stringify((ASTNode)arguments.get(i))).append(", ");
            }
            sb.append(Visitor.stringify((ASTNode)arguments.get(arguments.size() - 1)));
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean visit(SuperMethodInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node, this.container);
        this.methodInvocations.add(invocation);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getMethodInvocations().add(invocation);
        }
        return super.visit(node);
    }

    public boolean visit(SuperConstructorInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node, this.container);
        this.methodInvocations.add(invocation);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getMethodInvocations().add(invocation);
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        List arguments = node.arguments();
        for (Expression argument : arguments) {
            this.processArgument(argument);
        }
        OperationInvocation invocation = new OperationInvocation(this.cu, this.filePath, node, this.container);
        this.methodInvocations.add(invocation);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getMethodInvocations().add(invocation);
        }
        return super.visit(node);
    }

    private void processArgument(Expression argument) {
        AnonymousClassDeclarationObject anonymous;
        if (argument instanceof SuperMethodInvocation || argument instanceof Name || argument instanceof StringLiteral || argument instanceof BooleanLiteral || argument instanceof NumberLiteral || argument instanceof FieldAccess && ((FieldAccess)argument).getExpression() instanceof ThisExpression || argument instanceof ArrayAccess && Visitor.invalidArrayAccess((ArrayAccess)argument) || argument instanceof InfixExpression && Visitor.invalidInfix((InfixExpression)argument) || this.castExpressionInParenthesizedExpression(argument)) {
            return;
        }
        if (argument instanceof ExpressionMethodReference) {
            lambda = new LambdaExpressionObject(this.cu, this.filePath, (ExpressionMethodReference)argument, this.container);
            this.lambdas.add(lambda);
            if (this.current.getUserObject() != null) {
                anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getLambdas().add(lambda);
            }
        } else if (argument instanceof SuperMethodReference) {
            lambda = new LambdaExpressionObject(this.cu, this.filePath, (SuperMethodReference)argument, this.container);
            this.lambdas.add(lambda);
            if (this.current.getUserObject() != null) {
                anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getLambdas().add(lambda);
            }
        } else if (argument instanceof TypeMethodReference) {
            lambda = new LambdaExpressionObject(this.cu, this.filePath, (TypeMethodReference)argument, this.container);
            this.lambdas.add(lambda);
            if (this.current.getUserObject() != null) {
                anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getLambdas().add(lambda);
            }
        }
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)argument, LocationInfo.CodeElementType.EXPRESSION, this.container);
        this.arguments.add(expression);
        if (this.current.getUserObject() != null) {
            anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getArguments().add(expression);
        }
    }

    private boolean castExpressionInParenthesizedExpression(Expression argument) {
        CastExpression castExpression;
        Expression parenthesizedExpression;
        return argument instanceof ParenthesizedExpression && (parenthesizedExpression = ((ParenthesizedExpression)argument).getExpression()) instanceof CastExpression && (castExpression = (CastExpression)parenthesizedExpression).getExpression() instanceof SimpleName;
    }

    public boolean visit(QualifiedName node) {
        Name qualifier = node.getQualifier();
        if (Character.isUpperCase(qualifier.getFullyQualifiedName().charAt(0))) {
            this.types.add(qualifier.getFullyQualifiedName());
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getTypes().add(qualifier.getFullyQualifiedName());
            }
            LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.QUALIFIED_NAME, this.container);
            this.variables.add(expression);
            if (this.current.getUserObject() != null) {
                AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(expression);
            }
        } else if (qualifier instanceof SimpleName && !(node.getParent() instanceof QualifiedName)) {
            EnhancedForStatement enhancedFor;
            String qualifierIdentifier = ((SimpleName)qualifier).getIdentifier();
            MethodDeclaration parentMethodDeclaration = this.findParentMethodDeclaration((ASTNode)node);
            if (parentMethodDeclaration != null) {
                AbstractTypeDeclaration parentTypeDeclaration;
                boolean qualifierIsParameter = false;
                List parameters = parentMethodDeclaration.parameters();
                for (SingleVariableDeclaration parameter : parameters) {
                    if (!parameter.getName().getIdentifier().equals(qualifierIdentifier)) continue;
                    qualifierIsParameter = true;
                    break;
                }
                boolean qualifierIsField = false;
                if (!qualifierIsParameter && !parentMethodDeclaration.isConstructor() && (parentTypeDeclaration = this.findParentTypeDeclaration((ASTNode)parentMethodDeclaration)) != null) {
                    List bodyDeclarations = parentTypeDeclaration.bodyDeclarations();
                    for (BodyDeclaration declaration : bodyDeclarations) {
                        if (!(declaration instanceof FieldDeclaration)) continue;
                        FieldDeclaration fieldDeclaration = (FieldDeclaration)declaration;
                        List fragments = fieldDeclaration.fragments();
                        for (VariableDeclarationFragment fragment : fragments) {
                            if (!fragment.getName().getIdentifier().equals(qualifierIdentifier)) continue;
                            qualifierIsField = true;
                            break;
                        }
                        if (!qualifierIsField) continue;
                        break;
                    }
                }
                if (qualifierIsParameter || qualifierIsField || node.getName().getIdentifier().equals("length")) {
                    LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.QUALIFIED_NAME, this.container);
                    this.variables.add(expression);
                    if (this.current.getUserObject() != null) {
                        AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                        anonymous.getVariables().add(expression);
                    }
                }
            }
            if ((enhancedFor = this.findParentEnhancedForStatement((ASTNode)node)) != null && enhancedFor.getParameter().getName().getIdentifier().equals(qualifierIdentifier)) {
                LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.QUALIFIED_NAME, this.container);
                this.variables.add(expression);
                if (this.current.getUserObject() != null) {
                    AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                    anonymous.getVariables().add(expression);
                }
            }
        }
        return super.visit(node);
    }

    private EnhancedForStatement findParentEnhancedForStatement(ASTNode node) {
        for (ASTNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof EnhancedForStatement)) continue;
            return (EnhancedForStatement)parent;
        }
        return null;
    }

    private AbstractTypeDeclaration findParentTypeDeclaration(ASTNode node) {
        for (ASTNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AbstractTypeDeclaration)) continue;
            return (AbstractTypeDeclaration)parent;
        }
        return null;
    }

    private MethodDeclaration findParentMethodDeclaration(ASTNode node) {
        for (ASTNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MethodDeclaration)) continue;
            return (MethodDeclaration)parent;
        }
        return null;
    }

    public boolean visit(CastExpression node) {
        AnonymousClassDeclarationObject anonymous;
        LeafExpression expression;
        Expression castExpression = node.getExpression();
        if (castExpression instanceof SimpleName) {
            expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.CAST_EXPRESSION, this.container);
            this.variables.add(expression);
            if (this.current.getUserObject() != null) {
                anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
                anonymous.getVariables().add(expression);
            }
        }
        expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.CAST_EXPRESSION, this.container);
        this.castExpressions.add(expression);
        if (this.current.getUserObject() != null) {
            anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getCastExpressions().add(expression);
        }
        return super.visit(node);
    }

    public boolean visit(LambdaExpression node) {
        LambdaExpressionObject lambda = new LambdaExpressionObject(this.cu, this.filePath, node, this.container);
        this.lambdas.add(lambda);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getLambdas().add(lambda);
        }
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        LeafExpression expression = new LeafExpression(this.cu, this.filePath, (ASTNode)node, LocationInfo.CodeElementType.PARENTHESIZED_EXPRESSION, this.container);
        this.parenthesizedExpressions.add(expression);
        if (this.current.getUserObject() != null) {
            AnonymousClassDeclarationObject anonymous = (AnonymousClassDeclarationObject)this.current.getUserObject();
            anonymous.getParenthesizedExpressions().add(expression);
        }
        return super.visit(node);
    }

    public List<AbstractCall> getMethodInvocations() {
        return this.methodInvocations;
    }

    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return this.anonymousClassDeclarations;
    }

    public List<LeafExpression> getStringLiterals() {
        return this.stringLiterals;
    }

    public List<LeafExpression> getCharLiterals() {
        return this.charLiterals;
    }

    public List<LeafExpression> getNumberLiterals() {
        return this.numberLiterals;
    }

    public List<LeafExpression> getNullLiterals() {
        return this.nullLiterals;
    }

    public List<LeafExpression> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    public List<LeafExpression> getTypeLiterals() {
        return this.typeLiterals;
    }

    public List<AbstractCall> getCreations() {
        return this.creations;
    }

    public List<LeafExpression> getInfixExpressions() {
        return this.infixExpressions;
    }

    public List<String> getInfixOperators() {
        return this.infixOperators;
    }

    public List<LeafExpression> getArrayAccesses() {
        return this.arrayAccesses;
    }

    public List<LeafExpression> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    public List<LeafExpression> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    public List<LeafExpression> getThisExpressions() {
        return this.thisExpressions;
    }

    public List<LeafExpression> getArguments() {
        return this.arguments;
    }

    public List<LeafExpression> getParenthesizedExpressions() {
        return this.parenthesizedExpressions;
    }

    public List<LeafExpression> getCastExpressions() {
        return this.castExpressions;
    }

    public List<TernaryOperatorExpression> getTernaryOperatorExpressions() {
        return this.ternaryOperatorExpressions;
    }

    public List<LeafExpression> getVariables() {
        return this.variables;
    }

    public List<LambdaExpressionObject> getLambdas() {
        return this.lambdas;
    }

    private static boolean invalidArrayAccess(ArrayAccess e) {
        return e.getArray() instanceof SimpleName && Visitor.simpleNameOrNumberLiteral(e.getIndex());
    }

    private static boolean invalidInfix(InfixExpression e) {
        return Visitor.simpleNameOrNumberLiteral(e.getLeftOperand()) && Visitor.simpleNameOrNumberLiteral(e.getRightOperand());
    }

    private static boolean simpleNameOrNumberLiteral(Expression e) {
        return e instanceof SimpleName || e instanceof NumberLiteral;
    }

    public static String stringify(ASTNode node) {
        ASTFlattener printer = new ASTFlattener();
        node.accept((ASTVisitor)printer);
        return printer.getResult();
    }
}

