/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition.replacement;

import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.decomposition.replacement.VariableDeclarationReplacement;
import gr.uom.java.xmi.diff.CandidateAttributeRefactoring;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ConsistentReplacementDetector {
    private static <T extends Replacement> Set<T> inconsistentRenames(Set<T> currentRenames, T newRename) {
        LinkedHashSet<Replacement> inconsistentRenames = new LinkedHashSet<Replacement>();
        if (!newRename.getBefore().toUpperCase().equals(newRename.getAfter().toUpperCase())) {
            for (Replacement rename : currentRenames) {
                if (rename.getBefore().equals(newRename.getBefore()) && !rename.getAfter().equals(newRename.getAfter())) {
                    inconsistentRenames.add(rename);
                    continue;
                }
                if (rename.getBefore().equals(newRename.getBefore()) || !rename.getAfter().equals(newRename.getAfter())) continue;
                inconsistentRenames.add(rename);
            }
        }
        return inconsistentRenames;
    }

    public static <T extends Replacement> void updateRenames(Set<T> allConsistentRenames, Set<T> allInconsistentRenames, Map<String, Set<String>> aliasedVariablesInOriginalMethod, Map<String, Set<String>> aliasedVariablesInNextMethod, Set<T> renames) {
        boolean allRenamesHaveIdenticalTypeAndInitializer = ConsistentReplacementDetector.allRenamesHaveIdenticalTypeAndInitializer(renames);
        for (Replacement newRename : renames) {
            Set<Replacement> inconsistentRenames = ConsistentReplacementDetector.inconsistentRenames(allConsistentRenames, newRename);
            ConsistentReplacementDetector.filter(inconsistentRenames, aliasedVariablesInOriginalMethod, aliasedVariablesInNextMethod);
            if (inconsistentRenames.isEmpty() || ConsistentReplacementDetector.identicalTypeAndInitializer(newRename) && !allRenamesHaveIdenticalTypeAndInitializer) {
                allConsistentRenames.add(newRename);
                continue;
            }
            if (!allRenamesHaveIdenticalTypeAndInitializer) {
                for (Replacement rename : inconsistentRenames) {
                    if (ConsistentReplacementDetector.identicalTypeAndInitializer(rename)) continue;
                    allInconsistentRenames.add(rename);
                }
            } else {
                allInconsistentRenames.addAll(inconsistentRenames);
            }
            allInconsistentRenames.add(newRename);
        }
    }

    public static <T extends Replacement> void updateRenames(Set<T> allConsistentRenames, Set<T> allInconsistentRenames, Set<T> renames) {
        boolean allRenamesHaveIdenticalTypeAndInitializer = ConsistentReplacementDetector.allRenamesHaveIdenticalTypeAndInitializer(renames);
        for (Replacement newRename : renames) {
            Set<Replacement> inconsistentRenames = ConsistentReplacementDetector.inconsistentRenames(allConsistentRenames, newRename);
            if (inconsistentRenames.isEmpty() || ConsistentReplacementDetector.identicalTypeAndInitializer(newRename) && !allRenamesHaveIdenticalTypeAndInitializer) {
                allConsistentRenames.add(newRename);
                continue;
            }
            if (!allRenamesHaveIdenticalTypeAndInitializer) {
                for (Replacement rename : inconsistentRenames) {
                    if (ConsistentReplacementDetector.identicalTypeAndInitializer(rename)) continue;
                    allInconsistentRenames.add(rename);
                }
            } else {
                allInconsistentRenames.addAll(inconsistentRenames);
            }
            allInconsistentRenames.add(newRename);
        }
    }

    private static <T extends Replacement> boolean allRenamesHaveIdenticalTypeAndInitializer(Set<T> renames) {
        if (renames.size() > 1) {
            for (Replacement rename : renames) {
                if (ConsistentReplacementDetector.identicalTypeAndInitializer(rename)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static <T extends Replacement> boolean identicalTypeAndInitializer(T newRename) {
        VariableDeclarationReplacement replacement;
        return newRename instanceof VariableDeclarationReplacement && (replacement = (VariableDeclarationReplacement)newRename).identicalTypeAndInitializer();
    }

    public static <T extends Replacement> void updateRenames(Set<T> allConsistentRenames, Set<T> allInconsistentRenames, Set<T> renames, Map<String, Set<String>> aliasedAttributesInOriginalClass, Map<String, Set<String>> aliasedAttributesInNextClass, Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap) {
        for (Replacement newRename : renames) {
            Set<Replacement> inconsistentRenames = ConsistentReplacementDetector.inconsistentRenames(allConsistentRenames, newRename);
            if (inconsistentRenames.size() > 0) {
                ConsistentReplacementDetector.validInconsistencies(inconsistentRenames, newRename, renameMap);
            }
            ConsistentReplacementDetector.filter(inconsistentRenames, aliasedAttributesInOriginalClass, aliasedAttributesInNextClass);
            if (inconsistentRenames.isEmpty()) {
                allConsistentRenames.add(newRename);
                continue;
            }
            allInconsistentRenames.addAll(inconsistentRenames);
            allInconsistentRenames.add(newRename);
        }
    }

    private static <T extends Replacement> void validInconsistencies(Set<T> inconsistentRenames, T newRename, Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap) {
        if (ConsistentReplacementDetector.involvesOnlyAttributes(newRename, renameMap)) {
            LinkedHashSet<Replacement> toBeRemoved = new LinkedHashSet<Replacement>();
            for (Replacement rename : inconsistentRenames) {
                if (ConsistentReplacementDetector.involvesOnlyAttributes(rename, renameMap)) continue;
                toBeRemoved.add(rename);
            }
            inconsistentRenames.removeAll(toBeRemoved);
        } else {
            inconsistentRenames.clear();
        }
    }

    private static <T extends Replacement> boolean involvesOnlyAttributes(T rename, Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap) {
        Set<CandidateAttributeRefactoring> newCandidates = renameMap.get(rename);
        int candidatesWithBothAttributes = 0;
        for (CandidateAttributeRefactoring newCandidate : newCandidates) {
            if (newCandidate.getOriginalVariableDeclaration() != null || newCandidate.getRenamedVariableDeclaration() != null) continue;
            ++candidatesWithBothAttributes;
        }
        return candidatesWithBothAttributes == newCandidates.size();
    }

    private static <T extends Replacement> Set<T> filter(Set<T> inconsistentRenames, Map<String, Set<String>> aliasedAttributesInOriginalClass, Map<String, Set<String>> aliasedAttributesInNextClass) {
        Replacement rename;
        Set<String> aliasedAttributes;
        LinkedHashSet<Replacement> renamesToBeRemoved = new LinkedHashSet<Replacement>();
        for (String key : aliasedAttributesInOriginalClass.keySet()) {
            aliasedAttributes = aliasedAttributesInOriginalClass.get(key);
            for (Replacement r : inconsistentRenames) {
                if (r instanceof VariableDeclarationReplacement) {
                    rename = ((VariableDeclarationReplacement)r).getVariableNameReplacement();
                    if (!aliasedAttributes.contains(rename.getBefore())) continue;
                    renamesToBeRemoved.add(r);
                    continue;
                }
                if (!aliasedAttributes.contains(r.getBefore())) continue;
                renamesToBeRemoved.add(r);
            }
        }
        for (String key : aliasedAttributesInNextClass.keySet()) {
            aliasedAttributes = aliasedAttributesInNextClass.get(key);
            for (Replacement r : inconsistentRenames) {
                if (r instanceof VariableDeclarationReplacement) {
                    rename = ((VariableDeclarationReplacement)r).getVariableNameReplacement();
                    if (!aliasedAttributes.contains(rename.getAfter())) continue;
                    renamesToBeRemoved.add(r);
                    continue;
                }
                if (!aliasedAttributes.contains(r.getAfter())) continue;
                renamesToBeRemoved.add(r);
            }
        }
        inconsistentRenames.removeAll(renamesToBeRemoved);
        return inconsistentRenames;
    }
}

