/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition.replacement;

import gr.uom.java.xmi.diff.StringDistance;

public class Replacement {
    private String before;
    private String after;
    private ReplacementType type;

    public Replacement(String before, String after, ReplacementType type) {
        this.before = before;
        this.after = after;
        this.type = type;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public ReplacementType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.after == null ? 0 : this.after.hashCode());
        result = 31 * result + (this.before == null ? 0 : this.before.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Replacement) {
            Replacement other = (Replacement)obj;
            return this.before.equals(other.before) && this.after.equals(other.after) && this.type.equals((Object)other.type);
        }
        return false;
    }

    public String toString() {
        return this.before + " -> " + this.after;
    }

    public double normalizedEditDistance() {
        String s1 = this.getBefore();
        String s2 = this.getAfter();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    public boolean involvesVariable() {
        return this.type.equals((Object)ReplacementType.VARIABLE_NAME) || this.type.equals((Object)ReplacementType.BOOLEAN_REPLACED_WITH_VARIABLE) || this.type.equals((Object)ReplacementType.TYPE_LITERAL_REPLACED_WITH_VARIABLE) || this.type.equals((Object)ReplacementType.ARGUMENT_REPLACED_WITH_VARIABLE) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_METHOD_INVOCATION) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_CLASS_INSTANCE_CREATION) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_EXPRESSION_OF_METHOD_INVOCATION) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_ARRAY_ACCESS) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_PREFIX_EXPRESSION) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_STRING_LITERAL) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_NULL_LITERAL) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_NUMBER_LITERAL) || this.type.equals((Object)ReplacementType.VARIABLE_REPLACED_WITH_PARENTHESIZED_EXPRESSION);
    }

    public boolean isLiteral() {
        return this.type.equals((Object)ReplacementType.STRING_LITERAL) || this.type.equals((Object)ReplacementType.NUMBER_LITERAL);
    }

    public static enum ReplacementType {
        TYPE,
        STRING_LITERAL,
        CHAR_LITERAL,
        NUMBER_LITERAL,
        BOOLEAN_LITERAL,
        ANONYMOUS_CLASS_DECLARATION,
        INFIX_OPERATOR,
        VARIABLE_NAME,
        VARIABLE_DECLARATION,
        MERGE_VARIABLES,
        SPLIT_VARIABLE,
        ADD_VARIABLE,
        SWAP_VARIABLES,
        INVERT_CONDITIONAL,
        VARIABLE_DECLARATION_INITIALIZER,
        BOOLEAN_REPLACED_WITH_VARIABLE,
        BOOLEAN_REPLACED_WITH_PREFIX_EXPRESSION,
        BOOLEAN_REPLACED_WITH_ARGUMENT,
        TYPE_LITERAL_REPLACED_WITH_VARIABLE,
        STRING_LITERAL_REPLACED_WITH_CHAR_LITERAL,
        METHOD_INVOCATION,
        METHOD_INVOCATION_EXPRESSION,
        METHOD_INVOCATION_ARGUMENT,
        METHOD_INVOCATION_ARGUMENT_WRAPPED,
        METHOD_INVOCATION_EXPRESSION_ARGUMENT_SWAPPED,
        METHOD_INVOCATION_ARGUMENT_CONCATENATED,
        METHOD_INVOCATION_NAME,
        METHOD_INVOCATION_NAME_AND_ARGUMENT,
        METHOD_INVOCATION_NAME_AND_EXPRESSION,
        METHOD_INVOCATION_WRAPPED_IN_ANONYMOUS_CLASS_DECLARATION,
        ARGUMENT,
        ARGUMENT_REPLACED_WITH_VARIABLE,
        ARGUMENT_REPLACED_WITH_METHOD_INVOCATION,
        ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION,
        ARGUMENT_REPLACED_WITH_STATEMENT,
        ARGUMENT_REPLACED_WITH_EXPRESSION,
        ARGUMENT_REPLACED_WITH_RIGHT_HAND_SIDE_OF_ASSIGNMENT_EXPRESSION,
        VARIABLE_REPLACED_WITH_METHOD_INVOCATION,
        VARIABLE_REPLACED_WITH_CLASS_INSTANCE_CREATION,
        VARIABLE_REPLACED_WITH_EXPRESSION_OF_METHOD_INVOCATION,
        VARIABLE_REPLACED_WITH_ARRAY_ACCESS,
        VARIABLE_REPLACED_WITH_PREFIX_EXPRESSION,
        VARIABLE_REPLACED_WITH_THIS_EXPRESSION,
        VARIABLE_REPLACED_WITH_STRING_LITERAL,
        VARIABLE_REPLACED_WITH_NULL_LITERAL,
        VARIABLE_REPLACED_WITH_NUMBER_LITERAL,
        VARIABLE_REPLACED_WITH_PARENTHESIZED_EXPRESSION,
        ARRAY_ACCESS_REPLACED_WITH_METHOD_INVOCATION,
        METHOD_INVOCATION_REPLACED_WITH_CONDITIONAL_EXPRESSION,
        METHOD_INVOCATION_REPLACED_WITH_NULL_LITERAL,
        NULL_LITERAL_REPLACED_WITH_CONDITIONAL_EXPRESSION,
        VARIABLE_REPLACED_WITH_CONDITIONAL_EXPRESSION,
        CLASS_INSTANCE_CREATION,
        CLASS_INSTANCE_CREATION_ARGUMENT,
        CLASS_INSTANCE_CREATION_REPLACED_WITH_METHOD_INVOCATION,
        CLASS_INSTANCE_CREATION_WRAPPED_IN_METHOD_INVOCATION,
        METHOD_INVOCATION_REPLACED_WITH_CLASS_INSTANCE_CREATION,
        METHOD_INVOCATION_WRAPPED_IN_CLASS_INSTANCE_CREATION,
        METHOD_INVOCATION_REPLACED_WITH_METHOD_REFERENCE,
        METHOD_INVOCATION_REPLACED_WITH_STRING_LITERAL,
        BUILDER_REPLACED_WITH_CLASS_INSTANCE_CREATION,
        FIELD_ASSIGNMENT_REPLACED_WITH_SETTER_METHOD_INVOCATION,
        ARRAY_CREATION_REPLACED_WITH_DATA_STRUCTURE_CREATION,
        ARRAY_INITIALIZER_REPLACED_WITH_METHOD_INVOCATION_ARGUMENTS,
        EXPRESSION_REPLACED_WITH_TERNARY_ELSE,
        EXPRESSION_REPLACED_WITH_TERNARY_THEN,
        INFIX_EXPRESSION,
        COMPOSITE,
        CONCATENATION,
        CONDITIONAL,
        NULL_LITERAL_REPLACED_WITH_CREATION,
        NULL_LITERAL_REPLACED_WITH_STRING_LITERAL,
        NULL_LITERAL_REPLACED_WITH_TYPE_LITERAL,
        NULL_LITERAL_REPLACED_WITH_OPTIONAL_EMPTY,
        NULL_LITERAL_CHECK_REPLACED_WITH_OPTIONAL_IS_PRESENT_CHECK,
        NULL_LITERAL_CHECK_REPLACED_WITH_OPTIONAL_IS_EMPTY_CHECK,
        ANONYMOUS_CLASS_DECLARATION_REPLACED_WITH_LAMBDA,
        LAMBDA_EXPRESSION_ARGUMENT,
        PARENTHESIZED_EXPRESSION,
        CAST_EXPRESSION;

    }
}

