/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition.replacement;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.Replacement;

public class VariableDeclarationReplacement
extends Replacement {
    private VariableDeclaration v1;
    private VariableDeclaration v2;
    private VariableDeclarationContainer operation1;
    private VariableDeclarationContainer operation2;

    public VariableDeclarationReplacement(VariableDeclaration v1, VariableDeclaration v2, VariableDeclarationContainer operation1, VariableDeclarationContainer operation2) {
        super(v1.toString() + " | " + v1.getScope(), v2.toString() + " | " + v2.getScope(), Replacement.ReplacementType.VARIABLE_DECLARATION);
        this.v1 = v1;
        this.v2 = v2;
        this.operation1 = operation1;
        this.operation2 = operation2;
    }

    public VariableDeclaration getVariableDeclaration1() {
        return this.v1;
    }

    public VariableDeclaration getVariableDeclaration2() {
        return this.v2;
    }

    public VariableDeclarationContainer getOperation1() {
        return this.operation1;
    }

    public VariableDeclarationContainer getOperation2() {
        return this.operation2;
    }

    public boolean identicalTypeAndInitializer() {
        AbstractExpression initializer1 = this.v1.getInitializer();
        AbstractExpression initializer2 = this.v2.getInitializer();
        if (initializer1 != null && initializer2 != null) {
            return this.v1.equalType(this.v2) && initializer1.getExpression().equals(initializer2.getExpression());
        }
        return false;
    }

    public Replacement getVariableNameReplacement() {
        return new Replacement(this.v1.getVariableName(), this.v2.getVariableName(), Replacement.ReplacementType.VARIABLE_NAME);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.v1 == null ? 0 : this.v1.hashCode());
        result = 31 * result + (this.v2 == null ? 0 : this.v2.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableDeclarationReplacement other = (VariableDeclarationReplacement)obj;
        if (this.v1 == null ? other.v1 != null : !this.v1.equals(other.v1)) {
            return false;
        }
        return !(this.v2 == null ? other.v2 != null : !this.v2.equals(other.v2));
    }
}

