/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.decomposition.replacement;

import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.replacement.Replacement;

public class VariableReplacementWithMethodInvocation
extends Replacement {
    private AbstractCall invokedOperation;
    private Direction direction;

    public VariableReplacementWithMethodInvocation(String before, String after, AbstractCall invocation, Direction direction) {
        super(before, after, Replacement.ReplacementType.VARIABLE_REPLACED_WITH_METHOD_INVOCATION);
        this.invokedOperation = invocation;
        this.direction = direction;
    }

    public boolean getterReplacement() {
        if (this.direction.equals((Object)Direction.VARIABLE_TO_INVOCATION)) {
            String variable = this.getBefore();
            String capitalizedFirstLetter = Character.toUpperCase(variable.charAt(0)) + variable.substring(1, variable.length());
            String methodCall = this.getAfter();
            return methodCall.equals("get" + capitalizedFirstLetter + "()");
        }
        if (this.direction.equals((Object)Direction.INVOCATION_TO_VARIABLE)) {
            String variable = this.getAfter();
            String capitalizedFirstLetter = Character.toUpperCase(variable.charAt(0)) + variable.substring(1, variable.length());
            String methodCall = this.getBefore();
            return methodCall.equals("get" + capitalizedFirstLetter + "()");
        }
        return false;
    }

    public AbstractCall getInvokedOperation() {
        return this.invokedOperation;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static enum Direction {
        VARIABLE_TO_INVOCATION,
        INVOCATION_TO_VARIABLE;

    }
}

