/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLModifier;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class AddClassModifierRefactoring
implements Refactoring {
    private String modifier;
    private UMLAbstractClass classBefore;
    private UMLAbstractClass classAfter;

    public AddClassModifierRefactoring(String modifier, UMLAbstractClass classBefore, UMLAbstractClass classAfter) {
        this.modifier = modifier;
        this.classBefore = classBefore;
        this.classAfter = classAfter;
    }

    public UMLModifier getAddedModifier() {
        for (UMLModifier m : this.classAfter.getModifiers()) {
            if (!m.getKeyword().equals(this.modifier)) continue;
            return m;
        }
        return null;
    }

    public String getModifier() {
        return this.modifier;
    }

    public UMLAbstractClass getClassBefore() {
        return this.classBefore;
    }

    public UMLAbstractClass getClassAfter() {
        return this.classAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classBefore.codeRange().setDescription("original class declaration").setCodeElement(this.classBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classAfter.codeRange().setDescription("class declaration with added modifier").setCodeElement(this.classAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.ADD_CLASS_MODIFIER;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassBefore().getLocationInfo().getFilePath(), (Object)this.getClassBefore().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassAfter().getLocationInfo().getFilePath(), (Object)this.getClassAfter().getName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.modifier);
        sb.append(" in class ");
        sb.append(this.classAfter.getName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classAfter == null ? 0 : this.classAfter.hashCode());
        result = 31 * result + (this.classBefore == null ? 0 : this.classBefore.hashCode());
        result = 31 * result + (this.modifier == null ? 0 : this.modifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddClassModifierRefactoring other = (AddClassModifierRefactoring)obj;
        if (this.classAfter == null ? other.classAfter != null : !this.classAfter.equals(other.classAfter)) {
            return false;
        }
        if (this.classBefore == null ? other.classBefore != null : !this.classBefore.equals(other.classBefore)) {
            return false;
        }
        return !(this.modifier == null ? other.modifier != null : !this.modifier.equals(other.modifier));
    }
}

