/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.LeafMappingProvider;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class AssertThrowsRefactoring
implements Refactoring,
LeafMappingProvider {
    private Set<AbstractCodeMapping> assertThrowsMappings;
    private AbstractCall assertThrowsCall;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private List<LeafMapping> subExpressionMappings;

    public AssertThrowsRefactoring(Set<AbstractCodeMapping> assertThrowsMappings, AbstractCall assertThrowsCall, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter) {
        this.assertThrowsMappings = assertThrowsMappings;
        this.assertThrowsCall = assertThrowsCall;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.subExpressionMappings = new ArrayList<LeafMapping>();
    }

    @Override
    public void addSubExpressionMapping(LeafMapping newLeafMapping) {
        boolean alreadyPresent = false;
        for (LeafMapping oldLeafMapping : this.subExpressionMappings) {
            if (!oldLeafMapping.getFragment1().getLocationInfo().equals(newLeafMapping.getFragment1().getLocationInfo()) || !oldLeafMapping.getFragment2().getLocationInfo().equals(newLeafMapping.getFragment2().getLocationInfo())) continue;
            alreadyPresent = true;
            break;
        }
        if (!alreadyPresent) {
            this.subExpressionMappings.add(newLeafMapping);
        }
    }

    @Override
    public List<LeafMapping> getSubExpressionMappings() {
        return this.subExpressionMappings;
    }

    public Set<AbstractCodeMapping> getAssertThrowsMappings() {
        return this.assertThrowsMappings;
    }

    public AbstractCall getAssertThrowsCall() {
        return this.assertThrowsCall;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeMapping mapping : this.assertThrowsMappings) {
            AbstractCodeFragment fragment = mapping.getFragment1();
            ranges.add(fragment.codeRange().setDescription("original code").setCodeElement(fragment.getString()));
        }
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeMapping mapping : this.assertThrowsMappings) {
            AbstractCodeFragment fragment = mapping.getFragment2();
            ranges.add(fragment.codeRange().setDescription("assertThrows code").setCodeElement(fragment.getString()));
        }
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with introduced assertThrows").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.ASSERT_THROWS;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        String string = this.assertThrowsCall.actualString();
        sb.append(string.contains("\n") ? string.substring(0, string.indexOf("\n")) : string);
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(this.operationAfter);
        sb.append(" from class ");
        sb.append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.assertThrowsCall, this.assertThrowsMappings, this.operationAfter, this.operationBefore);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssertThrowsRefactoring other = (AssertThrowsRefactoring)obj;
        return Objects.equals(this.assertThrowsCall, other.assertThrowsCall) && Objects.equals(this.assertThrowsMappings, other.assertThrowsMappings) && Objects.equals(this.operationAfter, other.operationAfter) && Objects.equals(this.operationBefore, other.operationBefore);
    }
}

