/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLModifier;
import gr.uom.java.xmi.Visibility;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ChangeClassAccessModifierRefactoring
implements Refactoring {
    private Visibility originalAccessModifier;
    private Visibility changedAccessModifier;
    private UMLAbstractClass classBefore;
    private UMLAbstractClass classAfter;

    public ChangeClassAccessModifierRefactoring(Visibility originalAccessModifier, Visibility changedAccessModifier, UMLAbstractClass classBefore, UMLAbstractClass classAfter) {
        this.originalAccessModifier = originalAccessModifier;
        this.changedAccessModifier = changedAccessModifier;
        this.classBefore = classBefore;
        this.classAfter = classAfter;
    }

    public UMLModifier getOldModifier() {
        for (UMLModifier m : this.classBefore.getModifiers()) {
            if (!m.getKeyword().equals(this.originalAccessModifier.toString())) continue;
            return m;
        }
        return null;
    }

    public UMLModifier getNewModifier() {
        for (UMLModifier m : this.classAfter.getModifiers()) {
            if (!m.getKeyword().equals(this.changedAccessModifier.toString())) continue;
            return m;
        }
        return null;
    }

    public Visibility getOriginalAccessModifier() {
        return this.originalAccessModifier;
    }

    public Visibility getChangedAccessModifier() {
        return this.changedAccessModifier;
    }

    public UMLAbstractClass getClassBefore() {
        return this.classBefore;
    }

    public UMLAbstractClass getClassAfter() {
        return this.classAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classBefore.codeRange().setDescription("original class declaration").setCodeElement(this.classBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classAfter.codeRange().setDescription("class declaration with changed access modifier").setCodeElement(this.classAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.CHANGE_CLASS_ACCESS_MODIFIER;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassBefore().getLocationInfo().getFilePath(), (Object)this.getClassBefore().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassAfter().getLocationInfo().getFilePath(), (Object)this.getClassAfter().getName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append((Object)this.originalAccessModifier);
        sb.append(" to ");
        sb.append((Object)this.changedAccessModifier);
        sb.append(" in class ");
        sb.append(this.classAfter.getName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedAccessModifier == null ? 0 : this.changedAccessModifier.hashCode());
        result = 31 * result + (this.classAfter == null ? 0 : this.classAfter.hashCode());
        result = 31 * result + (this.classBefore == null ? 0 : this.classBefore.hashCode());
        result = 31 * result + (this.originalAccessModifier == null ? 0 : this.originalAccessModifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeClassAccessModifierRefactoring other = (ChangeClassAccessModifierRefactoring)obj;
        if (this.changedAccessModifier == null ? other.changedAccessModifier != null : !this.changedAccessModifier.equals((Object)other.changedAccessModifier)) {
            return false;
        }
        if (this.classAfter == null ? other.classAfter != null : !this.classAfter.equals(other.classAfter)) {
            return false;
        }
        if (this.classBefore == null ? other.classBefore != null : !this.classBefore.equals(other.classBefore)) {
            return false;
        }
        return !(this.originalAccessModifier == null ? other.originalAccessModifier != null : !this.originalAccessModifier.equals((Object)other.originalAccessModifier));
    }
}

