/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLModifier;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.Visibility;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ChangeOperationAccessModifierRefactoring
implements Refactoring {
    private Visibility originalAccessModifier;
    private Visibility changedAccessModifier;
    private UMLOperation operationBefore;
    private UMLOperation operationAfter;

    public ChangeOperationAccessModifierRefactoring(Visibility originalAccessModifier, Visibility changedAccessModifier, UMLOperation operationBefore, UMLOperation operationAfter) {
        this.originalAccessModifier = originalAccessModifier;
        this.changedAccessModifier = changedAccessModifier;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
    }

    public UMLModifier getOldModifier() {
        for (UMLModifier m : this.operationBefore.getModifiers()) {
            if (!m.getKeyword().equals(this.originalAccessModifier.toString())) continue;
            return m;
        }
        return null;
    }

    public UMLModifier getNewModifier() {
        for (UMLModifier m : this.operationAfter.getModifiers()) {
            if (!m.getKeyword().equals(this.changedAccessModifier.toString())) continue;
            return m;
        }
        return null;
    }

    public Visibility getOriginalAccessModifier() {
        return this.originalAccessModifier;
    }

    public Visibility getChangedAccessModifier() {
        return this.changedAccessModifier;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.operationBefore.codeRange().setDescription("original method declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.operationAfter.codeRange().setDescription("method declaration with changed access modifier").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.CHANGE_OPERATION_ACCESS_MODIFIER;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append((Object)this.originalAccessModifier);
        sb.append(" to ");
        sb.append((Object)this.changedAccessModifier);
        sb.append(" in method ");
        sb.append(this.operationAfter);
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedAccessModifier == null ? 0 : this.changedAccessModifier.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalAccessModifier == null ? 0 : this.originalAccessModifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeOperationAccessModifierRefactoring other = (ChangeOperationAccessModifierRefactoring)obj;
        if (this.changedAccessModifier == null ? other.changedAccessModifier != null : !this.changedAccessModifier.equals((Object)other.changedAccessModifier)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        return !(this.originalAccessModifier == null ? other.originalAccessModifier != null : !this.originalAccessModifier.equals((Object)other.originalAccessModifier));
    }
}

