/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ChangeReturnTypeRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private UMLType originalType;
    private UMLType changedType;
    private UMLOperation operationBefore;
    private UMLOperation operationAfter;
    private Set<AbstractCodeMapping> returnReferences;

    public ChangeReturnTypeRefactoring(UMLType originalType, UMLType changedType, UMLOperation operationBefore, UMLOperation operationAfter, Set<AbstractCodeMapping> returnReferences) {
        this.originalType = originalType;
        this.changedType = changedType;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.returnReferences = returnReferences;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.CHANGE_RETURN_TYPE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public UMLType getOriginalType() {
        return this.originalType;
    }

    public UMLType getChangedType() {
        return this.changedType;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.returnReferences;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean qualified = this.originalType.equals(this.changedType) && !this.originalType.equalsQualified(this.changedType);
        sb.append(this.getName()).append("\t");
        sb.append(qualified ? this.originalType.toQualifiedString() : this.originalType.toString());
        sb.append(" to ");
        sb.append(qualified ? this.changedType.toQualifiedString() : this.changedType.toString());
        sb.append(" in method ");
        sb.append(qualified ? this.operationAfter.toQualifiedString() : this.operationAfter.toString());
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedType == null ? 0 : this.changedType.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalType == null ? 0 : this.originalType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeReturnTypeRefactoring other = (ChangeReturnTypeRefactoring)obj;
        if (this.changedType == null ? other.changedType != null : !this.changedType.equals(other.changedType)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        return !(this.originalType == null ? other.originalType != null : !this.originalType.equals(other.originalType));
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalType.codeRange().setDescription("original return type").setCodeElement(this.originalType.toString()));
        ranges.add(this.operationBefore.codeRange().setDescription("original method declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.changedType.codeRange().setDescription("changed return type").setCodeElement(this.changedType.toString()));
        ranges.add(this.operationAfter.codeRange().setDescription("method declaration with changed return type").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }
}

