/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ChangeThrownExceptionTypeRefactoring
implements Refactoring {
    private Set<UMLType> originalTypes;
    private Set<UMLType> changedTypes;
    private UMLOperation operationBefore;
    private UMLOperation operationAfter;

    public ChangeThrownExceptionTypeRefactoring(Set<UMLType> originalTypes, Set<UMLType> changedTypes, UMLOperation operationBefore, UMLOperation operationAfter) {
        this.originalTypes = originalTypes;
        this.changedTypes = changedTypes;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
    }

    public Set<UMLType> getOriginalTypes() {
        return this.originalTypes;
    }

    public Set<UMLType> getChangedTypes() {
        return this.changedTypes;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (UMLType originalType : this.originalTypes) {
            ranges.add(originalType.codeRange().setDescription("original exception type").setCodeElement(originalType.toString()));
        }
        ranges.add(this.operationBefore.codeRange().setDescription("original method declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (UMLType changedType : this.changedTypes) {
            ranges.add(changedType.codeRange().setDescription("changed exception type").setCodeElement(changedType.toString()));
        }
        ranges.add(this.operationAfter.codeRange().setDescription("method declaration with changed thrown exception type").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.CHANGE_THROWN_EXCEPTION_TYPE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalTypes.size() == 1 ? this.originalTypes.iterator().next() : this.originalTypes);
        sb.append(" to ");
        sb.append(this.changedTypes.size() == 1 ? this.changedTypes.iterator().next() : this.changedTypes);
        sb.append(" in method ");
        sb.append(this.operationAfter.toString());
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedTypes == null ? 0 : this.changedTypes.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalTypes == null ? 0 : this.originalTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeThrownExceptionTypeRefactoring other = (ChangeThrownExceptionTypeRefactoring)obj;
        if (this.changedTypes == null ? other.changedTypes != null : !this.changedTypes.equals(other.changedTypes)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        return !(this.originalTypes == null ? other.originalTypes != null : !this.originalTypes.equals(other.originalTypes));
    }
}

