/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ChangeTypeDeclarationKindRefactoring
implements Refactoring {
    private String originalTypeDeclarationKind;
    private String changedTypeDeclarationKind;
    private UMLAbstractClass classBefore;
    private UMLAbstractClass classAfter;

    public ChangeTypeDeclarationKindRefactoring(String originalTypeDeclarationKind, String changedTypeDeclarationKind, UMLAbstractClass classBefore, UMLAbstractClass classAfter) {
        this.originalTypeDeclarationKind = originalTypeDeclarationKind;
        this.changedTypeDeclarationKind = changedTypeDeclarationKind;
        this.classBefore = classBefore;
        this.classAfter = classAfter;
    }

    public String getOriginalTypeDeclarationKind() {
        return this.originalTypeDeclarationKind;
    }

    public String getChangedTypeDeclarationKind() {
        return this.changedTypeDeclarationKind;
    }

    public UMLAbstractClass getClassBefore() {
        return this.classBefore;
    }

    public UMLAbstractClass getClassAfter() {
        return this.classAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classBefore.codeRange().setDescription("original class declaration").setCodeElement(this.classBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.classAfter.codeRange().setDescription("class declaration with changed type declaration kind").setCodeElement(this.classAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.CHANGE_TYPE_DECLARATION_KIND;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassBefore().getLocationInfo().getFilePath(), (Object)this.getClassBefore().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getClassAfter().getLocationInfo().getFilePath(), (Object)this.getClassAfter().getName()));
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.originalTypeDeclarationKind);
        sb.append(" to ");
        sb.append(this.changedTypeDeclarationKind);
        sb.append(" in type ");
        sb.append(this.classAfter.getName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedTypeDeclarationKind == null ? 0 : this.changedTypeDeclarationKind.hashCode());
        result = 31 * result + (this.classAfter == null ? 0 : this.classAfter.hashCode());
        result = 31 * result + (this.classBefore == null ? 0 : this.classBefore.hashCode());
        result = 31 * result + (this.originalTypeDeclarationKind == null ? 0 : this.originalTypeDeclarationKind.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeTypeDeclarationKindRefactoring other = (ChangeTypeDeclarationKindRefactoring)obj;
        if (this.changedTypeDeclarationKind == null ? other.changedTypeDeclarationKind != null : !this.changedTypeDeclarationKind.equals(other.changedTypeDeclarationKind)) {
            return false;
        }
        if (this.classAfter == null ? other.classAfter != null : !this.classAfter.equals(other.classAfter)) {
            return false;
        }
        if (this.classBefore == null ? other.classBefore != null : !this.classBefore.equals(other.classBefore)) {
            return false;
        }
        return !(this.originalTypeDeclarationKind == null ? other.originalTypeDeclarationKind != null : !this.originalTypeDeclarationKind.equals(other.originalTypeDeclarationKind));
    }
}

