/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ChangeVariableTypeRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private VariableDeclaration originalVariable;
    private VariableDeclaration changedTypeVariable;
    private VariableDeclarationContainer operationBefore;
    private VariableDeclarationContainer operationAfter;
    private Set<AbstractCodeMapping> variableReferences;
    private Set<Refactoring> relatedRefactorings;
    private boolean insideExtractedOrInlinedMethod;

    public ChangeVariableTypeRefactoring(VariableDeclaration originalVariable, VariableDeclaration changedTypeVariable, VariableDeclarationContainer operationBefore, VariableDeclarationContainer operationAfter, Set<AbstractCodeMapping> variableReferences, boolean insideExtractedOrInlinedMethod) {
        this.originalVariable = originalVariable;
        this.changedTypeVariable = changedTypeVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
        this.relatedRefactorings = new LinkedHashSet<Refactoring>();
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
    }

    public void addRelatedRefactoring(Refactoring refactoring) {
        this.relatedRefactorings.add(refactoring);
    }

    public Set<Refactoring> getRelatedRefactorings() {
        return this.relatedRefactorings;
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.originalVariable.isParameter() && this.changedTypeVariable.isParameter()) {
            return RefactoringType.CHANGE_PARAMETER_TYPE;
        }
        return RefactoringType.CHANGE_VARIABLE_TYPE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public VariableDeclaration getOriginalVariable() {
        return this.originalVariable;
    }

    public VariableDeclaration getChangedTypeVariable() {
        return this.changedTypeVariable;
    }

    public VariableDeclarationContainer getOperationBefore() {
        return this.operationBefore;
    }

    public VariableDeclarationContainer getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.variableReferences;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean qualified = this.originalVariable.equalType(this.changedTypeVariable) && !this.originalVariable.equalQualifiedType(this.changedTypeVariable);
        sb.append(this.getName()).append("\t");
        sb.append(qualified ? this.originalVariable.toQualifiedString() : this.originalVariable.toString());
        sb.append(" to ");
        sb.append(qualified ? this.changedTypeVariable.toQualifiedString() : this.changedTypeVariable.toString());
        String elementType = this.operationAfter.getElementType();
        sb.append(" in " + elementType + " ");
        sb.append(qualified ? this.operationAfter.toQualifiedString() : this.operationAfter.toString());
        sb.append(" from class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedTypeVariable == null ? 0 : this.changedTypeVariable.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalVariable == null ? 0 : this.originalVariable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeVariableTypeRefactoring other = (ChangeVariableTypeRefactoring)obj;
        if (this.changedTypeVariable == null ? other.changedTypeVariable != null : !this.changedTypeVariable.equals(other.changedTypeVariable)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        return !(this.originalVariable == null ? other.originalVariable != null : !this.originalVariable.equals(other.originalVariable));
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalVariable.codeRange().setDescription("original variable declaration").setCodeElement(this.originalVariable.toString()));
        String elementType = this.operationBefore.getElementType();
        ranges.add(this.operationBefore.codeRange().setDescription("original " + elementType + " declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.changedTypeVariable.codeRange().setDescription("changed-type variable declaration").setCodeElement(this.changedTypeVariable.toString()));
        String elementType = this.operationAfter.getElementType();
        ranges.add(this.operationAfter.codeRange().setDescription(elementType + " declaration with changed variable type").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }
}

