/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AnonymousClassDeclarationObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLAnonymousClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringMinerTimedOutException;
import org.refactoringminer.api.RefactoringType;

public class ExtractAttributeRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private UMLAttribute attributeDeclaration;
    private UMLAbstractClass originalClass;
    private UMLAbstractClass nextClass;
    private Set<AbstractCodeMapping> references;
    private boolean insideExtractedOrInlinedMethod;
    private List<UMLAnonymousClassDiff> anonymousClassDiffList;

    public ExtractAttributeRefactoring(UMLAttribute variableDeclaration, UMLAbstractClass originalClass, UMLAbstractClass nextClass, boolean insideExtractedOrInlinedMethod) {
        this.attributeDeclaration = variableDeclaration;
        this.originalClass = originalClass;
        this.nextClass = nextClass;
        this.references = new LinkedHashSet<AbstractCodeMapping>();
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
        this.anonymousClassDiffList = new ArrayList<UMLAnonymousClassDiff>();
    }

    public List<Refactoring> addReference(AbstractCodeMapping mapping, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) throws RefactoringMinerTimedOutException {
        this.references.add(mapping);
        ArrayList<Refactoring> allRefactorings = new ArrayList<Refactoring>();
        List<UMLAnonymousClass> attributeAnonymousClassList = this.attributeDeclaration.getAnonymousClassList();
        ArrayList<AnonymousClassDeclarationObject> fragmentAnonymousClassDeclarations = new ArrayList<AnonymousClassDeclarationObject>();
        ExtractAttributeRefactoring.recursivelyCollectAnonymousClassDeclarations(fragmentAnonymousClassDeclarations, mapping.getFragment1().getAnonymousClassDeclarations());
        if (attributeAnonymousClassList.size() > 0 && fragmentAnonymousClassDeclarations.size() > 0 && attributeAnonymousClassList.size() == fragmentAnonymousClassDeclarations.size()) {
            for (int i = 0; i < attributeAnonymousClassList.size(); ++i) {
                UMLAnonymousClass after = attributeAnonymousClassList.get(i);
                UMLAnonymousClass before = mapping.getOperation1().findAnonymousClass((AnonymousClassDeclarationObject)fragmentAnonymousClassDeclarations.get(i));
                if (before == null || after == null) continue;
                UMLAnonymousClassDiff anonymousClassDiff = new UMLAnonymousClassDiff(before, after, classDiff, modelDiff);
                anonymousClassDiff.process();
                List<UMLOperationBodyMapper> matchedOperationMappers = anonymousClassDiff.getOperationBodyMapperList();
                if (matchedOperationMappers.size() <= 0) continue;
                this.anonymousClassDiffList.add(anonymousClassDiff);
                List<Refactoring> anonymousClassDiffRefactorings = anonymousClassDiff.getRefactorings();
                allRefactorings.addAll(anonymousClassDiffRefactorings);
                if (classDiff != null && classDiff.getRemovedAnonymousClasses().contains(before)) {
                    classDiff.getRemovedAnonymousClasses().remove(before);
                }
                if (classDiff == null || !classDiff.getAddedAnonymousClasses().contains(after)) continue;
                classDiff.getAddedAnonymousClasses().remove(after);
            }
        }
        return allRefactorings;
    }

    private static void recursivelyCollectAnonymousClassDeclarations(List<AnonymousClassDeclarationObject> all, List<AnonymousClassDeclarationObject> current) {
        for (AnonymousClassDeclarationObject anonymous : current) {
            ExtractAttributeRefactoring.recursivelyCollectAnonymousClassDeclarations(all, anonymous.getAnonymousClassDeclarations());
            all.add(anonymous);
        }
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.EXTRACT_ATTRIBUTE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public UMLAttribute getVariableDeclaration() {
        return this.attributeDeclaration;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.references;
    }

    public List<UMLAnonymousClassDiff> getAnonymousClassDiffList() {
        return this.anonymousClassDiffList;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.attributeDeclaration);
        sb.append(" in class ");
        sb.append(this.attributeDeclaration.getClassName());
        return sb.toString();
    }

    public CodeRange getExtractedVariableDeclarationCodeRange() {
        return this.attributeDeclaration.codeRange();
    }

    public UMLAbstractClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLAbstractClass getNextClass() {
        return this.nextClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeDeclaration.getVariableDeclaration() == null ? 0 : this.attributeDeclaration.getVariableDeclaration().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtractAttributeRefactoring other = (ExtractAttributeRefactoring)obj;
        return !(this.attributeDeclaration == null ? other.attributeDeclaration != null : !this.attributeDeclaration.getVariableDeclaration().equals(other.attributeDeclaration.getVariableDeclaration()));
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getNextClass().getLocationInfo().getFilePath(), (Object)this.getNextClass().getName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment1().codeRange().setDescription("statement with the initializer of the extracted attribute"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.attributeDeclaration.codeRange().setDescription("extracted attribute declaration").setCodeElement(this.attributeDeclaration.toString()));
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment2().codeRange().setDescription("statement with the name of the extracted attribute"));
        }
        return ranges;
    }
}

