/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.CompositeStatementObjectMapping;
import gr.uom.java.xmi.decomposition.LambdaExpressionObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.StatementObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.CallTree;
import gr.uom.java.xmi.diff.CallTreeNode;
import gr.uom.java.xmi.diff.ExtractOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class ExtractOperationDetection {
    private UMLOperationBodyMapper mapper;
    private List<UMLOperation> addedOperations;
    private UMLAbstractClassDiff classDiff;
    private UMLModelDiff modelDiff;
    private List<AbstractCall> operationInvocations;
    private Map<CallTreeNode, CallTree> callTreeMap = new LinkedHashMap<CallTreeNode, CallTree>();
    private Map<UMLOperation, List<AbstractCall>> callCountMap = null;
    private List<UMLOperation> potentiallyMovedOperations = new ArrayList<UMLOperation>();

    public ExtractOperationDetection(UMLOperationBodyMapper mapper, List<UMLOperation> addedOperations, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff, boolean invocationsFromOtherMappers) {
        this.mapper = mapper;
        this.addedOperations = addedOperations;
        this.classDiff = classDiff;
        this.modelDiff = modelDiff;
        if (invocationsFromOtherMappers) {
            this.addInvocationsFromOtherMappers();
        } else {
            this.operationInvocations = ExtractOperationDetection.getInvocationsInSourceOperationAfterExtractionExcludingInvocationsInExactlyMappedStatements(mapper);
        }
    }

    public ExtractOperationDetection(UMLOperationBodyMapper mapper, List<UMLOperation> addedOperations, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        this(mapper, addedOperations, classDiff, modelDiff, false);
    }

    public ExtractOperationDetection(UMLOperationBodyMapper mapper, List<UMLOperation> potentiallyMovedOperations, List<UMLOperation> addedOperations, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        this(mapper, addedOperations, classDiff, modelDiff);
        this.potentiallyMovedOperations = potentiallyMovedOperations;
    }

    private void addInvocationsFromOtherMappers() {
        this.operationInvocations = new ArrayList<AbstractCall>();
        for (UMLOperationBodyMapper mapper : this.classDiff.getOperationBodyMapperList()) {
            if (mapper.equals(this.mapper)) continue;
            for (AbstractCodeFragment statement : mapper.getNonMappedLeavesT2()) {
                ExtractOperationDetection.addStatementInvocations(this.operationInvocations, statement);
            }
        }
    }

    public List<UMLOperation> getAddedOperationsSortedByCalls() {
        this.callCountMap = new LinkedHashMap<UMLOperation, List<AbstractCall>>();
        ArrayList<UMLOperation> sorted = new ArrayList<UMLOperation>();
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (UMLOperation addedOperation : this.addedOperations) {
            List<AbstractCall> matchingInvocations = this.matchingInvocations(addedOperation, this.operationInvocations, this.mapper.getContainer2());
            if (matchingInvocations.isEmpty()) continue;
            this.callCountMap.put(addedOperation, matchingInvocations);
            int count = matchingInvocations.size();
            if (sorted.isEmpty()) {
                sorted.add(addedOperation);
                counts.add(count);
                continue;
            }
            boolean inserted = false;
            for (int i = 0; i < counts.size(); ++i) {
                if (count <= (Integer)counts.get(i)) continue;
                sorted.add(i, addedOperation);
                counts.add(i, count);
                inserted = true;
                break;
            }
            if (inserted) continue;
            sorted.add(counts.size(), addedOperation);
            counts.add(counts.size(), count);
        }
        return sorted;
    }

    public List<ExtractOperationRefactoring> check(UMLOperation addedOperation) throws RefactoringMinerTimedOutException {
        ArrayList<ExtractOperationRefactoring> refactorings = new ArrayList<ExtractOperationRefactoring>();
        if (this.modelDiff != null && this.modelDiff.refactoringListContainsAnotherMoveRefactoringWithTheSameAddedOperation(addedOperation)) {
            return refactorings;
        }
        if (!this.mapper.getNonMappedLeavesT1().isEmpty() || !this.mapper.getNonMappedInnerNodesT1().isEmpty() || !this.mapper.getReplacementsInvolvingMethodInvocation().isEmpty() || this.mapper.containsCompositeMappingWithoutReplacements()) {
            List<AbstractCall> addedOperationInvocations;
            List<AbstractCall> list = addedOperationInvocations = this.callCountMap != null ? this.callCountMap.get(addedOperation) : this.matchingInvocations(addedOperation, this.operationInvocations, this.mapper.getContainer2());
            if (addedOperationInvocations.size() > 0) {
                int otherAddedMethodsCalled = 0;
                int otherAddedMethodsCalledWithSameOrMoreCallSites = 0;
                for (UMLOperation addedOperation2 : this.addedOperations) {
                    List<AbstractCall> addedOperationInvocations2;
                    if (addedOperation.equals(addedOperation2)) continue;
                    List<AbstractCall> list2 = addedOperationInvocations2 = this.callCountMap != null ? this.callCountMap.get(addedOperation2) : this.matchingInvocations(addedOperation2, this.operationInvocations, this.mapper.getContainer2());
                    if (addedOperationInvocations2 != null && addedOperationInvocations2.size() > 0) {
                        ++otherAddedMethodsCalled;
                    }
                    if (addedOperationInvocations2 == null || addedOperationInvocations2.size() < addedOperationInvocations.size()) continue;
                    ++otherAddedMethodsCalledWithSameOrMoreCallSites;
                }
                if (otherAddedMethodsCalledWithSameOrMoreCallSites == 0 && (otherAddedMethodsCalled == 0 || this.mapper.getContainer1().stringRepresentation().size() > addedOperationInvocations.size() * addedOperation.stringRepresentation().size())) {
                    List<AbstractCall> sortedInvocations = this.sortInvocationsBasedOnArgumentOccurrences(addedOperationInvocations);
                    for (AbstractCall addedOperationInvocation : sortedInvocations) {
                        VariableDeclaration declaration;
                        this.processAddedOperation(addedOperation, refactorings, sortedInvocations, addedOperationInvocation);
                        if (sortedInvocations.size() != 1 || addedOperationInvocation.arguments().size() != 1) continue;
                        String argument = addedOperationInvocation.arguments().get(0);
                        Set<VariableDeclaration> declarations = this.mapper.getContainer2().variableDeclarationMap().get(argument);
                        if (declarations == null || declarations.size() != 1 || (declaration = declarations.iterator().next()).getInitializer() == null || declaration.getInitializer().getTernaryOperatorExpressions().size() != 1) continue;
                        this.processAddedOperation(addedOperation, refactorings, sortedInvocations, addedOperationInvocation);
                    }
                } else {
                    this.processAddedOperation(addedOperation, refactorings, addedOperationInvocations, addedOperationInvocations.get(0));
                }
            }
        }
        return refactorings;
    }

    private List<AbstractCall> sortInvocationsBasedOnArgumentOccurrences(List<AbstractCall> invocations) {
        if (invocations.size() > 1) {
            ArrayList<AbstractCall> sorted = new ArrayList<AbstractCall>();
            ArrayList<String> allVariables = new ArrayList<String>();
            for (CompositeStatementObject composite : this.mapper.getNonMappedInnerNodesT1()) {
                for (LeafExpression expression : composite.getVariables()) {
                    allVariables.add(expression.getString());
                }
            }
            for (AbstractCodeFragment leaf : this.mapper.getNonMappedLeavesT1()) {
                for (LeafExpression expression : leaf.getVariables()) {
                    allVariables.add(expression.getString());
                }
            }
            int max = 0;
            for (AbstractCall invocation : invocations) {
                List<String> arguments = invocation.arguments();
                int occurrences = 0;
                for (String argument : arguments) {
                    if (argument.startsWith("this.") && !allVariables.contains(argument)) {
                        String substringAfterThis = argument.substring(5);
                        occurrences += Collections.frequency(allVariables, substringAfterThis);
                        continue;
                    }
                    occurrences += Collections.frequency(allVariables, argument);
                }
                if (occurrences > max) {
                    sorted.add(0, invocation);
                    max = occurrences;
                    continue;
                }
                sorted.add(invocation);
            }
            return sorted;
        }
        return invocations;
    }

    private void processAddedOperation(UMLOperation addedOperation, List<ExtractOperationRefactoring> refactorings, List<AbstractCall> addedOperationInvocations, AbstractCall addedOperationInvocation) throws RefactoringMinerTimedOutException {
        CallTreeNode root = new CallTreeNode(this.mapper.getContainer1(), addedOperation, addedOperationInvocation);
        CallTree callTree = null;
        if (this.callTreeMap.containsKey(root)) {
            callTree = this.callTreeMap.get(root);
        } else {
            callTree = new CallTree(root);
            this.generateCallTree(addedOperation, root, callTree);
            this.callTreeMap.put(root, callTree);
        }
        UMLOperationBodyMapper operationBodyMapper = this.createMapperForExtractedMethod(this.mapper, this.mapper.getContainer1(), addedOperation, addedOperationInvocation, false);
        if (operationBodyMapper != null && !this.containsRefactoringWithIdenticalMappings(refactorings, operationBodyMapper)) {
            ArrayList<AbstractCodeMapping> additionalExactMatches = new ArrayList<AbstractCodeMapping>();
            List<CallTreeNode> nodesInBreadthFirstOrder = callTree.getNodesInBreadthFirstOrder();
            for (int i = 1; i < nodesInBreadthFirstOrder.size(); ++i) {
                CallTreeNode node = nodesInBreadthFirstOrder.get(i);
                if (this.matchingInvocations(node.getInvokedOperation(), this.operationInvocations, this.mapper.getContainer2()).size() != 0) continue;
                this.processNestedMapper(operationBodyMapper, operationBodyMapper, refactorings, additionalExactMatches, node);
            }
            UMLOperation delegateMethod = this.findDelegateMethod(this.mapper.getContainer1(), addedOperation, addedOperationInvocation);
            if (this.extractMatchCondition(operationBodyMapper, additionalExactMatches)) {
                ExtractOperationRefactoring extractOperationRefactoring = null;
                extractOperationRefactoring = delegateMethod == null ? new ExtractOperationRefactoring(operationBodyMapper, this.mapper.getContainer2(), addedOperationInvocations) : new ExtractOperationRefactoring(operationBodyMapper, addedOperation, this.mapper.getContainer1(), this.mapper.getContainer2(), addedOperationInvocations);
                refactorings.add(extractOperationRefactoring);
            } else {
                for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
                    AbstractCodeFragment fragment1 = mapping.getFragment1();
                    if (fragment1 instanceof CompositeStatementObject) {
                        if (this.mapper.getNonMappedInnerNodesT1().contains(fragment1)) continue;
                        this.mapper.getNonMappedInnerNodesT1().add((CompositeStatementObject)fragment1);
                        continue;
                    }
                    if (this.mapper.getNonMappedLeavesT1().contains(fragment1)) continue;
                    this.mapper.getNonMappedLeavesT1().add(fragment1);
                }
            }
        }
    }

    private void processNestedMapper(UMLOperationBodyMapper mapper, UMLOperationBodyMapper operationBodyMapper, List<ExtractOperationRefactoring> refactorings, List<AbstractCodeMapping> additionalExactMatches, CallTreeNode node) throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper nestedMapper = this.createMapperForExtractedMethod(mapper, node.getOriginalOperation(), node.getInvokedOperation(), node.getInvocation(), true);
        if (nestedMapper != null && !this.containsRefactoringWithIdenticalMappings(refactorings, nestedMapper)) {
            additionalExactMatches.addAll(nestedMapper.getExactMatches());
            if (this.extractMatchCondition(nestedMapper, new ArrayList<AbstractCodeMapping>()) && (this.extractMatchCondition(operationBodyMapper, additionalExactMatches) || node.getOriginalOperation().delegatesTo(node.getInvokedOperation(), this.classDiff, this.modelDiff) != null)) {
                List<AbstractCall> nestedMatchingInvocations = this.matchingInvocations(node.getInvokedOperation(), node.getOriginalOperation().getAllOperationInvocations(), node.getOriginalOperation());
                ExtractOperationRefactoring nestedRefactoring = new ExtractOperationRefactoring(nestedMapper, mapper.getContainer2(), nestedMatchingInvocations);
                refactorings.add(nestedRefactoring);
                operationBodyMapper.addChildMapper(nestedMapper);
            } else {
                for (AbstractCodeMapping mapping : nestedMapper.getMappings()) {
                    AbstractCodeFragment fragment1 = mapping.getFragment1();
                    if (fragment1 instanceof CompositeStatementObject) {
                        if (mapper.getNonMappedInnerNodesT1().contains(fragment1)) continue;
                        mapper.getNonMappedInnerNodesT1().add((CompositeStatementObject)fragment1);
                        continue;
                    }
                    if (mapper.getNonMappedLeavesT1().contains(fragment1)) continue;
                    mapper.getNonMappedLeavesT1().add(fragment1);
                }
            }
        }
    }

    private boolean containsRefactoringWithIdenticalMappings(List<ExtractOperationRefactoring> refactorings, UMLOperationBodyMapper mapper) {
        Set<AbstractCodeMapping> newMappings = mapper.getMappings();
        for (ExtractOperationRefactoring ref : refactorings) {
            Set<AbstractCodeMapping> oldMappings = ref.getBodyMapper().getMappings();
            if (!oldMappings.containsAll(newMappings)) continue;
            return true;
        }
        return false;
    }

    private static List<AbstractCall> getInvocationsInSourceOperationAfterExtractionExcludingInvocationsInExactlyMappedStatements(UMLOperationBodyMapper mapper) {
        List<AbstractCall> operationInvocations = mapper.getContainer2().getAllOperationInvocations();
        for (AbstractCodeMapping mapping : mapper.getMappings()) {
            if (!mapping.isExact() || !mapping.getReplacementsInvolvingMethodInvocation().isEmpty()) continue;
            block1: for (AbstractCall invocation : mapping.getFragment2().getMethodInvocations()) {
                ListIterator<AbstractCall> iterator = operationInvocations.listIterator();
                while (iterator.hasNext()) {
                    AbstractCall matchingInvocation = iterator.next();
                    if (invocation != matchingInvocation && !invocation.actualString().equals(matchingInvocation.actualString())) continue;
                    iterator.remove();
                    continue block1;
                }
            }
        }
        for (AbstractCodeFragment statement : mapper.getNonMappedLeavesT2()) {
            ExtractOperationDetection.addStatementInvocations(operationInvocations, statement);
        }
        return operationInvocations;
    }

    public static List<AbstractCall> getInvocationsInSourceOperationAfterExtraction(UMLOperationBodyMapper mapper) {
        List<AbstractCall> operationInvocations = ExtractOperationDetection.getInvocationsInSourceOperationAfterExtractionExcludingInvocationsInExactlyMappedStatements(mapper);
        if (operationInvocations.isEmpty()) {
            return operationInvocations;
        }
        List<AbstractCall> invocationsInSourceOperationBeforeExtraction = mapper.getContainer1().getAllOperationInvocations();
        block0: for (AbstractCall invocation : invocationsInSourceOperationBeforeExtraction) {
            ListIterator<AbstractCall> iterator = operationInvocations.listIterator();
            while (iterator.hasNext()) {
                AbstractCall matchingInvocation = iterator.next();
                if (!invocation.getName().equals(matchingInvocation.getName())) continue;
                boolean matchingInvocationFound = false;
                for (String argument : invocation.arguments()) {
                    if (!argument.equals(matchingInvocation.getExpression())) continue;
                    iterator.remove();
                    matchingInvocationFound = true;
                    break;
                }
                if (!matchingInvocationFound) continue;
                continue block0;
            }
        }
        return operationInvocations;
    }

    public static void addStatementInvocations(List<AbstractCall> operationInvocations, AbstractCodeFragment statement) {
        for (AbstractCall statementInvocation : statement.getMethodInvocations()) {
            if (ExtractOperationDetection.containsInvocation(operationInvocations, statementInvocation)) continue;
            operationInvocations.add(statementInvocation);
        }
        List<LambdaExpressionObject> lambdas = statement.getLambdas();
        for (LambdaExpressionObject lambda : lambdas) {
            for (AbstractCall statementInvocation : lambda.getAllOperationInvocations()) {
                if (ExtractOperationDetection.containsInvocation(operationInvocations, statementInvocation)) continue;
                operationInvocations.add(statementInvocation);
            }
        }
    }

    public static boolean containsInvocation(List<AbstractCall> operationInvocations, AbstractCall invocation) {
        for (AbstractCall operationInvocation : operationInvocations) {
            if (!operationInvocation.getLocationInfo().equals(invocation.getLocationInfo())) continue;
            return true;
        }
        return false;
    }

    private List<AbstractCall> matchingInvocations(UMLOperation operation, List<AbstractCall> operationInvocations, VariableDeclarationContainer callerOperation) {
        ArrayList<AbstractCall> addedOperationInvocations = new ArrayList<AbstractCall>();
        for (AbstractCall invocation : operationInvocations) {
            if (!invocation.matchesOperation(operation, callerOperation, this.classDiff, this.modelDiff)) continue;
            addedOperationInvocations.add(invocation);
        }
        return addedOperationInvocations;
    }

    private void generateCallTree(UMLOperation operation, CallTreeNode parent, CallTree callTree) {
        List<AbstractCall> invocations = operation.getAllOperationInvocations();
        for (UMLOperation addedOperation : this.addedOperations) {
            for (AbstractCall invocation : invocations) {
                if (!invocation.matchesOperation(addedOperation, operation, this.classDiff, this.modelDiff) || callTree.containsInPathToRootOrSibling(parent, addedOperation)) continue;
                CallTreeNode node = new CallTreeNode(parent, operation, addedOperation, invocation);
                parent.addChild(node);
                this.generateCallTree(addedOperation, node, callTree);
            }
        }
    }

    private UMLOperationBodyMapper createMapperForExtractedMethod(UMLOperationBodyMapper mapper, VariableDeclarationContainer originalOperation, UMLOperation addedOperation, AbstractCall addedOperationInvocation, boolean nested) throws RefactoringMinerTimedOutException {
        for (UMLOperation potentiallyMovedOperation : this.potentiallyMovedOperations) {
            if (!potentiallyMovedOperation.equalSignature(addedOperation)) continue;
            return null;
        }
        List<UMLParameter> originalMethodParameters = originalOperation.getParametersWithoutReturnType();
        LinkedHashMap<UMLParameter, UMLParameter> originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters = new LinkedHashMap<UMLParameter, UMLParameter>();
        List<String> arguments = addedOperationInvocation.arguments();
        List<UMLParameter> parameters = addedOperation.getParametersWithoutReturnType();
        LinkedHashMap<String, String> parameterToArgumentMap = new LinkedHashMap<String, String>();
        int size = Math.min(arguments.size(), parameters.size());
        for (int i = 0; i < size; ++i) {
            String argumentName = arguments.get(i);
            String parameterName = parameters.get(i).getName();
            parameterToArgumentMap.put(parameterName, argumentName);
            for (UMLParameter originalMethodParameter : originalMethodParameters) {
                if (!originalMethodParameter.getName().equals(argumentName)) continue;
                originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters.put(originalMethodParameter, parameters.get(i));
            }
        }
        if (this.parameterTypesMatch(originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters)) {
            UMLOperation delegateMethod = this.findDelegateMethod(originalOperation, addedOperation, addedOperationInvocation);
            return new UMLOperationBodyMapper(mapper, delegateMethod != null ? delegateMethod : addedOperation, new LinkedHashMap<String, String>(), parameterToArgumentMap, this.classDiff, addedOperationInvocation, nested);
        }
        return null;
    }

    private boolean extractMatchCondition(UMLOperationBodyMapper operationBodyMapper, List<AbstractCodeMapping> additionalExactMatches) {
        List<VariableDeclaration> variableDeclarations;
        AbstractCodeMapping mapping;
        if (operationBodyMapper.getMappings().size() == 1 && (mapping = operationBodyMapper.getMappings().iterator().next()).getFragment1() instanceof AbstractExpression) {
            for (AbstractCodeMapping parentMapping : operationBodyMapper.getParentMapper().getMappings()) {
                if (!(parentMapping instanceof CompositeStatementObjectMapping)) continue;
                CompositeStatementObject parentComp1 = (CompositeStatementObject)parentMapping.getFragment1();
                CompositeStatementObject parentComp2 = (CompositeStatementObject)parentMapping.getFragment2();
                if (!parentComp1.getExpressions().contains(mapping.getFragment1()) || parentComp2.getMethodInvocations().contains(operationBodyMapper.getOperationInvocation())) continue;
                return false;
            }
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        ArrayList<AbstractCodeMapping> exactMatchList = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getExactMatches());
        boolean exceptionHandlingExactMatch = false;
        boolean throwsNewExceptionExactMatch = false;
        if (exactMatchList.size() == 1) {
            AbstractCodeMapping mapping2 = (AbstractCodeMapping)exactMatchList.get(0);
            if (mapping2.getFragment1() instanceof StatementObject && mapping2.getFragment2() instanceof StatementObject) {
                StatementObject statement1 = (StatementObject)mapping2.getFragment1();
                StatementObject statement2 = (StatementObject)mapping2.getFragment2();
                if (statement1.getParent().getString().startsWith("catch(") && statement2.getParent().getString().startsWith("catch(")) {
                    exceptionHandlingExactMatch = true;
                }
            }
            if (mapping2.getFragment1().throwsNewException() && mapping2.getFragment2().throwsNewException()) {
                throwsNewExceptionExactMatch = true;
            }
        }
        for (AbstractCodeMapping mapping3 : operationBodyMapper.getMappings()) {
            variableDeclarations = mapping3.getFragment2().getVariableDeclarations();
            if (variableDeclarations.size() <= 0) continue;
            block2: for (VariableDeclaration variableDeclaration : variableDeclarations) {
                for (AbstractCodeFragment leaf2 : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!leaf2.countableStatement() || !leaf2.getString().equals("return " + variableDeclaration.getVariableName() + ";\n")) continue;
                    --nonMappedElementsT2;
                    continue block2;
                }
            }
        }
        if (nonMappedElementsT2 == 1) {
            for (AbstractCodeFragment fragment2 : operationBodyMapper.getNonMappedLeavesT2()) {
                variableDeclarations = fragment2.getVariableDeclarations();
                if (variableDeclarations.size() <= 0) continue;
                block5: for (VariableDeclaration variableDeclaration : variableDeclarations) {
                    for (AbstractCodeMapping mapping4 : operationBodyMapper.getMappings()) {
                        boolean matchingReplacementFound = false;
                        for (Replacement r : mapping4.getReplacements()) {
                            if (!r.getAfter().equals(variableDeclaration.getVariableName())) continue;
                            matchingReplacementFound = true;
                        }
                        if (!matchingReplacementFound) continue;
                        --nonMappedElementsT2;
                        continue block5;
                    }
                }
            }
        }
        exactMatchList.addAll(additionalExactMatches);
        int exactMatches = exactMatchList.size();
        if (exactMatches == 0 && operationBodyMapper.getMappings().size() >= 1 && operationBodyMapper.getMappings().size() <= 2) {
            int beforeAfterContains = 0;
            AbstractCodeMapping mapping5 = operationBodyMapper.getMappings().iterator().next();
            for (Replacement r : mapping5.getReplacements()) {
                if (!r.getAfter().contains(r.getBefore()) && !r.getBefore().contains(r.getAfter())) continue;
                ++beforeAfterContains;
            }
            if (beforeAfterContains == mapping5.getReplacements().size()) {
                ++exactMatches;
            }
        }
        return mappings > 0 && (mappings > nonMappedElementsT2 || mappings > 1 && mappings >= nonMappedElementsT2 || exactMatches >= mappings && nonMappedElementsT1 == 0 || exactMatches == 1 && !throwsNewExceptionExactMatch && nonMappedElementsT2 - exactMatches <= 10 || !exceptionHandlingExactMatch && exactMatches > 1 && additionalExactMatches.size() < exactMatches && nonMappedElementsT2 - exactMatches < 20 || mappings == 1 && mappings > operationBodyMapper.nonMappedLeafElementsT2()) || this.argumentExtractedWithDefaultReturnAdded(operationBodyMapper);
    }

    private boolean argumentExtractedWithDefaultReturnAdded(UMLOperationBodyMapper operationBodyMapper) {
        ArrayList<AbstractCodeMapping> totalMappings = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        ArrayList<CompositeStatementObject> nonMappedInnerNodesT2 = new ArrayList<CompositeStatementObject>(operationBodyMapper.getNonMappedInnerNodesT2());
        ListIterator iterator = nonMappedInnerNodesT2.listIterator();
        while (iterator.hasNext()) {
            if (!((CompositeStatementObject)iterator.next()).toString().equals("{")) continue;
            iterator.remove();
        }
        List<AbstractCodeFragment> nonMappedLeavesT2 = operationBodyMapper.getNonMappedLeavesT2();
        return totalMappings.size() == 1 && ((AbstractCodeMapping)totalMappings.get(0)).containsReplacement(Replacement.ReplacementType.ARGUMENT_REPLACED_WITH_RETURN_EXPRESSION) && nonMappedInnerNodesT2.size() == 1 && ((CompositeStatementObject)nonMappedInnerNodesT2.get(0)).toString().startsWith("if") && nonMappedLeavesT2.size() == 1 && nonMappedLeavesT2.get(0).toString().startsWith("return ");
    }

    private UMLOperation findDelegateMethod(VariableDeclarationContainer originalOperation, UMLOperation addedOperation, AbstractCall addedOperationInvocation) {
        AbstractCall delegateMethodInvocation = addedOperation.isDelegate();
        if (originalOperation.isDelegate() == null && delegateMethodInvocation != null && !originalOperation.getAllOperationInvocations().contains(addedOperationInvocation)) {
            for (UMLOperation operation : this.addedOperations) {
                if (!delegateMethodInvocation.matchesOperation(operation, addedOperation, this.classDiff, this.modelDiff)) continue;
                return operation;
            }
        }
        return null;
    }

    private boolean parameterTypesMatch(Map<UMLParameter, UMLParameter> originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters) {
        for (UMLParameter key : originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters.keySet()) {
            UMLParameter value = originalMethodParametersPassedAsArgumentsMappedToCalledMethodParameters.get(key);
            if (key.getType().equals(value.getType()) || key.getType().equalsWithSubType(value.getType()) || key.getType().equalClassType(value.getType()) || OperationInvocation.collectionMatch(value.getType(), key.getType()) || this.modelDiff.isSubclassOf(key.getType().getClassType(), value.getType().getClassType())) continue;
            return false;
        }
        return true;
    }
}

