/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.OperationInvocation;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class ExtractOperationRefactoring
implements Refactoring {
    private UMLOperation extractedOperation;
    private VariableDeclarationContainer sourceOperationBeforeExtraction;
    private VariableDeclarationContainer sourceOperationAfterExtraction;
    private List<AbstractCall> extractedOperationInvocations;
    private Set<Replacement> replacements;
    private Set<AbstractCodeFragment> extractedCodeFragmentsFromSourceOperation;
    private Set<AbstractCodeFragment> extractedCodeFragmentsToExtractedOperation;
    private UMLOperationBodyMapper bodyMapper;
    private Map<String, String> parameterToArgumentMap;
    private List<AbstractCodeMapping> argumentMappings;

    public ExtractOperationRefactoring(UMLOperationBodyMapper bodyMapper, VariableDeclarationContainer sourceOperationAfterExtraction, List<AbstractCall> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.extractedOperation = bodyMapper.getOperation2();
        this.sourceOperationBeforeExtraction = bodyMapper.getContainer1();
        this.sourceOperationAfterExtraction = sourceOperationAfterExtraction;
        this.extractedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.extractedCodeFragmentsToExtractedOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.argumentMappings = new ArrayList<AbstractCodeMapping>();
        Optional<Map<String, String>> optionalMap = bodyMapper.getParameterToArgumentMap2();
        this.parameterToArgumentMap = optionalMap.isPresent() ? optionalMap.get() : Collections.emptyMap();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
            this.createArgumentMappings(mapping);
            this.checkForMatchingCallChain(mapping);
        }
    }

    public ExtractOperationRefactoring(UMLOperationBodyMapper bodyMapper, UMLOperation extractedOperation, VariableDeclarationContainer sourceOperationBeforeExtraction, VariableDeclarationContainer sourceOperationAfterExtraction, List<AbstractCall> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.extractedOperation = extractedOperation;
        this.sourceOperationBeforeExtraction = sourceOperationBeforeExtraction;
        this.sourceOperationAfterExtraction = sourceOperationAfterExtraction;
        this.extractedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.extractedCodeFragmentsToExtractedOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.argumentMappings = new ArrayList<AbstractCodeMapping>();
        Optional<Map<String, String>> optionalMap = bodyMapper.getParameterToArgumentMap2();
        this.parameterToArgumentMap = optionalMap.isPresent() ? optionalMap.get() : Collections.emptyMap();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
            this.createArgumentMappings(mapping);
            this.checkForMatchingCallChain(mapping);
        }
    }

    public CompositeStatementObject extractedFromSynchronizedBlock() {
        if (this.bodyMapper.getParentMapper() != null && this.extractedOperation.isSynchronized()) {
            for (CompositeStatementObject unmatched : this.bodyMapper.getParentMapper().getNonMappedInnerNodesT1()) {
                if (!unmatched.getLocationInfo().getCodeElementType().equals((Object)LocationInfo.CodeElementType.SYNCHRONIZED_STATEMENT)) continue;
                int subsumed = 0;
                for (AbstractCodeMapping mapping : this.bodyMapper.getMappings()) {
                    if (!unmatched.getLocationInfo().subsumes(mapping.getFragment1().getLocationInfo())) continue;
                    ++subsumed;
                }
                if (subsumed != this.bodyMapper.getMappings().size()) continue;
                return unmatched;
            }
        }
        return null;
    }

    private void checkForMatchingCallChain(AbstractCodeMapping mapping) {
        AbstractCall invocation1 = mapping.getFragment1().invocationCoveringEntireFragment();
        if (invocation1 == null) {
            invocation1 = mapping.getFragment1().assignmentInvocationCoveringEntireStatement();
        }
        if (invocation1 instanceof OperationInvocation && ((OperationInvocation)invocation1).numberOfSubExpressions() > 0) {
            for (AbstractCodeMapping m : this.bodyMapper.getParentMapper().getMappings()) {
                if (!m.getFragment2().getLocationInfo().subsumes(this.bodyMapper.getOperationInvocation().getLocationInfo())) continue;
                AbstractCall invocation2 = m.getFragment2().invocationCoveringEntireFragment();
                if (invocation2 == null) {
                    invocation2 = m.getFragment2().assignmentInvocationCoveringEntireStatement();
                }
                if (invocation2 == null || !invocation1.equals(invocation2)) continue;
                LeafMapping leafMapping = new LeafMapping(invocation1, invocation2, this.sourceOperationBeforeExtraction, this.sourceOperationAfterExtraction);
                this.bodyMapper.getParentMapper().getMappings().add(leafMapping);
                break;
            }
        }
    }

    public void updateMapperInfo() {
        this.replacements = this.bodyMapper.getReplacements();
        this.extractedCodeFragmentsFromSourceOperation.clear();
        this.extractedCodeFragmentsToExtractedOperation.clear();
        for (AbstractCodeMapping mapping : this.bodyMapper.getMappings()) {
            this.extractedCodeFragmentsFromSourceOperation.add(mapping.getFragment1());
            this.extractedCodeFragmentsToExtractedOperation.add(mapping.getFragment2());
        }
    }

    private boolean isMappedInParent(AbstractCodeFragment leaf) {
        if (this.bodyMapper.parentMapperContainsMapping(leaf)) {
            return true;
        }
        if (leaf.getParent() != null && this.bodyMapper.parentMapperContainsMapping(leaf.getParent())) {
            return true;
        }
        if (leaf.getParent() != null && leaf.getParent().getParent() == null) {
            return true;
        }
        return this.extractedOperationInvocations.size() == 1;
    }

    private boolean isDefaultValue(String argument) {
        return argument.equals("null") || argument.equals("0") || argument.equals("1") || argument.equals("false") || argument.equals("true");
    }

    private void createArgumentMappings(AbstractCodeMapping mapping) {
        boolean argumentMatchFound = false;
        for (AbstractCall call : this.extractedOperationInvocations) {
            for (String argument : call.arguments()) {
                if (this.parameterToArgumentMap.containsKey(argument) || !this.parameterToArgumentMap.containsValue(argument)) continue;
                Replacement replacementFound = null;
                for (Replacement replacement : mapping.getReplacements()) {
                    if (!replacement.getBefore().equals(argument) || !this.parameterToArgumentMap.containsKey(replacement.getAfter()) || !this.parameterToArgumentMap.get(replacement.getAfter()).equals(argument)) continue;
                    replacementFound = replacement;
                    break;
                }
                if (replacementFound != null) {
                    argumentMatchFound = this.processArgument(mapping, call, argument);
                    continue;
                }
                if (this.isDefaultValue(argument)) continue;
                argumentMatchFound = this.processArgument(mapping, call, argument);
            }
        }
        if (!argumentMatchFound) {
            for (Replacement replacement : mapping.getReplacements()) {
                List<LeafExpression> expressions1;
                if (!replacement.getBefore().equals(replacement.getAfter()) && !replacement.getBefore().equals("this." + replacement.getAfter()) && !replacement.getAfter().equals("this." + replacement.getBefore()) || (expressions1 = mapping.getFragment1().findExpression(replacement.getBefore())).size() <= 0) continue;
                List<AbstractCodeFragment> leaves = this.sourceOperationAfterExtraction.getBody().getCompositeStatement().getLeaves();
                block4: for (AbstractCodeFragment leaf : leaves) {
                    for (AbstractCall call : this.extractedOperationInvocations) {
                        List<LeafExpression> expressions2;
                        if (!leaf.getLocationInfo().subsumes(call.getLocationInfo()) || !this.isMappedInParent(leaf) || (expressions2 = leaf.findExpression(replacement.getAfter())).size() != 1) continue;
                        for (LeafExpression expression1 : expressions1) {
                            LeafMapping expressionMapping = new LeafMapping(expression1, expressions2.get(0), this.sourceOperationBeforeExtraction, this.sourceOperationAfterExtraction);
                            this.argumentMappings.add(expressionMapping);
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    private boolean processArgument(AbstractCodeMapping mapping, AbstractCall call, String argument) {
        List<LeafExpression> expressions1;
        ObjectCreation creation2;
        ObjectCreation creation1;
        AbstractCall invocation2;
        for (AbstractCodeMapping m : this.bodyMapper.getMappings()) {
            VariableDeclaration variableDeclaration1 = m.getFragment1().getVariableDeclaration(argument);
            VariableDeclaration variableDeclaration2 = m.getFragment2().getVariableDeclaration(argument);
            if (variableDeclaration1 == null || variableDeclaration2 == null) continue;
            if (m.getFragment1().equals(mapping.getFragment1()) && m.getFragment2().equals(mapping.getFragment2())) {
                return false;
            }
            if (!variableDeclaration1.getStatementsInScopeUsingVariable().contains(mapping.getFragment1()) || !variableDeclaration2.getStatementsInScopeUsingVariable().contains(mapping.getFragment2())) continue;
            return false;
        }
        AbstractCall invocation1 = mapping.getFragment1().invocationCoveringEntireFragment();
        if (invocation1 == null) {
            invocation1 = mapping.getFragment1().assignmentInvocationCoveringEntireStatement();
        }
        if ((invocation2 = mapping.getFragment2().invocationCoveringEntireFragment()) == null) {
            invocation2 = mapping.getFragment2().assignmentInvocationCoveringEntireStatement();
        }
        if ((creation1 = mapping.getFragment1().creationCoveringEntireFragment()) == null) {
            creation1 = mapping.getFragment1().assignmentCreationCoveringEntireStatement();
        }
        if ((creation2 = mapping.getFragment2().creationCoveringEntireFragment()) == null) {
            creation2 = mapping.getFragment2().assignmentCreationCoveringEntireStatement();
        }
        if ((expressions1 = mapping.getFragment1().findExpression(argument)).size() > 0) {
            List<AbstractCodeFragment> leaves = this.sourceOperationAfterExtraction.getBody().getCompositeStatement().getLeaves();
            for (AbstractCodeFragment leaf : leaves) {
                List<LeafExpression> expressions2;
                if (!leaf.getLocationInfo().subsumes(call.getLocationInfo()) || !this.isMappedInParent(leaf) || (expressions2 = leaf.findExpression(argument)).size() != 1) continue;
                int occurrence = 0;
                for (LeafExpression expression1 : expressions1) {
                    String argument2;
                    int index;
                    boolean equalArgument = false;
                    if (invocation1 != null && invocation2 != null && invocation1.arguments().size() == invocation2.arguments().size() && (index = this.indexInArguments(invocation1, expression1, occurrence)) != -1 && ((argument2 = invocation2.arguments().get(index)).equals(expression1.getString()) || argument2.equals(invocation1.arguments().get(index)))) {
                        equalArgument = true;
                    }
                    if (creation1 != null && creation2 != null && creation1.arguments().size() == creation2.arguments().size() && (index = this.indexInArguments(creation1, expression1, occurrence)) != -1 && ((argument2 = creation2.arguments().get(index)).equals(expression1.getString()) || argument2.equals(creation1.arguments().get(index)))) {
                        equalArgument = true;
                    }
                    if (!equalArgument) {
                        LeafMapping expressionMapping = new LeafMapping(expression1, expressions2.get(0), this.sourceOperationBeforeExtraction, this.sourceOperationAfterExtraction);
                        this.argumentMappings.add(expressionMapping);
                    }
                    ++occurrence;
                }
                return true;
            }
        }
        return false;
    }

    private int indexInArguments(AbstractCall call, LeafExpression expression, int occurrence) {
        int index = 0;
        int matches = 0;
        for (String argument : call.arguments()) {
            if (argument.equals(expression.getString()) || argument.contains(expression.getString())) {
                if (matches == occurrence) {
                    return index;
                }
                ++matches;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.extractedOperation);
        sb.append(" extracted from ");
        sb.append(this.sourceOperationBeforeExtraction);
        sb.append(" in class ");
        sb.append(this.getClassName());
        if (this.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
            sb.append(" & moved to class ");
            sb.append(this.extractedOperation.getClassName());
        }
        return sb.toString();
    }

    private String getClassName() {
        String targetClassName;
        if (this.getRefactoringType().equals((Object)RefactoringType.EXTRACT_AND_MOVE_OPERATION)) {
            return this.getSourceOperationBeforeExtraction().getClassName();
        }
        String sourceClassName = this.getSourceOperationBeforeExtraction().getClassName();
        return sourceClassName.equals(targetClassName = this.getSourceOperationAfterExtraction().getClassName()) ? sourceClassName : targetClassName;
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getExtractedOperation() {
        return this.extractedOperation;
    }

    public VariableDeclarationContainer getSourceOperationBeforeExtraction() {
        return this.sourceOperationBeforeExtraction;
    }

    public VariableDeclarationContainer getSourceOperationAfterExtraction() {
        return this.sourceOperationAfterExtraction;
    }

    public List<AbstractCall> getExtractedOperationInvocations() {
        return this.extractedOperationInvocations;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public List<AbstractCodeMapping> getArgumentMappings() {
        return this.argumentMappings;
    }

    public Map<String, String> getParameterToArgumentMap() {
        return this.parameterToArgumentMap;
    }

    public Set<AbstractCodeFragment> getExtractedCodeFragmentsFromSourceOperation() {
        return this.extractedCodeFragmentsFromSourceOperation;
    }

    public Set<AbstractCodeFragment> getExtractedCodeFragmentsToExtractedOperation() {
        return this.extractedCodeFragmentsToExtractedOperation;
    }

    public CodeRange getSourceOperationCodeRangeBeforeExtraction() {
        return this.sourceOperationBeforeExtraction.codeRange();
    }

    public CodeRange getSourceOperationCodeRangeAfterExtraction() {
        return this.sourceOperationAfterExtraction.codeRange();
    }

    public CodeRange getExtractedOperationCodeRange() {
        return this.extractedOperation.codeRange();
    }

    public CodeRange getExtractedCodeRangeFromSourceOperation() {
        return CodeRange.computeRange(this.extractedCodeFragmentsFromSourceOperation);
    }

    public CodeRange getExtractedCodeRangeToExtractedOperation() {
        return CodeRange.computeRange(this.extractedCodeFragmentsToExtractedOperation);
    }

    public Set<CodeRange> getExtractedOperationInvocationCodeRanges() {
        LinkedHashSet<CodeRange> codeRanges = new LinkedHashSet<CodeRange>();
        for (AbstractCall invocation : this.extractedOperationInvocations) {
            codeRanges.add(invocation.codeRange());
        }
        return codeRanges;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (!this.getSourceOperationAfterExtraction().getClassName().equals(this.getExtractedOperation().getClassName())) {
            return RefactoringType.EXTRACT_AND_MOVE_OPERATION;
        }
        return RefactoringType.EXTRACT_OPERATION;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSourceOperationBeforeExtraction().getLocationInfo().getFilePath(), (Object)this.getSourceOperationBeforeExtraction().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getSourceOperationAfterExtraction().getLocationInfo().getFilePath(), (Object)this.getSourceOperationAfterExtraction().getClassName()));
        pairs.add(new ImmutablePair((Object)this.getExtractedOperation().getLocationInfo().getFilePath(), (Object)this.getExtractedOperation().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getSourceOperationCodeRangeBeforeExtraction().setDescription("source method declaration before extraction").setCodeElement(this.sourceOperationBeforeExtraction.toString()));
        for (AbstractCodeFragment extractedCodeFragment : this.extractedCodeFragmentsFromSourceOperation) {
            ranges.add(extractedCodeFragment.codeRange().setDescription("extracted code from source method declaration"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getExtractedOperationCodeRange().setDescription("extracted method declaration").setCodeElement(this.extractedOperation.toString()));
        for (AbstractCodeFragment abstractCodeFragment : this.extractedCodeFragmentsToExtractedOperation) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("extracted code to extracted method declaration"));
        }
        ranges.add(this.getSourceOperationCodeRangeAfterExtraction().setDescription("source method declaration after extraction").setCodeElement(this.sourceOperationAfterExtraction.toString()));
        for (AbstractCall abstractCall : this.extractedOperationInvocations) {
            ranges.add(abstractCall.codeRange().setDescription("extracted method invocation").setCodeElement(abstractCall.actualString()));
        }
        for (AbstractCodeFragment abstractCodeFragment : this.bodyMapper.getNonMappedLeavesT2()) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("added statement in extracted method declaration"));
        }
        for (CompositeStatementObject compositeStatementObject : this.bodyMapper.getNonMappedInnerNodesT2()) {
            ranges.add(compositeStatementObject.codeRange().setDescription("added statement in extracted method declaration"));
        }
        return ranges;
    }
}

