/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLGeneralization;
import gr.uom.java.xmi.UMLRealization;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InheritanceDetection {
    private Map<String, LinkedHashSet<String>> subclassMap = new LinkedHashMap<String, LinkedHashSet<String>>();

    public InheritanceDetection(UMLModelDiff modelDiff) {
        this.generateNewInheritanceHierarchies(modelDiff);
    }

    private void addSubclassToSuperclass(String superclass, String subclass) {
        if (this.subclassMap.containsKey(superclass)) {
            LinkedHashSet<String> subclasses = this.subclassMap.get(superclass);
            subclasses.add(subclass);
        } else {
            LinkedHashSet<String> subclasses = new LinkedHashSet<String>();
            subclasses.add(subclass);
            this.subclassMap.put(superclass, subclasses);
        }
    }

    private void generateNewInheritanceHierarchies(UMLModelDiff modelDiff) {
        List<UMLGeneralization> addedGeneralizations = modelDiff.getAddedGeneralizations();
        for (UMLGeneralization generalization : addedGeneralizations) {
            String superclass = generalization.getParent();
            String subclass = generalization.getChild().getName();
            if (modelDiff.getAddedClass(superclass) == null || modelDiff.getAddedClass(subclass) == null) continue;
            this.addSubclassToSuperclass(superclass, subclass);
        }
        List<UMLRealization> addedRealizations = modelDiff.getAddedRealizations();
        for (UMLRealization realization : addedRealizations) {
            String supplier = realization.getSupplier();
            String client = realization.getClient().getName();
            if (modelDiff.getAddedClass(supplier) == null || modelDiff.getAddedClass(client) == null) continue;
            this.addSubclassToSuperclass(supplier, client);
        }
    }

    public Set<String> getRoots() {
        return this.subclassMap.keySet();
    }
}

