/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAbstractClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.ReferenceBasedRefactoring;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class InlineAttributeRefactoring
implements Refactoring,
ReferenceBasedRefactoring {
    private UMLAttribute attributeDeclaration;
    private UMLAbstractClass originalClass;
    private UMLAbstractClass nextClass;
    private Set<AbstractCodeMapping> references;
    private boolean insideExtractedOrInlinedMethod;

    public InlineAttributeRefactoring(UMLAttribute variableDeclaration, UMLAbstractClass originalClass, UMLAbstractClass nextClass, boolean insideExtractedOrInlinedMethod) {
        this.attributeDeclaration = variableDeclaration;
        this.originalClass = originalClass;
        this.nextClass = nextClass;
        this.references = new LinkedHashSet<AbstractCodeMapping>();
        this.insideExtractedOrInlinedMethod = insideExtractedOrInlinedMethod;
    }

    public void addReference(AbstractCodeMapping mapping) {
        this.references.add(mapping);
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.INLINE_ATTRIBUTE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public UMLAttribute getVariableDeclaration() {
        return this.attributeDeclaration;
    }

    @Override
    public Set<AbstractCodeMapping> getReferences() {
        return this.references;
    }

    public boolean isInsideExtractedOrInlinedMethod() {
        return this.insideExtractedOrInlinedMethod;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.attributeDeclaration);
        sb.append(" in class ");
        sb.append(this.nextClass.getName());
        return sb.toString();
    }

    public CodeRange getInlinedVariableDeclarationCodeRange() {
        return this.attributeDeclaration.codeRange();
    }

    public UMLAbstractClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLAbstractClass getNextClass() {
        return this.nextClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeDeclaration.getVariableDeclaration() == null ? 0 : this.attributeDeclaration.getVariableDeclaration().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InlineAttributeRefactoring other = (InlineAttributeRefactoring)obj;
        return !(this.attributeDeclaration == null ? other.attributeDeclaration != null : !this.attributeDeclaration.getVariableDeclaration().equals(other.attributeDeclaration.getVariableDeclaration()));
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.attributeDeclaration.codeRange().setDescription("inlined attribute declaration").setCodeElement(this.attributeDeclaration.toString()));
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment1().codeRange().setDescription("statement with the name of the inlined attribute"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment2().codeRange().setDescription("statement with the initializer of the inlined attribute"));
        }
        return ranges;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getNextClass().getLocationInfo().getFilePath(), (Object)this.getNextClass().getName()));
        return pairs;
    }
}

