/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.diff.CallTree;
import gr.uom.java.xmi.diff.CallTreeNode;
import gr.uom.java.xmi.diff.ExtractOperationDetection;
import gr.uom.java.xmi.diff.InlineOperationRefactoring;
import gr.uom.java.xmi.diff.UMLAbstractClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class InlineOperationDetection {
    private UMLOperationBodyMapper mapper;
    private List<UMLOperation> removedOperations;
    private UMLAbstractClassDiff classDiff;
    private UMLModelDiff modelDiff;
    private List<AbstractCall> operationInvocations;
    private Map<CallTreeNode, CallTree> callTreeMap = new LinkedHashMap<CallTreeNode, CallTree>();
    private Map<UMLOperation, List<AbstractCall>> callCountMap = null;

    public InlineOperationDetection(UMLOperationBodyMapper mapper, List<UMLOperation> removedOperations, UMLAbstractClassDiff classDiff, UMLModelDiff modelDiff) {
        this.mapper = mapper;
        this.removedOperations = removedOperations;
        this.classDiff = classDiff;
        this.modelDiff = modelDiff;
        this.operationInvocations = this.getInvocationsInTargetOperationBeforeInline(mapper);
    }

    public List<UMLOperation> getRemovedOperationsSortedByCalls() {
        this.callCountMap = new LinkedHashMap<UMLOperation, List<AbstractCall>>();
        ArrayList<UMLOperation> sorted = new ArrayList<UMLOperation>();
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (UMLOperation removedOperation : this.removedOperations) {
            List<AbstractCall> matchingInvocations = this.matchingInvocations(removedOperation, this.operationInvocations, this.mapper.getContainer1());
            if (matchingInvocations.isEmpty()) continue;
            this.callCountMap.put(removedOperation, matchingInvocations);
            int count = matchingInvocations.size();
            if (sorted.isEmpty()) {
                sorted.add(removedOperation);
                counts.add(count);
                continue;
            }
            boolean inserted = false;
            for (int i = 0; i < counts.size(); ++i) {
                if (count <= (Integer)counts.get(i)) continue;
                sorted.add(i, removedOperation);
                counts.add(i, count);
                inserted = true;
                break;
            }
            if (inserted) continue;
            sorted.add(counts.size(), removedOperation);
            counts.add(counts.size(), count);
        }
        return sorted;
    }

    public List<InlineOperationRefactoring> check(UMLOperation removedOperation) throws RefactoringMinerTimedOutException {
        ArrayList<InlineOperationRefactoring> refactorings = new ArrayList<InlineOperationRefactoring>();
        if (!this.mapper.getNonMappedLeavesT2().isEmpty() || !this.mapper.getNonMappedInnerNodesT2().isEmpty() || !this.mapper.getReplacementsInvolvingMethodInvocation().isEmpty() || this.mapper.containsCompositeMappingWithoutReplacements()) {
            List<AbstractCall> removedOperationInvocations;
            List<AbstractCall> list = removedOperationInvocations = this.callCountMap != null ? this.callCountMap.get(removedOperation) : this.matchingInvocations(removedOperation, this.operationInvocations, this.mapper.getContainer1());
            if (removedOperationInvocations.size() > 0 && !this.invocationMatchesWithAddedOperation(removedOperationInvocations.get(0), this.mapper.getContainer1(), this.mapper.getContainer2().getAllOperationInvocations())) {
                int otherAddedMethodsCalled = 0;
                int otherAddedMethodsCalledWithSameOrMoreCallSites = 0;
                for (UMLOperation removedOperation1 : this.removedOperations) {
                    List<AbstractCall> removedOperationInvocations1;
                    if (removedOperation.equals(removedOperation1)) continue;
                    List<AbstractCall> list2 = removedOperationInvocations1 = this.callCountMap != null ? this.callCountMap.get(removedOperation1) : this.matchingInvocations(removedOperation1, this.operationInvocations, this.mapper.getContainer1());
                    if (removedOperationInvocations1 != null && removedOperationInvocations1.size() > 0) {
                        ++otherAddedMethodsCalled;
                    }
                    if (removedOperationInvocations1 == null || removedOperationInvocations1.size() < removedOperationInvocations.size()) continue;
                    ++otherAddedMethodsCalledWithSameOrMoreCallSites;
                }
                if (otherAddedMethodsCalledWithSameOrMoreCallSites == 0 && (otherAddedMethodsCalled == 0 || this.mapper.getContainer2().stringRepresentation().size() > removedOperationInvocations.size() * removedOperation.stringRepresentation().size())) {
                    for (AbstractCall removedOperationInvocation : removedOperationInvocations) {
                        this.processRemovedOperation(removedOperation, refactorings, removedOperationInvocations, removedOperationInvocation);
                    }
                } else {
                    AbstractCall removedOperationInvocation = removedOperationInvocations.get(0);
                    this.processRemovedOperation(removedOperation, refactorings, removedOperationInvocations, removedOperationInvocation);
                }
            }
        }
        return refactorings;
    }

    private void processRemovedOperation(UMLOperation removedOperation, List<InlineOperationRefactoring> refactorings, List<AbstractCall> removedOperationInvocations, AbstractCall removedOperationInvocation) throws RefactoringMinerTimedOutException {
        CallTreeNode root = new CallTreeNode(this.mapper.getContainer1(), removedOperation, removedOperationInvocation);
        CallTree callTree = null;
        if (this.callTreeMap.containsKey(root)) {
            callTree = this.callTreeMap.get(root);
        } else {
            callTree = new CallTree(root);
            this.generateCallTree(removedOperation, root, callTree);
            this.callTreeMap.put(root, callTree);
        }
        UMLOperationBodyMapper operationBodyMapper = this.createMapperForInlinedMethod(this.mapper, removedOperation, removedOperationInvocation, false);
        List<CallTreeNode> nodesInBreadthFirstOrder = callTree.getNodesInBreadthFirstOrder();
        for (int i = 1; i < nodesInBreadthFirstOrder.size(); ++i) {
            CallTreeNode node = nodesInBreadthFirstOrder.get(i);
            this.processNestedMapper(operationBodyMapper, operationBodyMapper, refactorings, node);
        }
        if (this.inlineMatchCondition(operationBodyMapper, this.mapper)) {
            InlineOperationRefactoring inlineOperationRefactoring = new InlineOperationRefactoring(operationBodyMapper, this.mapper.getContainer1(), removedOperationInvocations);
            refactorings.add(inlineOperationRefactoring);
        } else {
            for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
                AbstractCodeFragment fragment2 = mapping.getFragment2();
                if (fragment2 instanceof CompositeStatementObject) {
                    if (this.mapper.getNonMappedInnerNodesT2().contains(fragment2)) continue;
                    this.mapper.getNonMappedInnerNodesT2().add((CompositeStatementObject)fragment2);
                    continue;
                }
                if (this.mapper.getNonMappedLeavesT2().contains(fragment2)) continue;
                this.mapper.getNonMappedLeavesT2().add(fragment2);
            }
        }
    }

    private void processNestedMapper(UMLOperationBodyMapper mapper, UMLOperationBodyMapper operationBodyMapper, List<InlineOperationRefactoring> refactorings, CallTreeNode node) throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper nestedMapper = this.createMapperForInlinedMethod(mapper, node.getInvokedOperation(), node.getInvocation(), true);
        if (this.inlineMatchCondition(nestedMapper, mapper)) {
            List<AbstractCall> nestedMatchingInvocations = this.matchingInvocations(node.getInvokedOperation(), node.getOriginalOperation().getAllOperationInvocations(), node.getOriginalOperation());
            InlineOperationRefactoring nestedRefactoring = new InlineOperationRefactoring(nestedMapper, mapper.getContainer1(), nestedMatchingInvocations);
            refactorings.add(nestedRefactoring);
            operationBodyMapper.addChildMapper(nestedMapper);
        } else {
            for (AbstractCodeMapping mapping : nestedMapper.getMappings()) {
                AbstractCodeFragment fragment2 = mapping.getFragment2();
                if (fragment2 instanceof CompositeStatementObject) {
                    if (mapper.getNonMappedInnerNodesT2().contains(fragment2)) continue;
                    mapper.getNonMappedInnerNodesT2().add((CompositeStatementObject)fragment2);
                    continue;
                }
                if (mapper.getNonMappedLeavesT2().contains(fragment2)) continue;
                mapper.getNonMappedLeavesT2().add(fragment2);
            }
        }
    }

    private List<AbstractCall> matchingInvocations(UMLOperation removedOperation, List<AbstractCall> operationInvocations, VariableDeclarationContainer callerOperation) {
        ArrayList<AbstractCall> removedOperationInvocations = new ArrayList<AbstractCall>();
        for (AbstractCall invocation : operationInvocations) {
            if (!invocation.matchesOperation(removedOperation, callerOperation, this.classDiff, this.modelDiff)) continue;
            removedOperationInvocations.add(invocation);
        }
        return removedOperationInvocations;
    }

    private UMLOperationBodyMapper createMapperForInlinedMethod(UMLOperationBodyMapper mapper, UMLOperation removedOperation, AbstractCall removedOperationInvocation, boolean nested) throws RefactoringMinerTimedOutException {
        List<String> arguments = removedOperationInvocation.arguments();
        List<String> parameters = removedOperation.getParameterNameList();
        LinkedHashMap<String, String> parameterToArgumentMap = new LinkedHashMap<String, String>();
        int size = Math.min(arguments.size(), parameters.size());
        for (int i = 0; i < size; ++i) {
            parameterToArgumentMap.put(parameters.get(i), arguments.get(i));
        }
        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, mapper, parameterToArgumentMap, new LinkedHashMap<String, String>(), this.classDiff, removedOperationInvocation, nested);
        return operationBodyMapper;
    }

    private void generateCallTree(UMLOperation operation, CallTreeNode parent, CallTree callTree) {
        List<AbstractCall> invocations = operation.getAllOperationInvocations();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (AbstractCall invocation : invocations) {
                if (!invocation.matchesOperation(removedOperation, operation, this.classDiff, this.modelDiff) || callTree.containsInPathToRootOrSibling(parent, removedOperation)) continue;
                CallTreeNode node = new CallTreeNode(parent, operation, removedOperation, invocation);
                parent.addChild(node);
                this.generateCallTree(removedOperation, node, callTree);
            }
        }
    }

    private List<AbstractCall> getInvocationsInTargetOperationBeforeInline(UMLOperationBodyMapper mapper) {
        List<AbstractCall> operationInvocations = mapper.getContainer1().getAllOperationInvocations();
        for (AbstractCodeFragment statement : mapper.getNonMappedLeavesT1()) {
            ExtractOperationDetection.addStatementInvocations(operationInvocations, statement);
            if (this.classDiff == null) continue;
            for (UMLAnonymousClass anonymousClass : this.classDiff.getRemovedAnonymousClasses()) {
                if (!statement.getLocationInfo().subsumes(anonymousClass.getLocationInfo())) continue;
                for (UMLOperation anonymousOperation : anonymousClass.getOperations()) {
                    for (AbstractCall anonymousInvocation : anonymousOperation.getAllOperationInvocations()) {
                        if (ExtractOperationDetection.containsInvocation(operationInvocations, anonymousInvocation)) continue;
                        operationInvocations.add(anonymousInvocation);
                    }
                }
            }
        }
        return operationInvocations;
    }

    private boolean inlineMatchCondition(UMLOperationBodyMapper operationBodyMapper, UMLOperationBodyMapper parentMapper) {
        if (operationBodyMapper.getContainer1().isGetter()) {
            return false;
        }
        int delegateStatements = 0;
        for (AbstractCodeFragment statement : operationBodyMapper.getNonMappedLeavesT1()) {
            AbstractCall invocation = statement.invocationCoveringEntireFragment();
            if (invocation == null || !invocation.matchesOperation(operationBodyMapper.getContainer1(), parentMapper.getContainer1(), this.classDiff, this.modelDiff)) continue;
            ++delegateStatements;
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1() - delegateStatements;
        List<AbstractCodeMapping> exactMatchList = operationBodyMapper.getExactMatches();
        List<AbstractCodeMapping> exactMatchListWithoutMatchesInNestedContainers = operationBodyMapper.getExactMatchesWithoutMatchesInNestedContainers();
        int exactMatches = exactMatchList.size();
        int exactMatchesWithoutMatchesInNestedContainers = exactMatchListWithoutMatchesInNestedContainers.size();
        return mappings > 0 && (mappings > nonMappedElementsT1 || exactMatchesWithoutMatchesInNestedContainers == 1 && !exactMatchListWithoutMatchesInNestedContainers.get(0).getFragment1().throwsNewException() && nonMappedElementsT1 - exactMatchesWithoutMatchesInNestedContainers < 10 || exactMatches > 1 && nonMappedElementsT1 - exactMatches < 20);
    }

    private boolean invocationMatchesWithAddedOperation(AbstractCall removedOperationInvocation, VariableDeclarationContainer callerOperation, List<AbstractCall> operationInvocationsInNewMethod) {
        if (operationInvocationsInNewMethod.contains(removedOperationInvocation) && this.classDiff != null) {
            for (UMLOperation addedOperation : this.classDiff.getAddedOperations()) {
                if (!removedOperationInvocation.matchesOperation(addedOperation, callerOperation, this.classDiff, this.modelDiff)) continue;
                return true;
            }
        }
        return false;
    }
}

