/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi.diff;

import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.AbstractCodeMapping;
import gr.uom.java.xmi.decomposition.CompositeStatementObject;
import gr.uom.java.xmi.decomposition.LeafExpression;
import gr.uom.java.xmi.decomposition.LeafMapping;
import gr.uom.java.xmi.decomposition.ObjectCreation;
import gr.uom.java.xmi.decomposition.UMLOperationBodyMapper;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.decomposition.replacement.Replacement;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.refactoringminer.api.Refactoring;
import org.refactoringminer.api.RefactoringType;

public class InlineOperationRefactoring
implements Refactoring {
    private UMLOperation inlinedOperation;
    private VariableDeclarationContainer targetOperationAfterInline;
    private VariableDeclarationContainer targetOperationBeforeInline;
    private List<AbstractCall> inlinedOperationInvocations;
    private Set<Replacement> replacements;
    private Set<AbstractCodeFragment> inlinedCodeFragmentsFromInlinedOperation;
    private Set<AbstractCodeFragment> inlinedCodeFragmentsInTargetOperation;
    private UMLOperationBodyMapper bodyMapper;
    private Map<String, String> parameterToArgumentMap;
    private List<AbstractCodeMapping> argumentMappings;

    public InlineOperationRefactoring(UMLOperationBodyMapper bodyMapper, VariableDeclarationContainer targetOperationBeforeInline, List<AbstractCall> operationInvocations) {
        this.bodyMapper = bodyMapper;
        this.inlinedOperation = bodyMapper.getOperation1();
        this.targetOperationAfterInline = bodyMapper.getContainer2();
        this.targetOperationBeforeInline = targetOperationBeforeInline;
        this.inlinedOperationInvocations = operationInvocations;
        this.replacements = bodyMapper.getReplacements();
        this.inlinedCodeFragmentsFromInlinedOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.inlinedCodeFragmentsInTargetOperation = new LinkedHashSet<AbstractCodeFragment>();
        this.argumentMappings = new ArrayList<AbstractCodeMapping>();
        Optional<Map<String, String>> optionalMap = bodyMapper.getParameterToArgumentMap1();
        this.parameterToArgumentMap = optionalMap.isPresent() ? optionalMap.get() : Collections.emptyMap();
        for (AbstractCodeMapping mapping : bodyMapper.getMappings()) {
            this.inlinedCodeFragmentsFromInlinedOperation.add(mapping.getFragment1());
            this.inlinedCodeFragmentsInTargetOperation.add(mapping.getFragment2());
            this.createArgumentMappings(mapping);
        }
    }

    public void updateMapperInfo() {
        this.replacements = this.bodyMapper.getReplacements();
        this.inlinedCodeFragmentsFromInlinedOperation.clear();
        this.inlinedCodeFragmentsInTargetOperation.clear();
        for (AbstractCodeMapping mapping : this.bodyMapper.getMappings()) {
            this.inlinedCodeFragmentsFromInlinedOperation.add(mapping.getFragment1());
            this.inlinedCodeFragmentsInTargetOperation.add(mapping.getFragment2());
        }
    }

    private boolean isMappedInParent(AbstractCodeFragment leaf) {
        if (this.bodyMapper.parentMapperContainsMapping(leaf)) {
            return true;
        }
        if (leaf.getParent() != null && this.bodyMapper.parentMapperContainsMapping(leaf.getParent())) {
            return true;
        }
        if (leaf.getParent() != null && leaf.getParent().getParent() == null) {
            return true;
        }
        return this.inlinedOperationInvocations.size() == 1;
    }

    private boolean isDefaultValue(String argument) {
        return argument.equals("null") || argument.equals("0") || argument.equals("1") || argument.equals("false") || argument.equals("true");
    }

    private void createArgumentMappings(AbstractCodeMapping mapping) {
        boolean argumentMatchFound = false;
        for (AbstractCall call : this.inlinedOperationInvocations) {
            for (String argument : call.arguments()) {
                if (this.parameterToArgumentMap.containsKey(argument) || !this.parameterToArgumentMap.containsValue(argument)) continue;
                Replacement replacementFound = null;
                for (Replacement replacement : mapping.getReplacements()) {
                    if (!replacement.getAfter().equals(argument) || !this.parameterToArgumentMap.containsKey(replacement.getBefore()) || !this.parameterToArgumentMap.get(replacement.getBefore()).equals(argument)) continue;
                    replacementFound = replacement;
                    break;
                }
                if (replacementFound != null) {
                    argumentMatchFound = this.processArgument(mapping, call, argument);
                    continue;
                }
                if (this.isDefaultValue(argument)) continue;
                argumentMatchFound = this.processArgument(mapping, call, argument);
            }
        }
        if (!argumentMatchFound) {
            for (Replacement replacement : mapping.getReplacements()) {
                List<LeafExpression> expressions2;
                if (!replacement.getBefore().equals(replacement.getAfter()) && !replacement.getBefore().equals("this." + replacement.getAfter()) && !replacement.getAfter().equals("this." + replacement.getBefore()) || (expressions2 = mapping.getFragment2().findExpression(replacement.getAfter())).size() <= 0) continue;
                List<AbstractCodeFragment> leaves = this.targetOperationBeforeInline.getBody().getCompositeStatement().getLeaves();
                block4: for (AbstractCodeFragment leaf : leaves) {
                    for (AbstractCall call : this.inlinedOperationInvocations) {
                        List<LeafExpression> expressions1;
                        if (!leaf.getLocationInfo().subsumes(call.getLocationInfo()) || !this.isMappedInParent(leaf) || (expressions1 = leaf.findExpression(replacement.getBefore())).size() != 1) continue;
                        for (LeafExpression expression2 : expressions2) {
                            LeafMapping expressionMapping = new LeafMapping(expressions1.get(0), expression2, this.targetOperationBeforeInline, this.targetOperationAfterInline);
                            this.argumentMappings.add(expressionMapping);
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    private boolean processArgument(AbstractCodeMapping mapping, AbstractCall call, String argument) {
        List<LeafExpression> expressions2;
        ObjectCreation creation2;
        ObjectCreation creation1;
        AbstractCall invocation2;
        for (AbstractCodeMapping m : this.bodyMapper.getMappings()) {
            VariableDeclaration variableDeclaration1 = m.getFragment1().getVariableDeclaration(argument);
            VariableDeclaration variableDeclaration2 = m.getFragment2().getVariableDeclaration(argument);
            if (variableDeclaration1 == null || variableDeclaration2 == null) continue;
            if (m.getFragment1().equals(mapping.getFragment1()) && m.getFragment2().equals(mapping.getFragment2())) {
                return false;
            }
            if (!variableDeclaration1.getStatementsInScopeUsingVariable().contains(mapping.getFragment1()) || !variableDeclaration2.getStatementsInScopeUsingVariable().contains(mapping.getFragment2())) continue;
            return false;
        }
        AbstractCall invocation1 = mapping.getFragment1().invocationCoveringEntireFragment();
        if (invocation1 == null) {
            invocation1 = mapping.getFragment1().assignmentInvocationCoveringEntireStatement();
        }
        if ((invocation2 = mapping.getFragment2().invocationCoveringEntireFragment()) == null) {
            invocation2 = mapping.getFragment2().assignmentInvocationCoveringEntireStatement();
        }
        if ((creation1 = mapping.getFragment1().creationCoveringEntireFragment()) == null) {
            creation1 = mapping.getFragment1().assignmentCreationCoveringEntireStatement();
        }
        if ((creation2 = mapping.getFragment2().creationCoveringEntireFragment()) == null) {
            creation2 = mapping.getFragment2().assignmentCreationCoveringEntireStatement();
        }
        if ((expressions2 = mapping.getFragment2().findExpression(argument)).size() > 0) {
            List<AbstractCodeFragment> leaves = this.targetOperationBeforeInline.getBody().getCompositeStatement().getLeaves();
            for (AbstractCodeFragment leaf : leaves) {
                List<LeafExpression> expressions1;
                if (!leaf.getLocationInfo().subsumes(call.getLocationInfo()) || !this.isMappedInParent(leaf) || (expressions1 = leaf.findExpression(argument)).size() != 1) continue;
                int occurrence = 0;
                for (LeafExpression expression2 : expressions2) {
                    String argument1;
                    int index;
                    boolean equalArgument = false;
                    if (invocation1 != null && invocation2 != null && invocation1.arguments().size() == invocation2.arguments().size() && (index = this.indexInArguments(invocation2, expression2, occurrence)) != -1 && ((argument1 = invocation1.arguments().get(index)).equals(expression2.getString()) || argument1.equals(invocation2.arguments().get(index)))) {
                        equalArgument = true;
                    }
                    if (creation1 != null && creation2 != null && creation1.arguments().size() == creation2.arguments().size() && (index = this.indexInArguments(creation2, expression2, occurrence)) != -1 && ((argument1 = creation1.arguments().get(index)).equals(expression2.getString()) || argument1.equals(creation2.arguments().get(index)))) {
                        equalArgument = true;
                    }
                    if (!equalArgument) {
                        LeafMapping expressionMapping = new LeafMapping(expressions1.get(0), expression2, this.targetOperationBeforeInline, this.targetOperationAfterInline);
                        this.argumentMappings.add(expressionMapping);
                    }
                    ++occurrence;
                }
                return true;
            }
        }
        return false;
    }

    private int indexInArguments(AbstractCall call, LeafExpression expression, int occurrence) {
        int index = 0;
        int matches = 0;
        for (String argument : call.arguments()) {
            if (argument.equals(expression.getString()) || argument.contains(expression.getString())) {
                if (matches == occurrence) {
                    return index;
                }
                ++matches;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("\t");
        sb.append(this.inlinedOperation);
        if (this.getRefactoringType().equals((Object)RefactoringType.INLINE_OPERATION)) {
            sb.append(" inlined to ");
            sb.append(this.targetOperationAfterInline);
            sb.append(" in class ");
            sb.append(this.getClassName());
        } else if (this.getRefactoringType().equals((Object)RefactoringType.MOVE_AND_INLINE_OPERATION)) {
            sb.append(" moved from class ");
            sb.append(this.inlinedOperation.getClassName());
            sb.append(" to class ");
            sb.append(this.getTargetOperationAfterInline().getClassName());
            sb.append(" & inlined to ");
            sb.append(this.getTargetOperationAfterInline());
        }
        return sb.toString();
    }

    private String getClassName() {
        return this.targetOperationAfterInline.getClassName();
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (!this.getTargetOperationBeforeInline().getClassName().equals(this.getInlinedOperation().getClassName())) {
            return RefactoringType.MOVE_AND_INLINE_OPERATION;
        }
        return RefactoringType.INLINE_OPERATION;
    }

    public UMLOperationBodyMapper getBodyMapper() {
        return this.bodyMapper;
    }

    public UMLOperation getInlinedOperation() {
        return this.inlinedOperation;
    }

    public VariableDeclarationContainer getTargetOperationAfterInline() {
        return this.targetOperationAfterInline;
    }

    public VariableDeclarationContainer getTargetOperationBeforeInline() {
        return this.targetOperationBeforeInline;
    }

    public List<AbstractCall> getInlinedOperationInvocations() {
        return this.inlinedOperationInvocations;
    }

    public Set<Replacement> getReplacements() {
        return this.replacements;
    }

    public List<AbstractCodeMapping> getArgumentMappings() {
        return this.argumentMappings;
    }

    public Map<String, String> getParameterToArgumentMap() {
        return this.parameterToArgumentMap;
    }

    public Set<AbstractCodeFragment> getInlinedCodeFragments() {
        return this.inlinedCodeFragmentsInTargetOperation;
    }

    public CodeRange getTargetOperationCodeRangeBeforeInline() {
        return this.targetOperationBeforeInline.codeRange();
    }

    public CodeRange getTargetOperationCodeRangeAfterInline() {
        return this.targetOperationAfterInline.codeRange();
    }

    public CodeRange getInlinedOperationCodeRange() {
        return this.inlinedOperation.codeRange();
    }

    public CodeRange getInlinedCodeRangeFromInlinedOperation() {
        return CodeRange.computeRange(this.inlinedCodeFragmentsFromInlinedOperation);
    }

    public CodeRange getInlinedCodeRangeInTargetOperation() {
        return CodeRange.computeRange(this.inlinedCodeFragmentsInTargetOperation);
    }

    public Set<CodeRange> getInlinedOperationInvocationCodeRanges() {
        LinkedHashSet<CodeRange> codeRanges = new LinkedHashSet<CodeRange>();
        for (AbstractCall invocation : this.inlinedOperationInvocations) {
            codeRanges.add(invocation.codeRange());
        }
        return codeRanges;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getInlinedOperation().getLocationInfo().getFilePath(), (Object)this.getInlinedOperation().getClassName()));
        pairs.add(new ImmutablePair((Object)this.getTargetOperationBeforeInline().getLocationInfo().getFilePath(), (Object)this.getTargetOperationBeforeInline().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getTargetOperationAfterInline().getLocationInfo().getFilePath(), (Object)this.getTargetOperationAfterInline().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getInlinedOperationCodeRange().setDescription("inlined method declaration").setCodeElement(this.inlinedOperation.toString()));
        for (AbstractCodeFragment abstractCodeFragment : this.inlinedCodeFragmentsFromInlinedOperation) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("inlined code from inlined method declaration"));
        }
        ranges.add(this.getTargetOperationCodeRangeBeforeInline().setDescription("target method declaration before inline").setCodeElement(this.targetOperationBeforeInline.toString()));
        for (AbstractCall abstractCall : this.inlinedOperationInvocations) {
            ranges.add(abstractCall.codeRange().setDescription("inlined method invocation").setCodeElement(abstractCall.actualString()));
        }
        for (AbstractCodeFragment abstractCodeFragment : this.bodyMapper.getNonMappedLeavesT1()) {
            ranges.add(abstractCodeFragment.codeRange().setDescription("deleted statement in inlined method declaration"));
        }
        for (CompositeStatementObject compositeStatementObject : this.bodyMapper.getNonMappedInnerNodesT1()) {
            ranges.add(compositeStatementObject.codeRange().setDescription("deleted statement in inlined method declaration"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.getTargetOperationCodeRangeAfterInline().setDescription("target method declaration after inline").setCodeElement(this.targetOperationAfterInline.toString()));
        for (AbstractCodeFragment inlinedCodeFragment : this.inlinedCodeFragmentsInTargetOperation) {
            ranges.add(inlinedCodeFragment.codeRange().setDescription("inlined code in target method declaration"));
        }
        return ranges;
    }
}

